# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Main Menu Pusher
# http://smystero.dlinkddns.org/smytvwhow/
# ------------------------------------------------------------

from core import items

from xbmcutils import plugin, gui, logger, config
from tvdb import tvdb_api

__class_name__ = "TestMenu"


class TestMenu():
    __object_type__ = "M"
    __object_name__ = "test_menu"

    def __init__(self):
        return

    def main(self, args):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_movies()

        item_list.append(items.MenuItem(self, config.get_localized_string(30931), "null",
                                        folder=False, playable=False, thumbnail="[search]"))
        item_list.append(items.MenuItem(self, "Multiselect", "multiselect",
                                        folder=False, playable=False, thumbnail="[search]"))
        item_list.append(items.MenuItem(self, "Lista Play/Cancel", "list_a"))
        item_list.append(items.MenuItem(self, "Lista Back", "list_b"))
        item_list.append(items.MenuItem(self, "Cerca", "search"))
        item_list.append(items.MenuItem(self, "Empty List", "list_c"))
        item_list.append(items.MenuItem(self, "Guarda serie", "main", target_type="P", target="p_guardaserie"))
        item_list.append(items.TestMediaItem(self, "TEST ME", "null",folder=False, playable=True, thumbnail="[favorite]"))

        gui.render_items(item_list)

        logger.debug("end...")

    def multiselect(self, item):
        logger.debug("start...")
        #choice = gui.show_multiselect_dialog("TestMultiSelect", ["Play","Run","Refresh url","Update Url", "Nothing"])
        logger.debug("end...")

    def search(self, item):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_tv_shows()

        ok, text = gui.get_user_input("")
        if ok:
            tv_db = tvdb_api.TvDb()
            search_results = tv_db.search(text)
            for result in search_results:
                title = "%s - %s (%s)" % (str(result["id"]), result["seriesname"], result["language"])
                si = items.ShowItem(self, item, result["id"], title, "list_seasons", {"url": "www.google.com"})

                item_list.append(si)
            gui.render_items(item_list)

        logger.debug("end...")

    def list_seasons(self, item):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_tv_shows()

        if isinstance(item, items.CallerItem):
            si = items.SeasonItem(self, item, int(item.item_info["show_id"]), 1, "peperoni 1", "list_episodes")
            item_list.append(si)

            si = items.SeasonItem(self, item, int(item.item_info["show_id"]), 2, "peperoni 2", "list_episodes")
            item_list.append(si)

            gui.render_items(item_list)

        logger.debug("end...")

    def list_episodes(self, item):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_episodes()

        if isinstance(item, items.CallerItem):
            for x in range(1, 11):
                si = items.EpisodeItem(self, item, int(item.item_info["show_id"]), int(item.item_info["season"]), x,
                                       "carciofi", "list_null", folder=False, playable=False)
                item_list.append(si)

            gui.render_items(item_list)

        logger.debug("end...")

    def list_null(self, item):
        logger.debug("start...")
        run_item = \
            items.MenuItem(self,
                           config.get_localized_string(30910),
                           'list_c')

        choice = gui.show_select_dialog(["Play","Run","Refresh url","Update Url", "Nothing"])
        if choice == 0:
            gui.play_media(items.TestMediaItem("Play me",
                                           "http://download.wavetlan.com/SVV/Media/HTTP/H264/Other_Media/"
                                           "H264_test7_voiceclip_mp4_480x360.mp4"))
        elif choice == 1:
            gui.run(run_item.build_url())
        elif choice == 2:
            gui.refresh_url(run_item.build_url())

        elif choice == 3:
            gui.update_url(run_item.build_url())

        logger.debug("end...")

    def list_c(self, args):
        item_list = []

        plugin.set_content_to_movies()

        gui.render_items(item_list)

        logger.debug("end...")

    def list_a(self, args):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_movies()

        item_list.append(items.MenuItem(self, "Play me", "play_me", folder=False, playable=False))
        item_list.append(items.MenuItem(self, "Cancel me", "cancel_me", folder=False))
        item_list.append(items.MenuItem(self, "Null list", "list_null", folder=False, playable=False))

        gui.render_items(item_list)

        logger.debug("end...")

    def list_b(self, args):
        logger.debug("start...")

        item_list = []

        plugin.set_content_to_movies()

        item_list.append(items.MenuItem(self, "Go to Main", "main"))

        gui.render_items(item_list)

        logger.debug("end...")

    def play_me(self, args):
        logger.debug("start...")

        gui.play_media(items.TestMediaItem("Play me",
                                       "http://download.wavetlan.com/SVV/Media/HTTP/H264/Other_Media/"
                                       "H264_test7_voiceclip_mp4_480x360.mp4"))

        logger.debug("end...")
