# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Tools for file unzipping
# http://smystero.dlinkddns.org/smytvwhow/
# ------------------------------------------------------------

import zipfile
import os
import os.path

class ziptools:
    def extract(self, file, dir):

        if not dir.endswith(':') and not os.path.exists(dir):
            os.mkdir(dir)

        zf = zipfile.ZipFile(file)
        self._createstructure(file, dir)

        for name in zf.namelist():
            if not name.endswith('/'):
                content = zf.read(name)
                try:
                    (path, filename) = os.path.split(os.path.join(dir, name))
                    os.makedirs(path)
                except:
                    pass
                outfilename = os.path.join(dir, name)
                try:
                    outfile = open(outfilename, 'wb')
                    outfile.write(content)
                except:
                    pass

    def _createstructure(self, file, dir):
        self._makedirs(self._listdirs(file), dir)

    def _makedirs(self, directories, basedir):
        for dir in directories:
            curdir = os.path.join(basedir, dir)
            if not os.path.exists(curdir):
                os.mkdir(curdir)

    def _listdirs(self, file):
        zf = zipfile.ZipFile(file)
        dirs = []
        for name in zf.namelist():
            if name.endswith('/'):
                dirs.append(name)

        dirs.sort()
        return dirs
