# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# PusherManager
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

from pusher_info import PusherInfo


class Manager(object):
    ALL_PUSHERS = {
        "p_smytvshow": PusherInfo(0, "p_smytvshow", "sMyTvShow", {})
        ,"p_italiafilm": PusherInfo(1, "p_italiafilm", "ItaliaFilm.co", {})
        ,"p_altadefinizione": PusherInfo(2, "p_altadefinizione", "AltaDefinizione.club", {})
        ,"p_guardaserie": PusherInfo(3, "p_guardaserie", "GuardaSerie.news", {})
        ,"p_italiaserie": PusherInfo(4, "p_italiaserie", "ItaliaSerie.news", {})
        ,"p_seriehd": PusherInfo(5, "p_seriehd", "SerieHD.org", {})
        ,"p_filmpertutti": PusherInfo(6, "p_filmpertutti", "FilmPerTutti.click", {})
    }
    COMMON_PUSHERS = ("p_italiafilm", "p_altadefinizione", "p_guardaserie", "p_italiaserie", "p_seriehd", "p_filmpertutti")
    SPECIAL_PUSHERS = ("p_smytvshow",)

    def __init__(self):
        pass

    @staticmethod
    def get_pusher(pid):
        ret = None
        try:
            ret = Manager.ALL_PUSHERS[pid]
        except Exception, e:
            pass
        return ret

    @staticmethod
    def common_pushers():
        return Manager.COMMON_PUSHERS

    @staticmethod
    def all_pushers():
        return () + Manager.SPECIAL_PUSHERS + Manager.COMMON_PUSHERS
