import sys
import os
import urllib
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import logging
from operator import itemgetter

def show_tags():
  tag_handle = int(sys.argv[1])
  xbmcplugin.setContent(tag_handle, 'tags')

  for tag in tags:
    iconPath = os.path.join(home, 'logos', tag['icon'])
    li = xbmcgui.ListItem(tag['name'], iconImage=iconPath)
    url = sys.argv[0] + '?tag=' + str(tag['id'])
    xbmcplugin.addDirectoryItem(handle=tag_handle, url=url, listitem=li, isFolder=True)

  xbmcplugin.endOfDirectory(tag_handle)


def show_streams(tag):
  stream_handle = int(sys.argv[1])
  xbmcplugin.setContent(stream_handle, 'streams')
  logging.warning('TAG show_streams!!!! %s', tag)
  for stream in streams[str(tag)]:
    logging.debug('STREAM HERE!!! %s', stream['name'])
    iconPath = os.path.join(home, 'logos', stream['icon'])
    li = xbmcgui.ListItem(stream['name'], iconImage=iconPath)
    xbmcplugin.addDirectoryItem(handle=stream_handle, url=stream['url'], listitem=li)

  xbmcplugin.endOfDirectory(stream_handle)


def get_params():
  """
  Retrieves the current existing parameters from XBMC.
  """
  param = []
  paramstring = sys.argv[2]
  if len(paramstring) >= 2:
    params = sys.argv[2]
    cleanedparams = params.replace('?', '')
    if params[len(params) - 1] == '/':
      params = params[0:len(params) - 2]
    pairsofparams = cleanedparams.split('&')
    param = {}
    for i in range(len(pairsofparams)):
      splitparams = {}
      splitparams = pairsofparams[i].split('=')
      if (len(splitparams)) == 2:
        param[splitparams[0]] = splitparams[1]
  return param


def lower_getter(field):
  def _getter(obj):
    return obj[field].lower()

  return _getter


addon = xbmcaddon.Addon()
home = xbmc.translatePath(addon.getAddonInfo('path'))

tags = [
  {
    'name': 'UK Sports',
    'id': 'LiveTV',
    'icon': 'livetv.png'
  }, {
    'name': 'Enjoy! - Tweet @BrianHR100',
    'id': 'comingsoon',
    'icon': 'comingsoon.png'
  }
]


LiveTV = [{
  'name': 'Sky Sports 1',
  'url': 'http://50.97.49.87:1935/apqq2/skysports1lsh/playlist.m3u8',
  'icon': 'ss1.png',
  'disabled': False
}, {
  'name': 'Sky Sports 2',
  'url': 'http://50.97.49.87:1935/apqq2/skysports2lsh/playlist.m3u8',
  'icon': 'ss2.png',
  'disabled': False
}, {
  'name': 'Sky Sports 3',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/531.m3u8',
  'icon': 'ss3.png',
  'disabled': False
}, {
  'name': 'Sky Sports 4',
  'url': 'http://50.97.49.87:1935/apqq2/skysports4lsh/playlist.m3u8',
  'icon': 'ss4.png',
  'disabled': False
}, {
  'name': 'Sky Sports 5',
  'url': 'http://50.97.49.87:1935/apqq2/skysports5lsh/playlist.m3u8',
  'icon': 'ss5.png',
  'disabled': False

}, {
  'name': 'Sky Sports News HQ',
  'url': 'http://xtream.iptv-streamer.com:8000/live/3333/3333/653.ts',
  'icon': 'ssn.png',
  'disabled': True
}, {
  'name': 'BT Sports 1',
  'url': 'http://50.97.49.87:1935/apqq2/btsports1lsh58/playlist.m3u8',
  'icon': 'bts1.png',
  'disabled': False
}, {
  'name': 'BT Sports 2',
  'url': 'http://50.97.49.87:1935/apqq2/btsports2lsh/playlist.m3u8',
  'icon': 'bts2.png',
  'disabled': False
}, {
  'name': 'BT Sports Europe',
  'url': 'http://50.97.49.87:1935/apqq2/bteulsh/playlist.m3u8',
  'icon': 'btseu.png',
  'disabled': False
}, {
  'name': 'BT Sports ESPN',
  'url': 'http://50.97.49.87:1935/apqq2/espnuklsh/playlist.m3u8',
  'icon': 'btespn.png',
  'disabled': False
}, {
  'name': 'HD Sky Sports 1',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/548.m3u8',
  'icon': 'sky1.png',
  'disabled': False
}, {
  'name': 'HD Sky Sports 2',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/547.m3u8',
  'icon': 'sky2.png',
  'disabled': False
}, {
  'name': 'HD Sky Sports 3',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/5.ch',
  'icon': 'sky3.png',
  'disabled': False
}, {
  'name': 'Liverpool fc Tv',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/536.m3u8',
  'icon': 'lfctv.png',
  'disabled': False
}, {
  'name': 'MUTV',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/535.m3u8',
  'icon': 'MUTV.png',
  'disabled': False
}, {
  'name': 'HD Sky Sports 4',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/545.m3u8',
  'icon': 'sky4.png',
  'disabled': False
}, {
  'name': 'HD Sky Sports 5',
  'url': 'http://ipsatpro.com:8000/live/1975/1975/544.m3u8',
  'icon': 'sky5.png',
  'disabled': False
}, {
  'name': 'Sky Sports 1',
  'url': 'rtmp://lb.miplayer.net:1935/goLive/_definst_/ibrodtv21_6vhudlq8',
  'icon': 'sky1.png',
  'disabled': False
}, {
  'name': 'Sky Sports 2',
  'url': 'rtmp://lb.miplayer.net:1935/goLive/_definst_/ibrodtv22_j5p1mted',
  'icon': 'sky2.png',
  'disabled': False
}, {
  'name': 'Sky Sports 3',
  'url': 'rtmp://lb.miplayer.net:1935/goLive/_definst_/ibrodtv23_5px3ntfs',
  'icon': 'sky3.png',
  'disabled': False
}, {
  'name': 'Sky Sports 4',
  'url': 'rtmp://lb.miplayer.net:1935/goLive/_definst_/ibrodtv24_f84rdmk',
  'icon': 'sky4.png',
  'disabled': False
}, {
  'name': 'Sky Sports 5',
  'url': 'rtmp://lb.miplayer.net:1935/goLive/_definst_/ibrodtv25_wt250ssk',
  'icon': 'sky5.png',
  'disabled': False
}, {
  'name': 'Sky Sports 1',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/86.ch',
  'icon': 'sky1.png',
  'disabled': False
}, {
  'name': 'Sky Sports 2',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/75.ch',
  'icon': 'sky2.png',
  'disabled': False
}, {
  'name': 'Sky Sports 3',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/76.ch',
  'icon': 'sky3.png',
  'disabled': False
}, {
  'name': 'Sky Sports 4',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/77.ch',
  'icon': 'sky4.png',
  'disabled': False
}, {
  'name': 'Sky Sports 5',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/74.ch',
  'icon': 'sky5.png',
  'disabled': False
}, {
  'name': 'BT Sports 2',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/6.ch',
  'icon': 'bts2.png',
  'disabled': False
}, {
  'name': 'Box Nation',
  'url': 'http://37.187.251.79:8080/skype/globalsportsIPTV/213.ch',
  'icon': 'BoxNation.png',
  'disabled': False
}]


Movies = [{
  'name': 'batman v superman',
  'url': '',
  'icon': 'bvs.png',
  'disabled': False
}]


streams = {
  'LiveTV': sorted((i for i in LiveTV if not i.get('disabled', False)), key=lower_getter('name')),
  'Movies': sorted((i for i in Movies if not i.get('disabled', False)), key=lower_getter('name')),
  # 'LiveTV': sorted(LiveTV, key=lower_getter('name')),
  # 'Movies': sorted(Movies, key=lower_getter('name')),
}

PARAMS = get_params()
TAG = None
logging.warning('PARAMS!!!! %s', PARAMS)

try:
  TAG = PARAMS['tag']
except:
  pass

logging.warning('ARGS!!!! sys.argv %s', sys.argv)

if TAG == None:
  show_tags()
else:
  show_streams(TAG)
