# -*- coding: utf-8 -*-
#
#    Copyright (c) 2015 Billy2011, MediaPortal Team
#

import os
from os.path import isfile
import sys
import time
import gzip
import threading
import twisted
from twisted.internet import task, reactor
from twisted.web.client import downloadPage, getPage
from .xmltvconverter import XMLTVConverter
import log

channelEPGCache = {}
mutex = threading.Lock()
DEFAULT_URLS = ("http://epg.iptv.ink/iptv.epg.gz",)

class ImportThread(threading.Thread):

	def __init__(self, threadID, name, import_func, callback=None, finiback=None):
		threading.Thread.__init__(self)
		self.threadID = threadID
		self.name = name
		self.import_func = import_func
		self.callback = callback
		self.finiback = finiback

	def run(self):
		print>>log, "[MP EPG] Starting " + self.name
		self.import_func()
		if self.callback: self.callback()
		print>>log, "[MP EPG] Exiting " + self.name
		if self.finiback: reactor.callFromThread(self.finiback)

class SimpleEPG(object):

	EPG_TMP_NAME = 'mp-iptv.epg_new.gz'
	EPG_DAT_NAME = 'mp-iptv.epg.dat'

	def __init__(self, epg_storage_path=None, epg_urls=DEFAULT_URLS):
		self.epg_path = epg_storage_path
		self.epg_urls = epg_urls
		self.has_epg = False
		self.ismodified = False
		path = '/tmp'
		if self.checkPath('/media/cf'):
			path='/media/cf'
		if self.checkPath('/media/usb'):
			path='/media/usb'
		if self.checkPath('/media/hdd'):
			path='/media/hdd'
		self.epg_tmp_file = os.path.join(path, self.EPG_TMP_NAME)
		self.epg_dat_file = os.path.join(path, self.EPG_DAT_NAME)
		self.isImporting = False

	def importEPGData(self):
		global mpepg
		if not self.isImporting and isfile(self.epg_dat_file):
			ImportThread(1, "MP-EPGDAT-ImportThread-1", self.readEPG).start()

	def getEPGData(self, u_idx=0):
		if not self.isImporting:
			self.isImporting = True
			self.url_idx = u_idx
			downloadPage(self.epg_urls[u_idx], self.epg_tmp_file, timeout=60).addCallback(lambda x: self.storeEPGData()).addErrback(self.downloadErr)

	def importThreadFini(self):
		print>>log, "[MP EPG] Import finished: " + self.epg_urls[self.url_idx]
		if (self.url_idx+1) < len(self.epg_urls):
			self.getEPGData(self.url_idx+1)
		else:
			self.saveEPG()

	def downloadErr(self, err):
		self.isImporting = False
		print>>log, "[MP EPG] Can't download iptv.ink epg data:\n%s" % err

	def storeEPGData(self):
		ImportThread(1, "MP-EPG-ImportThread-1", self.importEPG, self.importThreadFini).start()

	def importEPG(self, deleteFile=True):
		if isfile(self.epg_tmp_file):
			mutex.acquire()
			try:
				file = gzip.open(self.epg_tmp_file, 'rb')
				conv = XMLTVConverter()
				if not self.ismodified: channelEPGCache.clear()
				now = int(time.time())
				channelEPGCache['last_update_tm'] = now
				now -= 7200
				for program in conv.enumFile(file):
					ch, event = program
					ch = format(hash(ch.lower()) & sys.maxint, 'x')
					if not event[1] >= now: continue
					if not channelEPGCache.has_key(ch):
						channelEPGCache[ch] = []
					channelEPGCache[ch].append(event)
				file.close()
				if deleteFile:
					try:
						os.unlink(self.epg_tmp_file)
					except Exception, e:
						print>>log, "[MP EPG] Warning: Could not remove '%s' intermediate:\n%s" % (self.epg_tmp_file, str(e))
				self.has_epg = True if len(channelEPGCache) > 10 else False
				self.ismodified = True
			except:
				self.has_epg = False
			finally:
				self.isImporting = False
				mutex.release()

	def lockEPGCache(self, blocking=True):
		return mutex.acquire(blocking)

	def unlockEPGCache(self):
		return mutex.release()

	def getEvent(self, id, now=None):
		result = None
		try:
			p = channelEPGCache[id]
		except:
			pass
		else:
			if not now:
				now = int(time.time())

			def iter_events(p):
				for e in p:
					try:
						yield e
					except StopIteration:
						yield None
						break

			events = iter_events(p)
			for event in events:
				if event[1] >= now and now >= event[0]:
					#result = (id,event,events.next())
					result = (id,event,None)
					break

		return result

	def checkPath(self,path):
		f = os.popen('mount', "r")
		for l in f.xreadlines():
			if l.find(path)!=-1:
				return True
		return False

	def close(self):
		pass

	def saveEPG(self):
		global channelEPGCache
		if not self.ismodified or not self.has_epg: return
		mutex.acquire()
		print>>log, "[MP EPG] Saving EPG Data: " + self.epg_dat_file
		try:
			import cPickle as pickle
			#picklefile = gzip.open(self.epg_dat_file, 'wb')
			picklefile = open(self.epg_dat_file, 'wb')
			pickle.dump(channelEPGCache, picklefile)
			picklefile.close()
			self.ismodified = False
		except:
			print>>log, 'Error: saving EPG "%s"' % self.epg_dat_file
		finally:
			mutex.release()

	def readEPG(self):
		global channelEPGCache
		mutex.acquire()
		try:
			import cPickle as pickle
			#picklefile = gzip.open(self.epg_dat_file, 'rb')
			picklefile = open(self.epg_dat_file, 'rb')
			channelEPGCache = pickle.load(picklefile)
			picklefile.close()
			self.has_epg = True if len(channelEPGCache) > 10 else False
			self.ismodified = False
		except:
			print>>log, 'Error: reading EPG "%s"' % self.epg_dat_file
			self.channelEPGCache = {}
		finally:
			mutex.release()

mpepg = SimpleEPG()
