# -*- coding: utf-8 -*-
#
# HDMI Input Plugin by gutemine
#
hdmi_in_version="0.14"
#
# Thanks emanuel for the basics
#
from Components.ActionMap import ActionMap
from Components.Label import Label
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox 
from Plugins.Plugin import PluginDescriptor
from Components.config import config, ConfigSubsection, ConfigText, ConfigBoolean, ConfigInteger, ConfigSelection, getConfigListEntry
from Components.ConfigList import ConfigListScreen
from enigma import quitMainloop, eServiceReference
from Screens.Standby import Standby as StandbyOrg, StandbySummary as StandbySummaryOrg
import Screens.Standby
from Components.AVSwitch import AVSwitch
from Components.SystemInfo import SystemInfo
from enigma import eTimer, eDVBVolumecontrol, eDVBLocalTimeHandler, eServiceReference
from GlobalActions import globalActionMap
from os import statvfs as os_statvfs, path as os_path

yes_no_descriptions = {False: _("no"), True: _("yes")}
config.plugins.hdmiin = ConfigSubsection()
hdmiin_resolutions = []                                                     
hdmiin_resolutions.append(( "720p",_("Enable 720p24 Mode").replace("720p24","720p") ))
hdmiin_resolutions.append(( "720p24",_("Enable 720p24 Mode") ))
hdmiin_resolutions.append(( "720p60",_("Enable 720p24 Mode").replace("720p24","720p60") ))
config.plugins.hdmiin.resolution = ConfigSelection(default = "720p", choices = hdmiin_resolutions)
hdmiin_setup = []                                                     
hdmiin_setup.append(( "devices",_("Devices") ))
hdmiin_setup.append(( "menu",_("Menu") ))
hdmiin_setup.append(( "both",_("Menu")+" & "+_("Devices") ))
config.plugins.hdmiin.setup = ConfigSelection(default = "both", choices = hdmiin_setup)
config.plugins.hdmiin.force_hdmi_audio_disable = ConfigBoolean(default = False, descriptions=yes_no_descriptions) 
config.plugins.hdmiin.bypass_edid_checking = ConfigBoolean(default = False, descriptions=yes_no_descriptions) 
config.plugins.hdmiin.on_idle = ConfigBoolean(default = False, descriptions=yes_no_descriptions) 
config.plugins.hdmiin.suspend_streamserver = ConfigBoolean(default = True, descriptions=yes_no_descriptions) 
config.plugins.hdmiin.disabled_streamserver = ConfigBoolean(default = False, descriptions=yes_no_descriptions) 
config.plugins.hdmiin.led_pattern = ConfigInteger(default = 128, limits=(0,255))

hdmi_in_title=_("HDMI Input")+" "+_("Plugin")
hdmi_in_title_version=hdmi_in_title+" "+" V%s" % hdmi_in_version+"\n(c) "+_("gutemine")

class StandbyHdmiIn(StandbyOrg):                                                      
        def __init__(self, session):                                            
		StandbyOrg.__init__(self, session)

class HdmiIn(Screen):
	skin = """
	<screen position="0,0" size="1280,720" title="HDMI Input" flags="wfNoBorder" zPosition="10" transparent="1" >
	</screen>"""
	def __init__(self, session, args = 0):
		self.session=session
		self.skin=HdmiIn.skin
		Screen.__init__(self, session)
		f=open("/proc/interrupts","r")
		line=f.readline()
		self.interrupts=0
		while line:
			line=f.readline()
			if line.endswith("HDMI_RX_0\n"):
				sp=[]	
				sp=line.split()
				self.interrupts=int(sp[1])
		f.close()
		print _("[HDMI-IN] interrupts: %d") % (self.interrupts)
		self.onFirstExecBegin.append(self.passtrough)

		self["setupActions"] = ActionMap([ "SetupActions", "ChannelSelectEPGActions", "DirectionActions", "PowerKeyActions", "MenuActions" ],
			{
			"save": self.leave,
			"cancel": self.leave,
			"showEPGList": self.about,
			"ok": self.about,
			"left": self.about,
			"right": self.about,
			"previousSection": self.about,
			"nextSection": self.about,
			"deleteForward": self.about,
			"deleteBackward": self.about,
			"up": self.about,
			"down": self.about,
			"powerdown": self.powerdown,
			"powerup": self.powerup,
			"menu": self.configure,
                        }, -3)   
		config.plugins.hdmiin.disabled_streamserver.value=False                 

	def passtrough(self):
		f=open("/proc/stb/video/videomode","r")
		self.oldvideomode=f.read()
		f.close()
		f=open("/proc/stb/video/videomode_50hz","r")
		self.oldvideomode_50hz=f.read()
		f.close()
		f=open("/proc/stb/video/videomode_60hz","r")
		self.oldvideomode_60hz=f.read()
		f.close()

		self.oldservice=self.session.nav.getCurrentlyPlayingServiceReference().toString()

		f=open("/proc/interrupts","r")
		line=f.readline()
		self.interrupts=0
		while line:
			line=f.readline()
			if line.endswith("HDMI_RX_0\n"):
				sp=[]	
				sp=line.split()
				self.interrupts=int(sp[1])
		f.close()

		self.InterruptsTimer = eTimer()
  		if os_path.exists("/var/lib/dpkg/status"):
	                self.InterruptsTimer_conn = self.InterruptsTimer.timeout.connect(self.enablePasstrough)
        	else:                        
                	self.InterruptsTimer.callback.append(self.enablePasstrough)

	        self.InterruptsTimer.start(200, True)

	def enablePasstrough(self):
		f=open("/proc/interrupts","r")
		line=f.readline()
		interrupts=0
		global hdmi_in_interrupts
		while line:
			line=f.readline()
			if line.endswith("HDMI_RX_0\n"):
				sp=[]	
				sp=line.split()
				interrupts=int(sp[1])
		f.close()
		print _("[HDMI-IN] interrupts: %d -> %d") % (self.interrupts, interrupts)
		if interrupts == self.interrupts:
			# interrupts are not going up - probably nothing plugged into HDMI-IN
			self.session.openWithCallback(self.close,MessageBox, _("HDMI Input")+" "+_("nothing connected").lower(), MessageBox.TYPE_ERROR) 
			return

		print "###############################################"
		print _("[HDMI-IN] Display content")
		print "###############################################"

		self.session.nav.stopService()

		f=open("/proc/stb/video/videomode","w")
		f.write(config.plugins.hdmiin.resolution.value)
		f.close()

		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("on")
		f.close()

		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("on")
		f.close()

		f=open("/proc/stb/fp/led_set_pattern","w")
		f.write(str(config.plugins.hdmiin.led_pattern.value))
		f.close()
		
		f=open("/proc/stb/hdmi/bypass_edid_checking","w")
		if config.plugins.hdmiin.bypass_edid_checking.value:
			f.write("1")
		else:
			f.write("0")
		f.close()
	
		f=open("/proc/stb/audio/force_hdmi_audio_disable","w")
		if config.plugins.hdmiin.force_hdmi_audio_disable:
			f.write("1")
		else:
			f.write("0")
		f.close()

	        if os_path.exists("/usr/lib/enigma2/python/Plugins/SystemPlugins/StreamServer/StreamServerConfig.py"):
		        if config.streamserver.enabled.value and config.plugins.hdmiin.suspend_streamserver.value and int(config.streamserver.source.value)==1:
				config.plugins.hdmiin.disabled_streamserver.value=True                
	        		import Plugins.SystemPlugins.StreamServer.StreamServerConfig
				from Components.StreamServerControl import StreamServerControl, streamServerControl
				config.streamserver.enabled.value=False
				Plugins.SystemPlugins.StreamServer.StreamServerConfig.applyConfig(streamServerControl)
				print "[HDMI-IN] streaming disabled"

	def leave(self):
		print "###############################################"
		print "[HDMI-IN] Display last channel"
		print "###############################################"

		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

		f=open("/proc/stb/avs/0/input","w")
		f.write("aux")
		f.close()

		f=open("/proc/stb/avs/0/input","w")
		f.write("encoder")
		f.close()

		f=open("/proc/stb/video/videomode","w")
		f.write(self.oldvideomode)
		f.close()

		f=open("/proc/stb/video/videomode_50hz","w")
		f.write(self.oldvideomode_50hz)
		f.close()

		f=open("/proc/stb/video/videomode_60hz","w")
		f.write(self.oldvideomode_60hz)
		f.close()

		f=open("/proc/stb/fp/led_set_pattern","w")
		f.write("0")
		f.close()

		if config.plugins.hdmiin.bypass_edid_checking.value:
			f=open("/proc/stb/hdmi/bypass_edid_checking","w")
			f.write("0")
			f.close()

		if config.plugins.hdmiin.force_hdmi_audio_disable:
			f=open("/proc/stb/audio/force_hdmi_audio_disable","w")
			f.write("0")
			f.close()

	        if os_path.exists("/usr/lib/enigma2/python/Plugins/SystemPlugins/StreamServer/StreamServerConfig.py"):
		        if config.plugins.hdmiin.disabled_streamserver.value:                 
			        config.plugins.hdmiin.disabled_streamserver.value=False               
	        		import Plugins.SystemPlugins.StreamServer.StreamServerConfig
				from Components.StreamServerControl import StreamServerControl, streamServerControl
				config.streamserver.enabled.value=True
				Plugins.SystemPlugins.StreamServer.StreamServerConfig.applyConfig(streamServerControl)
				print "[HDMI-IN] streaming enabled"

		self.session.nav.playService(eServiceReference(self.oldservice))
		self.oldservice=None
		self.close(True)

	def about(self):
	       	self.session.open(HdmiInAbout)

	def configure(self):
		if config.plugins.hdmiin.setup.value=="setup":
			self.about()
		else:
			self.session.open(HdmiInConfiguration)

	def powerdown(self):
		if config.plugins.hdmiin.on_idle.value:
			self.leave()
			return
		f=open("/proc/stb/avs/0/input","r")
		status=f.read()
		f.close()
		if status.startswith("encoder"):
		        print "[HDMI-IN] power down"
			f=open("/proc/stb/avs/0/input","w")
			f.write("aux")
			f.close()
		else:
		        print "[HDMI-IN] power up"
			f=open("/proc/stb/avs/0/input","w")
			f.write("encoder")
			f.close()

	def powerup(self):
		pass

# rename Standby if needed
if config.plugins.hdmiin.on_idle.value: 
	Screens.Standby.Standby=HdmiIn
else:
	Screens.Standby.Standby=StandbyHdmiIn

class HdmiInConfiguration(Screen, ConfigListScreen):
    skin = """
        <screen position="center,center" size="570,250" title="HMDI Input Configuration" >
        <widget name="config" position="10,60" size="550,180" scrollbarMode="showOnDemand" />
        <widget name="buttonred" position="10,10" size="130,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="buttongreen" position="150,10" size="130,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="buttonyellow" position="290,10" size="130,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="buttonblue" position="430,10" size="130,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        </screen>"""

    def __init__(self, session, args = 0):
	Screen.__init__(self, session)

        self.onShown.append(self.setWindowTitle)
	self.onChangedEntry = []
	
        self.list = []                                                  
       	ConfigListScreen.__init__(self, self.list, session = self.session, on_change = self.changedEntry)
       	self.createSetup()       

       	self["buttonred"] = Label(_("Exit"))
       	self["buttongreen"] = Label(_("OK"))
       	self["buttonyellow"] = Label(_("Help"))
	self["buttonblue"] = Label(_("About"))
        self["setupActions"] = ActionMap(["SetupActions", "ColorActions"],
       	{
       		"green": self.save,
        	"red": self.cancel,
	       	"yellow": self.about,
        	"blue": self.about,
            	"save": self.save,
            	"cancel": self.cancel,
            	"ok": self.save,
       	})
       	
    def createSetup(self):                                                  
       	self.list = []
	self.list.append(getConfigListEntry(_("Resolution")+" "+("HDMI Input"), config.plugins.hdmiin.resolution))
      	self.list.append(getConfigListEntry(_("Idle")+" "+_("Mode")+" "+_("HDMI Input")+" "+_("enable"), config.plugins.hdmiin.on_idle))
#      	self.list.append(getConfigListEntry(_("Audio")+" "+_("disable"), config.plugins.hdmiin.force_hdmi_audio_disable))
      	self.list.append(getConfigListEntry(_("Setup")+" "+("HDMI Input"), config.plugins.hdmiin.setup))
      	self.list.append(getConfigListEntry(_("EDID")+" "+_("Check")+" "+_("disable"), config.plugins.hdmiin.bypass_edid_checking))
      	self.list.append(getConfigListEntry(_("LED")+" "+_("blue"), config.plugins.hdmiin.led_pattern))
        if os_path.exists("/usr/lib/enigma2/python/Plugins/SystemPlugins/StreamServer/StreamServerConfig.py"):
	    if config.plugins.hdmiin.disabled_streamserver.value or (config.streamserver.enabled.value and int(config.streamserver.source.value)==1):
	      	self.list.append(getConfigListEntry(_("Streamserver")+" "+_("disable"), config.plugins.hdmiin.suspend_streamserver))
        self["config"].list = self.list                                 
        self["config"].l.setList(self.list)         
       	
    def changedEntry(self):                                                 
       	self.createSetup()       
		
    def setWindowTitle(self):
	self.setTitle(hdmi_in_title+" "+_("Setup"))

    def save(self):
	f=open("/proc/stb/video/videomode","w")
	f.write(config.plugins.hdmiin.resolution.value)
	f.close()

	f=open("/proc/stb/hdmi/bypass_edid_checking","w")
	if config.plugins.hdmiin.bypass_edid_checking.value:
		f.write("1")
	else:
		f.write("0")
	f.close()

	f=open("/proc/stb/audio/force_hdmi_audio_disable","w")
	if config.plugins.hdmiin.force_hdmi_audio_disable:
		f.write("1")
	else:
		f.write("0")
	f.close()
	# rename Standby if needed
	if config.plugins.hdmiin.on_idle.value: 
		Screens.Standby.Standby=HdmiIn
	else:
		Screens.Standby.Standby=StandbyHdmiIn
        for x in self["config"].list:
           x[1].save()
        self.close(True)

    def cancel(self):
        for x in self["config"].list:
           x[1].cancel()
        self.close(False)

    def about(self):
       	self.session.open(HdmiInAbout)

class HdmiInAbout(Screen):
    skin = """
        <screen position="center,center" size="680,440" title="About HDMI Input Plugin" >
        <ePixmap position="290,10" size="100,100" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/HdmiIn/g3icon_hdmi_in.png" transparent="1" alphatest="on" />
        <widget name="buttonred" position="30,30" size="230,60" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="buttongreen" position="420,30" size="230,60" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="abouthdmiin" position="10,130" size="660,80" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;32"/>
        <widget name="freefilesystem" position="100,210" size="200,220" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;24"/>
        <widget name="freememory" position="370,210" size="200,220" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;24"/>
        </screen>"""

    def __init__(self, session, args = 0):
	Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)
        st = os_statvfs("/")                                                                           
        free = st.f_bavail * st.f_frsize/1024/1024                                                               
        total = st.f_blocks * st.f_frsize/1024/1024                                                
        used = (st.f_blocks - st.f_bfree) * st.f_frsize/1024/1024 
	freefilesystem=_("Root Filesystem\n\ntotal: %s MB\nused:  %s MB\nfree:  %s MB") % (total,used,free)		

      	memfree=0
      	memtotal=0
      	memused=0
	fm=open("/proc/meminfo")
      	line = fm.readline()
      	sp=line.split()
      	memtotal=int(sp[1])/1024
      	line = fm.readline()
      	sp=line.split()
      	memfree=int(sp[1])/1024
	fm.close()
	memused=memtotal-memfree
	freememory=_("Memory\n\ntotal: %i MB\nused: %i MB\nfree: %i MB") % (memtotal,memused,memfree)		

       	self["buttonred"] = Label(_("Exit"))
       	self["buttongreen"] = Label(_("OK"))
       	self["abouthdmiin"] = Label(hdmi_in_title_version)
       	self["freefilesystem"] = Label(freefilesystem)
       	self["freememory"] = Label(freememory)
        self["setupActions"] = ActionMap(["SetupActions", "ColorActions"],
       	{
       		"green": self.cancel,
        	"red": self.cancel,
	       	"yellow": self.cancel,
        	"blue": self.cancel,
            	"save": self.cancel,
            	"cancel": self.cancel,
            	"ok": self.cancel,
       	})

    def setWindowTitle(self):
        self.setTitle(_("About")+" "+hdmi_in_title)

    def cancel(self):
        self.close(False)

def startHdmiIn(session, **kwargs):
	session.open(HdmiIn)    

def startHdmiInConfiguration(session, **kwargs):
	session.open(HdmiInConfiguration)    

def autostart(reason,**kwargs):     
        print "[HDMI-IN] autostart"
	f=open("/proc/stb/fp/led_set_pattern","w")
	f.write("0")
	f.close()

	f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","r")
	check=f.read()
	f.close()
	if check.startswith("on"):
		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

	f=open("/proc/stb/audio/hdmi_rx_monitor","r")
	check=f.read()
	f.close()
	if check.startswith("on"):
		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

	f=open("/proc/stb/hdmi/bypass_edid_checking","r")
	check=f.read()
	f.close()
	if check.find("1") is not -1:
		f=open("/proc/stb/hdmi/bypass_edid_checking","w")
		f.write("o")
		f.close()
	
	f=open("/proc/stb/audio/force_hdmi_audio_disable","r")
	check=f.read()
	f.close()
	if check.find("1") is not -1:
		f=open("/proc/stb/audio/force_hdmi_audio_disable","w")
		f.write("0")
		f.close()
	config.plugins.hdmiin.disabled_streamserver.value=False
	config.plugins.hdmiin.disabled_streamserver.save()

def Plugins(**kwargs):
	return [PluginDescriptor(name=_("HDMI Input"), description=hdmi_in_title, where = PluginDescriptor.WHERE_EXTENSIONSMENU, icon="g3icon_hdmi_in.png", fnc=startHdmiIn),
		PluginDescriptor(where = [PluginDescriptor.WHERE_AUTOSTART], fnc = autostart),
		PluginDescriptor(name=_("HDMI Input"), description=hdmi_in_title, where=PluginDescriptor.WHERE_MENU, fnc=mainconf)]

def mainconf(menuid):
	if menuid == "mainmenu":                                                  
		return [(_("HDMI Input"), startHdmiIn, "hdmi_in", None)] 
	if menuid == "devices":                                                  
		if config.plugins.hdmiin.setup.value!="menu":
			return [(_("HDMI Input"), startHdmiInConfiguration, "hdmi_in_config", None)] 
	return [ ]                                                     

