# -*- coding: utf-8 -*-
#
# HDMI Input Plugin by gutemine
#
hdmi_in_version="0.6"
#
# Thank's emanuel for the basics
#
from Components.ActionMap import ActionMap
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox 
from Plugins.Plugin import PluginDescriptor

from enigma import eServiceReference

hdmi_in_title=_("HDMI Input")+" "+_("Plugin gutemine")+" V%s " % hdmi_in_version

class HdmiIn(Screen):
	skin = """
	<screen position="0,0" size="1280,720" title="HDMI Input" flags="wfNoBorder" zPosition="10" transparent="1" >
	</screen>"""

	def __init__(self, session, args = 0):
		Screen.__init__(self, session)
		self["setupActions"] = ActionMap([ "SetupActions", "ChannelSelectEPGActions", "DirectionActions", "PowerKeyActions" ],
			{
			"save": self.leave,
			"cancel": self.leave,
			"showEPGList": self.about,
			"ok": self.about,
			"left": self.about,
			"right": self.about,
			"previousSection": self.about,
			"nextSection": self.about,
			"deleteForward": self.about,
			"deleteBackward": self.about,
			"up": self.about,
			"down": self.about,
			"powerdown": self.powerdown,
			"powerup": self.powerup,
                        }, -3)   

		self.oldservice=self.session.nav.getCurrentlyPlayingServiceReference().toString()
		self.session.nav.stopService()

		f=open("/proc/stb/video/videomode","r")
		self.oldvideomode=f.read()
		f.close()
		f=open("/proc/stb/video/videomode_50hz","r")
		self.oldvideomode_50hz=f.read()
		f.close()
		f=open("/proc/stb/video/videomode_60hz","r")
		self.oldvideomode_60hz=f.read()
		f.close()

		f=open("/proc/stb/video/videomode","w")
		f.write("720p")
		f.close()

		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("on")
		f.close()

		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("on")
		f.close()

		print _("Display HDMI-IN content")

	def leave(self):
		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

#		f=open("/proc/stb/avs/0/input","w")
#		f.write("aux")
#		f.close()

#		f=open("/proc/stb/avs/0/input","w")
#		f.write("encoder")
#		f.close()

		f=open("/proc/stb/video/videomode","w")
		f.write(self.oldvideomode)
		f.close()
		f=open("/proc/stb/video/videomode_50hz","w")
		f.write(self.oldvideomode_50hz)
		f.close()
		f=open("/proc/stb/video/videomode_60hz","w")
		f.write(self.oldvideomode_60hz)
		f.close()

		self.session.nav.playService(eServiceReference(self.oldservice))
		self.oldservice=None
		print _("Display last channel")
		self.close(True)

	def about(self):
		self.session.open(MessageBox, hdmi_in_title , MessageBox.TYPE_INFO)

	def powerdown(self):
		f=open("/proc/stb/avs/0/input","r")
		status=f.read()
		f.close()
		if status.startswith("encoder"):
		        print "[HDMI-IN] power down"
			f=open("/proc/stb/avs/0/input","w")
			f.write("aux")
			f.close()
		else:
		        print "[HDMI-IN] power up"
			f=open("/proc/stb/avs/0/input","w")
			f.write("encoder")
			f.close()

	def powerup(self):
		pass

def startHdmiIn(session, **kwargs):
	session.open(HdmiIn)    

def autostart(reason,**kwargs):     
	print "###########################################"
        print "[HDMI-IN] autostart"
	print "###########################################"
	f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","r")
	check=f.read()
	f.close()
	if check.startswith("on"):
		f=open("/proc/stb/hdmi-rx/0/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

	f=open("/proc/stb/audio/hdmi_rx_monitor","r")
	check=f.read()
	f.close()
	if check.startswith("on"):
		f=open("/proc/stb/audio/hdmi_rx_monitor","w")
		f.write("off")
		f.close()

def Plugins(**kwargs):
#	return [PluginDescriptor(name=_("HDMI Input"), description=hdmi_in_title, where = PluginDescriptor.WHERE_MENU, fnc=mainconf)]
	return [PluginDescriptor(name=_("HDMI Input"), description=hdmi_in_title, where = PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=startHdmiIn),
		PluginDescriptor(where = [PluginDescriptor.WHERE_AUTOSTART], fnc = autostart),
		PluginDescriptor(name=_("HDMI Input"), description=hdmi_in_title, where=PluginDescriptor.WHERE_MENU, fnc=mainconf)]

def mainconf(menuid):
	if menuid != "mainmenu":                                                  
		return [ ]                                                     
	return [(_("HDMI Input"), startHdmiIn, "hdmi_in", None)] 

