#!/usr/bin/perl
# Version : 1.0
# Author  : Adem elik
# Tel     : +905357752170
# SkyPe   : ben-adembaba@hotmail.com
# Mail    : admin@turkdvb.com, turkdvb@gmail.com
# www.turkdvb.com   panel.turkdvb.com
# Copyright  TurkDvb. All Rights Reserved

@INC = &unique(@INC, ".");
BEGIN { push(@INC, ".."); };
use WebminCore;
use JSON;
&init_config();
&ReadParse();
@TURKDVB;

sub faalSoftGetSystemInfo {
	if($cache_fssysteminfo){return $cache_fssysteminfo;};
	local($fssyinfo);
	&foreign_require("system-status", "system_info.pl");
	$systeminf = &system_status::collect_system_info();
	@cpu = @{$systeminf->{'cpu'}};
	$cpu = \@cpu;
	$cpuused = $cpu[0]+$cpu[1]+$cpu[3];
	$fscpu = {'used'=> ($cpuused||1)};

	my ($disktotal, $diskfree) = ($systeminf->{'disk_total'}, $systeminf->{'disk_free'});
	$fsdisk = {'total'=>$disktotal,'free'=> $free,'used'=> ($disktotal-$diskfree||1)};

	my ($ramtotal,$ramfree,$vramtotal,$vramfree,$rtssss) = (@{$systeminf->{'mem'}});
	$fsram = {'total'=>$ramtotal,'free'=> $ramfree,'used'=> ($ramtotal-$ramfree||1)};
	$fsvram = {'total'=> $vramtotal,'free'=> $vramfree,'used'=> ($vramtotal-$vramfree||1)};

	$fssyinfo->{'cpu'} = $fscpu;
	$fssyinfo->{'disk'} = $fsdisk;
	$fssyinfo->{'ram'} = $fsram;
	$fssyinfo->{'vram'} = $fsvram;

	$fssyinfo->{'kernel'} = $systeminf->{'kernel'};
	$cache_fssysteminfo = $fssyinfo;
	return $cache_fssysteminfo;
}

if($in{'getsysteminfo'}) {
	&PrintHeader($charset);
	$fsysinf = &faalSoftGetSystemInfo();
	print JSON->new->encode($fsysinf);
}


