#!/usr/bin/perl
# Version : 1.0
# Author  : Adem elik
# Tel     : +905357752170
# SkyPe   : ben-adembaba@hotmail.com
# Mail    : admin@turkdvb.com, turkdvb@gmail.com
# www.turkdvb.com   panel.turkdvb.com
# Copyright  TurkDvb. All Rights Reserved

use WebminCore;
&init_config();
@TURKDVB;

sub backup_config_files {
	local @rv;
	push(@rv, &list_files());
	push(@rv, $module_config_directory);
	return &unique(@rv);
}
sub pre_backup {
	return undef;
}

# post_backup(&files)
# Called after the files are actually read
sub post_backup {
	&webmin_log("Backup", "Complete", scalar(@{$_[0]})." files",undef, $module_name);
	return undef;
}

# pre_restore(&files)
# Called before the files are restored from a backup
sub pre_restore {
	return undef;
}

# post_restore(&files)
# Called after the files are restored from a backup
sub post_restore {
	if(&is_running()){
		print &tdvbRestart()."\n";
		return undef;
	}
	return undef;
}

sub list_files {
	local (@lfiles);
	$filesval = "CHANNELINFO FILE|PROVIDERINFO FILE|CAID PRIO FILE|SOFTKEY FILE|AUTOROLL FILE|STATIC CW FILE";
	push(@lfiles, $config{'cfg'});
	push(@lfiles,"$module_config_directory/packages");
	$ccfiles = {"CHANNELINFO FILE"=>"/var/etc/CCcam.channelinfo",
		"PROVIDERINFO FILE"=>"/var/etc/CCcam.providers",
		"CAID PRIO FILE"=>"/var/etc/CCcam.prio",
		"SOFTKEY FILE"=>"/var/keys/SoftCam.Key",
		"AUTOROLL FILE"=>"/var/keys/AutoRoll.Key",
		"STATIC CW FILE"=>"/var/keys/constant.cw",};
	open($fh, $config{'cfg'});
	while(<$fh>) {
		s/\s+$//;s/#.*$//;
		if (/^\s*($filesval)\s*:\s*"((.|\n)*)"/ || /^\s*($filesval)\s*:\s*'((.|\n)*)'/ || /^\s*($filesval)\s*:\s*((.|\n)*)$/) {
			$ccfiles->{$1} = ($2||$ccfiles->{$1});
		}
	}
	close($fh);
	foreach $cfln (keys($ccfiles)){
		push(@lfiles,$ccfiles->{$cfln});
	}
	return @lfiles;
}



1;




