#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib, urllib2
import xbmcplugin, xbmcaddon, xbmcgui, xbmc
import sys, os, re, json, base64, operator, datetime, time

pluginhandle = int(sys.argv[1])
addon = xbmcaddon.Addon()
settings = xbmcaddon.Addon( id = "plugin.video.gamekult" )
useragent = "Mozilla/5.0 (X11; Linux x86_64; rv:40.0) Gecko/20100101 Firefox/40.0"
addon_path = xbmc.translatePath(os.path.join(xbmc.translatePath(os.path.join(xbmc.translatePath(os.path.join("special://","home")),"addons")),"plugin.video.gamekult"))
logo_path = os.path.join(addon_path+"/images","logo.png")
fanart_path = os.path.join(addon_path,"fanart.jpg")
base_video_url = "http://www.gamekult.com/video/"
base2_video_url = "http://www.dailymotion.com/embed/video/"

def parameters_string_to_dict(parameters):
    paramDict = {}
    if parameters:
        paramPairs = parameters[1:].split("&")
        for paramsPair in paramPairs:
            paramSplits = paramsPair.split('=')
            if (len(paramSplits)) == 2:
                paramDict[paramSplits[0]] = paramSplits[1]
    return paramDict
    
def translation(id):
    return addon.getLocalizedString(id).encode('utf-8','ignore')

def get_code(url,refer):
    hdr = {'User-Agent': useragent, 'Referer': refer}
    req = urllib2.Request(url, headers=hdr)
    page = urllib2.urlopen(req)
    return page.read()

def get_content(url):
    html = get_code(url,url)
    html = re.sub(r"\s+", " ", html)
    html = html.replace("> <","><")
    videos = re.findall('<figure class="small"><img src="(.*?)" alt="(.*?)" /></figure>(.*?)<a href="/video/(.*?)">', html)
    if '»</a>' in html:
        nextpage = True
    else:
        nextpage = False
    
    return videos,nextpage

def index(start):
    video_page = get_code(base_video_url,base_video_url)
    addDir(translation(30001), "jeux", "category", logo_path, fanart_path, "Retrouvez les dernières vidéos de jeux.", "Jeux", 1)
    addDir(translation(30002), "emissions", "category", logo_path, fanart_path, "Retrouvez les émissions Gamekult, le tout en vidéo!", "Émissions", 1)
    addDir(translation(30003), "chroniques", "category", logo_path, fanart_path, "Retrouvez les chroniques vidéo Gamekult, 24FPS, I see What You Did There, Des Oursins Dans Les Poches !", "Chroniques", 1)
    addDir(translation(30004), "reportages", "category", logo_path, fanart_path, "Retrouvez les reportages Gamekult, le tout en vidéo !", "Reportages", 1)
    addDir(translation(30005), "tests-video", "category", logo_path, fanart_path, "Retrouvez les derniers tests vidéo de jeux vidéo effectués par Gamekult.", "Tests video", 1)
    addDir(translation(30006), "replay", "category", logo_path, fanart_path, "Retrouvez les GK Live et les GK Play de jeux vidéo.", "Replay", 1)
    addDir(translation(30007), "guides", "category", logo_path, fanart_path, "Retrouvez les guides et les tutoriels de jeux vidéos.", "Guides", 1)
    addDir(translation(30008), "gameplay", "category", logo_path, fanart_path, "Retrouvez les dernières vidéos de gameplay de jeux vidéo.", "Gameplay", 1)
    addDir(translation(30009), "trailers", "category", logo_path, fanart_path, "Retrouvez les derniers trailer et bandes-annonces des jeux vidéo", "Trailers", 1)
    xbmcplugin.endOfDirectory(pluginhandle)
    
def addDir(name, url, mode, iconimage, fanart, desc, genre, start):
    u = sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&start="+str(start)
    xbmcplugin.setContent(pluginhandle, 'movies')
    ok = True
    liz = xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
    if ( fanart != '' ):
        liz.setProperty("Fanart_Image", fanart)
    liz.setInfo(type="video", infoLabels={"Title": name, "Plot": desc, "Genre": genre.title()})
    ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=True)
    return ok

def show_category(mode,url,start):
    vids, nextpage = get_content(base_video_url+url+'.html?p='+start)
    for (i, vid) in enumerate(vids):
        addDir(vid[1], vid[3], 'video', vid[0], vid[0], vid[1], url, start)
    if nextpage == True:
        addDir("...", url, 'category', logo_path, fanart_path, "", url, str(int(start)+1))
    xbmcplugin.endOfDirectory(pluginhandle)

def sources(mode,url):
    part_url = url.split('-')
    vid_url = get_code(base_video_url+"iframe-embed/"+part_url[-1].replace("v.html", "/"),base_video_url)
    apikey = re.findall("apiKey: '(.*?)'", vid_url)
    video = re.findall('video: "(.*?)"', vid_url)
    vid_url2 = get_code(base2_video_url+video[0]+"?api=postMessage&apiKey="+apikey[0],base_video_url)
    videos2 = re.findall('mp4","url":"(.*?)"', vid_url2)
    stream_url = []
    display_list = []
    dialog = xbmcgui.Dialog()
    for (video2) in reversed(videos2):
        reso = re.findall('x(.*?)\\\/', video2)
        display_list.append(reso[0]+"px")
        stream_url.append(video2.replace("\\/","/"))
    video_source = dialog.select(translation(30010), display_list)
    if (not video_source == -1 ):
        play_video("play_video", stream_url[video_source])

def play_video(mode,stream_url):
    xbmc.Player().play(stream_url)

params = parameters_string_to_dict(sys.argv[2])
mode = urllib.unquote_plus(params.get('mode', ''))
start = urllib.unquote_plus(params.get('start', ''))
url = urllib.unquote_plus(params.get('url', ''))

try:
    start
except:
    start = 0

if mode == 'category':
    show_category(mode,url,start)
if mode == 'video':
    sources(mode,url)
else:
    index(start)
