# 2014.03.17 19:59:35 Arabic Standard Time
#Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/TSmedia/resources/tube_resolver/mytube.py
from imports import *
from functions import log as datalog, get_logininfo
username, password = get_logininfo('youtube')

class SimpleLRUCache:

    def __init__(self, size):
        self.cache = []
        self.size = size

    def __contains__(self, key):
        for x in self.cache:
            if x[0] == key:
                return True

        return False

    def __getitem__(self, key):
        for i in range(len(self.cache)):
            x = self.cache[i]
            if x[0] == key:
                del self.cache[i]
                self.cache.append(x)
                return x[1]

        raise KeyError

    def __setitem__(self, key, value):
        for i in range(len(self.cache)):
            x = self.cache[i]
            if x[0] == key:
                if i < len(self.cache) - 1:
                    x[1] = value
                    del self.cache[i]
                    self.cache.append(x)
                else:
                    self.cache[-1][1] = value
                return

        if len(self.cache) == self.size:
            self.cache = self.cache[1:]
        self.cache.append([key, value])

    def __delitem__(self, key):
        for i in range(len(self.cache)):
            if self.cache[i][0] == key:
                del self.cache[i]
                return

        raise KeyError

    def resize(self, x = None):
        self.size = x
        if x < len(self.cache):
            del self.cache[:len(self.cache) - x]


from twisted import __version__
__TW_VER__ = tuple([ int(x) for x in __version__.split('.') ])
try:
    from twisted.internet.endpoints import TCP4ClientEndpoint
except:
    twEndpoints = False
    print 'Error: twisted endpoints not imported'
else:
    twEndpoints = True

try:
    from twisted.web.client import Agent
except:
    twAgent = False
    print 'Error: twisted agent not imported'
    from twisted.web.client import getPage
    from twisted.web.http_headers import Headers
else:
    twAgent = True
    import base64
    from cookielib import CookieJar
    from twisted.web.client import RedirectAgent, getPage, ProxyAgent, CookieAgent
    from twisted.internet import reactor
    from twisted.web.http_headers import Headers
    from twisted.internet.protocol import Protocol
    from twisted.internet.defer import Deferred
    from twisted.web import http
    from urlparse import urlunparse

agent_headers = {'Content-Type': ['application/x-www-form-urlencoded']}
if twAgent:

    class GetResource(Protocol):

        def __init__(self, finished):
            print 'GetResource:'
            self.data = ''
            self.finished = finished

        def dataReceived(self, data):
            self.data += data

        def connectionLost(self, reason):
            print 'connectionLost: ', reason
            self.finished.callback(self.data)


    class TwAgentHelper:
        DEBUG_HEADER = False

        def __init__(self, proxy_host = 'scorpion.premiumize.me', use_proxy = False, p_user = '', p_pass = '', use_cookies = False):
            print 'Twisted Agent in use', __TW_VER__
            self.headers = Headers(agent_headers)
            self.useProxy = use_proxy and twEndpoints
            self.useCookies = use_cookies
            if use_cookies:
                cookieJar = CookieJar()
            if self.useProxy:
                self.endpoint = TCP4ClientEndpoint(reactor, proxy_host, 80)
                if use_cookies:
                    self.agent = CookieAgent(ProxyAgent(self.endpoint), cookieJar)
                else:
                    self.agent = ProxyAgent(self.endpoint)
                auth = base64.b64encode('%s:%s' % (p_user, p_pass))
                self.headers.addRawHeader('Proxy-Authorization', 'Basic ' + auth.strip())
            elif use_cookies:
                self.agent = CookieAgent(Agent(reactor), cookieJar)
            else:
                self.agent = Agent(reactor)

        def getRedirectedUrl(self, callback, cb_err, url, *args, **kwargs):
            print 'getRedirectedUrl: ', url
            self._rd_callback = callback
            self.url = url
            self.data = ''
            self.agent.request('HEAD', url, headers=self.headers).addCallback(self.__getResponse, *args, **kwargs).addErrback(cb_err)

        def __getResponse(self, response, *args, **kwargs):
            print '__getResponse:'
            print 'Status code: ', response.phrase
            if self.DEBUG_HEADER:
                for header, value in response.headers.getAllRawHeaders():
                    print header, value

            r = response.headers.getRawHeaders('location')
            if r:
                r_url = r[0]
                p = self._parse(r_url)
                if 'http' not in p[0]:
                    print 'Rel. URL correction'
                    scheme, host, port, path = self._parse(self.url)
                    r_url = '%s://%s/%s' % (scheme, host, r_url)
            else:
                r_url = self.url
            print 'Location: ', r_url
            self._rd_callback(r_url, *args, **kwargs)

        def getWebPage(self, callback, cb_err, url, follow_redir, *args, **kwargs):
            print 'getWebPage: ', url
            self._wp_callback = callback
            self._errback = cb_err
            self.data = ''
            if follow_redir:
                self.getRedirectedUrl(self.__getWebPageDef, cb_err, url, *args, **kwargs)
            else:
                self.__getWebPageDef(url, *args, **kwargs)

        def __getWebPageDef(self, url, *args, **kwargs):
            try:
               d = self.agent.request('GET', url, headers=self.headers)
               d.addCallback(self.__getResource)
               d.addCallbacks(self._wp_callback, self._errback, callbackArgs=args, callbackKeywords=kwargs)
            except:
               self._errback = "download error:url"
               
        def __getResource(self, response):
            print '__getResource:'
            finished = Deferred()
            response.deliverBody(GetResource(finished))
            return finished

        @staticmethod
        def _parse(url, defaultPort = None):
            url = url.strip()
            parsed = http.urlparse(url)
            scheme = parsed[0]
            path = urlunparse(('', '') + parsed[2:])
            if defaultPort is None:
                if scheme == 'https':
                    defaultPort = 443
                else:
                    defaultPort = 80
            host, port = parsed[1], defaultPort
            if ':' in host:
                host, port = host.split(':')
                try:
                    port = int(port)
                except ValueError:
                    port = defaultPort

            if path == '':
                path = '/'
            return (scheme,
             host,
             port,
             path)


else:

    class TwAgentHelper:

        def __init__(self, proxy_host = None, use_proxy = False, p_user = '', p_pass = '', use_cookies = False):
            print 'Twisted Agent not in use', __TW_VER__
            self.headers = Headers(agent_headers)

        def getRedirectedUrl(self, callback, cb_err, url, *args, **kwargs):
            callback(url, *args, **kwargs)

        def getWebPage(self, callback, cb_err, url, follow_redir, *args, **kwargs):
            print 'getWebPage: ', url
            getPage(url, followRedirect=True, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(callback, *args, **kwargs).addErrback(cb_err)


pluginPath = ''
activeIcon = ''
proxy = False
ddlme_sortOrder = 0
premium_hosters = '(putlocker|sockshare|bitshare|movshare|nowvideo)'
std_headers = {'User-Agent': 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.6) Gecko/20100627 Firefox/3.6.6',
 'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
 'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
 'Accept-Language': 'en-us,en;q=0.5'}
lruCache = SimpleLRUCache(50)

class youtubeUrl:

    def __init__(self, callBack, errBack):
        self.callBack = callBack
        self.errBack = errBack
        self.error = ''
        self.useProxy = False
        puser = username
        ppass = password
        try:
            login = config.plugins.tstube.login.value
        except:
            login = True

        if login == True:
            if not username == '' and not password == '':
                self.yt_tw_agent_hlp = TwAgentHelper(use_proxy=self.useProxy, p_user=puser, p_pass=ppass, use_cookies=True)
                proxy = self.useProxy
                return
        self.yt_tw_agent_hlp = TwAgentHelper(use_proxy=self.useProxy, p_user=puser, p_pass=ppass, use_cookies=True)
        proxy = False

    def addCallback(self, cbFunc):
        self.callBack = cbFunc

    def addErrback(self, errFunc):
        self.errBack = errFunc

    def dataError(self, error):
        print 'dataError:'
        print error

    def errReturn(self, url = None):
        print self.error
        self.errBack(self.error)
        datalog('mytube/32/error', self.error)

    def cbYTErr(self, res):
        return None

    def getVideoUrl(self, url, videoPrio = 2):
        print 'got url:', url
        datalog('got url:', url)
        self.videoPrio=int(videoPrio)
        if not self.callBack:
            self.error = 'Error: no callBack set'
            self.errReturn()
            datalog('mytube/45/error', self.error)
            self.errBack(self.error)
        if videoPrio == 0:
            self.VIDEO_FMT_PRIORITY_MAP = {'38': 5,
             '22': 4,
             '35': 2,
             '18': 1,
             '34': 3}
        elif videoPrio == 1:
            self.VIDEO_FMT_PRIORITY_MAP = {'38': 5,
             '22': 4,
             '35': 1,
             '18': 2,
             '34': 3}
        else:
            self.VIDEO_FMT_PRIORITY_MAP = {'38': 2,
             '22': 1,
             '35': 3,
             '18': 4,
             '34': 5}
        self.video_url = None
        self.video_id = url
        self.videoPrio = videoPrio
        watch_url = 'http://www.youtube.com/watch?v=%s&gl=US&hl=en' % self.video_id
        self.yt_tw_agent_hlp.getWebPage(self.cbProxy_1, self.errReturn, watch_url, False)
        return

    def cbProxy_1(self, data):
        el = '&el=embedded'
        info_url = 'http://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en' % (self.video_id, el)
        self.yt_tw_agent_hlp.getWebPage(self.cbProxy_2, self.dataError, info_url, False)

    def cbProxy_2(self, infopage):
        videoinfo = parse_qs(infopage)
        if ('url_encoded_fmt_stream_map' or 'fmt_url_map') not in videoinfo:
            el = '&el=detailpage'
            info_url = 'http://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en' % (self.video_id, el)
            self.yt_tw_agent_hlp.getWebPage(self.cbProxy_3, self.dataError, info_url, False)
        else:
            self.parseVInfo(videoinfo)

    def cbProxy_3(self, infopage):
        videoinfo = parse_qs(infopage)
        if ('url_encoded_fmt_stream_map' or 'fmt_url_map') not in videoinfo:
            el = '&el=vevo'
            info_url = 'http://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en' % (self.video_id, el)
            self.yt_tw_agent_hlp.getWebPage(self.cbProxy_4, self.dataError, info_url, False)
        else:
            self.parseVInfo(videoinfo)

    def cbProxy_4(self, infopage):
        videoinfo = parse_qs(infopage)
        if ('url_encoded_fmt_stream_map' or 'fmt_url_map') not in videoinfo:
            el = ''
            info_url = 'http://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en' % (self.video_id, el)
            self.yt_tw_agent_hlp.getWebPage(self.cbProxy_5, self.dataError, info_url, False)
        else:
            self.parseVInfo(videoinfo)

    def cbProxy_5(self, infopage):
        videoinfo = parse_qs(infopage)
        self.parseVInfo(videoinfo)

    def parseVInfo(self, videoinfo):
        if ('url_encoded_fmt_stream_map' or 'fmt_url_map') not in videoinfo:
            if 'reason' not in videoinfo:
                self.error = 'Error: unable to extract "fmt_url_map" or "url_encoded_fmt_stream_map" parameter for unknown reason'
                datalog('mytube/126/error', self.error)
                self.errBack(self.error)
            else:
                reason = unquote_plus(videoinfo['reason'][0])
                self.error = 'Error: YouTube said: %s' % reason.decode('utf-8')
                self.errBack(self.error)
                datalog('mytube/41/error', self.error)
            self.errReturn(self.video_url)
            return self.video_url
        video_fmt_map = {}
        fmt_infomap = {}
        if videoinfo.has_key('url_encoded_fmt_stream_map'):
            tmp_fmtUrlDATA = videoinfo['url_encoded_fmt_stream_map'][0].split(',')
        else:
            tmp_fmtUrlDATA = videoinfo['fmt_url_map'][0].split(',')
        links=[]

        for fmtstring in tmp_fmtUrlDATA:
            fmturl = fmtid = fmtsig = ''
            quality=''
            mtype=''          
            if videoinfo.has_key('url_encoded_fmt_stream_map'):
                try:
                    for arg in fmtstring.split('&'):
                        

                        if arg.find('=') >= 0:
                            print arg.split('=')
                            key, value = arg.split('=')
                            if key == 'itag':
                                if len(value) > 3:
                                    value = value[:2]
                                fmtid = value
                            elif key == 'quality':
                                quality = value                                
                            elif key == 'type':
                                mtype = value.lower()                                 
                            elif key == 'url':
                                fmturl = value
                                
                            elif key == 'sig':
                                fmtsig = value

                    
                    
                    if fmtid != '' and fmturl != '' and fmtsig != '' and self.VIDEO_FMT_PRIORITY_MAP.has_key(fmtid):
                        video_fmt_map[self.VIDEO_FMT_PRIORITY_MAP[fmtid]] = {'fmtid': fmtid,
                         'fmturl': unquote_plus(fmturl),
                         'fmtsig': fmtsig}
                        fmt_infomap[int(fmtid)] = '%s&signature=%s' % (unquote_plus(fmturl), fmtsig)
                    if not fmturl=='' and not 'vp8' in mtype:
                       links.append((fmturl,quality,mtype))                    
                    
                    fmturl = fmtid = fmtsig = ''
                    mtype=''
                    quality=''
                except:
                    self.error = 'error parsing fmtstring: %s' % fmtstring
                    datalog('mytube/166/error', self.error)
                    self.errBack(self.error)
                    self.errReturn(self.video_url)
                    return self.video_url

            else:
                fmtid, fmturl = fmtstring.split('|')
            if self.VIDEO_FMT_PRIORITY_MAP.has_key(fmtid) and fmtid != '':
                video_fmt_map[self.VIDEO_FMT_PRIORITY_MAP[fmtid]] = {'fmtid': fmtid,
                 'fmturl': unquote_plus(fmturl)}
                fmt_infomap[int(fmtid)] = unquote_plus(fmturl)

        print 'links',links
        video_url=None
        if len(links)>0:
         for item in links:
            vurl=item[0]
            quality=item[1]
            ctype=item[2]
            video_url=None

            if  quality=='720hd':
               video_url=vurl
               break                           
            if  quality=='medium':
               video_url=vurl
               break
            if  quality=='small':
               video_url=vurl
               break
        
        if video_url:
           video_url=urllib.unquote_plus(video_url)                  
        self.callBack(video_url)
        return video_url        
        print '[youtubeUrl] got', sorted(fmt_infomap.iterkeys())
        datalog('[youtubeUrl] got', sorted(fmt_infomap.iterkeys()))
        video_fmt_map[sorted(video_fmt_map.iterkeys())[0]]['fmtid']
        if video_fmt_map and len(video_fmt_map):
            print '[youtubeUrl] found best available video format:', video_fmt_map[sorted(video_fmt_map.iterkeys())[0]]['fmtid']
            datalog('[youtubeUrl] found best available video format:', video_fmt_map[sorted(video_fmt_map.iterkeys())[0]]['fmtid'])
            best_video = video_fmt_map[sorted(video_fmt_map.iterkeys())[0]]
            self.video_url = '%s&signature=%s' % (best_video['fmturl'].split(';')[0], best_video['fmtsig'])
            if self.useProxy:
                self.yt_tw_agent_hlp.getRedirectedUrl(self.cbProxy_6, self.dataError, self.video_url, True)
            else:
                self.cbProxy_6(self.video_url, True)
        else:
            self.error = 'Error: no video url found'
            datalog('mytube/189/error', self.error)
            print '[youtubeUrl] ', self.error
            self.errBack(self.error)
            self.errReturn(self.video_url)

    def cbProxy_6(self, url, flag):
        print '[youtubeUrl] found best available video url:', url
        datalog('mytube/194/[youtubeUrl] found best available video url', url)
        if flag:
            try:
                self.callBack(url)
            except:
                pass
# okay decompyling mytube.pyo 
# decompiled 1 files: 1 okay, 0 failed, 0 verify failed
# 2014.03.17 19:59:36 Arabic Standard Time
