"""
This file is from enigma2 plugin :
GREEK STREAM TV

Ideas & Sources:
StreamTV (Black Hole image)
https://github.com/chrippa/livestreamer
http://code.google.com/p/airplayer/source/browse/trunk/AirPlayer/mediabackends/e2_media_backend.py
https://github.com/DonDavici/DreamPlex/blob/master/src/DP_Player.py
http://code.google.com/p/archivy-czsk/source/browse/trunk/engine/player/player.py?r=77
...all others...

"""

#from sys import path
#path.append("/usr/lib/enigma2/python/Plugins/Extensions/GreekStreamTV")

import os
import ssl

from time import sleep
from thread import start_new_thread

from enigma import eTimer, eConsoleAppContainer, ePicLoad, loadPNG, eServiceReference, iPlayableService, iServiceInformation
from enigma import gFont, eListboxPythonMultiContent, RT_HALIGN_LEFT, RT_HALIGN_RIGHT, RT_HALIGN_CENTER, RT_VALIGN_CENTER
from xml.etree.cElementTree import fromstring, ElementTree
from Plugins.Plugin import PluginDescriptor
from Screens.Screen import Screen
from Screens.ChoiceBox import ChoiceBox
from Screens.MessageBox import MessageBox
from Screens.InfoBarGenerics import InfoBarNotifications
from Components.Label import Label
from Components.ActionMap import NumberActionMap, ActionMap
from Components.config import config, ConfigSelection, getConfigListEntry, ConfigText, ConfigDirectory, ConfigYesNo, ConfigSelection
from Components.FileList import FileList, FileEntryComponent
from Components.MenuList import MenuList
from Components.Pixmap import Pixmap, MovingPixmap
from Components.AVSwitch import AVSwitch
from Components.ServiceEventTracker import ServiceEventTracker
from Tools.Directories import fileExists, resolveFilename, SCOPE_PLUGINS

from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmapAlphaTest
#from mytube import mytube
#from livestreamer import Livestreamer

PLUGIN_PATH = resolveFilename(SCOPE_PLUGINS, "Extensions/GreekStreamTV")

class SelectQuality(Screen):
    skin = """
		<screen name="SelectQuality" position="center,center" size="280,140" title="Select Quality">
			<widget name="menu" itemHeight="35" position="0,0" size="270,130" scrollbarMode="showOnDemand" transparent="1" zPosition="9"/>
		</screen>
           """

    def __init__(self, session, streams, selectedFunc, enableWrapAround=False):
        Screen.__init__(self, session)
        print "In stream-py going in SelectQuality 1"
        self.selectedFunc = selectedFunc
        menu = [ (str(sn[0]), sn[1]) for sn in streams.items() ]
        self["menu"] = MenuList(menu, enableWrapAround)
        self["actions"] = ActionMap(["OkCancelActions"], {
            "ok": self.okbuttonClick,
            "cancel": self.cancelClick
        })

    def getCurrent(self):
        cur = self["menu"].getCurrent()
        return cur and cur[1]

    def okbuttonClick(self):
        print "In stream-py going in SelectQuality 2"
        self.selectedFunc(self.getCurrent())

    def up(self):
        self["menu"].up()

    def down(self):
        self["menu"].down()

    def cancelClick(self):
        self.close(False)


class GreekStreamTVPlayer(Screen, InfoBarNotifications):
    skin = """
               <screen name="GreekStreamTVPlayer" flags="wfNoBorder" position="0,570" size="1280,190" title="GreekStreamTV Player" backgroundColor="#41000000" >
                   <!--ePixmap position="80,25" size="117,72" pixmap="%s/channel_background.png" zPosition="-1" transparent="1" alphatest="blend" /-->
                   <widget name="channel_icon" position="121,43" zPosition="10" size="35,35" backgroundColor="#41000000" />
                   <widget name="channel_name" position="250,20" size="650,40" font="Regular;36" halign="left" valign="center" foregroundColor="#ffffff" backgroundColor="#41000000" />
                   <widget name="channel_uri" position="250,70" size="950,60" font="Regular;22" halign="left" valign="top" foregroundColor="#ffffff" backgroundColor="#41000000" />
                   <widget source="session.CurrentService" render="Label" position="805,20" size="300,40" font="Regular;30" halign="right" valign="center" foregroundColor="#f4df8d" backgroundColor="#41000000" transparent="1" >
                       <convert type="ServicePosition">Position,ShowHours</convert>
                   </widget>
               </screen>
           """ % (PLUGIN_PATH)

    PLAYER_IDLE    = 0
    PLAYER_PLAYING = 1
    PLAYER_PAUSED  = 2

    def __init__(self, session, service, cbServiceCommand, chName, chURL, chIcon):
        Screen.__init__(self, session)
        InfoBarNotifications.__init__(self)

        isEmpty = lambda x: x is None or len(x)==0 or x == "None"
        if isEmpty(chName): chName = "Unknown"
        if isEmpty(chURL):  chURL  = "Unknown"
        if isEmpty(chIcon): chIcon = "default.png"
        chIcon = "%s/icons/%s" % (PLUGIN_PATH, chIcon)
        self.session = session
        self.service = service
        self.cbServiceCommand = cbServiceCommand

        self["actions"] = ActionMap(["OkCancelActions", "InfobarSeekActions", "MediaPlayerActions", "MovieSelectionActions"], {
            "ok": self.doInfoAction,
            "cancel": self.doExit,
            "stop": self.doExit,
            "playpauseService": self.playpauseService,
        }, -2)

        self.__event_tracker = ServiceEventTracker(screen = self, eventmap = {
            iPlayableService.evSeekableStatusChanged: self.__seekableStatusChanged,
            iPlayableService.evStart: self.__serviceStarted,
            iPlayableService.evEOF: self.__evEOF,
            iPlayableService.evUser + 10: self.__evAudioDecodeError,
            iPlayableService.evUser + 11: self.__evVideoDecodeError,
            iPlayableService.evUser + 12: self.__evPluginError,
        })

        self.hidetimer = eTimer()
        self.hidetimer.timeout.get().append(self.doInfoAction)

        self.state = self.PLAYER_IDLE
        self.__seekableStatusChanged()
 
        self.onClose.append(self.__onClose)
        self.doPlay()

        self["channel_icon"] = Pixmap()
        self["channel_name"] = Label(chName)
        self["channel_uri"]  = Label(chURL)

        self.picload = ePicLoad()
        self.scale   = AVSwitch().getFramebufferScale()
        self.picload.PictureData.get().append(self.cbDrawChannelIcon)
        self.picload.setPara((35, 35, self.scale[0], self.scale[1], False, 0, "#00000000"))
        self.picload.startDecode(chIcon)

    def cbDrawChannelIcon(self, picInfo=None):
        ptr = self.picload.getData()
        if ptr != None:
            self["channel_icon"].instance.setPixmap(ptr.__deref__())
            self["channel_icon"].show()

    def __onClose(self):
        self.session.nav.stopService()

    def __seekableStatusChanged(self):
        service = self.session.nav.getCurrentService()
        if service is not None:
            seek = service.seek()
            if seek is None or not seek.isCurrentlySeekable():
                self.setSeekState(self.PLAYER_PLAYING)

    def __serviceStarted(self):
        self.state = self.PLAYER_PLAYING
        self.__seekableStatusChanged()

    def __evEOF(self):
        self.doExit()

    def __evAudioDecodeError(self):
        currPlay = self.session.nav.getCurrentService()
        sAudioType = currPlay.info().getInfoString(iServiceInformation.sUser + 10)
        print "[__evAudioDecodeError] audio-codec %s can't be decoded by hardware" % (sAudioType)
        self.session.open(MessageBox, _("This Dreambox can't decode %s streams!") % sAudioType, type=MessageBox.TYPE_INFO, timeout=20)

    def __evVideoDecodeError(self):
        currPlay = self.session.nav.getCurrentService()
        sVideoType = currPlay.info().getInfoString(iServiceInformation.sVideoType)
        print "[__evVideoDecodeError] video-codec %s can't be decoded by hardware" % (sVideoType)
        self.session.open(MessageBox, _("This Dreambox can't decode %s streams!") % sVideoType, type=MessageBox.TYPE_INFO, timeout=20)

    def __evPluginError(self):
        currPlay = self.session.nav.getCurrentService()
        message = currPlay.info().getInfoString(iServiceInformation.sUser + 12)
        print "[__evPluginError]" , message
        self.session.open(MessageBox, message, type=MessageBox.TYPE_INFO, timeout=20)

    def __setHideTimer(self):
        self.hidetimer.start(5000)

    def doExit(self):
        print "[GreekStreamTVPlayer::doExit]"
        self.cbServiceCommand()
        self.close()

    def setSeekState(self, wantstate):
        service = self.session.nav.getCurrentService()
        if service is None:
            print "[GreekStreamTV:: ::setSeekState] No Service found"
            return

        pauseable = service.pause()
        if pauseable is not None:
            if wantstate == self.PLAYER_PAUSED:
                pauseable.pause()
                self.state = self.PLAYER_PAUSED
                if not self.shown:
                    self.hidetimer.stop()
                    self.show()
            elif wantstate == self.PLAYER_PLAYING:
                pauseable.unpause()
                self.state = self.PLAYER_PLAYING
                if self.shown:
                    self.__setHideTimer()
        else:
            self.state = self.PLAYER_PLAYING

    def doInfoAction(self):
        if self.shown:
            self.hidetimer.stop()
            self.hide()
        else:
            self.show()
            if self.state == self.PLAYER_PLAYING:
                self.__setHideTimer()

    def doPlay(self):
        if self.state == self.PLAYER_PAUSED:
            if self.shown:
                self.__setHideTimer()
        self.state = self.PLAYER_PLAYING
        self.session.nav.playService(self.service)
        if self.shown:
            self.__setHideTimer()

    def playpauseService(self):
        print "[GreekStreamTVPlayer::playpauseService] State ", self.state
        if self.state == self.PLAYER_PLAYING:
            self.setSeekState(self.PLAYER_PAUSED)
        elif self.state == self.PLAYER_PAUSED:
            self.setSeekState(self.PLAYER_PLAYING)


class StreamURIParser:
    def __init__(self, xml):
        self.xml = xml

    def parseStreamList(self):
        tvlist = []
        tree = ElementTree()
        tree.parse(self.xml)
        for iptv in tree.findall("iptv"):
            tvlist.append({
                "name" : str(iptv.findtext("name")).title(), 
                "icon" : str(iptv.findtext("icon")),
                "type" : str(iptv.findtext("type")), 
                "uri"  : self.parseStreamURI(str(iptv.findtext("uri")))
            })
        return sorted(tvlist, key=lambda item: item["name"])

    def parseStreamURI(self, uri):
        uriInfo = {}
        splitedURI = uri.split()
        uriInfo["URL"] = splitedURI[0]
        for x in splitedURI[1:]:
            i = x.find("=")
            uriInfo[x[:i]] = str(x[i+1:])
        return uriInfo
#######################
#class RSList(MenuList):
#	def __init__(self, list):
#		MenuList.__init__(self, list, False, eListboxPythonMultiContent)
#		self.l.setItemHeight(40)
#		textfont = int(config.plugins.xbmcplug.textfont.value)
#                self.l.setFont(0, gFont("Regular", textfont))

def streamListEntry(entry):
	res = [(entry)]

        white = 0xffffff 
        grey = 0xb3b3b9
        green = 0x389416
        black = 0x000000
        yellow = 0xe5b243
        blue = 0x002d39
        col = int(config.plugins.kodiplug.textcol.value, 16)
        colsel = int(config.plugins.kodiplug.textsel.value, 16)
        backcol = int(config.plugins.kodiplug.listcol.value, 16)
        backsel = int(config.plugins.kodiplug.listcol.value, 16)
#        res.append(MultiContentEntryText(pos=(0, 0), size=(650, 40), text=download, color=grey, color_sel = white, backcolor = black, backcolor_sel = black))
        res.append(MultiContentEntryText(pos=(50, 0), size=(650, 40), text=entry[0], color=col, color_sel = colsel, backcolor = backcol, backcolor_sel = backcol))

#        res.append(MultiContentEntryText(pos=(0, 0), size=(650, 40), text=download, color="#ffffff", color_sel = colsel, backcolor = 0x000000, backcolor_sel = backcol))

        return res

        
#######################
def streamListEntryX(entry):
    uriInfo = entry[1].get("uri")
    return [entry,
#        (eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST,5,1,35,35,loadPNG("%s/icons/%s" % (PLUGIN_PATH, str(entry[1].get("icon"))) )),
        (eListboxPythonMultiContent.TYPE_TEXT,45,7,240,37,0,RT_HALIGN_LEFT,entry[0]),
#        (eListboxPythonMultiContent.TYPE_TEXT,290,7,400,37,1,RT_HALIGN_LEFT,str(uriInfo.get("URL")))
    ]

class GreekStreamTVList(Screen):
    skin = """
		<screen name="GreekStreamTVList" position="center,center" size="1280,720" title="XBMC Addons" >
                        <!--ePixmap position="0,0" zPosition="-2" size="1280,720" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/XBMCAddons/images/panel3.png" /-->
			<widget source="global.CurrentTime" render="Label" position="1100,65" size="140,25" font="Regular;18" halign="right" backgroundColor="black" foregroundColor="#ffffff" transparent="1">
                        <convert type="ClockToText">Default</convert>
                        </widget>
                        <widget source="global.CurrentTime" render="Label" position="1100,40" size="140,25" font="Regular;18" halign="right" backgroundColor="black" foregroundColor="#ffffff" transparent="1" valign="center">
                        <convert type="ClockToText">Format:%d.%m.%Y</convert>
                        </widget>
                        <!--widget name="pixmap" position="942,372" size="200,200" zPosition="1" alphatest="on" /-->
                    	<widget name="streamlist" position="100,100" size="580,480" itemHeight="40" backgroundColor="#000000" foregroundColor="#b3b3b9" foregroundColorSelected="#ffffff" backgroundColorSelected="#000000" scrollbarMode="showOnDemand" />
                        <widget name="info" position="150,630" zPosition="4" size="900,50" font="Regular;22" foregroundColor="#7bd7f7" backgroundColor="#40000000" transparent="1" halign="left" valign="center" />
                        <!--ePixmap position="942,372" zPosition="1" size="200,200" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/XBMCAddons/images/default.png" /-->
		</screen>

           """
    def __init__(self, session, streamFile = None):
        from livestreamer import Livestreamer
        self.session = session
        Screen.__init__(self, session)
        self.skin = GreekStreamTVList.skin
        self["info"] = Label("...")
        self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions"], {
            "ok"    : self.keyOK,
            "cancel": self.keyCancel,
            "up"    : self.keyUp,
            "down"  : self.keyDown,
            "left"  : self.keyLeft,
            "right" : self.keyRight,
        }, -1)

        self.streamBin  = "/usr/bin/rtmpdump"

        if not streamFile:
            self.streamFile = resolveFilename(SCOPE_PLUGINS, "Extensions/GreekStreamTV/stream.xml")
        else:
            self.streamFile = streamFile

#        self.youtube    = mytube()
        self.lvstreamer = Livestreamer()

        self.streamList = []
        self.makeStreamList()

        self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
        self.streamMenuList.l.setFont(0, gFont("Regular", 22))
        self.streamMenuList.l.setFont(1, gFont("Regular", 18))
        self.streamMenuList.l.setItemHeight(37)
        self["streamlist"] = self.streamMenuList
        self.streamMenuList.setList(map(streamListEntry, self.streamList))

        self.onLayoutFinish.append(self.layoutFinished)

        self.rtmpConsole    = None
        self.beforeService  = None
        self.currentService = None
        self.playerStoped   = False
        self.keyLocked = False
        self.pd = None
        self.qsel = None

    def layoutFinished(self):
        os.system("killall -9 rtmpdump")

    def keyLeft(self):
        if self.keyLocked:
            return
        self["streamlist"].pageUp()

    def keyRight(self):
        if self.keyLocked:
            return
        self["streamlist"].pageDown()

    def keyUp(self):
        if self.keyLocked:
            return
        self["streamlist"].up()

    def keyDown(self):
        if self.keyLocked:
            return
        self["streamlist"].down()

    def keyCancel(self):
        self.cbAppClosed(True)
#        if "/usr/lib/enigma2/python/Plugins/Extensions/GreekStreamTV" in path:
#            path.remove("/usr/lib/enigma2/python/Plugins/Extensions/GreekStreamTV")
        self.close()

    def keyOK(self):
        print "[GreekStreamTVList::keyOK]"
        if self.keyLocked:
            return

        uriName  = self["streamlist"].getCurrent()[0][1].get("name")
        self["info"].setText("Starting %s Please Wait..." % uriName)
        self.timer = eTimer()
        self.timer.callback.append(self.StartStream)
        self.timer.start(100, 1)

    def StartStream(self):
        self.keyLocked        = True
        self.rtmpConsole      = None
        self.beforeService    = None
        self.currentService   = None
        self.playerStoped     = False
        self.pd               = None

        streamInfo  = self["streamlist"].getCurrent()[0][1]
        uriInfo     = streamInfo.get("uri")
        typeInfo    = streamInfo.get("type").split(":")
        protocol    = typeInfo[0]
        serviceType = typeInfo[1]
        bufferSize  = typeInfo[2]
        url         = uriInfo.get("URL")

        if protocol == "rtmp":
            url += " "
            url += " ".join(["%s=%s" % (key, value) for (key, value) in uriInfo.items() if key != "URL"])
            url = " ".join(url.split())
            print "[GreekStreamTVList::keyOK] URL is ", url, " URI is ", uriInfo
            self.doStreamAction(url, serviceType, bufferSize)
        #elif protocol == "oldrtmp":
        #    self.layoutFinished()
        #    self.rtmpConsole = eConsoleAppContainer()
        #    self.rtmpConsole.dataAvail.append(self.cbDataAvail)
        #    self.rtmpConsole.appClosed.append(self.cbAppClosed)
        #    self.rtmpConsole.execute(self.makeCommand(uriInfo))
        elif protocol in ("rtsp", "http"):
            self.doStreamAction(url, serviceType, bufferSize)
#        elif protocol == "youtube":
#            url = self.youtube.getVideoUrl(url)
#            self.doStreamAction(url, serviceType, bufferSize)
        elif protocol == "livestreamer":
                channel = None
                streams = None
#            try:
                url += " "
                url += " ".join(["%s=%s" % (key, value) for (key, value) in uriInfo.items() if key != "URL"])
                url = " ".join(url.split())
                print "[GreekStreamTVList::keyOK] URL is ", url, " URI is ", uriInfo
                channel = self.lvstreamer.resolve_url(url)
                streams = channel.get_streams()
                print "[GreekStreamTVList::keyOK] Streams: ", streams
                print "[GreekStreamTVList::keyOK] Streams-keys: ", streams.keys()
                if len(streams) == 3 and "best" in streams and "worst" in streams:
                    print "In stream-py going in streamPreBuffer"
                    print '[GreekStreamTVList::keyOK] streams["best"]: ', streams["best"]
                    self.streamPreBuffer(streams["best"])
                elif len(streams) == 0:
                    raise Exception("No Streams Found")
                else:
                    print "In stream-py going in self.qsel"
                    self.qsel = self.session.openWithCallback(self.QualitySelClosed, SelectQuality, streams, self.streamPreBuffer)
#            except Exception as err:
#                print "[GreekStreamTVList::keyOK::Exception] Error: ", err
#                tmpMessage = "An Error Occured: " + str(err)[:200] + "..."
#                self.session.openWithCallback(self.cbServiceCommand, MessageBox, tmpMessage, type=MessageBox.TYPE_ERROR, timeout=20)
        else:
            print "[GreekStreamTVList::keyOK] Unknown Protocol: ", protocol
            tmpMessage = "Unknown Protocol: " + protocol
            self.session.openWithCallback(self.cbServiceCommand, MessageBox, tmpMessage, type=MessageBox.TYPE_WARNING, timeout=20)

    def QualitySelClosed(self, recursive):
        if self.qsel:
            self.qsel.close()
        self.qsel = None
        self.cbServiceCommand()

    def streamPreBuffer(self, stream):
            print "[GreekStreamTVList::keyOK] stream: ", stream
            fd = None
#        try:
            fd = stream.open()
            prebuffer = fd.read(1024*256) #256K PREBUFFER
            if len(prebuffer) == 0:
               raise Exception("No Data Received From Stream Server")
            start_new_thread(self.streamCopy, (fd,prebuffer))
            sleep(1.5)
            self.doStreamAction("/tmp/stream2.avi")
#        except Exception as err:
#            if fd and hasattr(fd, "close"):
#                fd.close()
#            print "[GreekStreamTVList::keyOK::Exception] Error: ", err
#            tmpMessage = "An Error Occured while buffering: " + str(err)[:200] + "..."
#            self.session.openWithCallback(self.cbServiceCommand, MessageBox, tmpMessage, type=MessageBox.TYPE_ERROR, timeout=20)

    def streamCopy(self, fd, prebuffer):
        print "[GreekStreamTVList::streamCopy]"
        if os.access("/tmp/stream2.avi", os.F_OK):
            os.remove("/tmp/stream2.avi")
        os.mkfifo("/tmp/stream2.avi")
        self.pd = open("/tmp/stream2.avi", "wb")
        try:
            self.pd.write(prebuffer)
            while self is not None and self.session is not None and not self.playerStoped:
                data = fd.read(8192)
                if len(data) == 0:
                    break
                self.pd.write(data)
            print "[GreekStreamTVList:streamCopy] playerStoped"
            self.pd.close()
            if hasattr(fd, "close"):
                fd.close()
            fd = None
        except Exception as err:
            print "[GreekStreamTVList::streamCopy] Exception: ", err
        finally:
            self.playerStoped = True
            if fd and hasattr(fd, "close"):
                fd.close()

    def LivestreamerStop(self):
        print "[GreekStreamTVList::LivestreamStop]"
        self["info"].setText("...")
        self.keyLocked = False
        self.playerStoped = True
        os.system("killall -9 rtmpdump")
        sleep(0.5)
        if self.pd:
            try: self.pd.close()
            except:
                sleep(0.5)
                try: self.pd.close()
                except: pass
        if self.qsel is not None:
            self.qsel.close(False)
        self.pd   = None
        self.qsel = None

    def doStreamAction(self, url=None, serviceType="4097", bufferSize=None):
        if url is None:
            url="/tmp/stream.avi"
            self.streamPlayerTimer.stop()

        try: serviceType = int(serviceType)
        except: serviceType = 4097
        try: bufferSize = int(bufferSize)
        except: bufferSize = None

        service = eServiceReference(serviceType, 0, url)
        #if bufferSize is not None:
        #    service.setData(2, bufferSize*1024)
        streamInfo = self["streamlist"].getCurrent()[0][1]
        service.setName(str(streamInfo.get("name")))
        uriInfo    = streamInfo.get("uri")
        self.beforeService  = self.session.nav.getCurrentlyPlayingServiceReference()
        self.currentService = self.session.openWithCallback(self.cbFinishedStream,
                                    GreekStreamTVPlayer, 
                                    service, 
                                    cbServiceCommand=self.cbServiceCommand,
                                    chName=str(streamInfo.get("name")),
                                    chURL =str(uriInfo.get("URL")),
                                    chIcon=str(streamInfo.get("icon")))

    def cbServiceCommand(self, params=None):
        print "[GreekStreamTV::cbServiceCommand]"
        if params is None or isinstance(params, bool):
            self.playerStoped = True
            self.LivestreamerStop()
            return

    def cbAppClosed(self, ret):
        print "[GreekStreamTV::cbAppClosed] ", ret
        self.LivestreamerStop()
        self.doConsoleStop()
        if self.currentService is not None and not self.playerStoped:
            message = "The connection was terminated from the stream server."
            self.session.open(MessageBox, message, type=MessageBox.TYPE_INFO)
            self.currentService.close()
            self.currentService = None

    def cbDataAvail(self, data):
        print "[GreekStreamTV::cbDataAvail] ", data
        if str(data) == "Connected...":
            self.streamPlayerTimer = eTimer()
            self.streamPlayerTimer.timeout.get().append(self.doStreamAction)
            self.streamPlayerTimer.start(1000)

    def cbFinishedStream(self):
        print "[GreekStreamTV::cbFinishedStream]"
        self.LivestreamerStop()
        self.doConsoleStop()
        self.session.nav.playService(self.beforeService)
        print "[GreekStreamTV::cbFinishedStream] player done!!"

    def doConsoleStop(self):
        print "[GreekStreamTV::doConsoleStop]"
        self.LivestreamerStop()
        self.keyLocked = False
        if self.rtmpConsole is not None:
            self.rtmpConsole.sendCtrlC()
            self.rtmpConsole = None

    def makeCommand(self, uriInfo):
        def appendCommand(key, option):
            try:
                d = uriInfo.get(key)
                if d is not None:
                    return "-%s %s " % (option, d)
            except: pass
            return ""

        command  = "%s -v " % (self.streamBin)
        command += appendCommand("URL", "r")
        command += appendCommand("playpath", "y")
        command += appendCommand("swfUrl", "W")
        command += appendCommand("swfVfy", "W")
        command += appendCommand("pageUrl","p")
        command += appendCommand("app", "a")

        print "[GreekStreamTV::makeCommand] Command to run: ", command
        return command

    def makeStreamList(self):
        try: streamDB = StreamURIParser(self.streamFile).parseStreamList()
        except Exception as err:
            print "[GreekStreamTV::makeStreamList] Error: ", err
            streamDB = []
        self.streamList = [ (x.get("name"), x) for x in streamDB ]

def main(session, **kwargs):
    session.open(GreekStreamTVList, kwargs['streamFile'])
                                                           
def Plugins(**kwargs):
    return PluginDescriptor(
        name = _("GreekStreamTVPlayer"),
        description = "Watching live stream TV",
        where = PluginDescriptor.WHERE_PLUGINMENU,
        fnc = main,
        icon = "plugin.png")































