# coding: utf-8
"""
    This file is part of Plugin KodiDirect by pcd@xtrend-alliance.com
    Copyright (C) 2014

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
############### v8.0 ##################
from Plugins.Extensions.KodiDirect.lib.Utils import *
from Components.config import config, ConfigSubsection, ConfigSelection, ConfigText, ConfigYesNo
from Components.config import NoSave
from Components.ConfigList import ConfigListScreen
from Screens.MessageBox import MessageBox
import os
from os import path, system

from Screens.Console import Console
from Components.Button import Button
import gettext
from Components.Sources.StaticText import StaticText
from Components.Pixmap import Pixmap
from Components.Sources.List import List
from enigma import eTimer
from Plugins.Extensions.KodiDirect.lib.SkinLoader import loadPluginSkin

from Screens.Standby import TryQuitMainloop

#from Screens.VirtualKeyBoard import VirtualKeyBoard
from Plugins.Extensions.KodiDirect.lib.VirtualKeyBoard import VirtualKeyBoard
from Plugins.Extensions.KodiDirect.lib.Spinner import Spinner
##########################
import gettext
def _(txt):
	t = gettext.dgettext("KodiDirect", txt)
	if t == txt:
		pass#print "[KodiDirectA] fallback to default translation for", txt
		t = gettext.gettext(txt)
	return t


THISPLUG = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect"

def startspinner():
                cursel = THISPLUG+"/skin/spinner"
    		Bilder = []
		if cursel:
			for i in range(30):
				if (os.path.isfile("%s/wait%d.png"%(cursel,i+1))):
					Bilder.append("%s/wait%d.png"%(cursel,i+1))
		else:
		        Bilder = []
                #self["text"].setText("Press ok to exit")
                return Spinner(Bilder)

class KodiUtils(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("Extra help tools for plugin KodiDirect"))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("KodiUtils")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                actions = []
                actions.append("Save file from addon")
                actions.append("Restore file to addon")
		showlist(actions, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          elif sel == 0:
                self.session.open(Savefile)
          elif sel == 1:
                self.session.open(Putfile)     
                

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		self["text"].number(number)

class Savefile(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
		self["info"] = Label()
		self.info = (_("Here you can save a file from a current \nworking addon which may needed \nfor a new version to work."))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
                self["pixmap"] = Pixmap()
                currDir = THISPLUG + "/plugins/"
		self.filelist = FileList(currDir, matchingPattern = "(?i)^.*\.(py|xml)")
		self["menu"] = self.filelist
		self["menu"].onSelectionChanged.append(self.selectionChanged)
		self["actions"] = ActionMap(["OkCancelActions", "ColorActions", "DirectionActions", "MenuActions"],
		{
			"ok": self.okClicked,
			"cancel": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("Save File")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onShown.append(self.openTest)

    def openTest(self):
          pass
          
    def selectionChanged(self):
		index = self.filelist.getSelectionIndex()
                sel = self.filelist.getCurrentDirectory()
#                print "Here in selectionChanged sel =", sel


    def okClicked(self):
          if self.filelist.canDescent():
		self.filelist.descent()
          else:
                flist = self.filelist.getFileList()
                index = self.filelist.getSelectionIndex()
                sel = self.filelist.getCurrentDirectory()
                tfile = flist[index][0][0]
                sel1 = sel.replace(THISPLUG, "")
                
                savedir = config.plugins.kodiplug.cachefold.value+"/xbmc/savedir/" + sel1
                cmd = "mkdir  -p " + savedir
                os.system(cmd)
                cmd1 = "cp -f " + sel + tfile + " " + savedir 
                os.system(cmd1)
                self["info"].setText("Done !")

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#print "pressed", number
		self["text"].number(number)

class Putfile(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
		self["info"] = Label()
		self.info = (_("Here you can replace a file \nin a new addon version \nwith a saved 'working' file."))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
                self["pixmap"] = Pixmap()
                self.currDir = config.plugins.kodiplug.cachefold.value+"/xbmc/savedir/"
		self.filelist = FileList(self.currDir, matchingPattern = "(?i)^.*\.(py|xml)")
		self["menu"] = self.filelist
		self["menu"].onSelectionChanged.append(self.selectionChanged)
		self["actions"] = ActionMap(["OkCancelActions", "ColorActions", "DirectionActions", "MenuActions"],
		{
			"ok": self.okClicked,
			"cancel": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("Restore File")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onShown.append(self.openTest)

    def openTest(self):
          pass
          
    def selectionChanged(self):
		index = self.filelist.getSelectionIndex()
                sel = self.filelist.getCurrentDirectory()
#                print "Here in selectionChanged sel =", sel


    def okClicked(self):
          if self.filelist.canDescent():
		self.filelist.descent()
          else:
                flist = self.filelist.getFileList()
                index = self.filelist.getSelectionIndex()
                sel = self.filelist.getCurrentDirectory()
                tfile = flist[index][0][0]
                sel1 = sel.replace(self.currDir, "")
                
                savedir = THISPLUG + "/" + sel1
                cmd1 = "cp -f " + sel + tfile + " " + savedir 
#                print "Here in okClicked selected cmd1 =", cmd1
                os.system(cmd1)
                self["info"].setText("Done !")
                 
    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#print "pressed", number
		self["text"].number(number)


