﻿using System.Net;
using System.Threading;
using ChanSort.Ui.Properties;
using DevExpress.XtraEditors;

namespace ChanSort.Ui
{
  class UpdateCheck
  {
    private const string UpdateUrl = "http://github.com/PredatH0r/ChanSort/releases";
    private const string SearchString = "ChanSort_";

    public static void CheckForNewVersion()
    {
      var check = new UpdateCheck();
      Thread thread = new Thread(check.Check);
      thread.Start();
    }

    private void Check()
    {
      try
      {
        var newVersion = this.GetLatestVersion();
        if (newVersion.CompareTo(MainForm.AppVersion.TrimStart('v')) > 0)
          this.NotifyAboutNewVersion(newVersion);
      }
      catch { }
    }

    private string GetLatestVersion()
    {
      string response;
      using (WebClient client = new WebClient())
      {
        client.Proxy = null; // prevent a 1min wait/timeout by a .NET bug
        response = client.DownloadString(UpdateUrl);
      }
      int start = response.IndexOf(SearchString);
      if (start >= 0)
      {
        int end = response.IndexOf(".zip", start);
        if (end == start + SearchString.Length + 10)
          return response.Substring(start + SearchString.Length, 10);
      }
      return string.Empty;
    }

    private void NotifyAboutNewVersion(string newVersion)
    {
      if (XtraMessageBox.Show(
        string.Format(Resources.UpdateCheck_NotifyAboutNewVersion_Message, newVersion),
        Resources.UpdateCheck_NotifyAboutNewVersion_Caption,
        System.Windows.Forms.MessageBoxButtons.YesNo,
        System.Windows.Forms.MessageBoxIcon.Question,
        System.Windows.Forms.MessageBoxDefaultButton.Button1) != System.Windows.Forms.DialogResult.Yes)
        return;
      BrowserHelper.OpenUrl(UpdateUrl);
    }
  }
}
