import xbmcaddon
import xbmc
import xbmcgui
import xbmcplugin
import sys
import urllib
import urllib2
import urlparse
import exceptions
import json

# try:
#   import StorageServer
# except:
#   import storageserverdummy as StorageServer

from datetime import timedelta

plugin_id = 'plugin.video.dplay'


# thumbnails_cache_days = 0
# thumbnails_cache = StorageServer.StorageServer(plugin_id, 24*int(thumbnails_cache_days))

addon = xbmcaddon.Addon(id=plugin_id)
addonname = addon.getAddonInfo('name')
addonicon = addon.getAddonInfo('icon')

this_plugin = int(sys.argv[1])
plugin_url = sys.argv[0]

url_shows = 'http://it.dplay.com/api/v1/content/device/shows?realm=DPLAYIT&appVersion=2.0.0&platform=ANDROID' \
           '&platformVersion=5.1.1&order=alphabetic&page={0}&limit=20&embed=genres%2Cchannels%2Chome_channel%2Cpackage'
url_seasons = 'http://it.dplay.com/api/v1/content/device/shows/{0}/seasons?realm=DPLAYIT&appVersion=2.0.0' \
             '&platform=ANDROID&platformVersion=5.1.1'
url_episodes = 'http://it.dplay.com/api/v1/content/device/shows/{0}/seasons/{1}/videos?realm=DPLAYIT&appVersion=2.0.0' \
              '&platform=ANDROID&platformVersion=5.1.1&page={2}&limit=20&' \
              'embed=show%2Cchannels%2Chome_channel%2Cseason%2Cgenres%2Cvideo_cuepoints%2Cpackage'
url_playback = 'https://secure.it.dplay.com/secure/api/v1/content/device/playback/{0}?realm=DPLAYIT' \
              '&appVersion=2.0.0&platform=ANDROID&platformVersion=5.1.1'
base_show_thumbnail_url = 'http://res.cloudinary.com/db79cecgq/image/upload/'
user_agent = 'Dalvik/2.1.0 (Linux; U; Android 5.1.1; D6503 Build/23.4.A.0.546)'


def params_url(query):
    return plugin_url + '?' + urllib.urlencode(query)


def get_duration(milliseconds):
    return str(timedelta(milliseconds/1000.0))


def get_cached_url(show):
        crop = show['poster_image']['crop']
        thumbnail_params = 'c_crop,h_'+str(crop['h'])+',w_'+str(crop['w'])+',x_'+str(crop['x'])+',y_'+str(crop['y'])+'/'
        thumbnail_params += 'c_fill,h_246,w_368/'
        return base_show_thumbnail_url + thumbnail_params + show['poster_image']['file']


def all_shows():
    i = 0
    xbmcplugin.setContent(this_plugin, 'tvshows')
    while True:
        shows_url = url_shows.format(i)
        try:
            req = urllib2.Request(shows_url)
            req.add_header('User-Agent', user_agent)
            response = urllib2.urlopen(req)
        except urllib2.HTTPError:
                break
        data = json.loads(response.read())
        i += 1
        if len(data) == 0 or 'error' in data:
            break
        for show in data['data']:
            if 'poster_image' in show:
                thumbnail_url = get_cached_url(show)
            else:
                thumbnail_url = 'DefaultFolder.png'
            label = show['title']+" - ("+str(show['episodes_available'])+" Episodi)"
            litem = xbmcgui.ListItem(label, iconImage=thumbnail_url)
            litem.setInfo('video', {
                'plot': show['description']
            })
            litem.setProperty('TotalEpisodes', str(show['episodes_available']))
            litem.setProperty('TotalSeasons', str(show['seasons_available']))
            xbmcplugin.addDirectoryItem(
                handle=this_plugin,
                url=params_url({'show_id': show['id']}),
                listitem=litem,
                isFolder=True
            )
    xbmcplugin.endOfDirectory(this_plugin)


def get_seasons(show_id):
    season_url = url_seasons.format(show_id)
    xbmcplugin.setContent(this_plugin, 'episodes')
    try:
        req = urllib2.Request(season_url)
        req.add_header('User-Agent', user_agent)
        response = urllib2.urlopen(req)
    except urllib2.HTTPError:
        print('HTTPERROR')
    data = json.loads(response.read())
    if len(data) == 0:
        return
    for season in data['data']:
        thumbnail_url = 'DefaultFolder.png'
        label = season['name'] + " ({0} episodi su {1} disponibili)".format(
            season['episodes_available'], 
            season['episodes_total']
        )
        litem = xbmcgui.ListItem(label,
                                 iconImage=thumbnail_url
                                 )
        litem.setInfo('video', {
            'plot': season['name']
        })
        xbmcplugin.addDirectoryItem(
            handle=this_plugin,
            url=params_url({
                'show_id': show_id,
                'season_number': season['season_number'],
                'season_id': season['id']
            }),
            listitem=litem,
            isFolder=True
        )
    xbmcplugin.endOfDirectory(this_plugin)
    return


def get_episodes(show_id, season_id):
    i = 0
    xbmcplugin.setContent(this_plugin, 'episodes')
    while True:
        epUrl = url_episodes.format(show_id, season_id, i)
        try:
            req = urllib2.Request(epUrl)
            req.add_header('User-Agent', user_agent)
            response = urllib2.urlopen(req)
        except urllib2.HTTPError:
            break
        try:
            data = json.loads(response.read())
        except exceptions.ValueError:
            break
        i += 1
        print(response.getcode())
        if response.getcode() != 200:
            break
        if len(data) == 0 or 'error' in data:
            break
        for episode in data['data']:
            if episode['thumbnail_image'] is not None:
                crop = episode['thumbnail_image']['crop']
                thumbnail_params = 'c_crop,h_'+str(crop['h'])+',w_'+str(crop['w'])+',x_'\
                                  + str(crop['x'])+',y_'+str(crop['y'])+'/'
                thumbnail_params += 'c_fill,h_246,w_368/'
                thumbnail_url = base_show_thumbnail_url + thumbnail_params + episode['thumbnail_image']['file']
            else:
                thumbnail_url = 'DefaultVideo.png'
            label = episode['title']
            litem = xbmcgui.ListItem(label,
                                     iconImage=thumbnail_url
                                     )
            litem.setInfo('video', {
                'plot': episode['description'],
                'duration': get_duration(episode['duration'])
            })
            litem.setProperty('IsPlayable', 'true')
            xbmcplugin.addDirectoryItem(
                handle=this_plugin,
                url=params_url({
                    'episode_id': episode['id']
                }),
                listitem=litem
            )
    xbmcplugin.endOfDirectory(this_plugin)


def get_video_url(episode_id):
    print('get_video_url')
    playback_url = url_playback.format(episode_id)
    try:
        req = urllib2.Request(playback_url)
        req.add_header('User-Agent', user_agent)
        response = urllib2.urlopen(req)
    except urllib2.HTTPError:
        print("HTTPERROR")
    data = json.loads(response.read())
    url = data['data']['stream_url']
    xbmcplugin.setResolvedUrl(this_plugin, True, xbmcgui.ListItem(path=url))
    xbmc.executebuiltin('XBMC.PlayerControl(Play)')


args = urlparse.parse_qs(sys.argv[2][1:])
showid = args.get('show_id', None)
seasonid = args.get('season_id', None)
episodeid = args.get('episode_id', None)

if episodeid:
    get_video_url(episodeid[0])
elif seasonid:
    get_episodes(showid[0], seasonid[0])
elif showid:
    get_seasons(showid[0])
else:
    all_shows()