﻿# -*- coding: utf-8 -*-

"""
Copyright (C) 2015

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>
"""

import urllib, urllib2
import xbmcplugin, xbmcaddon, xbmcgui, xbmc
import sys, os, re, json, base64, operator, datetime, time

plugin_handle = int(sys.argv[1])

mysettings = xbmcaddon.Addon(id = 'plugin.video.SatunerTV')
profile = mysettings.getAddonInfo('profile')
home = mysettings.getAddonInfo('path')
fanart = xbmc.translatePath(os.path.join(home, 'fanart.jpg'))
icon = xbmc.translatePath(os.path.join(home, 'icon.png'))

online_m3u = mysettings.getSetting('online_m3u')
local_m3u = mysettings.getSetting('local_m3u')
online_xml = base64.b64decode(mysettings.getSetting('online_xml'))
online1_xml = base64.b64decode(mysettings.getSetting('online1_xml'))
online2_xml = base64.b64decode(mysettings.getSetting('online2_xml'))
online3_xml = base64.b64decode(mysettings.getSetting('online3_xml'))
online4_xml = base64.b64decode(mysettings.getSetting('online4_xml'))
online5_xml = base64.b64decode(mysettings.getSetting('online5_xml'))
online6_xml = base64.b64decode(mysettings.getSetting('online6_xml'))
online7_xml = base64.b64decode(mysettings.getSetting('online7_xml'))
online8_xml = base64.b64decode(mysettings.getSetting('online8_xml'))
online9_xml = base64.b64decode(mysettings.getSetting('online9_xml'))
online10_xml = base64.b64decode(mysettings.getSetting('online10_xml'))
online11_xml = base64.b64decode(mysettings.getSetting('online11_xml'))
online12_xml = base64.b64decode(mysettings.getSetting('online12_xml'))
online13_xml = base64.b64decode(mysettings.getSetting('online13_xml'))
online14_xml = base64.b64decode(mysettings.getSetting('online14_xml'))
online15_xml = base64.b64decode(mysettings.getSetting('online15_xml'))
local_xml = mysettings.getSetting('local_xml')

xml_regex = '<title>(.*?)</title>\s*<link>(.*?)</link>\s*<thumbnail>(.*?)</thumbnail>'
m3u_thumb_regex = 'tvg-logo=[\'"](.*?)[\'"]'
m3u_regex = '#(.+?),(.+)\s*(.+)\s*'

u_tube = 'http://www.youtube.com'

def removeAccents(s):
	return ''.join((c for c in unicodedata.normalize('NFD', s.decode('utf-8')) if unicodedata.category(c) != 'Mn'))
					
def read_file(file):
    try:
        f = open(file, 'r')
        content = f.read()
        f.close()
        return content
    except:
        pass

def make_request(url):
	try:
		req = urllib2.Request(url)
		req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:19.0) Gecko/20100101 Firefox/19.0')
		response = urllib2.urlopen(req)	  
		link = response.read()
		response.close()  
		return link
	except urllib2.URLError, e:
		print 'We failed to open "%s".' % url
		if hasattr(e, 'code'):
			print 'We failed with error code - %s.' % e.code	
		if hasattr(e, 'reason'):
			print 'We failed to reach a server.'
			print 'Reason: ', e.reason
			
def main():
	add_dir('[B]<<<  SEARCH  >>>[/B]', 'searchlink', 99, icon, fanart)
	if len(online_m3u) > 0:	
		add_dir('[COLOR with][B] ONLINE M3U <<[/B][/COLOR]', u_tube, 2, icon, fanart)
	if len(local_m3u) > 0:	
		add_dir('[COLOR with][B]>> LOCAL M3U <<[/B][/COLOR]', u_tube, 3, icon, fanart)
	if len(online_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET GENERALISTE[/B][/COLOR]', u_tube, 4, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETGENERALISTE.png', fanart)
	if len(online1_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET INFO[/B][/COLOR]', u_tube, 6, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETINFO.png', fanart)
	if len(online2_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET THEMATIQUE[/B][/COLOR]', u_tube, 7, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETTHEMATIQUE.png', fanart)
	if len(online3_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET TVCLUB[/B][/COLOR]', u_tube, 8, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETTVCLUB.png', fanart)
	if len(online4_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET CANAL+[/B][/COLOR]', u_tube, 9, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETCANAL+.png', fanart)
	if len(online5_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET CINE+[/B][/COLOR]', u_tube, 10, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETCINE+.png', fanart)
	if len(online6_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET ORANGE Tv[/B][/COLOR]', u_tube, 11, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETORANGETV.png', fanart)
	if len(online7_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET SATUNER Tv[/B][/COLOR]', u_tube, 12, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETSATUNERTV.png', fanart)
	if len(online8_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET ABSAT[/B][/COLOR]', u_tube, 13, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETABSAT.png', fanart)
	if len(online9_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET JEUNESSE[/B][/COLOR]', u_tube, 14, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETJEUNESSE.png', fanart)
	if len(online10_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET SPORT[/B][/COLOR]', u_tube, 15, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETSPORT.png', fanart)
	if len(online11_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET MUSIQUE[/B][/COLOR]', u_tube, 16, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETMUSIQUE.png', fanart)
	if len(online12_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET ADULTE[/B][/COLOR]', u_tube, 17, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETADULTE.png', fanart)
	if len(online13_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET COATCHING[/B][/COLOR]', u_tube, 18, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETCOATCHING.png', fanart)
	if len(online14_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET 4K[/B][/COLOR]', u_tube, 19, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUET4K.png', fanart)
	if len(online15_xml) > 0:	
		add_dir('[COLOR with][B]BOUQUET 3D[/B][/COLOR]', u_tube, 20, 'http://satunertv.pe.hu/Logos/SatTv/BOUQUETCHAINES3D.png', fanart)
	if len(local_xml) > 0:	
		add_dir('[COLOR lime][B]>> LOCAL XML <<[/B][/COLOR]', u_tube, 5, icon, fanart)		
	if (len(online_m3u) < 1 and len(local_m3u) < 1 and len(online_xml) < 1 and len(online1_xml) < 1 and len(online2_xml) < 1 and len(online3_xml) < 1 and len(online4_xml) < 1 and len(online5_xml) < 1 and len(online6_xml) < 1 and len(online7_xml) < 1 and len(online8_xml) < 1 and len(online9_xml) < 1 and len(online10_xml) < 1 and len(online11_xml) < 1 and len(online12_xml) < 1 and len(online13_xml) < 1 and len(online14_xml) < 1 and len(online15_xml) < 1 and len(local_xml) < 1 ):		
		mysettings.openSettings()
		xbmc.executebuiltin("Container.Refresh")		

def search(): 	
	try:
		keyb = xbmc.Keyboard('', 'Enter search text')
		keyb.doModal()
		if (keyb.isConfirmed()):
			searchText = urllib.quote_plus(keyb.getText()).replace('+', ' ')
		if len(online_m3u) > 0:		
			content = make_request(online_m3u)
			match = re.compile(m3u_regex).findall(content)
			for thumb, name, url in match:
				if re.search(searchText, removeAccents(name.replace('Đ', 'D')), re.IGNORECASE):
					m3u_playlist(name, url, thumb)	
		if len(local_m3u) > 0:		
			content = read_file(local_m3u)
			match = re.compile(m3u_regex).findall(content)		
			for thumb, name, url in match:
				if re.search(searchText, removeAccents(name.replace('Đ', 'D')), re.IGNORECASE):
					m3u_playlist(name, url, thumb)	
		if len(online_xml) > 0:					
			content = make_request(online_xml)
			match = re.compile(xml_regex).findall(content)	
			for name, url, thumb in match:
				if re.search(searchText, removeAccents(name.replace('Đ', 'D')), re.IGNORECASE):
					xml_playlist(name, url, thumb)	
		if len(local_xml) > 0:		
			content = read_file(local_xml)
			match = re.compile(xml_regex).findall(content)		
			for name, url, thumb in match:
				if re.search(searchText, removeAccents(name.replace('Đ', 'D')), re.IGNORECASE):
					xml_playlist(name, url, thumb)	
	except:
		pass
		
def m3u_online():		
	content = make_request(online_m3u)
	match = re.compile(m3u_regex).findall(content)
	for thumb, name, url in match:
		try:
			m3u_playlist(name, url, thumb)
		except:
			pass
			
def xml_online():			
	content = make_request(online_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online1():			
	content = make_request(online1_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online2():			
	content = make_request(online2_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online3():			
	content = make_request(online3_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online4():			
	content = make_request(online4_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online5():			
	content = make_request(online5_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass
			
def xml_online6():			
	content = make_request(online6_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online7():			
	content = make_request(online7_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online8():			
	content = make_request(online8_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online9():			
	content = make_request(online9_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online10():			
	content = make_request(online10_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online11():			
	content = make_request(online11_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online12():			
	content = make_request(online12_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online13():			
	content = make_request(online13_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online14():			
	content = make_request(online14_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def xml_online15():			
	content = make_request(online15_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:
		try:
			xml_playlist(name, url, thumb)
		except:
			pass

def m3u_local():
	content = read_file(local_m3u)
	match = re.compile(m3u_regex).findall(content)
	for thumb, name, url in match:	
		try:
			m3u_playlist(name, url, thumb)
		except:
			pass

def xml_local():		
	content = read_file(local_xml)
	match = re.compile(xml_regex).findall(content)
	for name, url, thumb in match:	
		try:
			xml_playlist(name, url, thumb)
		except:
			pass
				
def m3u_playlist(name, url, thumb):	
	name = re.sub('\s+', ' ', name).strip()			
	url = url.replace('"', ' ').replace('&amp;', '&').strip()
	if ('youtube.com/user/' in url) or ('youtube.com/channel/' in url) or ('youtube/user/' in url) or ('youtube/channel/' in url):
		if 'tvg-logo' in thumb:
			thumb = re.compile(m3u_thumb_regex).findall(str(thumb))[0].replace(' ', '%20')			
			add_dir(name, url, '', thumb, thumb)			
		else:	
			add_dir(name, url, '', icon, fanart)
	else:
		if 'youtube.com/watch?v=' in url:
			url = 'plugin://plugin.video.youtube/play/?video_id=%s' % (url.split('=')[-1])
		elif 'dailymotion.com/video/' in url:
			url = url.split('/')[-1].split('_')[0]
			url = 'plugin://plugin.video.dailymotion_com/?mode=playVideo&url=%s' % url	
		else:			
			url = url
		if 'tvg-logo' in thumb:				
			thumb = re.compile(m3u_thumb_regex).findall(str(thumb))[0].replace(' ', '%20')
			add_link(name, url, 1, thumb, thumb)			
		else:				
			add_link(name, url, 1, icon, fanart)	
					
def xml_playlist(name, url, thumb):
	name = re.sub('\s+', ' ', name).strip()			
	url = url.replace('"', ' ').replace('&amp;', '&').strip()
	if ('youtube.com/user/' in url) or ('youtube.com/channel/' in url) or ('youtube/user/' in url) or ('youtube/channel/' in url):
		if len(thumb) > 0:	
			add_dir(name, url, '', thumb, thumb)			
		else:	
			add_dir(name, url, '', icon, fanart)
	else:
		if 'youtube.com/watch?v=' in url:
			url = 'plugin://plugin.video.youtube/play/?video_id=%s' % (url.split('=')[-1])
		elif 'dailymotion.com/video/' in url:
			url = url.split('/')[-1].split('_')[0]
			url = 'plugin://plugin.video.dailymotion_com/?mode=playVideo&url=%s' % url	
		else:			
			url = url
		if len(thumb) > 0:		
			add_link(name, url, 1, thumb, thumb)			
		else:			
			add_link(name, url, 1, icon, fanart)	
	
def play_video(url):
	media_url = url
	item = xbmcgui.ListItem(name, path = media_url)
	xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
	return

def get_params():
	param = []
	paramstring = sys.argv[2]
	if len(paramstring)>= 2:
		params = sys.argv[2]
		cleanedparams = params.replace('?', '')
		if (params[len(params)-1] == '/'):
			params = params[0:len(params)-2]
		pairsofparams = cleanedparams.split('&')
		param = {}
		for i in range(len(pairsofparams)):
			splitparams = {}
			splitparams = pairsofparams[i].split('=')
			if (len(splitparams)) == 2:
				param[splitparams[0]] = splitparams[1]
	return param

def add_dir(name, url, mode, iconimage, fanart):
	u = sys.argv[0] + "?url=" + urllib.quote_plus(url) + "&mode=" + str(mode) + "&name=" + urllib.quote_plus(name) + "&iconimage=" + urllib.quote_plus(iconimage)
	ok = True
	liz = xbmcgui.ListItem(name, iconImage = "DefaultFolder.png", thumbnailImage = iconimage)
	liz.setInfo( type = "Video", infoLabels = { "Title": name } )
	liz.setProperty('fanart_image', fanart)
	if ('youtube.com/user/' in url) or ('youtube.com/channel/' in url) or ('youtube/user/' in url) or ('youtube/channel/' in url):
		u = 'plugin://plugin.video.youtube/%s/%s/' % (url.split( '/' )[-2], url.split( '/' )[-1])
		ok = xbmcplugin.addDirectoryItem(handle = int(sys.argv[1]), url = u, listitem = liz, isFolder = True)
		return ok		
	ok = xbmcplugin.addDirectoryItem(handle = int(sys.argv[1]), url = u, listitem = liz, isFolder = True)
	return ok

def add_link(name, url, mode, iconimage, fanart):
	u = sys.argv[0] + "?url=" + urllib.quote_plus(url) + "&mode=" + str(mode) + "&name=" + urllib.quote_plus(name) + "&iconimage=" + urllib.quote_plus(iconimage)	
	liz = xbmcgui.ListItem(name, iconImage = "DefaultVideo.png", thumbnailImage = iconimage)
	liz.setInfo( type = "Video", infoLabels = { "Title": name } )
	liz.setProperty('fanart_image', fanart)
	liz.setProperty('IsPlayable', 'true') 
	ok = xbmcplugin.addDirectoryItem(handle = int(sys.argv[1]), url = u, listitem = liz)  
		
params = get_params()
url = None
name = None
mode = None
iconimage = None

try:
	url = urllib.unquote_plus(params["url"])
except:
	pass
try:
	name = urllib.unquote_plus(params["name"])
except:
	pass
try:
	mode = int(params["mode"])
except:
	pass
try:
	iconimage = urllib.unquote_plus(params["iconimage"])
except:
	pass  

print "Mode: " + str(mode)
print "URL: " + str(url)
print "Name: " + str(name)
print "iconimage: " + str(iconimage)		

if mode == None or url == None or len(url) < 1:
	main()

elif mode == 1:
	play_video(url)

elif mode == 2:
	m3u_online()
	
elif mode == 3:
	m3u_local()
	
elif mode == 4:
	xml_online()
	
elif mode == 6:
	xml_online1()

elif mode == 7:
	xml_online2()

elif mode == 8:
	xml_online3()

elif mode == 9:
	xml_online4()

elif mode == 10:
	xml_online5()

elif mode == 11:
	xml_online6()

elif mode == 12:
	xml_online7()

elif mode == 13:
	xml_online8()

elif mode == 14:
	xml_online9()

elif mode == 15:
	xml_online10()

elif mode == 16:
	xml_online11()

elif mode == 17:
	xml_online12()

elif mode == 18:
	xml_online13()

elif mode == 19:
	xml_online14()

elif mode == 20:
	xml_online15()

elif mode == 5:
	xml_local()	

elif mode == 99:
	search()
	
xbmcplugin.endOfDirectory(plugin_handle)