from Plugins.Plugin import PluginDescriptor
from Screens.Screen import Screen
from Screens.ChannelSelection import ChannelSelection
from Screens.EventView import EventViewEPGSelect
from Screens.ChoiceBox import ChoiceBox
from Screens.MessageBox import MessageBox
from Screens.TimerEntry import TimerEntry
from Screens.TimerEdit import TimerSanityConflict
from Screens.EpgSelection import EPGSelection as impotedEPGSelection
from Screens.InfoBar import InfoBar
from Components.EpgList import EPG_TYPE_SINGLE, EPGList, EPG_TYPE_MULTI
from Components.Button import Button
from Components.Label import Label
from Components.Sources.Event import Event
from Components.ActionMap import NumberActionMap
from Components.Pixmap import MultiPixmap
from Components.config import config, ConfigSubsection, getConfigListEntry, ConfigInteger
from Components.ConfigList import ConfigListScreen
from Tools.Directories import fileExists
from Tools.LoadPixmap import LoadPixmap
from ServiceReference import ServiceReference
from RecordTimer import RecordTimerEntry, parseEvent, AFTEREVENT
from enigma import eEPGCache, eServiceReference, eServiceCenter, eListboxPythonMultiContent, gFont, RT_HALIGN_LEFT, RT_WRAP, getDesktop, eTimer, ePoint
from time import localtime, mktime, time
from datetime import datetime

config.valisepg = ConfigSubsection()
config.valisepg.ptH = ConfigInteger(default=20, limits=(0, 23))
config.valisepg.ptM = ConfigInteger(default=15, limits=(0, 56))
config.valisepg.autozap = ConfigInteger(default=10, limits=(3, 20))

class newEPGlist(EPGList):
	def __init__(self, type=EPG_TYPE_SINGLE, selChangedCB=None, timer = None):
		EPGList.__init__(self, type, selChangedCB, timer)
		self.l.setFont(0, gFont("Regular", 20))
		self.l.setFont(1, gFont("Regular", 14))
		self.l.setItemHeight(60)
		self.l.setBuildFunc(self.buildSingleEntry)
		self.breite = 200
		self.primetime_pixmap = LoadPixmap(cached=True, path='/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/primetime.png')
		self.search_pixmap = LoadPixmap(cached=True, path='/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/search.png')
		try:
			self.searchtext = config.plugins.epgsearch.history.value[0].lower()
		except:
			self.searchtext = None

	def buildSingleEntry(self, service, eventId, beginTime, duration, EventName):
		(clock_pic, rec) = self.getPixmapForEntry(service, eventId, beginTime, duration)
		t = localtime(beginTime)
		evCHT = float(str(t[3])+"."+str(t[4]))
		res = [
			None,
			(eListboxPythonMultiContent.TYPE_TEXT, 115, 6, 40, 24, 0, RT_HALIGN_LEFT, self.days[t[6]]),
			(eListboxPythonMultiContent.TYPE_TEXT, 155, 6, 135, 24, 0, RT_HALIGN_LEFT, "%02d.%02d, %02d:%02d"%(t[2],t[1],t[3],t[4]))
		]
		if rec:
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 290, 6, 21, 21, clock_pic))
		if (evCHT >= 20.1) and (evCHT <= 20.2):
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 321, 6, 21, 21, self.primetime_pixmap))
		elif  self.searchtext and (self.searchtext in EventName.lower()):
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 321, 6, 21, 21, self.search_pixmap))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 15, 3, 80, 18, 1, RT_HALIGN_LEFT, "____________________"))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 15, 28, 900, 26, 0, RT_HALIGN_LEFT, EventName))
		return res

class ValisEPG(ChannelSelection):
	if getDesktop(0).size().width() == 1280:
		skin = """
		<screen backgroundColor="#240e1014" flags="wfNoBorder" position="0,0" size="1280,720" title="Channels">
			<ePixmap alphatest="on" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/bg.png" position="0,0" size="1280,720" zPosition="-1" />
			<widget backgroundColor="#16454C5B" font="Regular;22" position="70,35" size="650,50" render="EpgShortTitle" source="Title" transparent="1" valign="center" zPosition="1" />
			<widget backgroundColor="#16454C5B" font="Regular;20" halign="right" position="940,35" render="Label" size="270,50" source="global.CurrentTime" transparent="1" valign="center" zPosition="1">
				<convert type="ClockToText">Format:%a %d. %b   %H:%M</convert>
			</widget>
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/red.png" position="100,643" size="30,30" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/green.png" position="390,643" size="30,30" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/yellow.png" position="680,643" size="30,30" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/blue.png" position="970,643" size="30,30" />
			<widget backgroundColor="#16454C5B" font="Regular;20" halign="left" name="key_red" position="145,645" size="220,26" transparent="1" zPosition="1" />
			<widget backgroundColor="#16454C5B" font="Regular;20" halign="left" name="key_green" position="435,645" size="220,26" transparent="1" zPosition="1" />
			<widget backgroundColor="#16454C5B" font="Regular;20" halign="left" name="key_yellow" position="725,645" size="220,26" transparent="1" zPosition="1" />
			<widget backgroundColor="#16454C5B" font="Regular;20" halign="left" name="key_blue" position="1015,645" size="220,26" transparent="1" zPosition="1" />
			<widget itemHeight="60" name="epglist" position="793,105" scrollbarMode="showOnDemand" size="430,420" transparent="1" />
			<widget position="57,105" size="730,420" backgroundColor="#240e1014" colorEventProgressbarBorder="#555555" colorEventProgressbarBorderSelected="#00aaaaaa" colorServiceDescription="#DBB96E" foregroundColorServiceNotAvail="#00656565" itemHeight="30" name="list" picServiceEventProgressbar="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/minibar.png" scrollbarMode="showOnDemand" serviceInfoFont="Regular;21" serviceItemHeight="30" serviceNameFont="Regular;23" serviceNumberFont="Regular;23" />
			<eLabel backgroundColor="#00555556" position="70,542" size="1140,2" />
			<widget backgroundColor="#240e1014" font="Regular;20" halign="left" name="NewDescription" position="200,556" size="1020,72" transparent="1" zPosition="1" />
			<widget alphatest="blend" position="793,29" render="Picon" size="100,60" source="ServiceEvent" transparent="1" zPosition="1">
				<convert type="piconRefString">ServicelistRef</convert>
			</widget>
			<widget alphatest="on" name="slider1" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/1.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/1a.png" position="765,95" size="22,440" />
			<widget alphatest="on" name="slider2" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/2.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/2a.png" position="1201,95" size="22,440" />
		</screen>
		"""
	elif getDesktop(0).size().width() == 1024:
		skin = """
		<screen backgroundColor="#120e1014" flags="wfNoBorder" position="0,0" size="1024,576" title="Channels">
			<eLabel backgroundColor="#10454C5B" position="0,0" size="1024,90" />
			<eLabel backgroundColor="#10454C5B" position="0,511" size="1024,70" />
			<eLabel backgroundColor="#00555556" position="50,317" size="643,2" />
			<widget backgroundColor="#10454C5B" font="Regular;20" position="50,35" size="630,50" render="EpgShortTitle" source="Title" transparent="1" valign="center" zPosition="1" />
			<widget backgroundColor="#10454C5B" font="Regular;20" halign="left" position="800,35" render="Label" size="200,50" source="global.CurrentTime" transparent="1" valign="center" zPosition="1">
				<convert type="ClockToText">Format:%a %d.   %H:%M</convert>
			</widget>
			<widget backgroundColor="#084c0000" font="Regular;18" halign="center" name="key_red" position="72,515" size="220,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#08004c00" font="Regular;18" halign="center" name="key_green" position="292,515" size="220,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#084b4b00" font="Regular;18" halign="center" name="key_yellow" position="512,515" size="220,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#08001e4b" font="Regular;18" halign="center" name="key_blue" position="730,515" size="220,26" transparent="0" zPosition="1" />
			<widget itemHeight="60" name="epglist" position="50,325" scrollbarMode="showOnDemand" size="670,180" transparent="1" />
			<widget position="50,97" size="670,212" backgroundColor="#100e1014" colorEventProgressbarBorder="#555555" colorEventProgressbarBorderSelected="#00aaaaaa" colorServiceDescription="#DBB96E" foregroundColorServiceNotAvail="#00656565" itemHeight="30" name="list" picServiceEventProgressbar="Vali.HD.flex/minibar.png" scrollbarMode="showOnDemand" serviceInfoFont="Regular;19" serviceItemHeight="30" serviceNameFont="Regular;21" serviceNumberFont="Regular;21" />
			<widget font="Regular;18" position="730,100" render="Label" size="250,400" source="Event" transparent="1" zPosition="1">
				<convert type="EventName">ExtendedDescription</convert>
			</widget>
			<widget alphatest="blend" position="680,29" render="Picon" size="100,60" source="ServiceEvent" transparent="1" zPosition="1">
				<convert type="piconRefString">ServicelistRef</convert>
			</widget>
			<widget alphatest="on" name="slider1" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd1.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd1a.png" position="698,97" size="22,440" />
			<widget alphatest="on" name="slider2" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd2.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd2a.png" position="698,325" size="22,440" />
		</screen>
		"""
	else:
		skin = """
		<screen backgroundColor="#120e1014" flags="wfNoBorder" position="0,0" size="720,576" title="Channels">
			<eLabel backgroundColor="#10454C5B" position="0,0" size="720,90" />
			<eLabel backgroundColor="#10454C5B" position="0,511" size="720,70" />
			<eLabel backgroundColor="#00555556" position="50,317" size="592,2" />
			<widget backgroundColor="#10454C5B" font="Regular;20" position="50,35" size="467,50" render="EpgShortTitle" source="Title" transparent="1" valign="center" zPosition="1" />
			<widget backgroundColor="#10454C5B" font="Regular;18" halign="right" position="517,35" render="Label" size="152,50" source="global.CurrentTime" transparent="1" valign="center" zPosition="1">
				<convert type="ClockToText">Format:%a %d.   %H:%M</convert>
			</widget>
			<widget backgroundColor="#064c0000" font="Regular;18" halign="center" name="key_red" position="50,515" size="155,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#06004c00" font="Regular;18" halign="center" name="key_green" position="205,515" size="155,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#064b4b00" font="Regular;18" halign="center" name="key_yellow" position="360,515" size="155,26" transparent="0" zPosition="1" />
			<widget backgroundColor="#06001e4b" font="Regular;18" halign="center" name="key_blue" position="515,515" size="155,26" transparent="0" zPosition="1" />
			<widget itemHeight="60" name="epglist" position="50,325" scrollbarMode="showOnDemand" size="620,180" transparent="1" />
			<widget position="50,97" size="620,212" backgroundColor="#160e1014" colorEventProgressbarBorder="#555555" colorEventProgressbarBorderSelected="#00aaaaaa" colorServiceDescription="#DBB96E" foregroundColorServiceNotAvail="#00656565" itemHeight="30" name="list" picServiceEventProgressbar="Vali.HD.flex/minibar.png" scrollbarMode="showOnDemand" serviceInfoFont="Regular;21" serviceItemHeight="30" serviceNameFont="Regular;23" serviceNumberFont="Regular;23" />
			<widget alphatest="on" name="slider1" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd1.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd1a.png" position="648,97" size="22,440" />
			<widget alphatest="on" name="slider2" pixmaps="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd2.png,/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/xd2a.png" position="648,325" size="22,440" />
		</screen>
		"""
	def __init__(self, session):
		ChannelSelection.__init__(self, session)
		self["epglist"] = newEPGlist(type = EPG_TYPE_SINGLE, selChangedCB = self.onEPGLSelectionChanged, timer = session.nav.RecordTimer)
		self.aktCurrentService = ServiceReference(self.getCurrentSelection())
		self.aktListBox = 1
		self.RedBtnMode = "FAVO"
		self["key_red"] = Button(_("Similar"))
		self["key_green"] = Button(_("Add timer"))
		self["key_yellow"] = Button(_("Today")+" "+str(config.valisepg.ptH.value)+":"+str(config.valisepg.ptM.value))
		self["key_blue"] = Button(_("Favourites"))
		self["Event"] = Event()
		self["NewDescription"] = Label(" ")
		self["slider1"] = MultiPixmap()
		self["slider2"] = MultiPixmap()
		self.AutoZap = eTimer()
		self.AutoZap_conn = self.AutoZap.timeout.connect(self.zapForRefresh)

		self.AZpos = 1
		self.updateEPGlist = True
		#self.onShown.append(self.onVEPGshow)
		self.onHide.append(self.onVEPGhide)
		self["actions"] = NumberActionMap(["ChannelSelectBaseActions", "OkCancelActions", "DirectionActions", "InfobarActions", "InfobarTeletextActions"],
			{
				"showFavourites": self.keyRedAction,
				"showAllServices": self.runEPGsearch,
				"showProviders": self.goPT,
				"showSatellites": self.AddConfirmedTimer,
				"nextBouquet": self.nextBouquet,
				"prevBouquet": self.prevBouquet,
				"nextMarker":  self.rightList,
				"prevMarker":  self.leftList,
				"cancel": self.cancel,
				"ok": self.pressOK,
				"right": self.pageDown0,
				"rightRepeated": self.pageDown0,
				"left": self.pageUp0,
				"leftRepeated": self.pageUp0,
				"up": self.moveUp0,
				"upRepeated": self.moveUp0,
				"down": self.moveDown0,
				"downRepeated": self.moveDown0,
				"showMovies": self.OptionsMenu,
				"gotAsciiCode": self.keyAsciiCode,
				"1": self.keyNumberGlobal,
				"2": self.keyNumberGlobal,
				"3": self.keyNumberGlobal,
				"4": self.keyNumberGlobal,
				"5": self.keyNumberGlobal,
				"6": self.keyNumberGlobal,
				"7": self.keyNumberGlobal,
				"8": self.keyNumberGlobal,
				"9": self.keyNumberGlobal,
				"0": self.keyNumber0,
				"startTeletext": self.showSinEPG
			}, -1)
		self.onLayoutFinish.append(self.AfterCreate)

	def leftList(self):
		self.aktListBox = 1
		self["slider1"].setPixmapNum(1)
		self["slider2"].setPixmapNum(0)

	def rightList(self):
		self.aktListBox = 2
		self["slider1"].setPixmapNum(0)
		self["slider2"].setPixmapNum(1)

	def moveUp0(self):
		if self.aktListBox==1:
			self["list"].moveUp()
		else:
			self["epglist"].moveUp()

	def moveDown0(self):
		if self.aktListBox==1:
			self["list"].moveDown()
		else:
			self["epglist"].moveDown()

	def pageUp0(self):
		if self.aktListBox==1:
			self["list"].instance.moveSelection(self["list"].instance.pageUp)
		else:
			self["epglist"].instance.moveSelection(self["list"].instance.pageUp)

	def pageDown0(self):
		if self.aktListBox==1:
			self["list"].instance.moveSelection(self["list"].instance.pageDown)
		else:
			self["epglist"].instance.moveSelection(self["list"].instance.pageDown)

	def nextBouquet(self):
		self.leftList()
		self.changeBouquet(+1)

	def prevBouquet(self):
		self.leftList()
		self.changeBouquet(-1)
		
	def AfterCreate(self):
		InfoBar.openEventView = self.IBshowEventInfo
		self["slider1"].setPixmapNum(1)
		self["slider2"].setPixmapNum(0)
		self.setModeTv()
		self.UpdateInfos()

	def onVEPGshow(self):
		pass

	def onVEPGhide(self):
		if self.updateEPGlist:
			self.leftList()
		else:
			self.updateEPGlist = True
		if self.movemode:
			self.toggleMoveMode()

	def UpdateInfos(self):
		l = self["epglist"]
		l.recalcEntrySize()
		aktRef=self.getCurrentSelection()
		self.aktCurrentService=ServiceReference(aktRef)
		l.fillSingleEPG(self.aktCurrentService)
		self["epglist"].instance.moveSelectionTo(0)

	def onEPGLSelectionChanged(self):
		self["NewDescription"].setText(" ")
		cur = self["epglist"].getCurrent()
		event = cur[0]
		self["Event"].newEvent(event)
		if cur is None:
			self["key_green"].setText(" ")
			return
		else:
			event = cur[0]
			if event is None:
				self["key_green"].setText(" ")
				return
			else:
				if cur[1] is None or cur[1].getServiceName() == "":
					self["key_green"].setText(" ")
					return
		serviceref = cur[1]
		eventid = event.getEventId()
		refstr = serviceref.ref.toString()
		isRecordEvent = False
		for timer in self.session.nav.RecordTimer.timer_list:
			if timer.eit == eventid and timer.service_ref.ref.toString() == refstr:
				isRecordEvent = True
				break
		if isRecordEvent:
			self["key_green"].setText(_("Remove timer"))
		elif not isRecordEvent:
			self["key_green"].setText(_("Add timer"))
		if event is None:
			return
		text = ""
		short = event.getShortDescription()
		ext = event.getExtendedDescription()
		if short and short != text:
			text += short
		if ext:
			if text:
				text += '  ->  '
			text += ext
		self["NewDescription"].setText(text)

	def updateEventInfo(self):
		if self.aktListBox==1:
			cur = self.getCurrentSelection()
			self["ServiceEvent"].newService(cur)
			self.UpdateInfos()

	def pressOK(self):
		if self.aktListBox==1:
			self.channelSelected()
		else:
			self.showEPGList()

	def showEPGList(self):
		self.updateEPGlist = False
		cur = self["epglist"].getCurrent()
		event = cur[0]
		service = cur[1]
		if event is not None:
			self.session.open(EventViewEPGSelect, event, service, self.eventViewCallback, InfoBar.instance.openSingleServiceEPG, InfoBar.instance.openMultiServiceEPG, InfoBar.instance.openSimilarList)

	def IBshowEventInfo(self, dummy=None):
		self.UpdateInfos()
		cur = self["epglist"].getCurrent()
		event = cur[0]
		service = cur[1]
		if event is not None:
			self.session.open(EventViewEPGSelect, event, service, self.eventViewCallback, InfoBar.instance.openSingleServiceEPG, InfoBar.instance.openMultiServiceEPG, InfoBar.instance.openSimilarList)

	def OpenSimiList(self, eventid, refstr):
		self.session.open(impotedEPGSelection, refstr, None, eventid)

	def eventViewCallback(self, setEvent, setService, val):
		l = self["epglist"]
		old = l.getCurrent()
		if val == -1:
			self["epglist"].moveUp()
		elif val == +1:
			self["epglist"].moveDown()
		cur = l.getCurrent()
		setService(cur[1])
		setEvent(cur[0])

	def OptionsMenu(self):
		cur_service = ServiceReference(self.getCurrentSelection())
		name = cur_service.getServiceName()
		askList = []
		askList.append((_("Channel Selection")+" - "+_("Favourites"), "FAVO"))
		askList.append((_("Channel Selection")+" - "+_("Providers"), "PROV"))
		askList.append((_("Channel Selection")+" - "+_("Satellites"), "SAT"))
		askList.append((_("Channel Selection")+" - "+_("All") +" "+_("Services"), "ALL"))
		askList.append((_("Single EPG")+": "+name, "SINGLE"))
		askList.append((_("Timer selection"), "TIMER"))
		askList.append((_("Automatically refresh EPG"), "REFRESH"))
		self.session.openWithCallback(self.OptionsCallback, ChoiceBox, title=("Vali's EPG "+_("Advanced Options")), list = askList)

	def OptionsCallback(self, choice):
		choice = choice and choice[1]
		if choice:
			if choice=="PROV":
				self["key_blue"].setText(_("Providers"))
				self.RedBtnMode = choice
				self.showProviders()
			elif choice=="SAT":
				self["key_blue"].setText(_("Satellites"))
				self.RedBtnMode = choice
				self.showSatellites()
			elif choice=="ALL":
				self["key_blue"].setText(_("All"))
				self.RedBtnMode = choice
				self.showAllServices()
			elif choice=="FAVO":
				self["key_blue"].setText(_("Favourites"))
				self.RedBtnMode = choice
				self.showFavourites()
			elif choice=="TIMER":
				from Screens.TimerEdit import TimerEditList
				self.session.open(TimerEditList)
			elif choice=="SINGLE":
				ref=self.getCurrentSelection()
				if ref:
					self.savedService = ref
					self.session.openWithCallback(self.SingleServiceEPGClosed, impotedEPGSelection, ref, serviceChangeCB = self.changeServiceCB)
			elif choice=="REFRESH":
				az = self.session.openWithCallback(self.clbAutoZap, ChoiceBox, title=(_("Automatically refresh EPG")), list = [(_("Cancel"), "DUMMY")])
				az.setTitle("Vali's EPG - AutoZap")
				if az.instance.size().width()<1000:
					az.instance.move(ePoint(50,70))
				self.AZpos = self["list"].getCurrentIndex()
				self.AutoZap.start(config.valisepg.autozap.value*1000)

	def clbAutoZap(self, dummy):
		self["list"].moveToIndex(self.AZpos)
		self.zap()
		self.AutoZap.stop()

	def zapForRefresh(self):
		self["list"].moveDown()
		NewService = self.getCurrentSelection()
		if (NewService.flags & 7) == 7:
			self.enterPath(NewService)
		elif not (NewService.flags & eServiceReference.isMarker):
			self.zap()

	def keyRedAction(self):
		if self.RedBtnMode=="PROV":
			self.showProviders()
		elif self.RedBtnMode=="SAT":
			self.showSatellites()
		elif self.RedBtnMode=="ALL":
			self.showAllServices()
		elif self.RedBtnMode=="FAVO":
			self.showFavourites()

	def runEPGsearch(self):
		if fileExists("/usr/lib/enigma2/python/Plugins/Extensions/EPGSearch/plugin.pyo"):
			self.updateEPGlist = False
			from Plugins.Extensions.EPGSearch.EPGSearch import EPGSearch
			service = self.getCurrentSelection()
			epg_cur = self["epglist"].getCurrent()
			epg_event = epg_cur[0]
			if epg_event:
				epg_name = epg_event and epg_event.getEventName() or ''
				self.session.open(EPGSearch, epg_name, False)
		else:
			self.session.open(MessageBox, _("A required tool (%s) was not found.") % ("EPFSearch"), MessageBox.TYPE_INFO)

	def AddConfirmedTimer(self):
		self.updateEPGlist = False
		ref=self.getCurrentSelection()
		cur = self["epglist"].getCurrent()
		event = cur[0]
		if event is None:
			return
		serviceref = cur[1]
		eventid = event.getEventId()
		refstr = serviceref.ref.toString()
		for timer in self.session.nav.RecordTimer.timer_list:
			if timer.eit == eventid and timer.service_ref.ref.toString() == refstr:
				cb_func = lambda ret : not ret or self.removeTimer(timer)
				self.session.openWithCallback(cb_func, MessageBox, _("Do you really want to delete %s?") % event.getEventName())
				break
		else:
			newEntry = RecordTimerEntry(serviceref, checkOldTimers = True, *parseEvent(event))
			self.session.openWithCallback(self.finishedAdd, TimerEntry, newEntry)

	def removeTimer(self, timer):
		timer.afterEvent = AFTEREVENT.NONE
		self.session.nav.RecordTimer.removeEntry(timer)
		self["key_green"].setText(_("Add timer"))

	def finishedAdd(self, answer):
		if answer[0]:
			entry = answer[1]
			simulTimerList = self.session.nav.RecordTimer.record(entry)
			if simulTimerList is not None:
				for x in simulTimerList:
					if x.setAutoincreaseEnd(entry):
						self.session.nav.RecordTimer.timeChanged(x)
				simulTimerList = self.session.nav.RecordTimer.record(entry)
				if simulTimerList is not None:
					self.session.openWithCallback(self.finishSanityCorrection, TimerSanityConflict, simulTimerList)
			self["key_green"].setText(_("Remove timer"))

	def finishSanityCorrection(self, answer):
		self.finishedAdd(answer)

	def getBqtServices(self, bouquet):
		services = [ ]
		servicelist = eServiceCenter.getInstance().list(bouquet)
		if not servicelist is None:
			while True:
				service = servicelist.getNext()
				if not service.valid():
					break
				if service.flags & (eServiceReference.isDirectory | eServiceReference.isMarker): #ignore non playable services
					continue
				services.append(ServiceReference(service))
		return services

	def showSinEPG(self):
		ref=self.getCurrentSelection()
		if ref:
			self.savedService = ref
			self.session.openWithCallback(self.SingleServiceEPGClosed, impotedEPGSelection, ref, serviceChangeCB = self.changeServiceCB)

	def goPT(self):
		self.updateEPGlist = False
		bouquets = self.servicelist.getRoot()
		newservices = self.getBqtServices(bouquets)
		class EPGSelection(impotedEPGSelection):
			def __init__(self, session, service=None, zapFunc=None, eventid=None, bouquetChangeCB=None, serviceChangeCB=None):
				impotedEPGSelection.__init__(self, session, newservices, zapFunc, eventid, bouquetChangeCB, serviceChangeCB)
			def onCreate(self):
				if self.type == EPG_TYPE_MULTI:
					heute = localtime(time())
					ptheute = datetime(heute[0],heute[1],heute[2],heute[3],heute[4])
					heute_time = int(mktime(ptheute.timetuple()))
					pt = datetime(heute[0],heute[1],heute[2],config.valisepg.ptH.value,config.valisepg.ptM.value)
					pt_ask_time = int(mktime(pt.timetuple()))
					if pt_ask_time<heute_time:
						pt_ask_time = pt_ask_time + 86400
					self["key_red"].hide()
					self["key_yellow"].hide()
					self["key_blue"].hide()
					self["now_text"].hide()
					self["next_text"].hide()
					self["more_text"].hide()
					l = self["list"]
					l.recalcEntrySize()
					l.fillMultiEPG(self.services, pt_ask_time)
					l.moveToService(self.session.nav.getCurrentlyPlayingServiceReference())
			def zapTo(self):
				pass
			def yellowButtonPressed(self):
				pass
			def blueButtonPressed(self):
				pass
			def enterDateTime(self):
				pass
			#def prevBouquet(self):
				#pass
			#def nextService(self):
				#pass
		self.session.open(EPGSelection, newservices)



class ValisEPGconfig(ConfigListScreen, Screen):
	skin = """
		<screen name="ValisEPGconfig" position="center,center" size="600,476" title="%s">
			<widget itemHeight="28" name="config" position="10,50" scrollbarMode="showOnDemand" size="580,280" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/red.png" position="30,350" size="30,30" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/green.png" position="30,390" size="30,30" />
			<ePixmap alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG//blue.png" position="30,430" size="30,30" />
			<eLabel font="Regular;20" halign="left" text="Cancel" position="70,352" size="220,26" transparent="1" zPosition="1" />
			<eLabel font="Regular;20" halign="left" text="Save" position="70,392" size="220,26" transparent="1" zPosition="1" />
			<widget font="Regular;20" halign="left" name="aktText" position="70,432" size="350,26" transparent="1" zPosition="1" />
		</screen>""" % ("Vali's EPG: "+_("Setup"))
	def __init__(self, session):
		self.session = session
		Screen.__init__(self, session)
		self["aktText"] = Label("Vali's EPG: "+(_("enable")).upper()+" !!!")
		self.isVEPGactive = False
		list = []
		list.append(getConfigListEntry("Primetime, "+_("hour"), config.valisepg.ptH))
		list.append(getConfigListEntry("Primetime, "+_("minutes"), config.valisepg.ptM))
		list.append(getConfigListEntry("AutoZap-"+_("Time")+" ("+_("seconds")+")", config.valisepg.autozap))
		ConfigListScreen.__init__(self, list)
		self["actions"] = NumberActionMap(["OkCancelActions", "ColorActions"], 
									{
									"red": self.exit,
									"green": self.save,
									"blue" : self.blueAct,
									"cancel": self.exit
									}, -1)
		self.onLayoutFinish.append(self.CheckActivVEPG)

	def save(self):
		for x in self["config"].list:
			x[1].save()
		self.close()

	def exit(self):
		for x in self["config"].list:
			x[1].cancel()
		self.close()

	def CheckActivVEPG(self):
		self.isVEPGactive = False
		CSfName = "/usr/lib/enigma2/python/Screens/InfoBarGenerics.py"
		CSfile = open(CSfName, "r")
		CSfLines = CSfile.readlines()
		CSfile.close()
		for x in CSfLines:
			if x[:-1]=='\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.pyo"):':
				self.isVEPGactive = True
		if self.isVEPGactive:
			self["aktText"].setText((_("disable")).upper()+" Vali's EPG")
		else:
			self["aktText"].setText((_("enable")).upper()+" Vali's EPG")

	def blueAct(self):
		#if self.isVEPGactive:
			#return
		CSfName = "/usr/lib/enigma2/python/Screens/InfoBarGenerics.py"
		CSfile = open(CSfName, "r")
		CSfLines = CSfile.readlines()
		CSfile.close()
		NEWfLines = []
		for x in CSfLines:
			if x[:-1]=="\t\tself.servicelist = self.session.instantiateDialog(ChannelSelection)":
				NEWfLines.append('\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.pyo"):\n')
				NEWfLines.append("\t\t\tfrom Plugins.Extensions.ValisEPG.plugin import ValisEPG\n")
				NEWfLines.append("\t\t\tself.servicelist = self.session.instantiateDialog(ValisEPG)\n")
				NEWfLines.append("\t\telse:\n")
				NEWfLines.append("\t\t\tself.servicelist = self.session.instantiateDialog(ChannelSelection)\n")
			elif x[:-1]=='\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.pyo"):':
				NEWfLines.append('\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.NO"):\n')
			elif x[:-1]=='\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.NO"):':
				NEWfLines.append('\t\tif fileExists("/usr/lib/enigma2/python/Plugins/Extensions/ValisEPG/plugin.pyo"):\n')
			else:
				NEWfLines.append(x)
		try:
			NEWfile = open(CSfName, "w")
			for xx in NEWfLines:
				NEWfile.writelines(xx)
			NEWfile.close()
			self.session.open(MessageBox, "Vali's EPG: "+_("enabled")+".\n"+_("Restart GUI")+" !", MessageBox.TYPE_INFO)
		except:
			self.session.open(MessageBox, "  I/O ERROR !!!", MessageBox.TYPE_ERROR)
		self.close()



def Plugins(**kwargs):
	return [PluginDescriptor(name="ValisEPGsetup", where=PluginDescriptor.WHERE_MENU, fnc=main)]

def main(menuid):
	if menuid != "setup":
		return [ ]
	return [(("Vali's EPG: "+_("Setup")), VEPGhandle, "valisepg", None)]

def VEPGhandle(session, **kwargs):
	session.open(ValisEPGconfig)







