#!/usr/bin/env python
# -*- coding: utf-8 -*-
#######################################################################
# maintainer: einfall
#This plugin is free software, you are allowed to
#modify it (if you keep the license),
#but you are not allowed to distribute/publish
#it without source code (this version and your modifications).
#This means you also have to distribute
#source code of your modifications.
#######################################################################

from Components.ActionMap import *
from Components.ServiceEventTracker import ServiceEventTracker
from Components.Button import Button
from Components.Label import Label
from Components.ScrollLabel import ScrollLabel
from Components.ConfigList import ConfigListScreen
from Components.Sources.StaticText import StaticText
from Components.ActionMap import NumberActionMap, ActionMap
from Components.config import config, ConfigSelection, getConfigListEntry, ConfigText, ConfigInteger, ConfigDirectory, ConfigYesNo, ConfigSelection, ConfigSubsection, ConfigPIN, configfile
from Components.FileList import FileList, FileEntryComponent
from Components.GUIComponent import GUIComponent
from Components.MenuList import MenuList
from Components.Pixmap import Pixmap, MovingPixmap
from Components.PluginList import PluginEntryComponent, PluginList
from Components.AVSwitch import AVSwitch
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmap, MultiContentEntryPixmapAlphaTest
from Components.ServiceEventTracker import ServiceEventTracker

from Plugins.Plugin import PluginDescriptor
from Screens.InfoBar import MoviePlayer
from Screens.HelpMenu import HelpableScreen
from Screens.MessageBox import MessageBox
from Screens.Screen import Screen
from enigma import iPlayableService, iServiceInformation, eServiceReference, eTimer
from enigma import gFont, eTimer, eConsoleAppContainer, ePicLoad, loadPNG, getDesktop, eListboxPythonMultiContent, eListbox, RT_HALIGN_LEFT, RT_HALIGN_RIGHT, RT_HALIGN_CENTER, RT_VALIGN_CENTER, RT_WRAP
from Tools.Directories import pathExists, fileExists, SCOPE_SKIN_IMAGE, resolveFilename
from Tools.LoadPixmap import LoadPixmap
from Tools import Notifications
from Tools.BoundFunction import boundFunction

import urllib, urllib2, re, os, shutil, time, datetime, glob, thread
from Tools.Downloader import HTTPProgressDownloader, downloadWithProgress

from twisted.web.client import downloadPage, getPage, error
from twisted.internet import reactor, defer

from threading import Thread

try:
	from enigma import eMediaDatabase
	isDreamOS = True
except:
	isDreamOS = False

pname = "MediaInfo"
pdesc = "MediaInfo - Stream Download"
pversion = "2.8.1"

global joblist
joblist = []

global downloadsfile
downloadsfile = "/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/downloads"

already_open = False
MoviePlayer.originalOpenEventView = MoviePlayer.openEventView

config.plugins.mediainfo = ConfigSubsection()
config.plugins.mediainfo.donemsg = ConfigYesNo(default = True)
config.plugins.mediainfo.dllimit = ConfigInteger(default = 2, limits = (1,10))
config.plugins.mediainfo.premiumize = ConfigYesNo(default = False)
config.plugins.mediainfo.premiumize_user = ConfigText(default = "User",  fixed_size=False)
config.plugins.mediainfo.premiumize_pass = ConfigText(default = "Pass",  fixed_size=False)
config.plugins.mediainfo.savetopath = ConfigText(default = "/media/hdd/movie/",  fixed_size=False)
config.plugins.mediainfo.delunpack = ConfigYesNo(default = True)
config.plugins.mediainfo.share_online = ConfigYesNo(default = False)
config.plugins.mediainfo.share_online_user = ConfigText(default = "user",  fixed_size=False)
config.plugins.mediainfo.share_online_pass = ConfigText(default = "pass",  fixed_size=False)
config.plugins.mediainfo.uploaded = ConfigYesNo(default = False)
config.plugins.mediainfo.uploaded_user = ConfigText(default = "User",  fixed_size=False)
config.plugins.mediainfo.uploaded_pass = ConfigText(default = "Pass",  fixed_size=False)
#config.plugins.mediainfo.otr = ConfigYesNo(default = False)
#config.plugins.mediainfo.otr_user = ConfigText(default = "user",  fixed_size=False)
#config.plugins.mediainfo.otr_pass = ConfigText(default = "pass",  fixed_size=False)

class downloadTask(Thread):
	def __init__(self, session, filename, url, hoster, downloadName):
		self.session = session
		self.filename = filename
		self.url = url
		self.downloadName = downloadName
		self.hoster = hoster
		self.end = 100
		self.progress = 0
		self.recvbytes = 0
		self.totalbytes = 0
		self.path = config.plugins.mediainfo.savetopath.value
		self.local = "%s%s" % (self.path, self.filename)
		self.unrar = "/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/unrar"
		self.pwlist = ['Uploadix', 'hd-world.org', 'movie-blog.org', 'ddl-warez', 'serienjunkies.org']
		self.stop_manuell = False
		self.dualPacked = False
		self.dualRarname = None
		self.unpackedFileName = None
		self.try_login = False
		self.keckse = {}
		self.keckse_dump = {}
		Thread.__init__(self)

	def start(self, checkname):
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			print "[MediaInfo] Start Download: %s" % checkname
			agent = 'Mozilla/5.0 (Windows NT 6.1; rv:32.0) Gecko/20100101 Firefox/32.0'
			try:
				self.download = downloadWithProgress(self.url, self.local, agent)
				self.download.addProgress(self.http_progress)
				self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)
			except:
				print "[MediaInfo] useragent wird nicht supportet."
				self.download = downloadWithProgress(self.url, self.local)
				self.download.addProgress(self.http_progress)
				self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)
			return True
		else:
			print "[MediaInfo] Max Download Slots Full %s" % checkname
			return False

	def startWithPremiumize(self, checkname):
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			if self.hoster == "share-online" and config.plugins.mediainfo.share_online.value:
				api_url = "http://api.share-online.biz/cgi-bin?q=userdetails&username=%s&password=%s" % (config.plugins.mediainfo.share_online_user.value, config.plugins.mediainfo.share_online_pass.value)
				getPage(api_url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.share_online_Cookies).addErrback(self.share_online_Error)
			elif self.hoster == "uploaded" and config.plugins.mediainfo.uploaded.value:
				api_url = "http://uploaded.net/me"
				getPage(api_url, timeout=15, headers=self.keckse_dump).addCallback(self.check_uploaded)
			elif self.hoster == "premiumize" and config.plugins.mediainfo.premiumize.value:
				api_url = "http://api.premiumize.me/pm-api/v1.php?method=directdownloadlink&params[login]=%s&params[pass]=%s&params[link]=%s" % (config.plugins.mediainfo.premiumize_user.value, config.plugins.mediainfo.premiumize_pass.value, self.url)
				getPage(api_url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.premiumizeApiData)
			elif self.hoster == "zippyshare":
				self.keckse = {}
				getPage(self.url, cookies=self.keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.zippyshareData)

	def zippyshareData(self, data):
		a = re.findall('var\sa\s=\s(.*?);', data)
		a = int(a[0])/3
		a = str(a)
		b = re.findall('var\sb\s=\s(.*?);', data)
		b = b[0]
		surl = re.findall('"\+\((.*?)\)\+"', data)
		rechnen = surl[0].replace('a',a).replace('b',b)
		baseurl = re.findall('<meta property="og:url" content="(.*?)v', data)
		key = re.findall('<a href="/view.jsp\?locale=.*?key=(.*?)"', data, re.S)
		url = baseurl[0]+"d/"+key[0]+"/"+str(eval(rechnen))+"/"+self.filename
		print url
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			print self.keckse
			print self.keckse['JSESSIONID']
			self.keckse = {'cookie': "JSESSIONID="+str(self.keckse['JSESSIONID'])}
			print self.keckse
			self.markJobAsDownload(self.filename)
			self.download = downloadWithProgress(url, self.local, headers=self.keckse)
			self.download.addProgress(self.http_progress)
			self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)

	def check_uploaded(self, data):
		if re.search(config.plugins.mediainfo.uploaded_user.value, data, re.S):
			print "cookies OKAY !!!!"
			self.try_login = False
			if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
				self.uploaded_download()
		else:
			if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value) and not self.try_login:
				print "hole cookies.."
				post = urllib.urlencode({'id': config.plugins.mediainfo.uploaded_user.value, 'pw': config.plugins.mediainfo.uploaded_pass.value})
				api_url = "http://uploaded.net/io/login"
				self.try_login = True
				getPage(api_url, method='POST', postdata=post, cookies=self.keckse, timeout=15, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.uploaded_cookies)

	def uploaded_cookies(self, data):
		print "cookies orginal:", self.keckse
		if 'login' in self.keckse:
			self.keckse_dump = {'cookie': 'login='+self.keckse['login']}
			print "cookies dump:", self.keckse_dump
			if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
				self.try_login = False
				self.uploaded_download()
		else:
			self.try_login = False
			print "cookies no login !"

	def uploaded_download(self):
		print "download cookies:", self.keckse
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			self.markJobAsDownload(self.filename)
			if self.url.endswith('/'):
				location = self.url.replace('ul.to','uploaded.net/file')+"ddl"
			else:
				location = self.url.replace('ul.to','uploaded.net/file')+"/ddl"
			print location
			self.download = downloadWithProgress(location, self.local, headers=self.keckse_dump)
			self.download.addProgress(self.http_progress)
			self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)

	def share_online_Cookies(self, data):
		cookie = re.findall('a=(.*\w+)', data)
		if cookie:
			kecks = "a=%s" % cookie[0]
			keckse = {'cookie': kecks}
			api_url = "http://api.share-online.biz/cgi-bin?q=linkdata&username=%s&password=%s&lid=%s" % (config.plugins.mediainfo.share_online_user.value, config.plugins.mediainfo.share_online_pass.value, self.url)
			getPage(api_url, method='POST', timeout=15, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.share_online_Data, keckse).addErrback(self.share_online_Error)

	def share_online_Error(self, error):
		print "[MediaInfo] ERROR: %s" % error
		self.markJobAsError(self.filename)
		self.backupJobs()

	def share_online_Data(self, data, keckse):
		location = re.findall('URL:.(.*?)\n', data, re.S|re.I)
		if location:
			if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
				self.markJobAsDownload(self.filename)
				self.download = downloadWithProgress(location[0], self.local, headers=keckse)
				self.download.addProgress(self.http_progress)
				self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)

	def premiumizeApiData(self, data):
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			if re.search('(Hoster could not be parsed from link|login failed)', data, re.S):
				print "[MediaInfo] Start Download: %s" % self.filename
				self.markJobAsDownload(self.filename)
				self.download = downloadWithProgress(self.url, self.local)
				self.download.addProgress(self.http_progress)
				self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)
			else:
				print "[MediaInfo] Start Download with Premiumize.me: %s" % self.filename
				location = re.findall('"location":"(.*?)"', data)
				if location:
					self.markJobAsDownload(self.filename)
					self.download = downloadWithProgress(location[0].replace('\\','').replace('https:','http:'), self.local)
					self.download.addProgress(self.http_progress)
					self.download.start().addCallback(self.http_finished).addErrback(self.http_failed)
				else:
					self.markJobAsError(self.filename)

	def startNextJob(self):
		print "[MediaInfo] Check for Next Download."
		if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
			global joblist
			if len(joblist) > 0:
				#if config.plugins.mediainfo.premiumize.value:
				for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
					if status == "Wait" and self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value) and hoster != "stream":
							job.startWithPremiumize(filename)
					elif status == "Wait" and self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
							if job.start(filename):
								print "mark as download", filename
								self.markJobAsDownload(filename)
				#else:
				#	for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				#		if status == "Wait" and self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
				#			if job.start(filename):
				#				print "mark as download", filename
				#				self.markJobAsDownload(filename)

	def checkRunningJobs(self):
		global joblist
		countRuningJobs = 0
		if len(joblist) > 0:
			for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				if status == "Download":
					countRuningJobs += 1
		return countRuningJobs

	def markJobAsDownload(self, change_filename):
		joblist_tmp = []
		global joblist
		if len(joblist) > 0:
			for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				if filename == change_filename:
					joblist_tmp.append((filename, int(time.time()), "Download", url, hoster, downloadName, job))
				else:
					joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
			joblist = joblist_tmp

	def markJobAsFinish(self, change_filename):
		joblist_tmp = []
		global joblist
		if len(joblist) > 0:
			for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				if filename == change_filename:
					joblist_tmp.append((filename, starttime, "Complete", url, hoster, downloadName, job))
				else:
					joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
			joblist = joblist_tmp

	def markJobAsError(self, change_filename):
		joblist_tmp = []
		global joblist
		if len(joblist) > 0:
			for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				if filename == change_filename:
					joblist_tmp.append((filename, starttime, "Error", url, hoster, downloadName, job))
				else:
					joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
			joblist = joblist_tmp
			self.backupJobs()

	def removeJobsFromJoblist(self, rarname):
		joblist_tmp = []
		global joblist
		if len(joblist) > 0:
			for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
				if not re.search(rarname, filename, re.I):
					joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
			joblist = joblist_tmp
			self.backupJobs()

	def stop(self):
		self.stop_manuell = True
		if self.download:
			self.download.stop()

	def http_progress(self, recvbytes, totalbytes):
		self.progress = int(self.end*recvbytes/float(totalbytes))
		self.recvbytes = recvbytes
		self.totalbytes = totalbytes

	def current_progress(self):
		return [self.recvbytes, self.totalbytes, self.progress]

	def http_finished(self, string=""):
		print "[http_finished]" + str(string), self.filename, self.totalbytes
		if not self.totalbytes > 250:
			self.markJobAsError(self.filename)
			self.backupJobs()
		else:
			self.markJobAsFinish(self.filename)
			self.backupJobs()
			if self.checkRunningJobs() < int(config.plugins.mediainfo.dllimit.value):
				self.startNextJob()
			rarname = self.getRarName(self.filename)
			if rarname is not None:
				if self.checkCompleteDownload(rarname):
					unpack_rarfile = self.getFirstRarFileFromList(rarname)
					if unpack_rarfile is not None:
						self.unpackRelease(unpack_rarfile, True)
			else:
				if config.plugins.mediainfo.donemsg.value:
					message = self.session.open(MessageBox, "MediaInfo: %s Download Complete." % self.filename, MessageBox.TYPE_INFO, timeout=4)

	def http_failed(self, failure_instance=None, error_message=""):
		print failure_instance
		if error_message == "" and failure_instance is not None:
			error_message = failure_instance.getErrorMessage()
			print "[http_failed] " + error_message
			if not self.stop_manuell:
				self.markJobAsError(self.filename)

#	def otrkey(self, cfilename):
#		if cfilename.endswith('.otrkey'):
#			print "true"
#			return True
#		else:
#			print "false"
#			return False
#
#	def decryptOtrkey(self, otrFilename):
#		cmd = "otrtool -x -e %s -p %s %s -D %s" % (config.plugins.mediainfo.otr_user.value, config.plugins.mediainfo.otr_pass.value, self.path+otrFilename, self.path)
#		print cmd
#		self.container = eConsoleAppContainer()
#		self.container.appClosed.append(boundFunction(self.decryptOtrkeyComplete, otrFilename))
#		self.container.dataAvail.append(boundFunction(self.otrdecryptLog))
#		self.container.execute(cmd)
#
#	def decryptOtrkeyComplete(self, otrFilename, reval):
#		print "[Mediainfo] Otr File decrypted: %s" % otrFilename
#
#	def otrdecryptLog(self, data):
#		print data
#		if re.search('Decrypting and verifying', data):
#			print "[Mediainfo] decrypting started: %s" % self.filename
#		elif re.search('OK checksums from header match', data):
#			print "[Mediainfo] decrypting Complete: %s" % self.filename
#		elif re.search('Ein Account zur E-Mail.*?wurde nicht gefunden', data):
#			print "[Mediainfo] Onlinetvrecorder login daten falsch: %s" % self.filename
#		elif re.search('Sie haben diese Sendung nicht aufgenommen.', data):
#			print "[Mediainfo] Sie haben diese Sendung nicht aufgenommen. Bitte Wishlist erstellen: %s" % self.filename

	def backupJobs(self):
		global downloadsfile
		if len(joblist) > 0:
			if fileExists(downloadsfile):
				download_file = open(downloadsfile, "w")
				for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
					download_file.write('"%s" "%s" "%s" "%s" "%s"\n' % (filename, status, url, hoster, downloadName))
				download_file.close()
		else:
			download_file = open(downloadsfile, "w").close()

	def checkCompleteDownload(self, rarname):
		global joblist
		countMatchedRarFiles = 0
		countComplete = 0
		for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
			if re.search(rarname, filename, re.I):
				countMatchedRarFiles += 1
				if status == "Complete":
					countComplete += 1
		if countMatchedRarFiles == countComplete:
			print "[MediaInfo] All Rarfile(s) Complete:", rarname
			return True
		else:
			print "[MediaInfo] All Rarfile(s) NOT Complete:", rarname
			return False

	def getRarName(self, filename):
		if re.search('part(\S+).rar', filename, re.I):
			rarname =  re.compile(".part", re.I).split(filename)
			return rarname[0]
		elif re.search('\.rar', filename, re.I):
			rarname =  re.compile(".rar", re.I).split(filename)
			return rarname[0]
		else:
			return None

	def getFirstRarFileFromList(self, rarname):
		global joblist
		rarlist = []
		for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
			if re.search(rarname, filename, re.I):
				rarlist.append(filename)
		if len(rarlist) > 0:
			rarlist.sort()
			return rarlist[0]
		else:
			return None

	def unpackRelease(self, rarname, checkDualPacked):
		if len(self.pwlist) > 0:
			self.found = False
			self.pw = self.pwlist.pop()
			print "[MediaInfo] Password from List: %s" % self.pw
			cmd = "%s e -p%s -kb %s%s -o+ %s" % (self.unrar, self.pw, self.path, rarname, self.path)
			print cmd
			self.container = eConsoleAppContainer()
			if isDreamOS:
				self.appClosed_conn = self.container.appClosed.connect(boundFunction(self.unrarComplete, rarname))
				if checkDualPacked:
					self.dataAvail_conn = self.container.dataAvail.connect(boundFunction(self.unrarLog, True))
				else:
					self.dataAvail_conn = self.container.dataAvail.connect(boundFunction(self.unrarLog, False))
				self.container.execute(cmd)
			else:
				self.container.appClosed.append(boundFunction(self.unrarComplete, rarname))
				if checkDualPacked:
					self.container.dataAvail.append(boundFunction(self.unrarLog, True))
				else:
					self.container.dataAvail.append(boundFunction(self.unrarLog, False))
				self.container.execute(cmd)
		else:
			print "[MediaInfo] No Password matched from PWList !"

	def unrarComplete(self, rarname, reval):
		print "[MediaInfo] Unrar Complete - FOUND PW:", self.found
		self.container.kill()
		if not self.found:
			self.unpackRelease(rarname, True)
		else:
			rarname_mark = self.getRarName(rarname)
			if self.dualPacked and self.dualRarname is not None:
				self.rarname_mark_save = self.getRarName(rarname)
				self.dualPacked = False
				self.unpackRelease(self.dualRarname, False)
			elif rarname_mark is not None:
				print "[MediaInfo] Delete RarFile(s) from Joblist ( %s )" % rarname_mark
				message = self.session.open(MessageBox, "MediaInfo: %s Unpacked." % rarname, MessageBox.TYPE_INFO, timeout=4)
				self.removeJobsFromJoblist(rarname_mark)
				self.removeRarFiles(rarname_mark)
			elif self.rarname_mark_save is not None:
				print "[MediaInfo] Delete RarFile(s) from Joblist ( %s )" % self.rarname_mark_save
				message = self.session.open(MessageBox, "MediaInfo: %s Unpacked." % rarname, MessageBox.TYPE_INFO, timeout=4)
				self.removeJobsFromJoblist(self.rarname_mark_save)
				self.removeRarFiles(self.rarname_mark_save)

	def unrarLog(self, checkForDualPacked, data):
		print data
		#parse = "Extracting  %s/([a-zA-z0-9_-].*\.avi|[a-zA-z0-9_-].*\.mkv|[a-zA-z0-9_-].*\.flv|[a-zA-z0-9_-].*\.mp4)" % config.plugins.mediainfo.savetopath.value
		#print "parse:", parse
		if re.search("Extracting  "+config.plugins.mediainfo.savetopath.value+".*?\.[avi|mkv|mp4]", data, re.S) and self.unpackedFileName is None:
			self.unpackedFileName_raw = re.findall("Extracting  "+config.plugins.mediainfo.savetopath.value+"(.*\w\.[avi|mkv|mp4|flv]+)", data, re.S)
			if self.unpackedFileName_raw:
				if not re.search('sample', self.unpackedFileName_raw[0]):
					self.unpackedFileName = config.plugins.mediainfo.savetopath.value+self.unpackedFileName_raw[0]
					print "[MediaInfo] unpackedFileName: %s" % self.unpackedFileName

		if checkForDualPacked:
			if re.search('\.r00', data):
				dualRarname = re.findall('([a-zA-z0-9_.-]+\.r00)', data)
				if dualRarname:
					self.dualPacked = True
					self.dualRarname = dualRarname[0]
					self.pwlist = self.pwlist = ['Uploadix', 'hd-world.org', 'movie-blog.org', 'ddl-warez', 'serienjunkies.org']
					print "[MediaInfo] Dual Packed: %s" %  self.dualRarname

		if re.search('wrong password', data):
			print "[MediaInfo] Password Missmatch !!! -> %s" % self.pw
			self.found = False
		elif re.search('All OK', data):
			print "[MediaInfo] Password Correct !!! -> %s" % self.pw
			self.found = True
		elif re.search('checksum error', data):
			print "[MediaInfo] checksum error !!!"
			self.found = True

	def removeRarFiles(self, rarname):
		print "[MediaInfo] file %s is DOONNNNNNNEEEEEEEE" % self.downloadName
		self.writeLog("Done: %s" % self.downloadName)
		# cleanup bad files
		filelist = glob.glob("%s*" % config.plugins.mediainfo.savetopath.value)
		for file in filelist:
			if file.lower().endswith(('.nfo', '.html', '.url', '.txt', '.url')):
				print "[MediaInfo] Remove file(s): %s" % file
				os.remove(file)
			elif re.search('sample', file, re.I):
				print "[MediaInfo] Remove file(s): %s" % file
				os.remove(file)

		# del unpacked rar files
		if config.plugins.mediainfo.delunpack.value:
			filelist = glob.glob("%s%s.part*" % (config.plugins.mediainfo.savetopath.value, rarname))
			for file in filelist:
				print "[MediaInfo] Remove file(s): %s" % file
				os.remove(file)

		if self.downloadName == "None":
			self.writeLog("downloadName: None")
			return

		if self.unpackedFileName is not None:
			self.writeLog("unpackedFileName: %s" % self.unpackedFileName)
			formatName = None
			if self.unpackedFileName.lower().endswith(".mkv"):
				formatName = ".mkv"
			elif self.unpackedFileName.lower().endswith(".avi"):
				formatName = ".avi"
			elif self.unpackedFileName.lower().endswith(".mp4"):
				formatName = ".mp4"
			elif self.unpackedFileName.lower().endswith(".flv"):
				formatName = ".flv"

			if formatName is not None:
				print "formatName:", formatName
				self.writeLog("FormatName: %s" % formatName)
				print "downloadName:", self.downloadName
				self.writeLog("DownloadName: %s" % self.downloadName)
				if re.search('[\.|\s]german[\.|\s]', self.downloadName, re.I):
					words = re.split('[\.|\s]german[\.|\s]', self.downloadName, 1, re.I)
					if words:
						self.downloadName = words[0]
				sourceFile = self.unpackedFileName
				destinationFile = "%s%s%s" % (config.plugins.mediainfo.savetopath.value, self.downloadName, formatName)
				if not fileExists(sourceFile):
					print "[MediaInfo] NO FilE: %s" % sourceFile
					self.writeLog("NO FilE: %s" % sourceFile)
					return
				print "[MediaInfo] MOVE: %s to %s" % (sourceFile, destinationFile)
				self.writeLog("MOVE: %s to %s" % (sourceFile, destinationFile))
				os.rename(sourceFile, destinationFile)
			else:
				self.writeLog("downloadName: No supportet format found.")

	def writeLog(self, text):
		lt = time.localtime()
		uhrzeit = time.strftime("%d.%m.%Y - %H:%M:%S", lt)
		logFile = "/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/log"
		if not fileExists(logFile):
			open(logFile, 'w').close()
		writeLogFile = open(logFile, "a")
		writeLogFile.write('%s - MediaInfo: %s\n' % (str(uhrzeit), text))
		writeLogFile.close()

class mediaInfoConfigScreen(Screen, ConfigListScreen):
	skin = 	"""
		<screen name="MediaInfo" title="MediaInfo" position="center,center" size="1280,720">
		<eLabel position="0,0" size="1280,720" zPosition="-15" backgroundColor="#26181d20" transparent="0" />
		<widget name="head" position="0,0" size="1280,45" backgroundColor="#26181d20" transparent="0" zPosition="5" foregroundColor="#00000000" font="Regular;26" halign="center" valign="center" />
		<widget name="config" position="20,50" size="1240,400" transparent="1" scrollbarMode="showOnDemand" />
		<widget name="check" position="20,450" size="1240,240" font="Regular;20" transparent="1" zPosition="5" valign="top" halign="left" />
		<widget name="key_red" position="99,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_green" position="411,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_yellow" position="761,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_blue" position="1073,680" size="200,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<ePixmap position="59,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_red.png" alphatest="on" />
		<ePixmap position="374,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_green.png" alphatest="on" />
		<ePixmap position="726,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_yellow.png" alphatest="on" />
		<ePixmap position="1037,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_blue.png" alphatest="on" />
	</screen>"""

	def __init__(self, session):
		Screen.__init__(self, session)
		self.session = session

		self["actions"] = ActionMap(["MI_Actions"], {
			"ok"	:	self.ok,
			"cancel":	self.cancel,
			"red"	:	self.cancel,
			"green"	:	self.save,
			"yellow":	self.checkAccounts,
			"left"	:	self.keyLeft,
			"right"	:	self.keyRight
		}, -1)

		self['head'] = Label("Settings:")
		self['key_red'] = Label("Cancel")
		self['key_green'] = Label("Save")
		self['key_yellow'] = Label("Hoster Status")
		self['key_blue'] = Label("")
		self["check"] = ScrollLabel()

		self.log = ""
		self.list = []
		self.createConfigList()
		ConfigListScreen.__init__(self, self.list)
		self.onLayoutFinish.append(self.checkAccounts)

	def createConfigList(self):
		self.setTitle(pname + " (" + pversion + ")")
		self.list = []
		self.list.append(getConfigListEntry("Save Downloads to:", config.plugins.mediainfo.savetopath))
		self.list.append(getConfigListEntry("Show 'Download Complete' Message:", config.plugins.mediainfo.donemsg))
		self.list.append(getConfigListEntry("Parallel Downloads:", config.plugins.mediainfo.dllimit))
		self.list.append(getConfigListEntry("Use Premiumize.me:", config.plugins.mediainfo.premiumize))
		if config.plugins.mediainfo.premiumize.value:
			self.list.append(getConfigListEntry("   Premiumize.me Username:", config.plugins.mediainfo.premiumize_user))
			self.list.append(getConfigListEntry("    Premiumize.me Password:", config.plugins.mediainfo.premiumize_pass))
		self.list.append(getConfigListEntry("Use Share-Online.biz:", config.plugins.mediainfo.share_online))
		if config.plugins.mediainfo.share_online.value:
			self.list.append(getConfigListEntry("    Share-Online.biz Username:", config.plugins.mediainfo.share_online_user))
			self.list.append(getConfigListEntry("    Share-Online.biz Password:", config.plugins.mediainfo.share_online_pass))
		self.list.append(getConfigListEntry("Use Uploaded.net:", config.plugins.mediainfo.uploaded))
		if config.plugins.mediainfo.uploaded.value:
			self.list.append(getConfigListEntry("    Uploaded.net Username:", config.plugins.mediainfo.uploaded_user))
			self.list.append(getConfigListEntry("    Uploaded.net Password:", config.plugins.mediainfo.uploaded_pass))
		#self.list.append(getConfigListEntry("Use Onlinetvrecorder.com for decrypt .otrkey file(s):", config.plugins.mediainfo.otr))
		#if config.plugins.mediainfo.otr.value:
		#	self.list.append(getConfigListEntry("    Onlinetvrecorder.com Username:", config.plugins.mediainfo.otr_user))
		#	self.list.append(getConfigListEntry("    Onlinetvrecorder.com: Password", config.plugins.mediainfo.otr_pass))

	def changedEntry(self):
		self.createConfigList()
		self["config"].setList(self.list)

	def checkAccounts(self):
		self.log = ""
		sl = self["check"]
		sl.instance.setZPosition(1)
		if config.plugins.mediainfo.premiumize.value:
			api_url = "http://api.premiumize.me/pm-api/v1.php?method=accountstatus&params[login]=%s&params[pass]=%s" % (config.plugins.mediainfo.premiumize_user.value, config.plugins.mediainfo.premiumize_pass.value)
			getPage(api_url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.checkPremiumize)
		else:
			self.writeLogSreen("Hoster Premiumize.me is disabled.")

		if config.plugins.mediainfo.share_online.value:
			api_url = "http://api.share-online.biz/cgi-bin?q=userdetails&aux=traffic&username=%s&password=%s" % (config.plugins.mediainfo.share_online_user.value, config.plugins.mediainfo.share_online_pass.value)
			getPage(api_url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.checkShareOnline)
		else:
			self.writeLogSreen("Hoster Share-Online.biz is disabled.")

		if config.plugins.mediainfo.uploaded.value:
			post = urllib.urlencode({'id': config.plugins.mediainfo.uploaded_user.value, 'pw': config.plugins.mediainfo.uploaded_pass.value})
			api_url = "http://uploaded.net/io/login"
			self.keckse_dumpy = {}
			getPage(api_url, method='POST', postdata=post, cookies=self.keckse_dumpy, timeout=15, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.checkUploadedCookie)
		else:
			self.writeLogSreen("Hoster Uploaded.net is disabled.")

	def checkUploadedCookie(self, data):
		api_url = "http://uploaded.net/me"
		getPage(api_url, timeout=15, cookies=self.keckse_dumpy).addCallback(self.checkUploaded)

	def checkUploaded(self, data):
		self.writeLogSreen("Login to: Uploaded - OK")
		if re.search('<td style=".*?">Status:</td>.*?<th style=".*?"><em>Free</em></a></th>', data, re.S|re.I):
			uploadedStatus = "Status: Uploaded - Expired: FREE USER - NO DOWNLOAD POSSIBLE"
			self.writeLogSreen(uploadedStatus)
		elif re.search('<td style=".*?">Status:</td>.*?<th style=".*?"><em>Premium</em></a></th>', data, re.S|re.I):
			duration = re.findall('<td>Duration:</td>.*?<th>(.*?)</th>', data, re.S|re.I)
			if duration:
				uploadedStatus = "Status: Uploaded - Premium: %s" % duration[0]
				self.writeLogSreen(uploadedStatus)
		else:
			uploadedStatus = "Status: Uploaded - Error"
			self.writeLogSreen(uploadedStatus)

	def checkPremiumize(self, data):
		premiumizeStatus = ""
		login = re.findall('"statusmessage":"(.*?)"', data)
		if login:
			if re.match('.*?OK', login[0]):
				self.writeLogSreen("Login to: Premiumize.me - OK")
				status = re.findall('"type":"(.*?)"\,"expires":(.*?)\,".*?"trafficleft_gigabytes":(\d+)', data)
				if status:
					(type, expires, left) = status[0]
					zeit = datetime.datetime.fromtimestamp(int(expires)).strftime('%d-%m-%Y %H:%M:%S')
					premiumizeStatus = "Status: Premiumize.me %s - Trafficleft: %s GB - Expired: %s" % (type, int(left), zeit)
					self.writeLogSreen(premiumizeStatus)
			else:
				self.writeLogSreen("Login to: Premiumize.me - FAiLED")

	def checkShareOnline(self, data):
		status = re.findall('group=(.*?)\n.*?expire_date=(.*?)\n', data, re.S)
		if status:
			self.writeLogSreen("Login to: Share-Online.biz - OK")
			(type, expires) = status[0]
			zeit = datetime.datetime.fromtimestamp(int(expires)).strftime('%d-%m-%Y %H:%M:%S')
			shareOnlineStatus = "Status: Share-Online.biz %s - Expired: %s" % (type, zeit)
			self.writeLogSreen(shareOnlineStatus)
		else:
			self.writeLogSreen("Login to: Share-Online.biz - FAiLED")

	def writeLogSreen(self, txt):
		self.log += txt+"\n"
		self["check"].setText(self.log)

	def ok(self):
		ConfigListScreen.keyOK(self)
		if self['config'].getCurrent()[1] == config.plugins.mediainfo.savetopath:
			self.session.openWithCallback(self.selectedMediaFile, mediaInfoFolderScreen, config.plugins.mediainfo.savetopath.value)

	def selectedMediaFile(self, res):
		if res is not None:
			config.plugins.mediainfo.savetopath.value = res
			config.plugins.mediainfo.savetopath.save()
			configfile.save()
			self.changedEntry()

	def keyLeft(self):
		ConfigListScreen.keyLeft(self)
		self.changedEntry()

	def keyRight(self):
		ConfigListScreen.keyRight(self)
		self.changedEntry()

	def save(self):
		config.plugins.mediainfo.savetopath.save()
		config.plugins.mediainfo.donemsg.save()
		config.plugins.mediainfo.dllimit.save()
		config.plugins.mediainfo.premiumize.save()
		config.plugins.mediainfo.premiumize_user.save()
		config.plugins.mediainfo.premiumize_pass.save()
		config.plugins.mediainfo.share_online.save()
		config.plugins.mediainfo.share_online_user.save()
		config.plugins.mediainfo.share_online_pass.save()
		config.plugins.mediainfo.uploaded.save()
		config.plugins.mediainfo.uploaded_user.save()
		config.plugins.mediainfo.uploaded_pass.save()
		#config.plugins.mediainfo.otr.save()
		#config.plugins.mediainfo.otr_user.save()
		#config.plugins.mediainfo.otr_pass.save()
		configfile.save()
		self.close()

	def cancel(self):
		self.close()

class mediaInfoFolderScreen(Screen):
	skin = """
		<screen position="center,center" size="650,400" title=" ">
			<widget name="media" position="10,10" size="540,30" valign="top" font="Regular;22" />
			<widget name="folderlist" position="10,45" zPosition="1" size="540,300" scrollbarMode="showOnDemand"/>
			<ePixmap position="10,370" size="260,25" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_red.png" alphatest="on" />
			<ePixmap position="210,370" size="260,25" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_green.png" alphatest="on" />
			<widget render="Label" source="key_red" position="40,372" size="100,20" valign="center" halign="left" zPosition="2" font="Regular;18" foregroundColor="white" />
			<widget render="Label" source="key_green" position="240,372" size="70,20" valign="center" halign="left" zPosition="2" font="Regular;18" foregroundColor="white" />
		</screen>
		"""

	def __init__(self, session, initDir, plugin_path = None):
		Screen.__init__(self, session)

		if not os.path.isdir(initDir):
			initDir = "/media/hdd/movie/"

		self["folderlist"] = FileList(initDir, inhibitMounts = False, inhibitDirs = False, showMountpoints = False, showFiles = False)
		self["media"] = Label()
		self["actions"] = ActionMap(["MI_Actions"],
		{
			"back": self.cancel,
			"left": self.left,
			"right": self.right,
			"up": self.up,
			"down": self.down,
			"ok": self.ok,
			"green": self.green,
			"red": self.cancel
		}, -1)
		self.title= "Choose Download folder"
		try:
			self["title"] = StaticText(self.title)
		except:
			print 'self["title"] was not found in skin'
		self["key_red"] = StaticText("Cancel")
		self["key_green"] = StaticText("Ok")

	def cancel(self):
		self.close(None)

	def green(self):
		directory = self["folderlist"].getSelection()[0]
		if (directory.endswith("/")):
			self.fullpath = self["folderlist"].getSelection()[0]
		else:
			self.fullpath = self["folderlist"].getSelection()[0] + "/"
	  	self.close(self.fullpath)

	def up(self):
		self["folderlist"].up()
		self.updateFile()

	def down(self):
		self["folderlist"].down()
		self.updateFile()

	def left(self):
		self["folderlist"].pageUp()
		self.updateFile()

	def right(self):
		self["folderlist"].pageDown()
		self.updateFile()

	def ok(self):
		if self["folderlist"].canDescent():
			self["folderlist"].descent()
			self.updateFile()

	def updateFile(self):
		currFolder = self["folderlist"].getSelection()[0]
		self["media"].setText(currFolder)

def ListEntry(entry):
	(filename, status, progress, dlspeed, currentSizeMB, totalMB) = entry
	if status == "Download":
		mbinfo = "%s mb/ %s mb" % (str(currentSizeMB), str(totalMB))
		dlinfo = "%s" % dlspeed
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 10, 0, 825, 70, 0, RT_HALIGN_LEFT | RT_WRAP, filename),
			(eListboxPythonMultiContent.TYPE_PROGRESS, 850, 5, 140, 20, int(progress)),
			(eListboxPythonMultiContent.TYPE_TEXT, 1010, 0, 80, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, str(progress)+"%"),
			(eListboxPythonMultiContent.TYPE_TEXT, 1105, 0, 175, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, status),
			(eListboxPythonMultiContent.TYPE_TEXT, 850, 35, 275, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, mbinfo),
			(eListboxPythonMultiContent.TYPE_TEXT, 1105, 35, 175, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, dlinfo),
			]
	elif status == "Complete":
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 10, 0, 825, 70, 0, RT_HALIGN_LEFT | RT_WRAP, filename),
			(eListboxPythonMultiContent.TYPE_PROGRESS, 850, 5, 140, 20, 100),
			(eListboxPythonMultiContent.TYPE_TEXT, 1010, 0, 80, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "100%"),
			(eListboxPythonMultiContent.TYPE_TEXT, 1105, 0, 175, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, status),
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 10, 0, 825, 70, 0, RT_HALIGN_LEFT | RT_WRAP, filename),
			(eListboxPythonMultiContent.TYPE_PROGRESS, 850, 5, 140, 20, 0),
			(eListboxPythonMultiContent.TYPE_TEXT, 1010, 0, 80, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "0%"),
			(eListboxPythonMultiContent.TYPE_TEXT, 1105, 0, 175, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, status),
			]

class mediaInfo(Screen):
	skin = 	"""
		<screen name="MediaInfo" title="MediaInfo" position="center,center" size="1280,720">
		<eLabel position="0,0" size="1280,720" zPosition="-15" backgroundColor="#26181d20" transparent="0" />
		<widget name="head" position="0,0" size="1280,50" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" zPosition="5" font="Regular;26" halign="center" valign="center" />
		<widget name="downloadList" position="0,50" size="1280,630" foregroundColor="#00ffffff" backgroundColor="#26181d20" scrollbarMode="showOnDemand" transparent="1" />
		<widget name="key_red" position="99,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_green" position="411,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_yellow" position="761,680" size="265,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<widget name="key_blue" position="1073,680" size="200,30" zPosition="1" font="Regular;22" halign="left" foregroundColor="#00ffffff" backgroundColor="#26181d20" transparent="0" />
		<ePixmap position="59,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_red.png" alphatest="on" />
		<ePixmap position="374,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_green.png" alphatest="on" />
		<ePixmap position="726,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_yellow.png" alphatest="on" />
		<ePixmap position="1037,684" size="25,25" zPosition="-1" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/pic/button_blue.png" alphatest="on" />
	</screen>"""

	def __init__(self, session, livestreaming):
		Screen.__init__(self, session)
		self.session = session
		self.livestreaming = livestreaming

		self['head'] = Label("Downloads")
		self['key_red'] = Label("Remove")
		self['key_green'] = Label("Download")
		self['key_yellow'] = Label("Start/Stop")
		self['key_blue'] = Label("Setup")

		global joblist
		self.dllist = []
		self.channelMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.channelMenuList.l.setFont(0, gFont('Regular', 20))
		self.channelMenuList.l.setItemHeight(70)
		self['downloadList'] = self.channelMenuList

		self["actions"]  = ActionMap(["MI_Actions"], {
			"ok"	:	self.exit,
			"info"	:	self.exit,
			"cancel":	self.exit,
			"back"	:	self.exit,
			"red"	:	self.jobRemove,
			"green"	:	self.jobStart,
			"yellow":	self.jobCheck,
			"blue"	:	self.mediaInfoSetup,
			"up"	:	self.keyUp,
			"down"	:	self.keyDown,
			"left"	:	self.keyLeft,
			"right"	:	self.keyRight
		}, -1)

		self.refreshTimer = eTimer()
		self.setTitle(pname + " (" + pversion + ")")
		if self.livestreaming:
			if isDreamOS:
				self.refreshTimer_conn1 = self.refreshTimer.timeout.connect(self.streamInfo)
				self.refreshTimer_conn2 = self.refreshTimer.timeout.connect(self.showJobs)
			else:
				self.refreshTimer.callback.append(self.showJobs)
				self.refreshTimer.callback.append(self.streamInfo)
		else:
			if isDreamOS:
				self.refreshTimer_conn1 = self.refreshTimer.timeout.connect(self.showJobs)
			else:
				self.refreshTimer.callback.append(self.showJobs)
		self.refreshTimer.start(1500)
		self.onLayoutFinish.append(self.showJobs)

	def getTitle(self):
		exist = self['downloadList'].getCurrent()
		if exist == None:
			return
		filename = self['downloadList'].getCurrent()[0][0]
		self.title = filename

	def streamInfo(self):
		service = self.session.nav.getCurrentService()
		bufferInfo = service.streamed().getBufferCharge()
		pname_text = service.info().getName()
		url_text = self.session.nav.getCurrentlyPlayingServiceReference().getPath()
		if bufferInfo != None:
			if bufferInfo[2] != 0:
				self.bufferSeconds = bufferInfo[4] / bufferInfo[2] #buffer size / avgOutRate
			else:
				self.bufferSeconds = 0
			self.bufferPercent = bufferInfo[0]
			self.bufferSecondsLeft = self.bufferSeconds * self.bufferPercent / 100
			self["head"].setText("Stream %s - Bitrate: %s - Buffer: %s filled (%s sec.)" % (self.formatKB(bufferInfo[1]), self.formatKBits(bufferInfo[2]), self.bufferPercent, self.bufferSecondsLeft))

	def getPremiumizeStatus(self, showTitle=False):
		if config.plugins.mediainfo.premiumize.value:
			api_url = "http://api.premiumize.me/pm-api/v1.php?method=accountstatus&params[login]=%s&params[pass]=%s" % (config.plugins.mediainfo.premiumize_user.value, config.plugins.mediainfo.premiumize_pass.value)
			getPage(api_url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getPremiumizeStatusData, showTitle)

	def getPremiumizeStatusData(self, data, showTitle):
		premiumizeStatus = ""
		login = re.findall('"statusmessage":"(.*?)"', data)
		if login:
			if re.match('.*?OK', login[0]):
				print "[MediaInfo] Premiumize.me login = True"
				status = re.findall('"type":"(.*?)"\,"expires":(.*?)\,".*?"trafficleft_gigabytes":(\d+)', data)
				if status:
					(type, expires, left) = status[0]
					zeit = datetime.datetime.fromtimestamp(int(expires)).strftime('%d-%m-%Y %H:%M:%S')
					premiumizeStatus = "Premiumize: %s - Trafficleft: %s GB - Expired: %s" % (type, int(left), zeit)
			else:
				premiumizeStatus = "Premiumize: Login Failed"
				print "[MediaInfo] Premiumize.me login = False."
				config.plugins.mediainfo.premiumize.value = False
				config.plugins.mediainfo.premiumize.save()
				configfile.save()
		else:
			self.title = premiumizeStatus

	def sendLink(self, filename, url):
		self.addJob = downloadTask(self.session, filename, url, "stream", None)
		global joblist
		joblist.append((filename, int(time.time()), "Wait", url, "stream", None, self.addJob))
		self.jobDownload(filename)
		self.backupJobs()

	def sendLinks(self, linklist, downloadName=None):
		self.downloadName = downloadName
		if len(linklist) > 0:
			loadlinks = []
			loadlinks_share_online = []
			loadlinks_upload_net = []
			loadlinks_zippyshare = []
			for url in linklist:
				if re.search('ul.to', url):
					if re.search('ul.to/.*?/', url, re.S|re.I):
						id = re.findall('ul.to/(.*?)/', url, re.S|re.I)
					elif re.search('ul.to/.*?', url, re.S|re.I):
						id = re.findall('ul.to/(.*?)$', url, re.S|re.I)
					status_url = 'http://uploaded.net/file/%s/status' % id[0]
					loadlinks_upload_net.append((url, status_url, self.downloadName))

				elif re.search('uploaded.(net|to)', url, re.S|re.I):
					if re.search('uploaded.(net|to)/file/.*?/', url, re.S|re.I):
						id = re.findall('uploaded.*?/file/(.*?)/', url, re.S|re.I)
					elif re.search('uploaded.(net|to)/file/.*?', url, re.S|re.I):
						id = re.findall('uploaded.*?/file/(.*?)$', url, re.S|re.I)
					status_url = 'http://uploaded.net/file/%s/status' % id[0]
					loadlinks_upload_net.append((url, status_url, self.downloadName))

				elif re.search('oboom.com', url, re.S|re.I):
					if re.search('oboom.com/.*?/', url, re.S|re.I):
						if re.search('#', url, re.S|re.I):
							id = re.findall('#(.*?)/', url, re.S|re.I)
						else:
							id = re.findall('oboom.com/(.*?)/', url, re.S|re.I)
						if id:
							status_url = "https://api.oboom.com/1.0/info?items="+id[0]
							loadlinks.append((url, status_url, self.downloadName))
					else:
						if re.search('#', url, re.S|re.I):
							id = re.findall('#(.*?)$', url, re.S|re.I)
						else:
							id = re.findall('oboom.com/(.*?)$', url, re.S|re.I)
						if id:
							status_url = "https://api.oboom.com/1.0/info?items="+id[0]
							loadlinks.append((url, status_url, self.downloadName))
				elif re.search('firedrive.com/file', url, re.S|re.I):
					loadlinks.append((url, status_url, self.downloadName))

				elif re.search('share-online.biz/dl/', url, re.S|re.I):
					if re.search('share-online.biz/dl/.*?/', url, re.S|re.I):
						id = re.findall('share-online.biz/dl/(.*?)/', url, re.S|re.I)
					else:
						id = re.findall('share-online.biz/dl/(.*?)$', url, re.S|re.I)
					if id:
						post_data = urllib.urlencode({'links': id[0]})
						loadlinks_share_online.append((url, id[0], "http://api.share-online.biz/linkcheck.php", post_data, self.downloadName))

				elif re.search('zippyshare.com', url, re.S|re.I):
					loadlinks_zippyshare.append((url, self.downloadName))

			if len(loadlinks) > 0:
				ds = defer.DeferredSemaphore(tokens=1)
				downloads = [ds.run(self.download, status_url).addCallback(self.getStatusInfo, url, downloadName).addErrback(self.downloadError) for url, status_url, downloadName in loadlinks]
				finished = defer.DeferredList(downloads).addErrback(self.dataError)
			elif len(loadlinks_share_online) > 0:
				ds = defer.DeferredSemaphore(tokens=1)
				downloads = [ds.run(self.download_share_online, post_url, post_data).addCallback(self.getStatusInfo_share_online, id, downloadName).addErrback(self.downloadError) for url, id, post_url, post_data, downloadName in loadlinks_share_online]
				finished = defer.DeferredList(downloads).addErrback(self.dataError)
			elif len(loadlinks_upload_net) > 0:
				ds = defer.DeferredSemaphore(tokens=2)
				downloads = [ds.run(self.download, status_url).addCallback(self.getStatusInfo_uploaded_net, url, downloadName).addErrback(self.downloadError) for url, status_url, downloadName in loadlinks_upload_net]
				finished = defer.DeferredList(downloads).addErrback(self.dataError)
			elif len(loadlinks_zippyshare) > 0:
				ds = defer.DeferredSemaphore(tokens=2)
				downloads = [ds.run(self.download, url).addCallback(self.getStatusInfo_zippyshare, url, downloadName).addErrback(self.downloadError) for url, downloadName in loadlinks_zippyshare]
				finished = defer.DeferredList(downloads).addErrback(self.dataError)

	def download(self, url):
		return getPage(url)

	def download_share_online(self, post_url, post_data):
		return getPage(post_url, method='POST', postdata=post_data)

	def downloadError(self, error):
		print error

	def getStatusInfo_zippyshare(self, data, url, downloadName):
		#filename = re.findall('>Name:</font>.*?<font style=".*?">(.*?)</font>', data, re.S|re.I)4
		filename = re.findall('\(\'dlbutton\'\).*?/.*?/.*?/.*?/(.*?\.rar)"', data, re.I)
		size = re.findall('>Size:</font>.*?<font style=".*?">(.*?)\s.*?</font>', data, re.S|re.I)
		if filename and size:
			print filename, size
			self.addJob = downloadTask(self.session, filename[0], url, "zippyshare", downloadName)
			global joblist
			joblist.append((filename[0], int(time.time()), "Wait", url, "zippyshare", downloadName, self.addJob))
			self.jobDownload(filename[0])

	def getStatusInfo_uploaded_net(self, data, url, downloadName):
		filename = re.findall('([a-zA-z0-9_.-]+\.rar)', data)
		if filename:
			self.addJob = downloadTask(self.session, filename[0], url, "uploaded", downloadName)
			global joblist
			joblist.append((filename[0], int(time.time()), "Wait", url, "uploaded", downloadName, self.addJob))
			if config.plugins.mediainfo.uploaded.value:
				self.jobDownload(filename[0])

	def getStatusInfo(self, data, url, downloadName):
		if re.search('firedrive.com', data):
			filename = re.findall('<b>Name:</b>.(.*?).<br>', data)
		else:
			filename = re.findall('([a-zA-z0-9_.-]+\.rar)', data)
		if filename:
			self.addJob = downloadTask(self.session, filename[0], url, "premiumize", downloadName)
			global joblist
			joblist.append((filename[0], int(time.time()), "Wait", url, "premiumize", downloadName, self.addJob))
			if config.plugins.mediainfo.premiumize.value:
				self.jobDownload(filename[0])

	def getStatusInfo_share_online(self, data, id, downloadName):
		if re.search(';OK;', data):
			filename = re.findall(';OK;(.*?);', data)
			if filename:
				self.addJob = downloadTask(self.session, filename[0], id, "share-online", downloadName)
				global joblist
				joblist.append((filename[0], int(time.time()), "Wait", id, "share-online", downloadName, self.addJob))
				if config.plugins.mediainfo.share_online.value:
					self.jobDownload(filename[0])

	def jobStart(self):
		service = self.session.nav.getCurrentService()
		filename = service.info().getName()
		url = self.session.nav.getCurrentlyPlayingServiceReference().getPath()
		filename = ''.join(re.split(r'[.;:!&?,]', filename))
		quessFileType = os.path.splitext(url)[1][1:]
		if re.search('(\.avi|\.mp4|\.ts|\.mp3|\.mpg|\.mpeg|\.mkv)', quessFileType, re.I):
			filetype = quessFileType
		else:
			filetype = ".mp4"
		filename = "%s%s" % (filename.replace(' ','_'), filetype)

		if not any(filename in job for job in joblist):
			if re.match('.*?http', url, re.S) and not re.match('.*?m3u8', url, re.S):
				try:
					req = urllib2.Request(url, headers={'Content-Type':'application/x-www-form-urlencoded', 'User-agent':'Mozilla/5.0 (Windows NT 6.1; rv:32.0) Gecko/20100101 Firefox/32.0'})
					res = urllib2.urlopen(req)
					url = res.geturl()
					print url
					print "[Download] added: %s - %s" % (filename, url)
					self.addJob = downloadTask(self.session, filename, url, "stream", None)
					global joblist
					joblist.append((filename, int(time.time()), "Wait", url, "stream", None, self.addJob))
					self.jobDownload(filename)
					self.backupJobs()
				except urllib2.HTTPError, error:
					print error
					message = self.session.open(MessageBox, ("Error: %s" % error), MessageBox.TYPE_INFO, timeout=3)
				except urllib2.URLError, error:
					print error.reason
					message = self.session.open(MessageBox, ("Error: %s" % error.reason), MessageBox.TYPE_INFO, timeout=3)
			else:
				message = self.session.open(MessageBox, ("No rtmp/m3u8 download support, only http protocol."), MessageBox.TYPE_INFO, timeout=3)
		else:
			print "[MediaInfo] dupe: %s" % filename

	def showJobs(self):
		self.taskList = []
		global joblist
		showDownload = 0
		showWait = 0
		showComplete = 0
		showError = 0
		self.dllist = []
		self.waitlist = []
		self.completelist = []
		self.errorlist = []
		for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
			if status == "Download":
				showDownload += 1
				(recvbytes, totalbytes, progress) = job.current_progress()
				currentSizeMB = int(recvbytes/1024/1024)
				totalMB = int(totalbytes/1024/1024)
				dlspeed = self.calcDnSpeed(int(starttime), currentSizeMB, totalMB)
				self.dllist.append((filename, status, progress, dlspeed, currentSizeMB, totalMB))
			elif status == "Wait":
				showWait += 1
				self.waitlist.append((filename, status, 0, 0, 0, 0))
			elif status == "Complete":
				showComplete += 1
				self.completelist.append((filename, status, 0, 0, 0, 0))
			elif status == "Error":
				showError += 1
				self.errorlist.append((filename, status, 0, 0, 0, 0))
		info = "Downloads: %s / %s (%s) - Wait: %s - Complete: %s - Error: %s" % (str(showDownload), str(len(joblist)), str(config.plugins.mediainfo.dllimit.value), str(showWait), str(showComplete), str(showError))
		self["head"].setText(info)
		self.taskList = self.dllist + self.waitlist + self.completelist + self.errorlist
		self.channelMenuList.setList(map(ListEntry, self.taskList))

	def calcDnSpeed(self, starttime, currentSizeMB, totalMB):
		endtime = int(time.time())
		runtime = endtime - int(starttime)
		if runtime == 0:
			runtime = 1
		if currentSizeMB == 0:
			currentSizeMB = 1
		dlspeed = (currentSizeMB * 1024) / runtime
		resttime = (((int(totalMB) - currentSizeMB) * 1024) / (currentSizeMB * 1024)) * runtime
		if dlspeed > 1024:
			dlspeed = "%.2f mb/s" % (float(dlspeed) / 1024)
		else:
			dlspeed = "%s kb/s" % dlspeed
		return dlspeed

	### job changes
	def jobCheck(self):
		exist = self['downloadList'].getCurrent()
		if exist == None:
			return
		filename = self['downloadList'].getCurrent()[0][0]
		status = self['downloadList'].getCurrent()[0][1]
		if status == "Download":
			self.jobStop(filename, False)
		else:
			self.jobDownload(filename)

	def jobDownload(self, change_filename):
		#joblist_tmp = []
		global joblist
		for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
			if filename == change_filename:
				if config.plugins.mediainfo.premiumize.value and hoster == "premiumize":
					job.startWithPremiumize(filename)
				elif config.plugins.mediainfo.share_online.value and hoster == "share-online":
					job.startWithPremiumize(filename)
				elif config.plugins.mediainfo.uploaded.value and hoster == "uploaded":
					job.startWithPremiumize(filename)
				elif hoster == "zippyshare":
					job.startWithPremiumize(filename)
				elif hoster == "stream":
					if job.start(filename):
						job.markJobAsDownload(filename)
		self.showJobs()

	def jobStop(self, change_filename, remove=False):
		joblist_tmp = []
		global joblist
		for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
			if filename == change_filename:
				job.stop()
				if not remove:
					joblist_tmp.append((filename, starttime, "Wait", url, hoster, downloadName, job))
			else:
				joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
		joblist = joblist_tmp
		self.showJobs()

	def jobRemove(self):
		exist = self['downloadList'].getCurrent()
		if exist == None:
			return
		check_filename = self['downloadList'].getCurrent()[0][0]
		check_status = self['downloadList'].getCurrent()[0][1]
		if check_status == "Download":
			self.jobStop(check_filename, True)
			self.showJobs()
		elif check_status == "Wait" or "Complete" or "Error":
			joblist_tmp = []
			global joblist
			rarname = self.getRarName(check_filename)
			if rarname is not None:
				for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
					if not re.search(rarname, filename, re.I):
						joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
				joblist = joblist_tmp
			else:
				for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
					if not filename == check_filename:
						joblist_tmp.append((filename, starttime, status, url, hoster, downloadName, job))
				joblist = joblist_tmp
			self.showJobs()
			self.backupJobs()

	def backupJobs(self):
		global downloadsfile
		if len(joblist) > 0:
			if fileExists(downloadsfile):
				download_file = open(downloadsfile, "w")
				for (filename, starttime, status, url, hoster, downloadName, job) in joblist:
					download_file.write('"%s" "%s" "%s" "%s" "%s"\n' % (filename, status, url, hoster, downloadName))
				download_file.close()
		else:
			download_file = open(downloadsfile, "w").close()

	def getRarName(self, filename):
		if re.search('part(\S+).rar', filename, re.I):
			rarname =  re.compile(".part", re.I).split(filename)
			return rarname[0]
		else:
			return None

	### formats
	def formatKBits(self, value, ending="Bit/s", roundNumbers=2):
		bits = value * 8
		if bits > (1024*1024):
			return str(round(float(bits)/float(1024*1024),roundNumbers))+" M"+ending
		if bits > 1024:
			return str(round(float(bits)/float(1024),roundNumbers))+" K"+ending
		else:
			return str(bits)+" "+ending

	def formatKB(self, value, ending="B", roundNumbers=2):
		byte = value
		if byte > (1024*1024):
			return str(round(float(byte)/float(1024*1024),roundNumbers))+" M"+ending
		if byte > 1024:
			return str(round(float(byte)/float(1024),roundNumbers))+" K"+ending
		else:
			return str(byte)+" "+ending

	def dataError(self, error):
		print error

	### Keys
	def mediaInfoSetup(self):
		self.session.openWithCallback(self.mediaInfoSetupCallback, mediaInfoConfigScreen)

	def mediaInfoSetupCallback(self):
		pass
		#if self.livestreaming:
		#	self.getPremiumizeStatus(True)
		#else:
		#	self.getPremiumizeStatus(False)

	def keyLeft(self):
		self['downloadList'].pageUp()
		self.getTitle()

	def keyRight(self):
		self['downloadList'].pageDown()
		self.getTitle()

	def keyUp(self):
		self['downloadList'].up()
		self.getTitle()

	def keyDown(self):
		self['downloadList'].down()
		self.getTitle()

	def exit(self):
		already_open = False
		self.close()

def openMoviePlayerEventView(self):
	already_open = False
	if True and not already_open:
		already_open = True
		service = self.session.nav.getCurrentService()
		filename = service.info().getName()
		url = self.session.nav.getCurrentlyPlayingServiceReference().getPath()
		if re.match('.*?http://', url, re.S):
			self.session.open(mediaInfo, True)
		else:
			MoviePlayer.originalOpenEventView(self)
	else:
		MoviePlayer.originalOpenEventView(self)

MoviePlayer.openEventView = openMoviePlayerEventView

def autostart(reason, **kwargs):
	global downloadsfile
	if (reason == 0) and (kwargs.has_key("session")):
		session = kwargs["session"]
		session = session
		global joblist
		print "[MediaInfo] READ OLD JOBS !!!"
		if fileExists(downloadsfile):
			dlfile = open(downloadsfile, "r")
			for rawData in dlfile.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(filename, status, url, hoster, downloadName) = data[0]
					addJob = downloadTask(session, filename, url, hoster, downloadName)
					if status == "Download":
						joblist.append((filename, int(time.time()), "Wait", url, hoster, downloadName, addJob))
					elif status == "Error":
						joblist.append((filename, int(time.time()), "Wait", url, hoster, downloadName, addJob))
					else:
						joblist.append((filename, int(time.time()), status, url, hoster, downloadName, addJob))
		else:
			dlfile = open(downloadsfile, "w").close()

def main(session, **kwargs):
	session.open(mediaInfo, False)

def Plugins(**kwargs):
	return [PluginDescriptor(name="MediaInfo", description="Download the Stream", where = [PluginDescriptor.WHERE_PLUGINMENU], icon="plugin.png", fnc=main),
			PluginDescriptor(where=[PluginDescriptor.WHERE_SESSIONSTART], fnc=autostart)]