import xbmc
import threading
from pulsar.logger import log
from pulsar.rpc import server_thread
from pulsar.monitor import PulsarMonitor
from pulsar.daemon import pulsard_thread


def run():
    # Make sure the XBMC jsonrpc server is started.
    xbmc.startServer(xbmc.SERVER_JSONRPCSERVER, True)

    # Make the monitor
    monitor = PulsarMonitor()

    threads = [
        threading.Thread(target=server_thread),  # JSONRPC thread
        threading.Thread(target=pulsard_thread, args=[monitor]),  # Pulsard thread
    ]
    for t in threads:
        t.daemon = True
        t.start()

    # XBMC loop
    while not xbmc.abortRequested:
        xbmc.sleep(1000)

    log.info("pulsar: exiting pulsard")
