import os
import sys
import urllib2
import xbmc
import xbmcgui
import xbmcplugin
import socket
from pulsar.config import PULSARD_HOST
from pulsar.addon import ADDON, ADDON_ID
from pulsar.util import notify, GetLocalizedString

try:
    import simplejson as json
except ImportError:
    import json


HANDLE = int(sys.argv[1])


class closing(object):
    def __init__(self, thing):
        self.thing = thing

    def __enter__(self):
        return self.thing

    def __exit__(self, *exc_info):
        self.thing.close()


class NoRedirectHandler(urllib2.HTTPRedirectHandler):
    def http_error_302(self, req, fp, code, msg, headers):
        import urllib
        infourl = urllib.addinfourl(fp, headers, headers["Location"])
        infourl.status = code
        infourl.code = code
        return infourl
    http_error_300 = http_error_302
    http_error_301 = http_error_302
    http_error_303 = http_error_302
    http_error_307 = http_error_302


def _json(url):
    with closing(urllib2.urlopen(url)) as response:
        if response.code >= 300 and response.code <= 307:
            item = xbmcgui.ListItem(
                path=response.geturl(),
                label=xbmc.getInfoLabel("ListItem.Label"),
                label2=xbmc.getInfoLabel("ListItem.label2"),
                thumbnailImage=xbmc.getInfoLabel("ListItem.Art(thumb)"))
            _infoLabels = {
                "Title": xbmc.getInfoLabel("ListItem.Title"),
                "OriginalTitle": xbmc.getInfoLabel("ListItem.OriginalTitle"),
                "TVShowTitle": xbmc.getInfoLabel("ListItem.TVShowTitle"),
                "Season": xbmc.getInfoLabel("ListItem.Season"),
                "Episode": xbmc.getInfoLabel("ListItem.Episode"),
                # "Date": xbmc.getInfoLabel("ListItem.Date"),
                "VideoCodec": xbmc.getInfoLabel("ListItem.VideoCodec"),
                "VideoResolution": xbmc.getInfoLabel("ListItem.VideoResolution"),
                "VideoAspect": xbmc.getInfoLabel("ListItem.VideoAspect"),
                "DBID": xbmc.getInfoLabel("ListItem.DBID"),
                "DBTYPE": xbmc.getInfoLabel("ListItem.DBTYPE"),
            }
            infoLabels = {}
            for key, value in _infoLabels.iteritems():
                if value:
                    infoLabels[key] = value

            item.setInfo(type='Video', infoLabels=infoLabels)
            xbmcplugin.setResolvedUrl(HANDLE, True, item)
            return

        payload = response.read()

        if payload:
            return json.loads(payload)


def run(url_suffix=""):
    if not os.path.exists(os.path.join(xbmc.translatePath(ADDON.getAddonInfo("path")), ".firstrun")):
        notify(ADDON.getLocalizedString(30101).encode('utf-8'))
        return

    socket.setdefaulttimeout(300)
    urllib2.install_opener(urllib2.build_opener(NoRedirectHandler()))

    url = sys.argv[0].replace("plugin://%s" % ADDON_ID, PULSARD_HOST + url_suffix) + sys.argv[2]
    xbmc.log(url)

    try:
        data = _json(url)
    except:
        return

    if not data:
        return

    if data["content_type"]:
        xbmcplugin.addSortMethod(HANDLE, xbmcplugin.SORT_METHOD_UNSORTED)
        xbmcplugin.addSortMethod(HANDLE, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE)
        xbmcplugin.addSortMethod(HANDLE, xbmcplugin.SORT_METHOD_DATE)
        xbmcplugin.addSortMethod(HANDLE, xbmcplugin.SORT_METHOD_GENRE)
        xbmcplugin.setContent(HANDLE, data["content_type"])

    listitems = range(len(data["items"]))
    for i, item in enumerate(data["items"]):
        # Translate labels
        if item["label"][0:8] == "LOCALIZE":
            item["label"] = GetLocalizedString(item["label"])
        if item["label2"][0:8] == "LOCALIZE":
            item["label2"] = GetLocalizedString(item["label2"])

        listItem = xbmcgui.ListItem(label=item["label"], label2=item["label2"], iconImage=item["icon"], thumbnailImage=item["thumbnail"])
        if item.get("info"):
            listItem.setInfo("video", item["info"])
        if item.get("stream_info"):
            for type_, values in item["stream_info"].items():
                listItem.addStreamInfo(type_, values)
        if item.get("art"):
            listItem.setArt(item["art"])
        if item.get("context_menu"):
            # Translate context menus
            for m, menu in enumerate(item["context_menu"]):
                if menu[0][0:8] == "LOCALIZE":
                    menu[0] = GetLocalizedString(menu[0])
            listItem.addContextMenuItems(item["context_menu"])
        listItem.setProperty("isPlayable", item["is_playable"] and "true" or "false")
        if item.get("properties"):
            for k, v in item["properties"].items():
                listItem.setProperty(k, v)
        listitems[i] = (item["path"], listItem, not item["is_playable"])

    xbmcplugin.addDirectoryItems(HANDLE, listitems, totalItems=len(listitems))
    xbmcplugin.endOfDirectory(HANDLE, succeeded=True, updateListing=False, cacheToDisc=True)
