# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Player Wrapper
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import logger, config
import xbmc

if config.use_mysql:
    from mysqlinterface import sql_manager as sql
else:
    from sql import sql_manager as sql


class traktPlayer(xbmc.Player):
    _playing = False
    _season = "0"
    _episode = "0"
    _showtitle = ""

    def __init__(self, *args, **kwargs):
        xbmc.Player.__init__(self, *args, **kwargs)
        logger.debug("Player initalized.")

    def play(self, *args, **kwargs):
        logger.info("Player started.")
        xbmc.Player.play(self, *args, **kwargs)
        while self.isPlaying():
            xbmc.sleep(1000)
        logger.info("Player ended.")

    # called when kodi starts playing a file
    def onPlayBackStarted(self):
        logger.debug("onPlayBackStarted() - %s" % self.isPlayingVideo())

        # only do anything if we're playing a video
        if self.isPlayingVideo():
            self._season = xbmc.getInfoLabel('VideoPlayer.Season')
            self._episode = xbmc.getInfoLabel('VideoPlayer.Episode')
            self._showtitle = xbmc.getInfoLabel('VideoPlayer.TVShowTitle')
            if self._season and self._episode and self._showtitle:
                logger.debug("Playing %s: s%sx%s" % (self._showtitle, str(self._season), str(self._episode)))
                self._playing = True

    # called when kodi stops playing a file
    def onPlayBackEnded(self):
        logger.debug("onPlayBackEnded() - %s" % self.isPlayingVideo())
        if self._playing:
            logger.debug("Updating local trakt DB for %s: s%sx%s" % (self._showtitle, str(self._season), str(self._episode)))
            s = sql.SqlManager()
            s.add_single_trakt(self._showtitle, int(self._season), int(self._episode))
            del s

            self._playing = False

    # called when user stops kodi playing a file
    def onPlayBackStopped(self):
        logger.debug("onPlayBackStopped() - %s" % self.isPlayingVideo())
        if self._playing:
            self._playing = False

    # called when user pauses a playing file
    def onPlayBackPaused(self):
        logger.debug("onPlayBackPaused() - %s" % self.isPlayingVideo())

    # called when user resumes a paused file
    def onPlayBackResumed(self):
        logger.debug("onPlayBackResumed() - %s" % self.isPlayingVideo())

    # called when user queues the next item
    def onQueueNextItem(self):
        logger.debug("onQueueNextItem() - %s" % self.isPlayingVideo())

    # called when players speed changes. (eg. user FF/RW)
    def onPlayBackSpeedChanged(self, speed):
        logger.debug("onPlayBackSpeedChanged(speed: %s) - %s" % (str(speed), self.isPlayingVideo()))

    # called when user seeks to a time
    def onPlayBackSeek(self, time, offset):
        logger.debug("onPlayBackSeek(time: %s, offset: %s) - %s" % (str(time), str(offset), self.isPlayingVideo()))

    # called when user performs a chapter seek
    def onPlayBackSeekChapter(self, chapter):
        logger.debug("onPlayBackSeekChapter(chapter: %s) - %s" % (str(chapter), self.isPlayingVideo()))

