# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# RAPIDVIDEO server connector
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import re

from core import scrapertools, common as c
from xbmcutils import logger
from util import unpackerjs

SERVER_NAME = "[RapidVideo]"
SERVER_ID = "rapidvideo"


def find_videos(data):
    logger.debug("start...")

    found = set()
    found.add("http://www.rapidvideo.org/embed-theme.html")
    found.add("http://www.rapidvideo.org/embed-jquery.html")
    found.add("http://www.rapidvideo.org/embed-s.html")
    found.add("http://www.rapidvideo.org/embed-images.html")
    found.add("http://www.rapidvideo.org/embed-faq.html")
    found.add("http://www.rapidvideo.org/embed-embed.html")
    found.add("http://www.rapidvideo.org/embed-ri.html")
    found.add("http://www.rapidvideo.org/embed-d.html")
    found.add("http://www.rapidvideo.org/embed-css.html")
    found.add("http://www.rapidvideo.org/embed-js.html")
    found.add("http://www.rapidvideo.org/embed-player.html")
    found.add("http://www.rapidvideo.org/embed-cgi.html")

    url_list = []

    patron = "rapidvideo.org/([a-z0-9A-Z]+)"
    matches = re.compile(patron, re.DOTALL).findall(data)
    for match in matches:
        url = "http://www.rapidvideo.org/embed-%s.html" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    patron = "rapidvideo.org/embed-([a-z0-9A-Z]+)"
    matches = re.compile(patron,re.DOTALL).findall(data)
    for match in matches:
        url = "http://www.rapidvideo.org/embed-%s.html" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    logger.debug("end...")
    return url_list


def get_video_url(page_url):
    logger.debug("start...")
    video_urls = []

    try:
        try:
            if not page_url.startswith("http://www.rapidvideo.org/embed-"):
                video_id = c.get_match(page_url, "rapidvideo.org/([a-z0-9A-Z]+)")
                page_url = "http://www.rapidvideo.org/embed-"+video_id+".html"
        except:
            logger.error("Video not found")

        data = scrapertools.cache_page(page_url)
        try:
            packed = c.get_match(data,"(<script type='text/javascript'>eval\(function\(p,a,c,k,e,d\).*?</script>)")
        except:
            packed = c.get_match(data,"(function\(p, a, c, k, e, d\).*?</script>)")
            packed = "<script type='text/javascript'>eval("+packed

        unpacked = unpackerjs.unpack_js(packed)

        patron = 'setup\(\{file:"([^"]+)"'
        location = c.find_single_match(unpacked,patron)

        video_urls.append([scrapertools.get_filename_from_url(location)[-4:], location])

    except:
        logger.error("Probably video [%s] has been removed." % page_url)

    logger.debug("end...")
    return video_urls
