# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# Plugin command dispatcher
# http://smystero.dlinkddns.org/smytvshow/
#------------------------------------------------------------

import runner
from core.param import Param
from xbmcutils import config, logger

def dispatch():
    logger.debug("start...")

    caller_item = get_params()

    target_type = caller_item.item_info["target_type"]
    target = caller_item.item_info["target"]
    action = caller_item.item_info["action"]

    logger.info("target_type = [%s] target = [%s] action = [%s]" % (target_type, target, action))

    if action.endswith("_run"):
        import pushers.p_util.utils as utils
        utils.route_call(action, caller_item)
    else:
        runner.run_action(target_type, target, action, caller_item)

    logger.debug("end...")
    return


def get_params():
    return Param(config.get_args()).get_caller_item()


