# coding: utf-8
"""
    This file is part of Plugin KodiDirect by pcd@xtrend-alliance.com
    Copyright (C) 2014

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
############### v8.0 ##################
from enigma import eConsoleAppContainer,gPixmapPtr
from Plugins.Extensions.KodiDirect.lib.Utils import *
from Components.config import config, ConfigSubsection, ConfigSelection, ConfigText, ConfigYesNo
from Components.config import NoSave
from Components.ConfigList import ConfigListScreen
from Screens.MessageBox import MessageBox
import os
from os import path, system

from Components.Task import Task, Job, job_manager as JobManager, Condition
from Screens.TaskView import JobView
from Screens.Console import Console
from Components.Button import Button
from Tools.Directories import fileExists, copyfile
from Tools.LoadPixmap import LoadPixmap
######################
import xml.etree.cElementTree 
import gettext
from Components.Sources.StaticText import StaticText
from Components.Pixmap import Pixmap, MovingPixmap
from Components.Sources.List import List
from enigma import eTimer
from Plugins.Extensions.KodiDirect.lib.SkinLoader import loadPluginSkin
from GlobalActions import globalActionMap #mfaraj2608 needed for today changes
from keymapparser import readKeymap, removeKeymap #mfaraj2608 needed for today changes
##########################to avoid conflict with similar plugins
#import xpath
#import xbmcaddon, xbmcgui
import re
import datetime,time
##########################
from Screens.Standby import TryQuitMainloop
from Screens.InputBox import PinInput

#from Screens.VirtualKeyBoard import VirtualKeyBoard
from Plugins.Extensions.KodiDirect.lib.VirtualKeyBoard import VirtualKeyBoard
from Plugins.Extensions.KodiDirect.lib.Spinner import Spinner
##########################
import gettext
def _(txt):
	t = gettext.dgettext("KodiDirect", txt)
	if t == txt:
		pass#print "[KodiDirectA] fallback to default translation for", txt
		t = gettext.gettext(txt)
	return t

##########################
##########################
from glob import glob
import sys
from os.path import join, basename
##########################

try:
       import Image
except:
    try: 
       from PIL import Image
    except:
       try:
             os.system("opkg install python-image")
       except:
             os.system("dpkg --install '/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/python-imaging_1.1.7-r5.8_mipsel.deb'") 
             
select_file="/tmp/select.txt"
THISPLUG = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect"
THISADDON = ""
HANDLE = 1
NEWDEFPY = ""
ARG = " "
DEBUG = 0
SELECT = []
newstext = " "
date = " "
NewUpdate = " "
PICPOS = []

#HOST = "http://mirrors.kodi.tv/addons/jarvis/"
#HOST = "https://github.com/hadynz/repository.arabic.xbmc-addons/tree/master/repo"
HOST = ""
HOST1 = "http://mirrors.kodi.tv/addons/jarvis/"
        
def dellog():###to clear log files

   import os
   if os.path.exists("/tmp/e.log"):
      os.remove("/tmp/e.log")
   if os.path.exists("/tmp/xbmc_log"):
      os.remove("/tmp/xbmc_log")
   if os.path.exists("/tmp/KodiDirect_log"):
      os.remove("/tmp/KodiDirect_log")      
      
   if os.path.exists("/tmp/KodiDirect_error"):
      os.remove("/tmp/KodiDirect_error")
    
   if os.path.exists("/tmp/data.txt"):
      os.remove("/tmp/data.txt")  
   if os.path.exists("/tmp/vidinfo.txt"):
      os.remove("/tmp/vidinfo.txt")       
   if os.path.exists("/tmp/vidinfo.txt"):
      os.remove("/tmp/type.txt") 
          
def jointext(file1, file2):
                  f1=open(file1,"r+")
                  txt1 = f1.read()
                  f2=open(file2,"r")
                  txt2 = f2.read()
                  txt = txt1 + txt2
                  f1.write(txt)
                  f1.close()
                  f2.close()
                  

def parameters_string_to_dict(parameters):
    paramDict = {}
#    pass#print "Here in parameters =", parameters
    if parameters:
        paramPairs = parameters.split("&")
        for paramsPair in paramPairs:
#            pass#print "Here in paramPairs =", paramPairs
            if not "=" in paramsPair:
                    continue
            paramSplits = paramsPair.split('=')
            if paramSplits[0]=="?url":
               paramSplits[0]='url'
            paramDict[paramSplits[0]] = paramSplits[1]
    return paramDict

def getpics(names, pics, tmpfold, picfold):
              if config.plugins.kodiplug.skinres.value == "fullhd":
                    nw = 300
              else:
                    nw = 200      
              pix = []
              if config.plugins.kodiplug.thumb.value == "False":
                      if config.plugins.kodiplug.skinres.value == "fullhd":
                                defpic = THISPLUG + "/skin/images/defaultL.png" 
                      else:       
                                defpic = THISPLUG + "/skin/images/default.png"    
                      npic = len(pics)
                      i = 0
                      while i < npic:
                             pix.append(defpic)
                             i = i+1
                      return pix
              cmd = "rm " + tmpfold + "/*"
              os.system(cmd)
              npic = len(pics)
              j = 0
              pass#print "In getpics names =", names
              while j < npic:
                   name = names[j]
                   pass#print "In getpics name =", name
                   if name is None:
                          name = "Video"
                   try:
                          name = name.replace("&", "")
                          name = name.replace(":", "")
                   except:
                          pass       
                   url = pics[j]
                   if url is None:
                          url = " "
                   if ".png" in url:
                          tpicf = tmpfold + "/" + name + ".png"
#                          picf = picfold + "/" + name + ".png"
                   else:       
                          tpicf = tmpfold + "/" + name + ".jpg"
#                          picf = picfold + "/" + name + ".jpg"
                   picf = picfold + "/" + name + ".png"       
                   if fileExists(picf):
                          cmd = "cp " + picf + " " + tmpfold
                          os.system(cmd)
                   
                   if not fileExists(picf):
                       if THISPLUG in url:
                          try:
                                  cmd = "cp " + url + " " + tpicf
                                  os.system(cmd)
                          except:
                                  pass
                       else:
#                          try:
                                  if url.startswith("https"):
                                         url = url.replace("https", "http")
                                  cmd = "wget -O '" + tpicf +"' -c '" + url + "'"
                                  os.system(cmd)
                                  """
                          except:
                                  if ".png" in tpicf:
                                          cmd = "cp " + THISPLUG + "/skin/images/default.png " + tpicf
                                  else:
                                          cmd = "cp " + THISPLUG + "/skin/images/default.jpg " + tpicf
                                  os.system(cmd)
                                  """        
                       if not fileExists(tpicf): 
                                  if ".png" in tpicf:
                                          cmd = "cp " + THISPLUG + "/skin/images/default.png " + tpicf
                                  else:
                                          cmd = "cp " + THISPLUG + "/skin/images/default.jpg " + tpicf
                                  os.system(cmd)

                       try:
                          try:
                                import Image
                          except:
                                from PIL import Image
                          im = Image.open(tpicf)
                          imode = im.mode
                          if im.mode != "P":
                                 im = im.convert("P")
                          w = im.size[0]
                          d = im.size[1]
                          r = float(d)/float(w)
                          d1 = r*nw
                          if w != nw:        
                                 x = int(nw)

                                 y = int(d1)
                                 im = im.resize((x,y), Image.ANTIALIAS)
                          tpicf = tmpfold + "/" + name + ".png"
                          picf = picfold + "/" + name + ".png"
                          im.save(tpicf)

                       except:

                          tpicf = THISPLUG + "/skin/images/default.png" 
                          
                   pix.append(j)
                   pix[j] = picf
                   j = j+1       
              cmd1 = "cp " + tmpfold + "/* " + picfold + " && rm " + tmpfold + "/* &"
              os.system(cmd1)
              return pix
                  
             
def up(names, tmppics, pos, menu, pixmap):
                menu.up()
                pos = pos - 1
                num = len(names)
                if pos == -1:
                              pos = num - 1
                              menu.moveToIndex(pos)  
                name = names[pos]
                if name == "Exit":
                         if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitLL.png" 
                         else:       
                                pic1 = THISPLUG + "/skin/images/ExitL.png"     
                         pixmap.instance.setPixmapFromFile(pic1)
                else:
                        try: 
                         pic1 = tmppics[pos]
                         pixmap.instance.setPixmapFromFile(pic1)
                        except:
                         pass 
                return pos
                
def down(names, tmppics, pos, menu, pixmap):
                menu.down()
                pos = pos + 1
                num = len(names)
                if pos == num:
                              pos = 0
                              menu.moveToIndex(pos) 
                name = names[pos]
                if name == "Exit":
                         if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitLL.png" 
                         else:       
                                pic1 = THISPLUG + "/skin/images/ExitL.png"     
                         pixmap.instance.setPixmapFromFile(pic1)
                else:
                        try:
                         pic1 = tmppics[pos]
                         pixmap.instance.setPixmapFromFile(pic1)
                        except:
                         pass 
                return pos
                      
def left(names, tmppics, pos, menu, pixmap):
         menu.pageUp()
         pos = menu.getSelectionIndex()
         name = names[pos]
         
         if name != "Exit":
                pic1 = tmppics[pos]
                pixmap.instance.setPixmapFromFile(pic1)

         else:      
                try:
                         if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitLL.png" 
                         else:       
                                pic1 = THISPLUG + "/skin/images/ExitL.png"     
                         pixmap.instance.setPixmapFromFile(pic1) 
                except:
                  pass       
         return pos
         
def right(names, tmppics, pos, menu, pixmap):
         menu.pageDown()
         pos = menu.getSelectionIndex()
         name = names[pos]
         if name != "Exit":
                pic1 = tmppics[pos]
                pixmap.instance.setPixmapFromFile(pic1)
         else:      
                try:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitLL.png" 
                       else:       
                                pic1 = THISPLUG + "/skin/images/ExitL.png"     
                       pixmap.instance.setPixmapFromFile(pic1)
                except:
                       pass                       
         return pos                  
                
config.plugins.kodiplug = ConfigSubsection()
config.plugins.kodiplug.tempdel = ConfigYesNo(True)
config.plugins.kodiplug.picdel = ConfigYesNo(False)
config.plugins.kodiplug.cachefold = ConfigText("/media/hdd", False)
config.plugins.kodiplug.mmenu = ConfigYesNo(True)
#config.plugins.kodiplug.debug = ConfigYesNo(False)
config.plugins.kodiplug.thumb = ConfigSelection(default = "False", choices = [("True", _("yes")),("False", _("no")), ("Single", _("single"))])   
config.plugins.kodiplug.backup = ConfigYesNo(False)
config.plugins.kodiplug.directpl = ConfigYesNo(False)
config.plugins.kodiplug.textcol = ConfigSelection(default = "0xffffff", choices = [("0xffffff", _("white")), ("0xb3b3b9", _("grey"))])  
config.plugins.kodiplug.textsel = ConfigSelection(default = "0xf07655", choices = [("0xf07655", _("red")),("0xe5b243", _("yellow")), ("0xffffff", _("white"))])   
config.plugins.kodiplug.textfont = ConfigSelection(default = "25", choices = [("25", _("default")), ("35", _("large")), ("22", _("small"))])  
config.plugins.kodiplug.skinres = ConfigSelection(default = "hd", choices = [("fullhd", _("Full-HD 1920x1080")), ("hd", _("HD 1280x720"))])  
config.plugins.kodiplug.wait = ConfigSelection(default = "60", choices = [("60", _("60sec")), ("120", _("120sec")), ("180", _("180sec")), ("240", _("240sec")), ("300", _("300sec"))])  
config.plugins.kodiplug.listcol = ConfigSelection(default = "0x000000", choices = [("0x000000", _("black")), ("0x002d39", _("blue"))])  
config.plugins.kodiplug.mainback = NoSave(ConfigSelection(default = "default", choices = [("default", _("default")), ("skin2", _("skin2"))]))  
config.plugins.kodiplug.viewdownloads = ConfigSelection(default="disabled", choices = [("disabled",_("Not assigned")), ("help",_("Key help"))])
config.plugins.kodiplug.youtubequal = ConfigSelection(default="2", choices = [("1",_("SD")), ("2",_("720p")), ("3",_("1080p"))])

def update_xbmc_text(addon_id):##mfaraj to update the file from xbmc client to be used by xbmc library files
            if addon_id==None:
               return
            try:cachefolder=config.plugins.kodiplug.cachefold.value
            except:cachefolder="/media/hdd"
            afile=open("/etc/xbmc.txt",'w')
            afile.write(cachefolder)
            afile.close()

            
def startspinner():
                cursel = THISPLUG+"/skin/spinner"
    		Bilder = []
		if cursel:
			for i in range(30):
				if (os.path.isfile("%s/wait%d.png"%(cursel,i+1))):
					Bilder.append("%s/wait%d.png"%(cursel,i+1))
		else:
		        Bilder = []
                #self["text"].setText("Press ok to exit")
                return Spinner(Bilder)             
def buildBilder():
                cursel = THISPLUG+"/skin/spinner"
    		Bilder = []
		if cursel:
			for i in range(30):
				if (os.path.isfile("%s/wait%d.png"%(cursel,i+1))):
					Bilder.append("%s/wait%d.png"%(cursel,i+1))
		else:
		        Bilder = []
                #self["text"].setText("Press ok to exit")
                
                return Bilder

class XbmcConfigScreen(ConfigListScreen,Screen):
   	
	def __init__(self, session, args = 0):
		self.session = session
		self.setup_title = _("Plugin Configuration")
		self["title"] = Button(self.setup_title)
		Screen.__init__(self, session)
		self.skinName = "Kodiconfig"

		cfg = config.plugins.kodiplug 
                self.list = [
                        getConfigListEntry(_("Cache folder"), cfg.cachefold),
                        getConfigListEntry(_("Skin resolution-(restart e2 after change)"), cfg.skinres),
                        getConfigListEntry(_("Text font in lists"), cfg.textfont),
                        getConfigListEntry(_("Waiting time for list (sec)"), cfg.wait),
                        getConfigListEntry(_("Stop download at Exit from plugin ?"), cfg.tempdel),
                        getConfigListEntry(_("Delete thumbpics at Exit from plugin ?"), cfg.picdel),
                        getConfigListEntry(_("Show in mainmenu-(restart e2 after change)"), cfg.mmenu),
                        getConfigListEntry(_("View downloads key-(restart e2 after change)"), cfg.viewdownloads), 
#                        getConfigListEntry(_("Debug log ?"), cfg.debug),
                        getConfigListEntry(_("Show thumbpic ?"), cfg.thumb),
                        getConfigListEntry(_("Move addons to cache folder ?"), cfg.backup),
                        getConfigListEntry(_("Play videos direct with no download option ?"), cfg.directpl),

                        getConfigListEntry(_("Text colour in lists"), cfg.textcol),
                        getConfigListEntry(_("Selected-text colour in lists"), cfg.textsel),
                        getConfigListEntry(_("List background colour"), cfg.listcol),
                        getConfigListEntry(_("YouTube video quality"), cfg.youtubequal),
 			]
		ConfigListScreen.__init__(self, self.list, session = self.session, on_change = self.changedEntry)
		self["status"] = Label()
		self["statusbar"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Save"))

		self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.cancel,
			"green": self.save,
			"cancel": self.cancel,
			"ok": self.save,
		}, -2)
		self.onChangedEntry = []
	
	def changedEntry(self):
		for x in self.onChangedEntry:
			x()
               	
	def getCurrentEntry(self):
		return self["config"].getCurrent()[0]
	def getCurrentValue(self):
		return str(self["config"].getCurrent()[1].getText())
	def createSummary(self):
		from Screens.Setup import SetupSummary
		return SetupSummary

	def cancel(self):
		for x in self["config"].list:
			x[1].cancel()
                self.close()


	def save(self):
                self.saveAll()
                picfold = config.plugins.kodiplug.cachefold.value + "/xbmc/pic"
                cmd = "rm -rf " + picfold
                os.system(cmd)


class Rundefault(Screen):
    def __init__(self, session, name, url, nextrun,progressCallBack=None):
                Screen.__init__(self, session)
                self.name = name
                self.session=session
                self.url = url
                self.nextrun = nextrun

                self.onShown.append(self.start)
                self.error=None
                self.data1=''
########################
                self.updateTimer = eTimer()
                try:
                      self.updateTimer_conn = self.updateTimer.timeout.connect(self.updateStatus)
                except AttributeError:
                      self.updateTimer.callback.append(self.updateStatus)
                self.timecount = 0
                ncount = config.plugins.kodiplug.wait.value 
                nc = int(ncount)*1000
                timeint = int(float(nc/120))
#                if timeint < 1000: timeint = 1000
                pass#print "timeint =", timeint
                self.timeint = 1000
                self.nct = int(float(nc/timeint))
                pass#print "self.nct =", self.nct
#		self.updateTimer.start(timeint)
#		self.updateStatus()
########################                
                self.error=''                
                self.progressCallBack=progressCallBack
                self.progress=(_('Please wait...\n'))
                if os.path.exists("/tmp/stopaddon"):
                   os.remove("/tmp/stopaddon")
    def start(self):
                url = self.url
                name = self.name
                if DEBUG == 1:
                       pass#print "In Rundefault name =", name
                       pass#print "In Rundefault url =", url
                       pass#print "In Rundefault self.nextrun =", self.nextrun
#                pass#print "In Rundefault url B=", url       
                if (THISPLUG not in url):
                        desc = " "
                        self.progressCallBack("Finished")
                        self.updateTimer.stop()
                        self.session.open(Playvid, name, url, desc)
                        self.close()
                        
                else:		
########################pictures?###########
                   n1 = url.find("default.py?", 0)
                   urla = url[(n1+11):]
                   pass#print "In Rundefault urla =", urla
                   plugin_id=os.path.split(THISADDON)[1]
                   if ("plugin.image" in plugin_id) or ("plugin.picture" in plugin_id) and ("url=" not in urla) and ("plugin://" not in urla):
                        pass#print "In Rundefault going in picshow"
                        self.picshow(urla)
                   else:
#######################pictures#############
                        global HANDLE
                        hdl = int(HANDLE)
                        hdl = hdl+1
                        HANDLE = str(hdl)
                        n1 = url.find('?', 0)
                        if n1<0:
                                return
                                
                        url1 = url[:n1]
                        url2 = url[n1:]
                        url2 = url2.replace(" ", "%20") 
                        if "plugin://plugin.video.youtube/" in url:
                               url1 = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins/plugin.video.youtube/default.py"
                               url2 = url2.replace("plugin://plugin.video.youtube/?", "path=/root/video&")

#                        url2 = url[n1:]
#                        url2 = url2.replace(" ", "%20")        
                        arg = url1 + " " + HANDLE + " '" + url2 + "'"
                        if DEBUG == 1:
                               pass#print "Rundefault arg =", arg
                        self.arg = arg
                        self.stream()
                        
    def picshow(self, urla):
                xurl = urla
                xdest = "/tmp/picture.png"
	        downloadPage(xurl, xdest).addCallback(self.picture).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def picture(self, fplug):                        
                pic = "/tmp/picture.png"
##                self.session.open(Showpic, pic)
#                self.close()        
                self.session.open(Splash3, pic)        
                        
                   
    def stoprun(self):
                self.close() 
		try:
			
			self.container.appClosed.remove(self.runFinished)
			self.container.dataAvail.remove(self.dataAvail)
                        self.progressCallBack("Finished")    
                except:
                        pass
    
                                         

    def dataAvail(self,rstr):
            if os.path.exists("/tmp/stopaddon"):
                self.stoprun()
                return
            if rstr:
               self.data1=self.data1+rstr
               if self.progressCallBack is not None:
                  self.progress=self.progress+"..."
                  self.progressCallBack(self.progress)
            #if self.progress_callback is not None:
               #self.progress_callback('Please wait..")
    
                                                   
    def stream(self):

                self.picfold = config.plugins.kodiplug.cachefold.value+"/xbmc/pic"
                self.tmpfold = config.plugins.kodiplug.cachefold.value+"/xbmc/tmp"
#                cmd = "rm -rf " + self.tmpfold
#                system(cmd)
                
                if os.path.exists("/tmp/stopaddon"):
                   self.stoprun()
                   return
                
                if DEBUG == 1:
                       pass#print "In rundef self.arg =", self.arg
                cmd = "python " + self.arg
                pass#print "In rundef cmd A=", cmd
#                cmd = cmd.replace("&", "\\&")
#                cmd = cmd.replace("(", "\\(")
#                cmd = cmd.replace(")", "\\)")
                afile = file("/tmp/test.txt","w")       
                afile.write("going in default.py")
                afile.write(cmd)
                fdef = 'default'#NEWDEFPY[:-3]
                args = cmd.split(" ")
                arg1 = args[1]
                arg2 = args[2]
                arg3 = args[3]
                arg4=config.plugins.kodiplug.cachefold.value
                sys.argv = [arg1,arg2, arg3,arg4]                
                self.plugin_id=os.path.split(THISADDON)[1]
#                dellog()
                
                pass#print "539arg3 =",arg3
                if 'select=true' in arg3 :
                      rfile = THISPLUG + "/result.txt"
	              f = open(rfile, "w")
	              line = arg3.replace("'?", "")
	              params=parameters_string_to_dict(line)
	              pass#print "Here in select writing result.txt params =", params
	              url = params.get("url","0")
                      text = url + "\n"
                      pass#print "Here in select writing result.txt text =", text
                      f.write(text)
                      f.close()
        
                      myfile = file(r"/tmp/arg1.txt")       
                      icount = 0
                      for line in myfile.readlines(): 
                            sysarg = line
                            icount = icount+1
                            if icount > 0:
                                 break
                        
                      pass#print "sysarg =", sysarg
                      args = sysarg.split(" ")
#              
                      cmd = "python '" + args[0] +"' '1' '" + args[2] + "'"
                  
                   
                else:
                   
                   xpath_file=THISPLUG+"/plugins/"+self.plugin_id+"/xpath.py"
                   fixed2_file=THISPLUG+"/plugins/"+self.plugin_id+"/fixed2"
                   default_file=THISPLUG+"/plugins/"+self.plugin_id+"/default.py" 
#                   if not os.path.exists(xpath_file): 
#                   os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)                                       
#                   if not os.path.exists(fixed2_file):
#                      os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)

                   pass#print "In rundef cmd B=", cmd
###                   cmd='python '+default_file+' 1 '+"'"+arg3+"'" 
                   pass#print "In rundef cmd C=", cmd
                       
                ###############################

               
                 
                #cmd='python '+xpath_file+' 1 '+arg3      
                self.container = eConsoleAppContainer()
#		self.container.appClosed.append(self.action)
##                try:
##		       self.container.appClosed.append(self.finad)
##                except:       
##                       self.container.appClosed.connect(self.finad) 			        
#		self.container.dataAvail.append(self.dataAvail)
##		try:
##		       self.container.dataAvail.append(self.dataAvail)
##                except:       
##                       self.container.dataAvail.connect(self.dataAvail) 	
		self.data1=''		
#                if os.path.exists("/tmp/KodiDirect_log"):
#                    os.remove("/tmp/KodiDirect_log")
                    
                if os.path.exists("/tmp/data.txt"):
                   os.remove("/tmp/data.txt")                    		
#                if DEBUG == 1:
                cmd = cmd + " &"
                pass#print "In Rundefault cmd =", cmd
                timen = time.time() 
                global NTIME 
                timenow = timen - NTIME
                NTIME = timen
                pass#print "In Rundefault 1 timenow", timenow
                self.lastcmd = cmd
##                os.system(cmd)
#                       self.action(" ")
#                self.container.execute(cmd) 
                self.dtext = " "
                self.p = os.popen(cmd)
                self.timecount = 0
                self.updateTimer.start(self.timeint)

    def updateStatus(self):
         ncount = config.plugins.kodiplug.wait.value
         self.timecount = self.timecount + 1 
         pass#print "In rundef updateStatus self.timecount =", self.timecount
         self.dtext = self.p.read()
         pass#print "In rundef updateStatus self.dtext =", self.dtext
         if "data B" in self.dtext:
                self.updateTimer.stop()
                self.action(" ")
         """
         if os.path.exists(self.dfile):
            b1 = os.path.getsize(self.dfile)
            if b1 > 0:
              pass#print "In rundef b1 =", b1
              b = b1 / 1000
              pass#print "In rundef b =", b
              try:
                  pass#print "In rundef self.bLast =", self.bLast
                  if b == self.bLast:
                     self.updateTimer.stop()
                     self.action(" ")
              except:
                   pass      
              self.bLast = b
         """
         pass#print "In rundef self.timecount =", self.timecount 
         if self.timecount > self.nct:     
              self.updateTimer.stop()
              self.action(" ")
              
#         elif self.timecount > 10:
#              pass#print "No /tmp/data.txt", b
#              self.updateTimer.stop()
#              self.close()
              
              
    def callback(self,result):
        if result:
           self.stream()		
    def action(self,retval):
            pass#print "In Rundefault action 1"
            if os.path.exists("/tmp/stopaddon"):
                   self.stoprun()
                   return    
            #######################
            str = self.data1
            pass#print "In Rundefault action 2"
            ########################  
              
            self.data = []
            self.names = []
            self.urls = []
            self.pics = []
            self.names.append("Exit")
            self.urls.append(" ")
            if config.plugins.kodiplug.skinres.value == "fullhd":
                                exitpic = THISPLUG + "/skin/images/ExitL.png"
            else:
                                exitpic = THISPLUG + "/skin/images/Exit.png"
            self.pics.append(exitpic)
            self.tmppics = []
            self.lines = []
            self.vidinfo = []
            afile = open("/tmp/test.txt","w")       
            afile.write("\nin action=")
            datain =""
            parameters = []
            pass#print "In Rundefault action 3"
            self.data = []
#            dtext = self.p.read()
            data = self.dtext.splitlines()
            for line in data:
                   pass#print "In Rundefault line =", line
                   if not "data B" in line: continue
                   else: 
                         i1 = line.find("&", 0)
                         line1 = line[i1:]
                         self.data.append(line1)
            pass#print "In Rundefault self.data =", self.data 
            ln = len(self.data)
            if ln == 0:
                 f1=open('/tmp/e.log',"w+")
                 f1.write(self.dtext)
                 self.error=(_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen"))
                 self.progressCallBack((_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen")))
                 return
                    
            """           
            if not path.exists("/tmp/data.txt"):
                try:
                 self.lastcmd = self.lastcmd + " > /tmp/e1.log 2>&1"
                 os.system(self.lastcmd)
                 jointext("/tmp/e.log", "/tmp/e1.log")
                 self.error=(_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen"))
                 self.progressCallBack((_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen")))
                 return
                except:
                 return 
            else:
                 timen = time.time() 
                 global NTIME 
                 timenow = timen - NTIME
                 NTIME = timen
                 print"In Rundefault 2 timenow", timenow
                 pass#print "In Rundefault action 4"
                 self.progressCallBack(_("Finished"))
                 if not path.exists("/tmp/vidinfo.txt"):
                       pass
                 else:
                       myfile = file(r"/tmp/vidinfo.txt")       
                       icount = 0
                       vinfo = myfile.read()
                       myfile.close()
                       self.vidinfo = vinfo.split("ITEM")
                 
                 myfile = open(r"/tmp/data.txt")       
                 icount = 0
                 self.error='Finished'
                 for line in myfile.readlines():
                        pass#print "In rundef line =", line
                        n1 = line.find("name=", 0)
                        n2 = line.find("&name=", (n1+3))
#                        pass#print "In rundef n1, n2 =", n1, n2
                        if n2 > -1:
                             line = line[n2:]
                        datain = line[:-1]
                        self.data.append(icount)
                        self.data[icount] = datain
                        icount = icount+1
                 myfile.close()
            """
            n1 = 0
            if n1==0:    
                 inum = len(self.data)
                 i = 0
                 while i < inum:
                        name = " "
                        url = " "
                        line = self.data[i]
                        if DEBUG == 1:
                               pass#print "In rundef line B=", line
                        if line.startswith("&"):
                               line = line[1:]
#                        pass#print "In rundef line C=", line       
                        params = parameters_string_to_dict(line)
                        if DEBUG == 1:
                               pass#print "Rundefault params=", params
                        self.lines.append(line)
                        try:
                               name = params.get("name")
                               name = name.replace("AxNxD", "&")
                               name = name.replace("ExQ", "=")
                               if DEBUG == 1:
                                       pass#print "Rundefault name=", name       
                        except:
                               pass
                        try:
                               url = params.get("url")
                               url = url.replace("AxNxD", "&")
                               url = url.replace("ExQ", "=")
                               if DEBUG == 1:
                                       pass#print "Rundefault url=", url      
                        except:
                              pass
                        """      
                        try:
                              pic = params.get("thumbnailImage")
                              if (pic == "DefaultFolder.png"):
                                     pic = THISPLUG + "/skin/images/default.png"
                        except:
                              pic = THISPLUG + "/skin/images/default.png" 
                        """
                        thumbnailImage = params.get("thumbnailImage") 
                        pass#print "Rundefault thumbnailImage=", thumbnailImage   
                        iconImage = params.get("iconImage") 
                        pass#print "Rundefault iconImage=", iconImage
                        try:
                           if thumbnailImage.startswith("http"):
                               pic = thumbnailImage
                               pass#print "Rundefault pic A=", pic
                           elif iconImage.startswith("http"):
                               pic = iconImage
                               pass#print "Rundefault pic B=", pic
                           else:
                               pic = THISPLUG + "/skin/images/default.png"
                        except:
                               pic = THISPLUG + "/skin/images/default.png"
                        if DEBUG == 1:
                                       pass#print "Rundefault pic=", pic              
                        self.names.append(name)
                        self.urls.append(url)
                        self.pics.append(pic)
                        i = i+1
                 if DEBUG == 1:
                        pass#print "Rundefault self.names=", self.names
                        pass#print "Rundefault self.urls=", self.urls
                        pass#print "Rundefault self.pics=", self.pics
                 if (len(self.names) == 2) and (self.urls[1] is None) and (THISPLUG not in self.names[1]):
                        if "*download*" in self.names[1]:
                                url = self.names[1].replace("*download*", "")
                                name = self.name                                
                                desc = " "
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Getvid, name, url, desc)
                                self.close()
                        elif "*download2*" in self.names[1]:
                                url = self.names[1].replace("*download2*", "")
                                name = self.name                                
                                desc = " "
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Getvid2, name, url, desc)
                                self.close()
                        elif ("stack://" in self.names[1]):
                                stkurl = self.names[1]
                                self.playstack(stkurl)

                        elif ("rtmp" in self.names[1]):
                            if "live" in name:
                                name = self.name
                                desc = " "
                                url = self.names[1]
#                                self.session.open(Showrtmp2, name, url, desc)
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                           
                            else:
                                name = self.name
                                desc = " "
                                url = self.names[1]
#                                self.session.open(Showrtmp, name, url, desc)
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Playvid, name, url, desc)
                                self.close()        
                                
                        else:        
                                name = self.name                                
                                desc = " "
                                url = self.names[1]
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                 elif (len(self.names) == 2) and (self.urls[1] is not None) and (THISPLUG not in self.urls[1]):
                        url = self.urls[1]
                        if "*download*" in url:
                                url = url.replace("*download*", "")
                                name = self.name                                
                                desc = " "
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Getvid, name, url, desc)
                                self.close()
                        elif "*download2*" in url:
                                url = url.replace("*download2*", "")
                                name = self.name                                
                                desc = " "
                                self.progressCallBack("")
                                self.updateTimer.stop()
                                self.session.open(Getvid2, name, url, desc)
                                self.close()
                                       
                        else:
                                name = self.name                                
                                desc = " "
                                self.progressCallBack("Finished")
                                self.updateTimer.stop()
                                self.session.open(Playvid, name, url, desc)
                                self.close()    
#                 else:        
#                        self.tmppics = getpics(self.names, self.pics, self.tmpfold, self.picfold)
                        #if int(self.nextrun) == 2:
#                        self.progressCallBack("")
#                        self.session.open(XbmcPluginScreen,self.name,self.names, self.urls, self.tmppics,self.nextrun)
#                        self.close()
                        
                        
                        
                 else:  
                    inm = 0 
                    for name in self.names:
                                if name is None:
                                      self.names[inm] = "Video"
                                self.names[inm] = self.names[inm].replace(":", "-")
                                self.names[inm] = self.names[inm].replace("&", "-")
                                self.names[inm] = self.names[inm].replace("'", "-")
                                self.names[inm] = self.names[inm].replace("?", "-")
                                self.names[inm] = self.names[inm].replace("/", "-")
                                self.names[inm] = self.names[inm].replace("#", "-")
                                self.names[inm] = self.names[inm].replace("|", "-")
                                self.names[inm] = self.names[inm].replace("*", "")
                                inm = inm+1
                    ipic = 2 
                    npic = len(self.pics)
                    cpic = self.pics[1]
                    pass#print "cpic =", cpic
                    pass#print "self.pics A=", self.pics
                    while ipic < npic:
                          pic = self.pics[ipic]
                          if pic == cpic:
                                self.pics[ipic] = THISPLUG + "/skin/images/default.png"
                          ipic = ipic+1
                          
                    pass#print "self.pics B=", self.pics
                    if config.plugins.kodiplug.thumb.value == "True":
                               self.tmppics = getpics(self.names, self.pics, self.tmpfold, self.picfold)
                               self.session.open(XbmcPluginScreen2,self.name,self.names, self.urls, self.tmppics,self.nextrun)
                    else:                       
                               self.tmppics = getpics(self.names, self.pics, self.tmpfold, self.picfold)
                               self.session.open(XbmcPluginScreen,self.name,self.names, self.urls, self.tmppics,self.nextrun)
                    """
                    else:                       
                        
                        timenow = time.time()
                        global NTIME
                        NTIME = timenow
                        timen = timenow - NTIME
                        pass#print "Before getpics2 timen =", timen
                        namelist = ""
                        piclist = ""
                        self.tmppics = []
                        inm = 0 
                        for name in self.names:
                                if name is None:
                                      self.names[inm] = "Video"
                                self.names[inm] = self.names[inm].replace(":", "-")
                                self.names[inm] = self.names[inm].replace("&", "-")
                                self.names[inm] = self.names[inm].replace("'", "-")
                                self.names[inm] = self.names[inm].replace("?", "-")
                                self.names[inm] = self.names[inm].replace("/", "-")
                                self.names[inm] = self.names[inm].replace("#", "-")
                                self.names[inm] = self.names[inm].replace("|", "-")
                                inm = inm+1
                        for name in self.names:
                                namelist = namelist + "#####" + name
                                name1 = "/media/hdd/xbmc/pic/" + name + ".png"
                                self.tmppics.append(name1) 
                        for pic in self.pics:
                                if pic is None:
                                      pic = THISPLUG + "/skin/images/default.png"
                                piclist = piclist + "#####" + pic
                        tfold = self.tmpfold
                        pfold = self.picfold    
                        namelist = namelist[5:]
                        
                        pass#print "Before getpics2 namelist =", namelist
                        piclist = piclist[5:]
                        piclist = piclist.replace("'", "$$$$")   
                        pass#print "Before getpics2 piclist =", piclist
                        cmd = "python " + THISPLUG + "/Getpics.py '" + namelist + "' '" + piclist + "' '" + tfold + "' '" + pfold + "' &"
                        pass#print "Before getpics2 cmd =", cmd
                        os.system(cmd)
                        
#                        self.tmppics = getpics2(self.names, self.pics, self.tmpfold, self.picfold)
                        timenow = time.time()
                        timen = timenow - NTIME
                        pass#print "After getpics2 timen =", timen
#                        self.tmppics = getpics(self.names, self.pics, self.tmpfold, self.picfold)
#                        timenow = time.time()
#                        timen = timenow - NTIME
                        pass#print "After getpics timen =", timen
                        #if int(self.nextrun) == 2:
                        self.progressCallBack("")
                        self.session.open(XbmcPluginScreen2,self.name,self.names, self.urls, self.tmppics,self.nextrun)
                        pass#print "Here in rundef end"
                    """
              
    def playstack(self, urlFull):
          if DEBUG == 1:
                 pass#print "urlFull =", urlFull 
          playlist = []
          names = []
          i = 0
          start = 0
          while i<20:
                 n1 = urlFull.find("http", start)
                 if n1 < 0:
                        break
                 n2 = urlFull.find("http", (n1+4))
                 if n2 < 0:
                        n2 = len(urlFull)
                 url1 = urlFull[n1:n2]
#                 pass#print "url1 =", url1 
                 n3 = url1.find(".mp4", 0)
                 if n3<0:
                        n3 = url1.find(".flv", 0)
                        if n3<0:
                              break 
                 url1 = url1[0:(n3+4)]
#                 pass#print "url1 B=", url1
                 name = "Video" + str(i)
                 playlist.append(url1)
                 names.append(name)
#                 pass#print "n1, n2, n3 =", n1, n2, n3
#                 pass#print "playlist[i] =", playlist[i]
                 start = n2-1
                 i = i+1
          idx = 0       
          self.session.open(Playlist, idx, names, playlist)

    def keyNumberGlobal(self, number):
		self["text"].number(number)

#########################
class XbmcPluginScreen2(Screen):

	def __init__(self, session, name, names, urls, tmppics,curr_run):
		self.skinName = "XbmcPluginScreen2"
		Screen.__init__(self, session)
		title = "KodiDirect 3.0"
		self["title"] = Button(title)
		self["bild"] = startspinner()
		self.curr_run = curr_run
		self.nextrun=self.curr_run+1
		self.pos = []		
                if config.plugins.kodiplug.skinres.value == "fullhd": 
                       self.pos.append([35,80])
                       self.pos.append([395,80])
                       self.pos.append([755,80])
                       self.pos.append([1115,80])
                       self.pos.append([1475,80])
                       self.pos.append([35,530])
                       self.pos.append([395,530])
                       self.pos.append([755,530])
                       self.pos.append([1115,530])
                       self.pos.append([1475,530])
                else:       
                       self.pos.append([20,50])
                       self.pos.append([260,50])
                       self.pos.append([500,50])
                       self.pos.append([740,50])
                       self.pos.append([980,50])
                
                       self.pos.append([20,350])
                       self.pos.append([260,350])
                       self.pos.append([500,350])
                       self.pos.append([740,350])
                       self.pos.append([980,350])                       

                pass#print " self.pos =", self.pos
		
		list = []
                self.name = name
		self.pics = tmppics
		self.mlist = names
		self.urls1 = urls
		self.names1 = names
		self["info"] = Label()
		
		self.curr_run=curr_run
		txt = str(SELECT[self.curr_run])
		pass#print "In XbmcPluginScreen SELECT[self.curr_run] A=", SELECT[self.curr_run]
		self.nextrun=self.curr_run+1
	 	pass#print "2028",txt	
		self.select=txt
		self.rundef=None
		self.plug=''
		self.keylock=False
		self.spinner_running=False

		
		pass#print "self.mlist =", self.mlist
                list = names
                self["menu"] = List(list)
                
                for x in list:
                       pass#print "x in list =", x

                ip = 0
                pass#print "self.pics = ", self.pics

		self["frame"] = MovingPixmap()

                self["label1"] = StaticText()
                self["label2"] = StaticText()
                self["label3"] = StaticText()
                self["label4"] = StaticText()
                self["label5"] = StaticText()
                self["label6"] = StaticText()
                self["label7"] = StaticText()
                self["label8"] = StaticText()
                self["label9"] = StaticText()
                self["label10"] = StaticText()
                self["label11"] = StaticText()
                self["label12"] = StaticText()
                self["label13"] = StaticText()
                self["label14"] = StaticText()
                self["label15"] = StaticText()
                self["label16"] = StaticText()


                self["pixmap1"] = Pixmap()
                self["pixmap2"] = Pixmap()
                self["pixmap3"] = Pixmap()
                self["pixmap4"] = Pixmap()
                self["pixmap5"] = Pixmap()
                self["pixmap6"] = Pixmap()
                self["pixmap7"] = Pixmap()
                self["pixmap8"] = Pixmap()
                self["pixmap9"] = Pixmap()
                self["pixmap10"] = Pixmap()
                self["pixmap11"] = Pixmap()
                self["pixmap12"] = Pixmap()
                self["pixmap13"] = Pixmap()
                self["pixmap14"] = Pixmap()
                self["pixmap15"] = Pixmap()
                self["pixmap16"] = Pixmap()
                i = 0

                self["actions"] = NumberActionMap(["OkCancelActions", "MenuActions", "DirectionActions", "NumberActions"],
			{
				"ok": self.okClicked,
				"cancel": self.close,
				"left": self.key_left,
			        "right": self.key_right,
			        "up": self.key_up,
			        "down": self.key_down,
			})

                self.index = 0
                ln = len(self.names1)
                self.npage = int(float(ln/10)) + 1
                pass#print "self.npage =", self.npage
                self.ipage = 1
                self.icount = 0
                pass#print "Going in openTest"
                self.onLayoutFinish.append(self.openTest)
                
                             
        def startSpinner(self):
            if self.spinner_running==False:
                Bilder=buildBilder()
                self["bild"].start(Bilder)
                self.spinner_running=True
                return    
        def stopSpinner(self):
            if self.spinner_running==True:
                self["bild"].stop()
                self.spinner_running=False
                self['bild'].instance.setPixmap(gPixmapPtr())
            return            

        def exit(self):
          if self.spinner_running==True:
           self.stopSpinner()
           self.keylock=False
           
           afile=open("/tmp/stopaddon","w")
           afile.write("stop execution")
           afile.close()
           
           self.progressCallBack("Finished")           
           try:self.rundef.stoprun()
           except:pass
          else:
           self.stopSpinner()   
           #self['bild']=None 
#           dellog()
           self.close()          
           
        
        #self['bild']=None
        
        def progressCallBack(self,progress):
          try:
             if progress is not None:
                if progress.startswith("Error"):
                   self.keylock=False
                   self["info"].setText(progress)
                   self.stopSpinner() 
                   return       
                if  progress=="Finished":
                   self.keylock=False
                   self.selection_changed()
                   self.stopSpinner()
                   return
           
             self["info"].setText(progress)
          except:
                  pass  
        
        def selection_changed(self):
          self.keylock=False
          try:self["info"].setText(self.select)
          except:pass
    
        def showerror(self):

          from Plugins.Extensions.KodiDirect.lib.XBMCAddonsinfo import XBMCAddonsinfoScreen
          self.session.open(XBMCAddonsinfoScreen,None)
                 

        def paintFrame(self):
                pass#print "In paintFrame self.index, self.minentry, self.maxentry =", self.index, self.minentry, self.maxentry
#		if self.maxentry < self.index or self.index < 0:
#			return
                ifr = self.index - (10*(self.ipage-1))
		ipos = self.pos[ifr]
		pass#print "ifr, ipos =", ifr, ipos
		self["frame"].moveTo( ipos[0], ipos[1], 1)
		self["frame"].startMoving()


        def openTest(self):
#                coming in self.ipage=1, self.shortnms, self.pics
                 pass#print "self.ipage, self.npage =", self.ipage, self.npage
		 if self.ipage < self.npage:
                        self.maxentry = (10*self.ipage)-1
                        self.minentry = (self.ipage-1)*10
                        #self.index 0-11
                        pass#print "self.ipage , self.minentry, self.maxentry =", self.ipage, self.minentry, self.maxentry     

                 elif self.ipage == self.npage:
                        pass#print "self.ipage , len(self.pics) =", self.ipage, len(self.pics)
                        self.maxentry = len(self.pics) - 1
                        self.minentry = (self.ipage-1)*10
                        pass#print "self.ipage , self.minentry, self.maxentry B=", self.ipage, self.minentry, self.maxentry   
                        i1 = 0
                        blpic = THISPLUG + "/skin/images/Blank.png"
                        while i1 < 12:
                              self["label" + str(i1+1)].setText(" ")
                              self["pixmap" + str(i1+1)].instance.setPixmapFromFile(blpic)
                              i1 = i1+1
                 pass#print "len(self.pics) , self.minentry, self.maxentry =", len(self.pics) , self.minentry, self.maxentry        

                 i = 0
                 i1 = 0
                 self.picnum = 0
                 pass#print "doing pixmap"
                 ln = self.maxentry - (self.minentry-1)
                 """
                 while i1 < ln:
                    idx = self.minentry + i1 
                    pass#print "i1, idx =", i1, idx
                    
                    if os.path.exists(self.pics[idx]):
                           self.picnum = self.picnum+1
                    i1 = i1+1
                 pass#print "self.picnum  =", self.picnum 
                 pass#print "self.icount A=", self.icount
                 if self.icount < 15:   
                      self.icount = self.icount+1
                      if (self.picnum < 9):
                           pass#print "pic not ready self.icount =", self.icount
                           os.system("sleep 1")
                           self.openTest()
                      else:   
                           pass#print "pics ready"
                           self.icount = 15
                           pass
                 """
                 while i < ln:
                    idx = self.minentry + i 
                    pass#print "i, idx =", i, idx
##################################
                    pass#print "self.names1[idx] B=", self.names1[idx]
                    self["label" + str(i+1)].setText(self.names1[idx])
#################################

                    pass#print "idx, self.pics[idx]", idx, self.pics[idx]
                    pic = self.pics[idx]
                    if not os.path.exists(self.pics[idx]):
                           pic = THISPLUG + "/skin/images/default.png"
                    self["pixmap" + str(i+1)].instance.setPixmapFromFile(self.pics[idx])
                    i = i+1  
                 self.index = self.minentry
                 self.paintFrame()
                           
                 
        def key_left(self):
		self.index -= 1
		if self.index < 0:
			self.index = self.maxentry
		self.paintFrame()

        def key_right(self):
		self.index += 1
		if self.index > self.maxentry:
			self.index = 0
		self.paintFrame()

        def key_up(self):
		self.index = self.index - 5
#		if self.index < 0:
#			self.index = self.maxentry
#		self.paintFrame()
                pass#print "keyup self.index, self.minentry = ", self.index, self.minentry
		if self.index < (self.minentry):
                    if self.ipage > 1:
                        self.ipage = self.ipage - 1
                        self.openTest()
                         
		    elif self.ipage == 1:	
                        self.close()
                else:
		        self.paintFrame()



        def key_down(self):
                self.index = self.index + 5
                pass#print "keydown self.index, self.maxentry = ", self.index, self.maxentry
		if self.index > (self.maxentry):
                    if self.ipage < self.npage:
                        self.ipage = self.ipage + 1
                        self.openTest()
                         
		    elif self.ipage == self.npage:	
                        self.index = 0
                        self.ipage = 1
                        self.openTest()

                else:
		        self.paintFrame()


#########################
###############################	
        def okClicked(self):
          #self["bild"] = startspinner()
          
          if self.keylock:
                   return     
    
          if DEBUG == 1:
                print"screen number"+str(self.curr_run)+"okClicked"
          itype = self.index
          url = self.urls1[itype]
          name = self.names1[itype]
          self.name = name
          global SELECT
#          SELECT.append(self.name)
          print"screen number"+str(self.curr_run)+"okClicked SELECT[0]=", SELECT[0]
#          SELECT[self.curr_run] = SELECT[self.curr_run-1] + " -> " + self.name
          SELECT.append(SELECT[self.curr_run] + " -> " + self.name)
          self.next_select=SELECT[self.curr_run]
          print"In XbmcPluginScreen self.curr_run =", self.curr_run
          print"In XbmcPluginScreen SELECT[self.curr_run] =", SELECT[self.curr_run]
          print"In XbmcPluginScreen SELECT =", SELECT
          self.url = url
          print"In XbmcPluginScreen self.name =", self.name
          if 'search' in self.name.lower():
                     #ShowSearchDialog(self.session)
                     pass#print "In XbmcPluginScreen search" 
#                     from  Screens.VirtualKeyBoard import VirtualKeyBoard
                     from Plugins.Extensions.KodiDirect.lib.VirtualKeyBoard import VirtualKeyBoard
#                     import os
                     try:
                        txt=open('/tmp/xbmc_search.txt','r').read()
                        #os.remove("/tmp/xbmc_search.txt") 
                     except:
       
                           txt=''
                     self.name=name
                     self.url=url      
                     self.session.openWithCallback(self.searchCallback, VirtualKeyBoard, title = (_("Enter your search term(s)")), text = txt)           

          else:
            if itype == 0:
                  self.close()
            elif itype == 1 and self.curr_run==1:
              if name == "Setup":###to generate e2 e2sett.py
                d = THISPLUG + "/plugins/" + self.plug
                settings_file=d+"/resources/settings.xml"
                
                import sys,os
                if not os.path.exists(settings_file):
                   self['info'].setText(_("No settings available"))
                   return
                
         
                from Plugins.Extensions.KodiDirect.lib.XBMCAddonsSetup import AddonsettScreen
              
                
                self.session.open(AddonsettScreen,self.plug)
                
                return
            elif itype == 2 and self.name == "Favorites":

                
                favorites_xml="/etc/KodiDirect/favorites.xml"
                import os
                if not os.path.exists(favorites_xml):
                       try:   
                        if not os.path.exists("/etc/KodiDirect"):
                           os.makedirs("/etc/KodiDirect")
                        copyfile(THISPLUG+"/lib/defaults/favorites.xml",favorites_xml)
                       except:
                        return 
                from Plugins.Extensions.KodiDirect.lib.favorites import getfavorites
                favlist=getfavorites(self.plug)
                names2=[]
                urls2=[]
                names2.append("Exit")
                urls2.append("")
                for fav in favlist:
                     names2.append(fav[0])
                     urls2.append(fav[1])
                self.session.open(Favorites, names2, urls2)
                return

                                         
                  
 #         elif 'search' in self.name.lower():
          
            else:
                  self["info"].setText("Please wait ...")
##                  self.keylock=True
                  self.startSpinner()
                  self.rundef = Rundefault(self.session, name, url, self.nextrun,self.progressCallBack)
                  self.rundef.start()
                  
                  
##################################                  
#    plugin://plugin.video.youtube/kodion/search/query/?q=adele             
        def searchCallback(self,search_txt): 
          if search_txt:
               pass#print "In XbmcPluginScreen self.url 2=", self.url
               pass#print "In XbmcPluginScreen search_txt 1=", search_txt
               n1 = self.url.find("?", 0)
               if "plugin.video.youtube" in THISADDON:
                       self.url = self.url[:(n1+1)] + "plugin://plugin.video.youtube/kodion/search/query/?q=" + search_txt
               
               else:
#                       pass#print "In XbmcPluginScreen search_txt 2=", search_txt
                       file=open("/tmp/xbmc_search.txt",'w')
                       file.write(search_txt)
                       file.close()
                       self["info"].setText(_("Please wait.."))
##                       self.keylock=True 
               rundef = Rundefault(self.session, self.name, self.url, 2,self.progressCallBack)
               rundef.start() 
               if rundef.error:
                      self["info"].setText(_("Error:")+rundef.error)  
#################################### 
#######
class XbmcPluginScreen(Screen):


    def __init__(self, session, name, names, urls, tmppics,curr_run):
		Screen.__init__(self, session)
		if curr_run == 1:
		       self.skinName = "KodiMenusScreenB"
		else:
		       self.skinName = "KodiMenusScreen"
		self["bild"] = startspinner()
		title = "KodiDirect 3.0"
		self["title"] = Button(title)
                self.session=session
		self.list = []                
                self["menu"] = List(self.list)
                self["menu"] = RSList([])
		self["info"] = Label()
		self.curr_run=curr_run
		txt = str(SELECT[self.curr_run])
		pass#print "In XbmcPluginScreen SELECT[self.curr_run] A=", SELECT[self.curr_run]
		self.nextrun=self.curr_run+1
	 	pass#print "2028",txt	
		self.select=txt
		self.rundef=None
		self.plug=''
		self.keylock=False
		self.spinner_running=False
		self["info"].setText(txt)
		self["pixmap"] = Pixmap()

	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))		
	
                self["actions"] = NumberActionMap(["OkCancelActions", "DirectionActions", "ColorActions", "EPGSelectActions"],{
                       "upRepeated": self.up,
                       "downRepeated": self.down,
                       "up": self.up,
                       "down": self.down,
                       "info":self.showerror,
                       "left": self.left,
                       "right":self.right,
		       "red": self.close,
		       "green": self.okClicked,                       
                       "ok": self.okClicked,                                            
                       "cancel": self.exit,}, -1)
                self.plug = name
                self.handle = 1
                self.names1 = []
                for nam in names:
                       if nam is None:
                               nam = "Video"
                       self.names1.append(nam)        
#                self.names1 = names
                self.urls1 = urls
                self.tmppics1 = tmppics
                if DEBUG == 1:

                       pass#print "screen number"+str(self.curr_run)+"self.names1 =", self.names1
                       pass#print "screen number"+str(self.curr_run)+"self.urls1 =", self.urls1
                       pass#print "screen number"+str(self.curr_run)+"self.tmppics1 =", self.tmppics1
                self.names = []
                self.urls = []
                self.pics = []
                self.tmppics = []
                self.sett = []
                self.lines = []
                self.vidinfo = []                
                self.data = []
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                system("rm /tmp/data.txt")
                self.pos = 0
                self.missed = " "
                self.shlist = " "
                self["menu"].onSelectionChanged.append(self.selection_changed)
                self.onShown.append(self.selection_changed)
                self.onLayoutFinish.append(self.action)
    def startSpinner(self):
        if self.spinner_running==False:
          
          #self["bild"] = startspinner()
          
          Bilder=buildBilder()
          self["bild"].start(Bilder)
          self.spinner_running=True
          return    
    def stopSpinner(self):
       if self.spinner_running==True:
          self["bild"].stop()
          self.spinner_running=False
          self['bild'].instance.setPixmap(gPixmapPtr())
          #self["bild"].instance=None
       #self["bild"]=None
       return            
    def exit(self):
        if self.spinner_running==True:
           self.stopSpinner()
           self.keylock=False
           
           afile=open("/tmp/stopaddon","w")
           afile.write("stop execution")
           afile.close()
           
           self.progressCallBack("Finished")           
           try:self.rundef.stoprun()
           except:pass
        else:
           self.stopSpinner()   
           #self['bild']=None 
#           dellog()
           self.close()          
           
        
        #self['bild']=None
        
    def progressCallBack(self,progress):
      try:
        if progress is not None:
          if progress.startswith("Error"):
              self.keylock=False
              self["info"].setText(progress)
              self.stopSpinner() 
              return       
          if  progress=="Finished":
              self.keylock=False
              self.selection_changed()
              self.stopSpinner()
              return
           
        self["info"].setText(progress)
      except:
        pass  
        
    def selection_changed(self):
        self.keylock=False
        try:self["info"].setText(self.select)
        except:pass
    
    def showerror(self):

       from Plugins.Extensions.KodiDirect.lib.XBMCAddonsinfo import XBMCAddonsinfoScreen
       self.session.open(XBMCAddonsinfoScreen,None)
    
    def home(self):
                
                self.session.open(StartPlugin)
                self.close()

    def action(self):
                        if config.plugins.kodiplug.thumb.value == "False":
		                picthumb = THISPLUG + "/skin/images/default.png"
#                                self["pixmap"].instance.setPixmapFromFile(picthumb)
#                        pass#print "In XbmcPluginScreen self.names1 =", self.names1
                        showlist(self.names1, self["menu"])
#                        self.selection_changed()
                
    def up(self):
                if self.keylock:
                   return
                self.pos = up(self.names1, self.tmppics1, self.pos, self["menu"], self["pixmap"])

    def down(self):
                if self.keylock:
                   return    
    
                self.pos = down(self.names1, self.tmppics1, self.pos, self["menu"], self["pixmap"])
                
    def left(self):
                if self.keylock:
                   return    
    
                self.pos = left(self.names1, self.tmppics1, self.pos, self["menu"], self["pixmap"])

    def right(self):
                if self.keylock:
                   return    
                self.pos = right(self.names1, self.tmppics1, self.pos, self["menu"], self["pixmap"])

    def cancel(self):
                self.keylock=False
                afile=open("/tmp/stopaddon","w")
                afile.write("stop execution")
                afile.close()
                self.close()  
	
    def keyRight(self):
                if self.keylock:
                   return     
    
		self["text"].right()


    def vidError(self, reply):
                return

    def okClicked(self):
          #self["bild"] = startspinner()
          
          if self.keylock:
                   return     
    
          if DEBUG == 1:
                pass#print "screen number"+str(self.curr_run)+"okClicked"
          itype = self["menu"].getSelectionIndex()
          url = self.urls1[itype]
          name = self.names1[itype]
          self.name = name
          global SELECT
#          SELECT.append(self.name)
          pass#print "screen number"+str(self.curr_run)+"okClicked SELECT[0]=", SELECT[0]
#          SELECT[self.curr_run] = SELECT[self.curr_run-1] + " -> " + self.name
          SELECT.append(SELECT[self.curr_run] + " -> " + self.name)
          self.next_select=SELECT[self.curr_run]
          pass#print "In XbmcPluginScreen self.curr_run =", self.curr_run
          pass#print "In XbmcPluginScreen SELECT[self.curr_run] =", SELECT[self.curr_run]
          pass#print "In XbmcPluginScreen SELECT =", SELECT
          self.url = url
          self.url = url
          pass#print "In XbmcPluginScreen self.name =", self.name
          if 'search' in self.name.lower():
                     #ShowSearchDialog(self.session)
                     pass#print "In XbmcPluginScreen search" 
#                     from  Screens.VirtualKeyBoard import VirtualKeyBoard
                     from Plugins.Extensions.KodiDirect.lib.VirtualKeyBoard import VirtualKeyBoard
#                     import os
                     try:
                        txt=open('/tmp/xbmc_search.txt','r').read()
                        #os.remove("/tmp/xbmc_search.txt") 
                     except:
       
                           txt=''
                     self.name=name
                     self.url=url      
                     self.session.openWithCallback(self.searchCallback, VirtualKeyBoard, title = (_("Enter your search term(s)")), text = txt)           

          else:
            if itype == 0:
                  self.close()
            elif itype == 1 and self.curr_run==1:
              if name == "Setup":###to generate e2 e2sett.py
                d = THISPLUG + "/plugins/" + self.plug
                settings_file=d+"/resources/settings.xml"
                
                import sys,os
                if not os.path.exists(settings_file):
                   self['info'].setText(_("No settings available"))
                   return
                
         
                from Plugins.Extensions.KodiDirect.lib.XBMCAddonsSetup import AddonsettScreen
              
                
                self.session.open(AddonsettScreen,self.plug)
                
                return
            elif itype == 2 and self.name == "Favorites":

                
                favorites_xml="/etc/KodiDirect/favorites.xml"
                import os
                if not os.path.exists(favorites_xml):
                       try:   
                        if not os.path.exists("/etc/KodiDirect"):
                           os.makedirs("/etc/KodiDirect")
                        copyfile(THISPLUG+"/lib/defaults/favorites.xml",favorites_xml)
                       except:
                        return 
                from Plugins.Extensions.KodiDirect.lib.favorites import getfavorites
                favlist=getfavorites(self.plug)
                names2=[]
                urls2=[]
                names2.append("Exit")
                urls2.append("")
                for fav in favlist:
                     names2.append(fav[0])
                     urls2.append(fav[1])
                self.session.open(Favorites, names2, urls2)
                return

                                         
                  
 #         elif 'search' in self.name.lower():
          
            else:
                  self["info"].setText("Please wait..")
                  self.keylock=True
                  self.startSpinner()
#                  dellog()
                  self.rundef = Rundefault(self.session, name, url, self.nextrun,self.progressCallBack)
                  self.rundef.start()
                  
                  
##################################                  
#    plugin://plugin.video.youtube/kodion/search/query/?q=adele             
    def searchCallback(self,search_txt): 
          if search_txt:
               pass#print "In XbmcPluginScreen self.url 2=", self.url
               pass#print "In XbmcPluginScreen search_txt 1=", search_txt
               n1 = self.url.find("?", 0)
               if "plugin.video.youtube" in THISADDON:
                       self.url = self.url[:(n1+1)] + "plugin://plugin.video.youtube/kodion/search/query/?q=" + search_txt
               
               else:
#                       pass#print "In XbmcPluginScreen search_txt 2=", search_txt
                       file=open("/tmp/xbmc_search.txt",'w')
                       file.write(search_txt)
                       file.close()
                       self["info"].setText(_("Please wait.."))
                       self.keylock=True 
               rundef = Rundefault(self.session, self.name, self.url, 2,self.progressCallBack)
               rundef.start() 
               if rundef.error:
                      self["info"].setText(_("Error:")+rundef.error)  
####################################                                 

class Favorites(Screen): 

    def __init__(self, session, names, urls):
		Screen.__init__(self, session)
		self.skinName = "Favorites"
		title = (_("Favorites"))
		self["title"] = Button(title)
#############################################                
		self.list = []                
#                self["list"] = List(self.list)
#                self["list"] = RSList([])
                self["menu"] = List(self.list)
                self["menu"] = RSList([])
#############################################
		self["info"] = Label()
		self["pixmap"] = Pixmap()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
		self["key_yellow"] = Button(_("Delete favorite"))
#		self["key_blue"] = Button(_("More addons"))
                self["actions"] = NumberActionMap(["OkCancelActions", "ColorActions"],{
                       "red": self.close,
		       "green": self.okClicked,
		       "yellow": self.delete,
#		       "blue": self.addon,
                       "ok": self.okClicked,
                       "cancel": self.close,}, -1)

                self.names = names
                self.urls = urls
	        self.onLayoutFinish.append(self.source)
	        
        
    def source(self):	        
                pic = THISPLUG + "/skin/images/default.png"
                self["pixmap"].instance.setPixmapFromFile(pic)
                showlist(self.names, self["menu"])
    

    def okClicked(self):
           try:
	        idx = self["menu"].getSelectionIndex()
	        desc = " "
	        name = self.names[idx]
                url = self.urls[idx]
                self.session.open(Playvid, name, url, desc)
           except:
                self["info"].setText(_("No item selected !")) 
                
    def delete(self):
           import xml.etree.ElementTree as ET
           xmlfile = "/etc/KodiDirect/favorites.xml"
           tree = ET.parse(xmlfile)

           idx = self["menu"].getSelectionIndex()
           name = self.names[idx]
           root = tree.getroot()
                
           i=0
           for addon in root.iter('addon'):   
                    for media in addon.iter('media'):
                            title = media.get('title')
                            if title == name:
                                   addon.remove(media)
                            tree.write(xmlfile)           
           self.close()

####################################
class StartPlugin_mainmenu2(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
		self.skinName = "StartPlugin_mainmenu2"
		title = "KodiDirect 3.0"
		self["title"] = Button(title)
		self.pos = []		

                if config.plugins.kodiplug.skinres.value == "fullhd":
                       self.pos.append([125,50])
                       self.pos.append([380,50])
                       self.pos.append([635,50])
                       self.pos.append([890,50])
                       self.pos.append([125,350])
                       self.pos.append([380,350])
                       self.pos.append([635,350])
                       self.pos.append([890,350])
                       self.pos.append([125,650])
                       self.pos.append([380,650])
                       self.pos.append([635,650])
                       self.pos.append([890,650])
                else:
                       self.pos.append([90,40])
                       self.pos.append([260,40])
                       self.pos.append([430,40])
                       self.pos.append([600,40])
                       self.pos.append([90,240])
                       self.pos.append([260,240])
                       self.pos.append([430,240])
                       self.pos.append([600,240])
                       self.pos.append([90,440])
                       self.pos.append([260,440])
                       self.pos.append([430,440])
                       self.pos.append([600,440])
                pass#print " self.pos =", self.pos

		self["frame"] = MovingPixmap()

                self["label1"] = StaticText()
                self["label2"] = StaticText()
                self["label3"] = StaticText()
                self["label4"] = StaticText()
                self["label5"] = StaticText()
                self["label6"] = StaticText()
                self["label7"] = StaticText()
                self["label8"] = StaticText()
                self["label9"] = StaticText()
                self["label10"] = StaticText()
                self["label11"] = StaticText()
                self["label12"] = StaticText()
                self["label13"] = StaticText()
                self["label14"] = StaticText()
                self["label15"] = StaticText()
                self["label16"] = StaticText()


                self["pixmap1"] = Pixmap()
                self["pixmap2"] = Pixmap()
                self["pixmap3"] = Pixmap()
                self["pixmap4"] = Pixmap()
                self["pixmap5"] = Pixmap()
                self["pixmap6"] = Pixmap()
                self["pixmap7"] = Pixmap()
                self["pixmap8"] = Pixmap()
                self["pixmap9"] = Pixmap()
                self["pixmap10"] = Pixmap()
                self["pixmap11"] = Pixmap()
                self["pixmap12"] = Pixmap()
                self["pixmap13"] = Pixmap()
                self["pixmap14"] = Pixmap()
                self["pixmap15"] = Pixmap()
                self["pixmap16"] = Pixmap()
                
                self["bild"] = startspinner()
                
                self["label21"] = StaticText("")
		self["label22"] = StaticText("")
		self["label220"] = StaticText("")
		self["label23"] = StaticText("")
		self["label230"] = StaticText("")
		self["label24"] = StaticText("")
                
                self["key_red"] = Button(_("Delete addons"))
		self["key_green"] = Button(_("Software"))
		self["key_yellow"] = Button(_("Config"))
		self["key_blue"] = Button(_("Tips"))
		
                self["actions"] = NumberActionMap(["OkCancelActions", "ColorActions", "MenuActions", "DirectionActions", "NumberActions"],
			{
				"ok": self.okClicked,
				"cancel": self.closeNonRecursive,
				"left": self.key_left,
			        "right": self.key_right,
			        "up": self.key_up,
			        "down": self.key_down,
			        
			        "red": self.delete,
		                "green": self.soft,
		                "yellow": self.conf,
		                "blue": self.howto,

				"menu": self.closeRecursive,
				"1": self.keyNumberGlobal,
				"2": self.keyNumberGlobal,
				"3": self.keyNumberGlobal,
				"4": self.keyNumberGlobal,
				"5": self.keyNumberGlobal,
				"6": self.keyNumberGlobal,
				"7": self.keyNumberGlobal,
				"8": self.keyNumberGlobal,
				"9": self.keyNumberGlobal
			})
########################
                self.updateTimer = eTimer()
                try:
                      self.updateTimer_conn = self.updateTimer.timeout.connect(self.updateStatus)
                except AttributeError:
                      self.updateTimer.callback.append(self.updateStatus)
                self.timecount = 0
                ncount = config.plugins.kodiplug.wait.value 
                nc = int(ncount)*1000
                timeint = int(float(nc/120))
#                if timeint < 1000: timeint = 1000
                pass#print "timeint =", timeint
                self.timeint = 1000
                self.nct = int(float(nc/timeint))
                pass#print "self.nct =", self.nct
#		self.updateTimer.start(timeint)
#		self.updateStatus()
########################  
                self.spinner_running=False
                self["info"] = Label()
		global newstext
		news = newstext
		self.cancel=False
		self.data1=''
		self.keylock=False
		self.progress=(_("please wait.."))
#		pass#print "In StartPlugin_mainmenu newstext =", newstext
                n1 = news.find("update2", 0)
                if n1 > -1:
                       upd = news[n1:(n1+14)]
		else:
		       upd = "None"
		if fileExists("/etc/kodiupd"):       
		   myfile = file(r"/etc/kodiupd")
                   icount = 0
                   for line in myfile.readlines():
                       if icount == 0:
                              upd1 = line
                              break
                       icount = icount+1
                   myfile.close()
                else:   
                   upd1 = "None"
                n2 = upd1.find(".", 0)
                if n2 > -1:   
                       upd1 = upd1[:n2]
                updA = upd.replace("update", "")       
                upd1A = upd1.replace("update", "")
                if upd != "None":       
                       txt1 = (_("Installed update")) + upd1A + (_("   Available update")) + updA
                else:       
                       txt1 = " "
		txt = txt1
                self["info"].setText(txt)

################
                pass#print "In StartPlugin_mainmenu2 Going in listplugs"
                self.index = 0
                self.ipage = 1
                self.onLayoutFinish.append(self.listplugs)

    def paintFrame(self):
                pass#print "In paintFrame self.index, self.minentry, self.maxentry =", self.index, self.minentry, self.maxentry
#		if self.maxentry < self.index or self.index < 0:
#			return
                ifr = self.index - (12*(self.ipage-1))
		ipos = self.pos[ifr]
		pass#print "ifr, ipos =", ifr, ipos
		self["frame"].moveTo( ipos[0], ipos[1], 1)
		self["frame"].startMoving()


    def openTest(self):
#                coming in self.ipage=1, self.shortnms, self.icons
                 pass#print "self.ipage, self.npage =", self.ipage, self.npage
                 pass#print "In openTest self.icons =", self.icons
		 if self.ipage < self.npage:
                        self.maxentry = (12*self.ipage)-1
                        self.minentry = (self.ipage-1)*12
                        #self.index 0-11
                        pass#print "self.ipage , self.minentry, self.maxentry =", self.ipage, self.minentry, self.maxentry     

                 elif self.ipage == self.npage:
                        pass#print "self.ipage , len(self.icons) =", self.ipage, len(self.icons)
                        self.maxentry = len(self.icons) - 1
                        self.minentry = (self.ipage-1)*12
                        pass#print "self.ipage , self.minentry, self.maxentry B=", self.ipage, self.minentry, self.maxentry   
                        i1 = 0
                        blpic = THISPLUG + "/skin/images/Blank.png"
                        while i1 < 12:
                              self["label" + str(i1+1)].setText(" ")
                              self["pixmap" + str(i1+1)].instance.setPixmapFromFile(blpic)
                              i1 = i1+1
                 pass#print "len(self.icons) , self.minentry, self.maxentry =", len(self.icons) , self.minentry, self.maxentry        
                 i = 0
                 pass#print "doing pixmap"
                 ln = self.maxentry - (self.minentry-1)
                 while i < ln:
                      idx = self.minentry + i 
                      pass#print "i, idx =", i, idx
##################################
                      pass#print "self.shortnms[idx] B=", self.shortnms[idx]
                      self["label" + str(i+1)].setText(self.shortnms[idx])
#################################
                      pass#print "idx, self.icons[idx]", idx, self.icons[idx]  
                      self["pixmap" + str(i+1)].instance.setPixmapFromFile(self.icons[idx])
                      i = i+1

#                 if self.ipage == self.npage:
                 self.index = self.minentry
                 self.paintFrame()
                 
    def key_left(self):
		self.index -= 1
		if self.index < 0:
			self.index = self.maxentry
		self.paintFrame()
		self.details()

    def key_right(self):
		self.index += 1
		if self.index > self.maxentry:
			self.index = 0
		self.paintFrame()
		self.details()

    def key_up(self):
		self.index = self.index - 4
#		if self.index < 0:
#			self.index = self.maxentry
#		self.paintFrame()
                pass#print "keyup self.index, self.minentry = ", self.index, self.minentry
		if self.index < (self.minentry):
                    if self.ipage > 1:
                        self.ipage = self.ipage - 1
                        self.openTest()
                         
		    elif self.ipage == 1:	
                        self.close()
                else:
		        self.paintFrame()
                        self.details()


    def key_down(self):
                self.index = self.index + 4
                pass#print "keydown self.index, self.maxentry = ", self.index, self.maxentry
		if self.index > (self.maxentry):
                    if self.ipage < self.npage:
                        self.ipage = self.ipage + 1
                        self.openTest()
                         
		    elif self.ipage == self.npage:	
                        self.index = 0
                        self.ipage = 1
                        self.openTest()

                else:
		        self.paintFrame()
                        self.details()

#########################

    def details(self):
         name = self.names[self.index]
         if self.index > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
#                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc= self.getinfo(name)
                
                self["label21"].setText(pname)
                self["label220"].setText("Version :")
                self["label22"].setText(version)
                self["label230"].setText("Provider :")
                self["label23"].setText(prov)
                self["label24"].setText(desc)
         else:      
                if self.index == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                              pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:       
                              pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label21"].setText(" ")
                self["label220"].setText(" ")
                self["label22"].setText(" ")
                self["label230"].setText(" ")
                self["label23"].setText(" ")
                self["label24"].setText(" ")  


    def keyNumberGlobal(self, number):
		pass#print "menu keyNumber:", number
		# Calculate index
		number -= 1
		if len(self["menu"].list) > number:
			self["menu"].setIndex(number)
			pass#print "Here in Menu 8"
			self.okbuttonClick()

    def closeNonRecursive(self):
                os.system("rm /tmp/*.png")
                if config.plugins.kodiplug.picdel.value is True:
                        picfold = config.plugins.kodiplug.cachefold.value + "/xbmc/pic"
                        cmd = "rm -rf " + picfold
                        os.system(cmd)
                        self.close(False)
                else:        
                        self.close(False)

    def closeRecursive(self):
                self.close(True)

    def createSummary(self):
#                return MenuSummary
                return


##########################
    def conf(self):            
          self.session.open(XbmcConfigScreen)

    def howto(self):            
          from Plugins.Extensions.KodiDirect.lib.XBMChelpinfo import XBMChelpinfo
          self.session.open(XBMChelpinfo)      

    def startSpinner(self):
        if self.spinner_running==False:
          Bilder=buildBilder()
          self["bild"].start(Bilder)
          self.spinner_running=True
          return    
    def stopSpinner(self):
       if self.spinner_running==True:
          self["bild"].stop()
          self.spinner_running=False
          self['bild'].instance.setPixmap(gPixmapPtr())
       #self["bild"]=None
       return 
       
    def stoprun(self):
                self.close() 
		try:
			
			self.container.appClosed.remove(self.runFinished)
			self.container.dataAvail.remove(self.dataAvail)
                        self.progressCallBack(_("Finished"))    
                except:
                        pass
    
                        
                        
    def exit(self):
    
        if self.spinner_running==True:
           self.cancel=True
           self.keylock=False
           self.progressCallBack(_("Finished"))
           self.stoprun()
                     
           
           
        else:
           self.stopSpinner()   
           
           self.close()          
            
    
           

                        
                         
                
    def showerror(self):
       from Plugins.Extensions.KodiDirect.lib.XBMCAddonsinfo import XBMCAddonsinfoScreen
       self.session.open(XBMCAddonsinfoScreen,None)
    
    def delete(self):
                if self.keylock:
                   return
#                self.session.open(DelAdd) 
                self.session.openWithCallback(self.listplugs, DelAdd)           

    def addon(self):
                if self.keylock:
                   return    
#                self.session.open(Getaddons)
                self.session.openWithCallback(self.listplugs, Getadds)           

    def script(self):
                if self.keylock:
                   return    
    
                url ="http://mirrors.kodi.tv/addons/jarvis/"
                self.session.open(Scripts, url)           

    def soft(self):
                if self.keylock:
                   return    
                url ="http://www.xtrend-alliance.com/XbmcAddon/Software/listkodi.txt"
##                url ="http://www.xtrend-alliance.com/XbmcAddon/Software2/listkodi.txt"

                self.session.open(Software, url)


    def selection_changed(self):
      self.keylock=False
      
      
      try:
        pos = self["menu"].getSelectionIndex()
        name = self.names[pos]    
#        self["info"].setText(name)
      except:
        pass
#        self["info"].setText(" ")
    def checkImports(self):
                xmfile = THISPLUG+"/plugins/"+self.id+"/resources/settings.xml"
                tmpfile = THISPLUG+"/ofile.xml"
                if os.path.exists(xmfile):
                       f = open(xmfile, "r")
                       f1 = open(tmpfile, "w")
                       ftxt = f.read()
                       ftxt = ftxt.decode("ISO-8859-1")
                       f1.write(ftxt)
                       f.close()
                       f1.close()
                       pass#print "Here in checkImports copying /tmp/ofile.xml to ", xmfile 
                       cmd = "cp -f " + tmpfile + " " + xmfile + " && rm " + tmpfile
                       pass#print "Here in checkImports cmd ", cmd 
                       os.system(cmd)
                


                self.shlist = " "
                self.plugins=" "
                scripts = THISPLUG + "/scripts"
                for name in os.listdir(scripts):
#                       if "script." in name:
                              self.shlist = self.shlist + name + " "
                              
                plugins = THISPLUG + "/plugins"
                for name in os.listdir(plugins):
#                       if "script." in name:
                              self.plugins = self.plugins + name + " "                              
                              
                import xbmcaddon
                try:
                  sys.argv[0]=THISPLUG+"/plugins/"+self.id+"/default.py"
                except:
                  import sys
                  sys.argv=[]
                  sys.argv.append(THISPLUG+"/plugins/"+self.id+"/default.py")
                update_xbmc_text(self.id)                  
                addon = xbmcaddon.Addon(self.id)
                path = addon.getAddonInfo("path")
                pass#print "In checkImports self.id =", self.id 
                pass#print "In checkImports path =", path            
                xfile = path + "/addon.xml" 
                tree = xml.etree.cElementTree.parse(xfile)
                root = tree.getroot()
                self.missed = ""
                i = 0
                try:
                  for x in root.iter('import'):
                    addon = x.get('addon') + " " #to get xbmcswift not xbmcswift2
                    if "xbmc.python" in addon:
                          continue
                    if "xbmc.addon" in addon:
                          continue      
                    if addon in self.shlist or addon in self.plugins:
                          continue
                    self.missed = self.missed + " " + addon
                    i = 1                 
                except:
                  for x in root.getiterator('import'):
                    addon = x.get('addon') + " "
                    if "xbmc.python" in addon:
                          continue
                    if "xbmc.addon" in addon:
                          continue          
                    if addon in self.shlist or addon in self.plugins:
                          continue
                    self.missed = self.missed + " " + addon
                    i = 1 
                if i == 1:
#                    self.session.openWithCallback(self.error, MessageBox, self.missed, type = 3, timeout = 20)
                    self.download(self.missed)

                else:
                    arg = "'" + THISPLUG.strip() + "/plugins/" + self.name.strip() + "/default.py' '1' ''"
                    self.arg = arg
                    self.stream()    

    def download(self, missed):
          url ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/list.txt"
          sclist = urlopen(url).read()

          url1 ="http://mirrors.kodi.tv/addons/jarvis/addons.xml"
          fdlist = urlopen(url1).read()

          pass#print "missed = [", missed

          items = missed.split(" ") 
          pass#print "items =", items
          commands = []   
          for item in items:
             pass#print "In download item =", item
             sitem = 'addon id="' + item
             n1 = fdlist.find(sitem, 0)
             if n1 < 0:
                  if item in sclist:
                             plug = item + ".zip"
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
                  else:
                             txt = item + " not found"
                             self["info"].setText(txt)
#                             return

             else:
               n2 = fdlist.find('version="', n1)
               n3 = fdlist.find('"', (n2+10))
               ver = fdlist[(n2+9):n3]      
               itemurl = "http://mirrors.kodi.tv/addons/jarvis/" + item + "/" + item + "-" + ver + ".zip"
             
               if "script." in item:
                             plug = item
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' '" + itemurl + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Sc=", cmd
               elif "plugin.video" in item:
                             plug = item
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' '" + itemurl + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Ad=", cmd
          title = (_("Installing addons ")) + missed
#          pass#print "commands= ", commands
          self.session.open(Console,_(title), commands)
          self.close()

    def download2(self, item):
                  commands = []
                  url ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/list.txt"
                  sclist = urlopen(url).read()
                  if item in sclist:
                             plug = item + ".zip"
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)

                             title = (_("Installing addons "))
                             self.session.open(Console,_(title), commands)
                             self.close()
                  else:
                             txt = item + " not found"
                             self["info"].setText(txt)
                             return



    def downloadXX(self, missed):
          pass#print "missed = [", missed
          items = missed.split(" ") 
          pass#print "items =", items
          ebuf = []
          fileslist = []
          icount = 0
          for item in items:
                fileslist.append(icount)
                fileslist[icount] = (_(item), "")
                if item == "":
                       continue
                ebuf.append(fileslist[icount])
                icount = icount + 1
          pass#print "ebuf=", ebuf             
          self.session.openWithCallback(self.donemiss, ChoiceBox, title="Install missing item & Restart KodiDirect:- ", list=ebuf)

    def donemiss(self, res):
       if res is None:
                 self.close()
       else:          
          pass#print "res=", res   
          pass#print "In donemiss res[0] =", res[0] 
          global HOST
          HOST = ""
##          url = HOST + res[0] + "/"
          url = res[0] + "/"
          url1 = "http://mirrors.kodi.tv/addons/jarvis/" + res[0] + "/"
          if "plugin.video" in res[0]:       
                 self.session.open(Addons2, res[0], url)
          else:       
                 self.session.open(Scripts2, res[0], url1)


    def downloadX(self, missed):
    
          url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/list5.txt"
          adlist = urlopen(url1).read()
          self.addata = adlist.splitlines()
          url2 ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/list4.txt"
          sclist = urlopen(url2).read()
          self.scdata = sclist.splitlines()
          
          items = missed.split(" ") 
          pass#print "items =", items
          commands = []   
          for item in items:
             if "script." in item:
                for scr in self.scdata:
                      if item in scr:
                             plug = scr
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Sc=", cmd
             elif "plugin.video" in item:
                for ad in self.addata:
                      if item in ad:
                             plug = ad
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Addons/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Ad=", cmd
          title = (_("Installing addons "))
#          pass#print "commands= ", commands
          self.session.open(Console,_(title), commands)
          self.close()




    def upX(self):
         if self.keylock:
                   return
         dedesc = " "
         endesc = " "
         itdesc = " "
         self["menu"].up()
         self.pos = self.pos - 1
         num = len(self.names)
         if self.pos == -1:
                self.pos = num - 1
                self["menu"].moveToIndex(self.pos) 
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc= self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")  
                
    def downX(self):
         if self.keylock:
                   return    
    
         dedesc = " "
         endesc = " "
         itdesc = " "

         self["menu"].down()
         self.pos = self.pos + 1
         num = len(self.names)
         if self.pos == num:
                self.pos = 0
                self["menu"].moveToIndex(0)  
         name = self.names[self.pos]
         if DEBUG == 1:
                pass#print "name =", name
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                if DEBUG == 1:
                       pass#print "name B=", name
                pname, version, prov, desc= self.getinfo(name)

                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                desc = desc.replace(":", "-")
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")  
                
    def leftX(self):
         if self.keylock:
                   return
         self["menu"].pageUp()
         self.pos = self["menu"].getSelectionIndex()
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc = self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")                        
                self.error=None
    def rightX(self):
         if self.keylock:
                   return
         self["menu"].pageDown()
         self.pos = self["menu"].getSelectionIndex()
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc = self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ") 
                                      

    def getinfo(self, name):            
                xfile = THISPLUG + "/plugins/" + name + "/addon.xml"
                dedesc = ' '
                endesc = ' '
                itdesc = ' '
                try:tree = xml.etree.cElementTree.parse(xfile)
                except: return "", "", "", ""
                root = tree.getroot()
                pname = str(root.get('name'))
                version = str(root.get('version'))
                prov = str(root.get('provider-name'))
                try:
                    for description in root.iter('description'):
                        lang = description.get('lang')
                        desc = str(description.text)
                        if lang == "de":
                              dedesc = desc
                        elif lang == "it":
                              itdesc = desc      
                        else:      
                              endesc = desc
                except:
                    for description in root.getiterator('description'):
                        lang = description.get('lang')
                        desc = str(description.text)
                        if lang == "de":
                              dedesc = desc
                        elif lang == "it":
                              itdesc = desc      
                        else:      
                              endesc = desc
                              
                if config.osd.language.value == "de_DE":
                              desc2 = dedesc
                elif config.osd.language.value == "it_IT":
                              desc2 = itdesc                               
                else:
                              desc2 = endesc
                if desc2 == ' ':
                              desc2 = endesc               
                              
                return pname, version, prov, desc2
                
    def listplugs(self):
                pass#print "In listplugs 1"
                url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                fpage = urlopen(url1).read()
                n1 = fpage.find("Adult(18+)", 0)
                n2 = fpage.find("#####", n1)
                ftxt = fpage[n1:n2]
                pass#print "ftxt =", ftxt
                self.urls = []
                self.names = []
                self.shortnms = []
                self.icons = []
                path = THISPLUG + "/plugins"
                self.names.append("Exit")
                self.shortnms.append("Exit")
                self.urls.append("0")
                if config.plugins.kodiplug.skinres.value == "fullhd":
                       pic1 = THISPLUG + "/skin/images/ExitL.png"
                else:       
                       pic1 = THISPLUG + "/skin/images/Exit.png"
                self.icons.append(pic1)
                i = 1
                
                for name in os.listdir(path):
                    pass#print "In listplugs 2 name =", name
#                    if "plugin.video" not in name:
                    if "E2" in name:
                                     self.names.append(name)
                                     self.shortnms.append(name) 
                                     self.urls.append(i)
                                     pic = self.getpic(name)
                                     self.icons.append(pic)
                                     i = i+1
                    if "plugin." not in name:
                       continue
                    elif "plugin.video.select" in name:
                       continue   
                    else:      
                       pass#print "config.ParentalControl.configured.value =", config.ParentalControl.configured.value
                       if name not in ftxt:
                              pass#print "In listplugs 2 name B=", name
                              self.names.append(name)
                              name1 = name[13:]
                              self.shortnms.append(name1) 
                              self.urls.append(i)
                              pic = self.getpic(name)
                              self.icons.append(pic)
                              i = i+1
                       else:        
                              if config.ParentalControl.configured.value: 
                                     continue
                              else:
                                     self.names.append(name)
                                     name1 = name[13:]
                                     self.shortnms.append(name1) 
                                     self.urls.append(i)
                                     pic = self.getpic(name)
                                     self.icons.append(pic)
                                     i = i+1
                              
                self.names.append("Get more......")
                self.shortnms.append("Get more......")
                self.urls.append("0")
                if config.plugins.kodiplug.skinres.value == "fullhd":
                       pic1 = THISPLUG + "/skin/images/DownloadL.png"
                else:
                       pic1 = THISPLUG + "/skin/images/Download.png"
                self.icons.append(pic1)
                pass#print "In listplugs self.icons =", self.icons
                self.num = i+1
#                showlist(self.shortnms, self["menu"])
                i = 0
                """                
                while i < self.num:
                      pass#print "i, self.shortnms[i] =", i, self.shortnms[i]
                      ilabel = "label" + str(i+1)
                      pass#print "self.shortnms[i] B=", self.shortnms[i]
                      name = self.shortnms[i]
                      pass#print "name =", name
                      pass#print "ilabel =", ilabel
                      self[ilabel].setText(name)
                      pass#print "ilabel B=", ilabel
                      i = i+1
                """                
##################################
                pass#print "self.shortnms =", self.shortnms
                self.npage = int(float(len(self.shortnms)/12)) + 1
                pass#print "self.npage =", self.npage
                self.ipage = 1
                self.openTest()


                
##################################                
    def getpic(self, name):
                try:
                          try:
                                import Image
                          except:
                                from PIL import Image
                          pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                          pic2 = "/tmp/" + name + ".png"
                          pass#print "In getpic pic1 =", pic1
                          im = Image.open(pic1)
                          imode = im.mode
                          if im.mode != "P":
                                 im = im.convert("P")
                          w = im.size[0]
                          d = im.size[1]
                          if config.plugins.kodiplug.skinres.value == "fullhd":
                                 nw = 225
                          else:       
                                 nw = 150
                          r = float(d)/float(w)
                          d1 = r*nw
                          if w != nw:        
                                 x = int(nw)

                                 y = int(d1)
                                 im = im.resize((x,y), Image.ANTIALIAS)
                          pass#print "In getpic pic2=", pic2
                          im.save(pic2)

                except:
                          if config.plugins.kodiplug.skinres.value == "fullhd":
                                  pic2 = THISPLUG + "/skin/images/default.png"
                          else:       
                                  pic2 = THISPLUG + "/skin/images/defaultS.png"
                return pic2
                
                
##################################                
    def checkUpd(self):           
                pass#print "In checkUpd self.name = ", self.name
                tfile = THISPLUG + "/plugins/" + self.name + "/addon.xml"
                f = open(tfile, "r")       
                txt = f.read()
                pass#print "In checkUpd txt = ", txt
                n1 = txt.find('<addon', 0)
                n11 = txt.find('id', n1)
                n2 = txt.find("version", n11)
                n3 = txt.find('"', n2)
                n4 = txt.find('"', (n3+2))
                version = txt[(n3+1):n4]
                pass#print "In checkUpd version = ", version
                f.close()
                surl ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                fpage = urlopen(surl).read()
#                tfile2 = THISPLUG + "/adlist.txt"      
#                f2 = open(tfile2, "r")
#                fpage = f2.read()
                lines = fpage.splitlines()
                
#                f2.close()
                nlist = 0
                for line in lines: 
#                       pass#print "In checkUpd line =", line
#                       pass#print "In checkUpd self.name B=", self.name   
                       if line.startswith("#####"):
                             continue
                       elif "###" not in line:
                             continue  
                       elif self.name in line:  
                             nlist = 1 #addon in adlist.txt    
#                             pass#print "In checkUpd line B=", line
#                             pass#print "In checkUpd self.name c=", self.name   
                             items = line.split("###")
                             n = len(items)
#                             pass#print "In checkUpd items =", items
                             name = items[0]
                             url1 = items[1]
                             if items[2] != '': 
                                   url2 = items[2]
                                   self.checkLine(line, version) 
                                   break
                             else:      
                                   pass#print "In checkUpd going in self.okClicked2 "
                                   self.okClicked2()
                       else:
                                   continue
                if nlist == 0: # user added addon
                       self.okClicked2()


    def checkLine(self, line, version):
           pass#print "In checkLine line =", line
           items = line.split("###")
           pass#print "In checkLine items =", items
           name = items[0]
           url1 = items[1]
           url2 = items[2]
           if url2 == '':
                self.okClicked2()
           else:       
                url2 = items[2]
                n2 = url1.find(".zip", 0)
                n3 = url1.rfind(name, 0, n2)
                n4 = n3 + len(name) + 1
                url0 = url1[:n4] 
                pass#print  "url0 =", url0
                xurl = url2
                xdest = "/tmp/down.txt"
                self.line = line
                self.version = version
                self.name = name
                self.url1 = url1
                self.url2 = url2
                self.url0 = url0 
#                fpage = urlopen(url2).read()
                downloadPage(xurl, xdest).addCallback(self.getdown).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def getdown(self, fplug):                
                fpage = open("/tmp/down.txt", "r").read()
                
                if self.url2.endswith(".xml"):
                        rx = '"' + self.name + '".*?version="(.*?)"'
                else:
                        rx = self.name + '-(.*?).zip'
                match = re.compile(rx,re.DOTALL).findall(fpage)
                pass#print  "match =", match
                if len(match) == 0:
                        rx = self.name + '_(.*?).zip'
                        match = re.compile(rx,re.DOTALL).findall(fpage)
                        pass#print  "match 2=", match
                try:        
                        latest = self.findmax(match)
                except:        
                        latest = max(match) 
                latest = latest.replace("%7E", "~")                       
                pass#print  "latest =", latest
                pass#print  "self.version =", self.version
                if latest != self.version:
                    if not self.url1.endswith(".zip"):  #datadirectory zip false
                        self.session.open(GetaddonsA3, self.line)           
                    else:
                        self.xurl = self.url0 + latest + ".zip"
                        pass#print  "self.xurl =", self.xurl
                        txt = _("New version ") + latest + _(" is available. Update Now ?")
                        pass#print  "txt =", txt
                        self.session.openWithCallback(self.do_update, MessageBox, txt, type = 0)
                else:
                        self.okClicked2()
                               
    def findmax(self, match = []):
                A = []
                B = []
                C = []
                D = []
                E = []
                for item in match:
                        item = item.replace("%7E", "~")
                        x = item.split(".")
                        pass#print "x =", x
                        A.append(int(x[0]))
                lx = len(x)        
                Amax = max(A) 
                maxitem = str(Amax)
                if lx > 1:
                    for item in match:        
                        x = item.split(".")
                        if int(x[0]) == int(Amax):
                                B.append(int(x[1]))
                        else:
                                continue         
                    Bmax = max(B) 
                    maxitem = str(Amax) + "." + str(Bmax)
                    if lx > 2:
                      for item in match:        
                        x = item.split(".")
                        if (int(x[0]) == int(Amax)) and (int(x[1]) == int(Bmax)):
                                C.append(int(x[2]))
                      Cmax = max(C) 
                      maxitem = str(Amax) + "." + str(Bmax) + "." + str(Cmax)                         
                return maxitem        

    def do_update(self, answer):
                if answer is None:
                       self.okClicked2()
                else:
                       if answer is False:
                               self.okClicked2()
                       else:
                               xurl = self.xurl
                               pass#print  "self.xurl=", self.xurl
                               xdest = "/tmp/plug.zip"
	                       downloadPage(xurl, xdest).addCallback(self.install).addErrback(self.showError)

    def install(self, fplug):
                fdest = THISPLUG + "/plugins"
                addon = THISPLUG + "/plugins/" + self.name
                cmd1 = "rm -rf '" + addon + "'" 
                cmd2 = " unzip -o -q '/tmp/plug.zip' -d '" + fdest + "'"
                cmd3 = " cp -f '" + THISPLUG + "/xpath.py' " + addon 
                cmd = cmd1 + " && " + cmd2 + " && " + cmd3
                pass#print "cmd =", cmd
                title = _("Installing ...")
                self.session.open(Console,_(title),[cmd])
#                self.session.openWithCallback(self.defaultpy,Console,_(title),[cmd])
                self.close()

##################################

    def okClicked(self):
#                if self.keylock:
#                   return    
    
                pass#print "In StartPlugin_mainmenu okClicked"
#                idx = self["menu"].getSelectionIndex()
                idx = self.index
                if DEBUG == 1:
                       pass#print "idx =", idx
                if idx == 0:
                       self.close()
                elif "Get more" in self.names[idx]:       
                       self.addon()
                else:       
                       self.name = self.names[idx]
                       pass#print "In StartPlugin_mainmenu okClicked B self.name =", self.name
########################################
                       if self.name.endswith("E2"):
                               self.runE2plug(self.name) 
                       else:        
                               self.checkUpd()


    def runE2plug(self, name):
           from Plugins.Extensions.KodiDirect.Execlist import Execlist
           Execlist(self.session, name)


    def okClicked2(self):
############################################                           
                       global SELECT
                       SELECT=[]
                       SELECT.append(self.name)
                       SELECT.append("1")
                       SELECT[1] = self.name
                       pass#print "In StartPlugin_mainmenu SELECT[0] =", SELECT[1]
		       self.id = self.name
		       f = open("/tmp/kodiplug.txt", "w")
		       tplug = self.id + "\n"
		       f.write(tplug)
		       f.close()
		       self.defaultpy()
		       #self.changepy()
		       self.checkImports()
		       
    def defaultpy(self):
        global THISADDON
        THISADDON = THISPLUG + "/plugins/" + self.id
        dpath = THISADDON + "/default.py"
        if not os.path.exists(dpath):
               fmod = self.findmod()
               cmd = "mv " + THISADDON + "/" + fmod + " " + THISADDON + "/default.py"
               pass#print "cmd =", cmd
               os.system(cmd)

        tfile = THISPLUG + "/added.txt"
        f = open(tfile, 'r')
        addtxt = f.read()
        f.close()

        fpath1 = THISPLUG + "/plugins/" + self.id 
        fpath2 = fpath1 + "/fixed2"
        if fileExists(fpath2):
            addtxt2 = "\nf = file('/tmp/e.log', 'a')\nsys.stdout = f\n"
            fpath = fpath1 + "/default.py"
            f = open(fpath, 'r')
            deftxt = f.read()
            f.close()
            if addtxt2 in deftxt:
               f1 = open('/tmp/default.txt', 'w')
               icount =0
               deftxt3 = deftxt.replace(addtxt2, "\n")
               f1.write(deftxt3)
               
               f.close()
               f1.close()
               cmd = "rm " + fpath + " && cp /tmp/default.txt " + fpath  
               os.system(cmd)
            else:
               pass  
               
        else:                   
            fpath = fpath1 + "/default.py"
            f = open(fpath, 'r')
            deftxt = f.read()
            pass#print "In defaultpy deftxt =", deftxt
            x = ord(deftxt[0])
            x1 = ord(deftxt[1])
            x2 = ord(deftxt[2])
            x3 = ord(deftxt[3])
            xm = max([x,x1,x2,x3]) 
            pass#print "In defaultpy nonasci xm =",  xm
            if xm > 127:
                   n1 = deftxt.find("#", 0)
                   if n1 == -1:
                          n1 = 1000
                   n2 = deftxt.find("import", 0)
                   if n2 == -1:
                          n2 = 1000
                   n3 = deftxt.find("from", 0)
                   if n3 == -1:
                          n3 = 1000
                   nmin = min(n1, n2, n3)
                   pass#print "nmin =", nmin
                   deftxt = deftxt[nmin:]

            pass#print "In defaultpy deftxt B=", deftxt
            data = []
            data = deftxt.splitlines()
            f.close()            
            if addtxt not in deftxt:
               cmdrm = "rm " + fpath1 + "/xpath.py"
               os.system(cmdrm)
               f1 = open('/tmp/default.txt', 'w')
               icount =0
#               f = open(fpath, 'r')
               for line in data:
                   line = line.decode("ISO-8859-1")
                   line = line + "\n"
                   if not (line.startswith("#")):
                       if icount==0:
                          f1.write(addtxt)
                          icount = 1
                       else:
                          pass   
                   f1.write(line)
               f.close()
               f1.close()
               cmd = "rm " + fpath + " && cp /tmp/default.txt " + fpath  
               os.system(cmd)
            cmd1 = "touch " + fpath2
            os.system(cmd1)


    def findmod(self):
                xfile = THISADDON + "/addon.xml"
                pass#print "In plugin-py findmod xfile =", xfile
                f = open(xfile, "r")
                ftext = f.read()
                n1 = ftext.find("<extension", 0)
                n2 = ftext.find("library", n1)
                n3 = ftext.find('"', n2)
                n4 = ftext.find('"', (n3+1))
                fmod = ftext[(n3+1):n4]
                pass#print "Newmod =", fmod
                return fmod


######
    def dataAvail(self,rstr):
            
            if rstr:
               self.data1=self.data1+rstr
               if self.progressCallBack is not None:
                  self.progress=self.progress+"..."
                  self.progressCallBack(self.progress)
            #if self.progress_callback is not None:
               #self.progress_callback('Please wait..")
                                              

####
    def progressCallBack(self,progress):
        if progress is not None:
           if progress.startswith("Error"):
              self["info"].setText(progress)
              self.keylock=False
              return
           elif progress.startswith("Finished"):
              self["info"].setText(progress)
              self.stopSpinner()
              self.selection_changed()
              self.keylock=False
              return              
           else:   
              
              self["info"].setText(progress)
    def stream(self):

                self.picfold = config.plugins.kodiplug.cachefold.value+"/xbmc/pic"
                self.tmpfold = config.plugins.kodiplug.cachefold.value+"/xbmc/tmp"
                cmd = "rm " + self.tmpfold + "/*"
                system(cmd)
                system("rm /tmp/data.txt")
                system("rm /tmp/data.txt")
                system("rm /tmp/vidinfo.txt")
                system("rm /tmp/type.txt")
                if DEBUG == 1:
                       pass#print "DEBUG =", DEBUG
                if DEBUG == 1:
                       pass#print "StartPlugin_mainmenu self.arg =", self.arg
                cmd = "python " + self.arg
                cmd = cmd.replace("&", "\\&")
#                afile = file("/tmp/test.txt","w")       
#                afile.write("going in default.py")
#                afile.write(cmd)
                if DEBUG == 1:
                       pass#print "going in default-py Now =", datetime.datetime.now()
#                system(cmd)
#######################################
                fdef ='default'# NEWDEFPY[:-3]
                arg1 = THISPLUG + "/plugins/" + self.name + "/default.py"
                arg2 = "1"
                arg3 = ""
                arg4=config.plugins.kodiplug.cachefold.value
                sys.argv = [arg1,arg2, arg3,arg4]
                d = THISPLUG + "/plugins/" + self.name
                global THISADDON
                THISADDON = d
                self.plugin_id=self.name
                
                
                sys.argv = [arg1,arg2, arg3,arg4]
                d = THISADDON
                
#                dellog()       
                ###############################
                xpath_file=THISPLUG+"/plugins/"+self.name+"/xpath.py"
                fixed2_file=THISPLUG+"/plugins/"+self.name+"/fixed2"
                default_file=THISPLUG+"/plugins/"+self.name+"/default.py"
#                if not os.path.exists(xpath_file): 
                os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)                                       
#                if not os.path.exists(fixed2_file):
#                      os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)   
                cmd='python '+default_file+' 1 '+"'"+arg3+"'" 
                pass#print cmd 
#######################
                            
                self.container = eConsoleAppContainer()
#		self.container.appClosed.append(self.action)
                try:
		       self.container.appClosed.append(self.action)
                except:       
                       self.container.appClosed.connect(self.action) 			        
#		self.container.dataAvail.append(self.dataAvail)
                try:
		       self.container.dataAvail.append(self.dataAvail)
                except:       
                       self.container.dataAvail.connect(self.dataAvail) 	               
  	        self.keylock=True               
     
               
                           #self.debug=False
                self.cancel=False           
                self.data1=''
			
#                if os.path.exists("/tmp/KodiDirect_log"):
#                    os.remove("/tmp/KodiDirect_log")
                    
                if os.path.exists("/tmp/data.txt"):
                   os.remove("/tmp/data.txt")                
                timen = time.time() 
                global NTIME 
                NTIME = timen
                timenow = timen - NTIME
                print"In StartPlugin_mainmenu2 timenow", timenow
                """
                if DEBUG == 1:
                       pass#print "In StartPlugin_mainmenu cmd =", cmd
                       self.lastcmd = cmd
                       os.system(cmd)
                       self.action(" ")
                else:
                       self.container.execute(cmd) 
                """ 
                pass#print "In StartPlugin_mainmenu2 cmd =", cmd
                self.dtext = " "
                self.lastcmd = cmd
                self.p = os.popen(cmd)
                self.timecount = 0
                self.updateTimer.start(self.timeint)

              
    def updateStatus(self):
         ncount = config.plugins.kodiplug.wait.value
#         nct = int(ncount)/4
         self.timecount = self.timecount + 1
         pass#print "In StartPlugin_mainmenu2 updateStatus self.timecount =", self.timecount
         self.dtext = self.p.read()
         pass#print "IIn StartPlugin_mainmenu2 updateStatus self.dtext =", self.dtext
         if "data B" in self.dtext:
                self.updateTimer.stop()
                self.action(" ")
         pass#print "In StartPlugin_mainmenu2 self.timecount =", self.timecount 
         if self.timecount > self.nct:     
              self.updateTimer.stop()
              self.action(" ")
                  
    def action(self,retval):
    
                            
            self.keylock=False
            self.names2 = []
            self.urls2 = []
            self.pics2 = []
            self.names2.append("Exit")
            self.urls2.append(" ")
            if config.plugins.kodiplug.skinres.value == "fullhd":
                                exitpic = THISPLUG + "/skin/images/ExitL.png"
            else:
                                exitpic = THISPLUG + "/skin/images/Exit.png"
            self.pics2.append(exitpic)
            self.names2.append("Setup")
            self.urls2.append(" ")
            setpic = THISPLUG + "/skin/images/Setup.png"
            self.pics2.append(setpic)
            self.names2.append("Favorites")
            self.urls2.append(" ")
            favpic = THISPLUG + "/skin/images/Favourite.png"
            self.pics2.append(favpic)            
            
            self.data = []
            self.tmppics2 = []
            self.lines = []
            self.vidinfo = []
            afile = open("/tmp/test.txt","w")       
            afile.write("\nin action=")
            datain = " "
            parameters = []
#            self.stopSpinner()
            self.data = []
            pass#print "StartPlugin_mainmenu2 self.dtext =", self.dtext
            data = self.dtext.splitlines()
            for line in data:
                   pass#print "StartPlugin_mainmenu2 line =", line
                   if not "data B" in line: continue
                   else: 
                         i1 = line.find("&", 0)
                         line1 = line[i1:]
                         self.data.append(line1)
            pass#print "StartPlugin_mainmenu2 self.data =", self.data
            

            if len(self.data) == 0:
#                 self.lastcmd = self.lastcmd + " > /tmp/e1.log 2>&1 &"
                 f1=open('/tmp/e.log',"w+")
                 f1.write(self.dtext)
                 self.error=(_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen"))
                 self["info"].setText(self.error)
                 return
            """
            if not path.exists("/tmp/data.txt"):
#                 self.lastcmd = self.lastcmd + " > /tmp/e1.log 2>&1 &"
                 self.lastcmd = self.lastcmd + " > /tmp/e1.log 2>&1"
                 os.system(self.lastcmd)
                 jointext("/tmp/e.log", "/tmp/e1.log")
                 self.error=(_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen"))
                 self["info"].setText(self.error)
                 return
            else:
                 self.selection_changed() 
                 if not path.exists("/tmp/vidinfo.txt"):
                       pass
                 else:
                       myfile = file(r"/tmp/vidinfo.txt")       
                       icount = 0
                       vinfo = myfile.read()
                       myfile.close()
                       self.vidinfo = vinfo.split("ITEM")
                 
                 myfile = open(r"/tmp/data.txt")       
                 icount = 0
                 for line in myfile.readlines():
                        datain = line[:-1]
                        self.data.append(icount)
                        self.data[icount] = datain
                        icount = icount+1
                 myfile.close()
            """ 
            n1 = 0
            if n1 == 0:    
                 inum = len(self.data)
                 i = 0
                 while i < inum:
                        name = " "
                        url = " "
                        line = self.data[i]
                        pass#print "StartPlugin_mainmenu line =", line
                        params = parameters_string_to_dict(line)
                        self.lines.append(line)
                        try:
                               name = params.get("name")
                               name = name.replace("AxNxD", "&")
                               name = name.replace("ExQ", "=")
                        except:
                               pass
                        try:
                              url = params.get("url")
                              url = url.replace("AxNxD", "&")
                              url = url.replace("ExQ", "=")
                        except:
                              pass
                        try:
                              pic = params.get("thumbnailImage")
                              if (pic == "DefaultFolder.png"):
                                     pic = THISPLUG + "/skin/images/default.png"
                        except:
                              pic = THISPLUG + "/skin/images/default.png"
                        self.name = name
                        self.names2.append(name)
                        self.urls2.append(url)
                        self.pics2.append(pic)
                        i = i+1
                 if (len(self.names2) == 2) and (self.urls2[1] is None) and (THISPLUG not in self.names2[1]):
                        if ("rtmp" in self.names2[1]):
                            if "live" in name:
                                name = self.name
                                desc = " "
                                url = self.names2[1]
#                                self.session.open(Showrtmp2, name, url, desc)
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                           
                            else:
                                name = self.name
                                desc = " "
                                url = self.names[1]
#                                self.session.open(Showrtmp, name, url, desc)
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()  

                        else:        
                                name = self.name                                
                                desc = " "
                                url = self.names2[1]
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                 elif (len(self.names2) == 2) and (self.urls2[1] is not None) and (THISPLUG not in self.urls2[1]):
                                name = self.name                                
                                desc = " "
                                url = self.urls2[1]
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                 else:        
                        if DEBUG == 1:
                                pass#print "StartPlugin_mainmenu self.names2 =", self.names2
                                pass#print "StartPlugin_mainmenu self.urls2 =", self.urls2
                                pass#print "StartPlugin_mainmenu self.pics2 =", self.pics2
#                        self.tmppics2 = getpics(self.names2, self.pics2, self.tmpfold, self.picfold)

                        self.tmppics2 = []
                        for name in self.names2:
                               self.tmppics2.append(name)
                        
                        if self.cancel==True:
                           return
                        self.session.open(XbmcPluginScreen, self.id, self.names2, self.urls2, self.tmppics2,1)

                     
####################################
####################################
class StartPlugin_mainmenu(Screen):
    def __init__(self, session):
		Screen.__init__(self, session)
		self.skinName = "xbmc4"
                title = (_("Addons"))
                self.setTitle(title)
                self.session=session
                self["bild"] = startspinner()
                self.spinner_running=False
                self["label1"] = StaticText("")
		self["label2"] = StaticText("")
		self["label20"] = StaticText("")
		self["label3"] = StaticText("")
		self["label30"] = StaticText("")
		self["label4"] = StaticText("")
		self["info"] = Label()
		global newstext
		news = newstext
		self.cancel=False
		self.data1=''
		self.keylock=False
		self.progress=(_("please wait.."))
#		pass#print "In StartPlugin_mainmenu newstext =", newstext
                n1 = news.find("update2", 0)
                if n1 > -1:
                       upd = news[n1:(n1+14)]
		else:
		       upd = "None"
		if fileExists("/etc/kodiupd"):       
		   myfile = file(r"/etc/kodiupd")
                   icount = 0
                   for line in myfile.readlines():
                       if icount == 0:
                              upd1 = line
                              break
                       icount = icount+1
                   myfile.close()
                else:   
                   upd1 = "None"
                n2 = upd1.find(".", 0)
                if n2 > -1:   
                       upd1 = upd1[:n2]
                updA = upd.replace("update", "")       
                upd1A = upd1.replace("update", "")
                if upd != "None":       
                       txt1 = (_("Installed update")) + upd1A + (_("   Available update")) + updA
                else:       
                       txt1 = " "
		txt = txt1
                self["info"].setText(txt)

		self["pixmap"] = Pixmap()
		self["pixmap1"] = Pixmap()
		self.list = []                
                self["menu"] = List(self.list)
                self["menu"] = RSList([])
#		self["info"] = Label()
		self["pixmap"] = Pixmap()
		self.progress=(_("Please wait.."))
		self["key_red"] = Button(_("Delete addons"))
		self["key_green"] = Button(_("Software"))
		self["key_yellow"] = Button(_("Config"))
		self["key_blue"] = Button(_("Tips"))
                system("rm /tmp/select.txt")
                
                
                self["menu"].onSelectionChanged.append(self.selection_changed)
                self.onShown.append(self.selection_changed)                
                self["actions"] = NumberActionMap(["OkCancelActions", "ColorActions", "DirectionActions","EPGSelectActions"],{
                       "upRepeated": self.up,
                       "downRepeated": self.down,
                       "up": self.up,
                       "down": self.down,
                       "left": self.left,
                       "right":self.right,
                       "red": self.delete,
		       "green": self.soft,
		       "yellow": self.conf,
		       "blue": self.howto,
                       "ok": self.okClicked,
                       "info":self.showerror,                     
                       "cancel": self.exit,}, -1)
########################
                self.updateTimer = eTimer()
                try:
                      self.updateTimer_conn = self.updateTimer.timeout.connect(self.updateStatus)
                except AttributeError:
                      self.updateTimer.callback.append(self.updateStatus)
                self.timecount = 0
                ncount = config.plugins.kodiplug.wait.value 
                nc = int(ncount)*1000
                timeint = int(float(nc/120))
#                if timeint < 1000: timeint = 1000
                pass#print "timeint =", timeint
                self.timeint = 1000
                self.nct = int(float(nc/timeint))
                pass#print "self.nct =", self.nct
#		self.updateTimer.start(timeint)
#		self.updateStatus()
########################                

                      
                self.pos = 0
                self.num = 0
                self.urls = []
                self.names = []
                self.shortnms = []
                self.data = []
                self.missed = " "
                self.shlist = " "
                self.onLayoutFinish.append(self.listplugs)

    def conf(self):            
          self.session.open(XbmcConfigScreen)

    def howto(self):            
          from Plugins.Extensions.KodiDirect.lib.XBMChelpinfo import XBMChelpinfo
          self.session.open(XBMChelpinfo)      

    def startSpinner(self):
        if self.spinner_running==False:
          Bilder=buildBilder()
          self["bild"].start(Bilder)
          self.spinner_running=True
          return    
    def stopSpinner(self):
       if self.spinner_running==True:
          self["bild"].stop()
          self.spinner_running=False
          self['bild'].instance.setPixmap(gPixmapPtr())
       #self["bild"]=None
       return 
       
    def stoprun(self):
                self.close() 
		try:
			
			self.container.appClosed.remove(self.runFinished)
			self.container.dataAvail.remove(self.dataAvail)
                        self.progressCallBack(_("Finished"))    
                except:
                        pass
    
                        
                        
    def exit(self):
        os.system("rm /tmp/*.png")
        if config.plugins.kodiplug.picdel.value is True:
                        picfold = config.plugins.kodiplug.cachefold.value + "/xbmc/pic"
                        cmd = "rm -rf " + picfold
                        os.system(cmd)
        if self.spinner_running==True:
           self.cancel=True
           self.keylock=False
           self.progressCallBack(_("Finished"))
           self.stoprun()
                     
           
           
        else:
           self.stopSpinner()   
           
           self.close()          
            
    
           

                        
                         
                
    def showerror(self):
       from Plugins.Extensions.KodiDirect.lib.XBMCAddonsinfo import XBMCAddonsinfoScreen
       self.session.open(XBMCAddonsinfoScreen,None)
    
    def delete(self):
                if self.keylock:
                   return
#                self.session.open(DelAdd) 
                self.session.openWithCallback(self.listplugs, DelAdd)           

    def addon(self):
                if self.keylock:
                   return    
#                self.session.open(Getaddons)
                self.session.openWithCallback(self.listplugs, Getadds)           

    def script(self):
                if self.keylock:
                   return    
    
                url ="http://mirrors.kodi.tv/addons/jarvis/"
                self.session.open(Scripts, url)           

    def soft(self):
                if self.keylock:
                   return    
                url ="http://www.xtrend-alliance.com/XbmcAddon/Software/listkodi.txt"
##                url ="http://www.xtrend-alliance.com/XbmcAddon/Software2/listkodi.txt"

                self.session.open(Software, url)


    def selection_changed(self):
      self.keylock=False
      
      
      try:
        pos = self["menu"].getSelectionIndex()
        name = self.names[pos]    
#        self["info"].setText(name)
      except:
        pass
#        self["info"].setText(" ")
    def checkImports(self):
                xmfile = THISPLUG+"/plugins/"+self.id+"/resources/settings.xml"
                tmpfile = THISPLUG+"/ofile.xml"
                if os.path.exists(xmfile):
                       f = open(xmfile, "r")
                       f1 = open(tmpfile, "w")
                       ftxt = f.read()
                       ftxt = ftxt.decode("ISO-8859-1")
                       f1.write(ftxt)
                       f.close()
                       f1.close()
                       pass#print "Here in checkImports copying /tmp/ofile.xml to ", xmfile 
                       cmd = "cp -f " + tmpfile + " " + xmfile + " && rm " + tmpfile
                       pass#print "Here in checkImports cmd ", cmd 
                       os.system(cmd)
                


                self.shlist = " "
                self.plugins=" "
                scripts = THISPLUG + "/scripts"
                for name in os.listdir(scripts):
#                       if "script." in name:
                              self.shlist = self.shlist + name + " "
                              
                plugins = THISPLUG + "/plugins"
                for name in os.listdir(plugins):
#                       if "script." in name:
                              self.plugins = self.plugins + name + " "                              
                              
                import xbmcaddon
                try:
                  sys.argv[0]=THISPLUG+"/plugins/"+self.id+"/default.py"
                except:
                  import sys
                  sys.argv=[]
                  sys.argv.append(THISPLUG+"/plugins/"+self.id+"/default.py")
                update_xbmc_text(self.id)                  
                addon = xbmcaddon.Addon(self.id)
                path = addon.getAddonInfo("path")
                pass#print "In checkImports self.id =", self.id 
                pass#print "In checkImports path =", path            
                xfile = path + "/addon.xml" 
                tree = xml.etree.cElementTree.parse(xfile)
                root = tree.getroot()
                self.missed = ""
                i = 0
                try:
                  for x in root.iter('import'):
                    addon = x.get('addon') + " " #to get xbmcswift not xbmcswift2
                    if "xbmc.python" in addon:
                          continue
                    if "xbmc.addon" in addon:
                          continue      
                    if addon in self.shlist or addon in self.plugins:
                          continue
                    self.missed = self.missed + " " + addon
                    i = 1                 
                except:
                  for x in root.getiterator('import'):
                    addon = x.get('addon') + " "
                    if "xbmc.python" in addon:
                          continue
                    if "xbmc.addon" in addon:
                          continue          
                    if addon in self.shlist or addon in self.plugins:
                          continue
                    self.missed = self.missed + " " + addon
                    i = 1 
                if i == 1:
#                    self.session.openWithCallback(self.error, MessageBox, self.missed, type = 3, timeout = 20)
                    self.download(self.missed)

                else:
                    arg = "'" + THISPLUG.strip() + "/plugins/" + self.name.strip() + "/default.py' '1' ''"
                    self.arg = arg
                    self.stream()    

    def download(self, missed):
          url ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/list.txt"
          sclist = urlopen(url).read()

          url1 ="http://mirrors.kodi.tv/addons/jarvis/addons.xml"
          fdlist = urlopen(url1).read()

          pass#print "missed = [", missed

          items = missed.split(" ") 
          pass#print "items =", items
          commands = []   
          for item in items:
             pass#print "In download item =", item
             sitem = 'addon id="' + item
             n1 = fdlist.find(sitem, 0)
             if n1 < 0:
                  if item in sclist:
                             plug = item + ".zip"
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
                  else:
                             txt = item + " not found"
                             self["info"].setText(txt)
#                             return

             else:
               n2 = fdlist.find('version="', n1)
               n3 = fdlist.find('"', (n2+10))
               ver = fdlist[(n2+9):n3]      
               itemurl = "http://mirrors.kodi.tv/addons/jarvis/" + item + "/" + item + "-" + ver + ".zip"
             
               if "script." in item:
                             plug = item
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' '" + itemurl + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Sc=", cmd
               elif "plugin.video" in item:
                             plug = item
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' '" + itemurl + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Ad=", cmd
          title = (_("Installing addons ")) + missed
          pass#print "commands= ", commands
          self.session.open(Console,_(title), commands)
          self.close()

    def download2(self, item):
                  commands = []
                  url ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/list.txt"
                  sclist = urlopen(url).read()
                  if item in sclist:
                             plug = item + ".zip"
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/kodi/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)

                             title = (_("Installing addons "))
                             self.session.open(Console,_(title), commands)
                             self.close()
                  else:
                             txt = item + " not found"
                             self["info"].setText(txt)
                             return



    def downloadXX(self, missed):
          pass#print "missed = [", missed
          items = missed.split(" ") 
          pass#print "items =", items
          ebuf = []
          fileslist = []
          icount = 0
          for item in items:
                fileslist.append(icount)
                fileslist[icount] = (_(item), "")
                if item == "":
                       continue
                ebuf.append(fileslist[icount])
                icount = icount + 1
          pass#print "ebuf=", ebuf             
          self.session.openWithCallback(self.donemiss, ChoiceBox, title="Install missing item & Restart KodiDirect:- ", list=ebuf)

    def donemiss(self, res):
       if res is None:
                 self.close()
       else:          
          pass#print "res=", res   
          pass#print "In donemiss res[0] =", res[0] 
          global HOST
          HOST = ""
##          url = HOST + res[0] + "/"
          url = res[0] + "/"
          url1 = "http://mirrors.kodi.tv/addons/jarvis/" + res[0] + "/"
          if "plugin.video" in res[0]:       
                 self.session.open(Addons2, res[0], url)
          else:       
                 self.session.open(Scripts2, res[0], url1)


    def downloadX(self, missed):
    
          url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/list5.txt"
          adlist = urlopen(url1).read()
          self.addata = adlist.splitlines()
          url2 ="http://www.xtrend-alliance.com/XbmcAddon/Script-modules/list4.txt"
          sclist = urlopen(url2).read()
          self.scdata = sclist.splitlines()
          
          items = missed.split(" ") 
          pass#print "items =", items
          commands = []   
          for item in items:
             if "script." in item:
                for scr in self.scdata:
                      if item in scr:
                             plug = scr
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Script-modules/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Sc=", cmd
             elif "plugin.video" in item:
                for ad in self.addata:
                      if item in ad:
                             plug = ad
                             fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                             dest = "/tmp/" + plug
                             cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Addons/" + plug + "'"
                             cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                             cmd = cmd1 + " && " + cmd2
                             commands.append(cmd)
#                             pass#print "cmd Ad=", cmd
          title = (_("Installing addons "))
#          pass#print "commands= ", commands
          self.session.open(Console,_(title), commands)
          self.close()




    def up(self):
         if self.keylock:
                   return
         dedesc = " "
         endesc = " "
         itdesc = " "
         self["menu"].up()
         self.pos = self.pos - 1
         num = len(self.names)
         if self.pos == -1:
                self.pos = num - 1
                self["menu"].moveToIndex(self.pos) 
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc= self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")  
                
    def down(self):
         if self.keylock:
                   return    
    
         dedesc = " "
         endesc = " "
         itdesc = " "

         self["menu"].down()
         self.pos = self.pos + 1
         num = len(self.names)
         if self.pos == num:
                self.pos = 0
                self["menu"].moveToIndex(0)  
         name = self.names[self.pos]
         if DEBUG == 1:
                pass#print "name =", name
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                if DEBUG == 1:
                       pass#print "name B=", name
                pname, version, prov, desc= self.getinfo(name)

                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                desc = desc.replace(":", "-")
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")  
                
    def left(self):
         if self.keylock:
                   return
         self["menu"].pageUp()
         self.pos = self["menu"].getSelectionIndex()
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc = self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap1"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ")                        
                self.error=None
    def right(self):
         if self.keylock:
                   return
         self["menu"].pageDown()
         self.pos = self["menu"].getSelectionIndex()
         name = self.names[self.pos]
         if self.pos > 0:
                pic1 = THISPLUG + "/plugins/" + name + "/icon.png"
                self["pixmap1"].instance.setPixmapFromFile(pic1)
                pname, version, prov, desc = self.getinfo(name)
                
                self["label1"].setText(pname)
                self["label20"].setText("Version :")
                self["label2"].setText(version)
                self["label30"].setText("Provider :")
                self["label3"].setText(prov)
                self["label4"].setText(desc)
         else:      
                if self.pos == 0:
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                                pic1 = THISPLUG + "/skin/images/ExitL.png"
                       else:
                                pic1 = THISPLUG + "/skin/images/Exit.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                self["label1"].setText(" ")
                self["label20"].setText(" ")
                self["label2"].setText(" ")
                self["label30"].setText(" ")
                self["label3"].setText(" ")
                self["label4"].setText(" ") 
                                      

    def getinfo(self, name):            
                xfile = THISPLUG + "/plugins/" + name + "/addon.xml"
                dedesc = ' '
                endesc = ' '
                itdesc = ' '
                try:tree = xml.etree.cElementTree.parse(xfile)
                except: return "", "", "", ""
                root = tree.getroot()
                pname = str(root.get('name'))
                version = str(root.get('version'))
                prov = str(root.get('provider-name'))
                try:
                    for description in root.iter('description'):
                        lang = description.get('lang')
                        desc = str(description.text)
                        if lang == "de":
                              dedesc = desc
                        elif lang == "it":
                              itdesc = desc      
                        else:      
                              endesc = desc
                except:
                    for description in root.getiterator('description'):
                        lang = description.get('lang')
                        desc = str(description.text)
                        if lang == "de":
                              dedesc = desc
                        elif lang == "it":
                              itdesc = desc      
                        else:      
                              endesc = desc
                              
                if config.osd.language.value == "de_DE":
                              desc2 = dedesc
                elif config.osd.language.value == "it_IT":
                              desc2 = itdesc                               
                else:
                              desc2 = endesc
                if desc2 == ' ':
                              desc2 = endesc               
                              
                return pname, version, prov, desc2
                
    def listplugs(self):
                pass#print "In listplugs 1"
                url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                fpage = urlopen(url1).read()
                n1 = fpage.find("Adult(18+)", 0)
                n2 = fpage.find("#####", n1)
                ftxt = fpage[n1:n2]
                pass#print "ftxt =", ftxt
                self.urls = []
                self.names = []
                self.shortnms = []
                path = THISPLUG + "/plugins"
                self.names.append("Exit")
                self.shortnms.append("Exit")
                self.urls.append("0")
                i = 1
                for name in os.listdir(path):
                    if "E2" in name:
                                     self.names.append(name)
                                     self.shortnms.append(name) 
                                     self.urls.append(i)
                                     i = i+1
                    
                    if "__init__" in name:
                       continue

                    if "plugin." not in name:
                       continue
                    elif "plugin.video.select" in name:
                       continue   
                    else:      
                       pass#print "config.ParentalControl.configured.value =", config.ParentalControl.configured.value
                       if name not in ftxt:
                              pass#print "In listplugs 2"
                              self.names.append(name)
                              name1 = name[13:]
                              self.shortnms.append(name1) 
                              self.urls.append(i)
                              i = i+1
                       else:        
                              if config.ParentalControl.configured.value: 
                                     continue
                              else:
                                     self.names.append(name)
                                     name1 = name[13:]
                                     self.shortnms.append(name1) 
                                     self.urls.append(i)
                                     i = i+1
                              
                self.num = i
                self.names.append("Get more......")
                self.shortnms.append("Get more......")
                self.urls.append("0")
                showlist(self.shortnms, self["menu"])
##################################               
    def checkUpd(self):           
                pass#print "In checkUpd self.name = ", self.name
                tfile = THISPLUG + "/plugins/" + self.name + "/addon.xml"
                f = open(tfile, "r")       
                txt = f.read()
                pass#print "In checkUpd txt = ", txt
                n1 = txt.find('<addon', 0)
                n11 = txt.find('id', n1)
                n2 = txt.find("version", n11)
                n3 = txt.find('"', n2)
                n4 = txt.find('"', (n3+2))
                version = txt[(n3+1):n4]
                pass#print "In checkUpd version = ", version
                f.close()
                surl ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                fpage = urlopen(surl).read()
#                tfile2 = THISPLUG + "/adlist.txt"      
#                f2 = open(tfile2, "r")
#                fpage = f2.read()
                lines = fpage.splitlines()
                
#                f2.close()
                nlist = 0
                for line in lines: 
#                       pass#print "In checkUpd line =", line
#                       pass#print "In checkUpd self.name B=", self.name   
                       if line.startswith("#####"):
                             continue
                       elif "###" not in line:
                             continue  
                       elif self.name in line:  
                             nlist = 1 #addon in adlist.txt    
#                             pass#print "In checkUpd line B=", line
#                             pass#print "In checkUpd self.name c=", self.name   
                             items = line.split("###")
                             n = len(items)
#                             pass#print "In checkUpd items =", items
                             name = items[0]
                             url1 = items[1]
                             if items[2] != '': 
                                   url2 = items[2]
                                   self.checkLine(line, version) 
                                   break
                             else:      
                                   pass#print "In checkUpd going in self.okClicked2 "
                                   self.okClicked2()
                       else:
                                   continue
                if nlist == 0: # user added addon
                       self.okClicked2()


    def checkLine(self, line, version):
           pass#print "In checkLine line =", line
           items = line.split("###")
           pass#print "In checkLine items =", items
           name = items[0]
           url1 = items[1]
           url2 = items[2]
           if url2 == '':
                self.okClicked2()
           else:       
                url2 = items[2]
                n2 = url1.find(".zip", 0)
                n3 = url1.rfind(name, 0, n2)
                n4 = n3 + len(name) + 1
                url0 = url1[:n4] 
                pass#print  "url0 =", url0
                xurl = url2
                xdest = "/tmp/down.txt"
                self.line = line
                self.version = version
                self.name = name
                self.url1 = url1
                self.url2 = url2
                self.url0 = url0 
#                fpage = urlopen(url2).read()
                downloadPage(xurl, xdest).addCallback(self.getdown).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def getdown(self, fplug):                
                fpage = open("/tmp/down.txt", "r").read()
                
                if self.url2.endswith(".xml"):
                        rx = '"' + self.name + '".*?version="(.*?)"'
                else:
                        rx = self.name + '-(.*?).zip'
                match = re.compile(rx,re.DOTALL).findall(fpage)
                pass#print  "match =", match
                if len(match) == 0:
                        rx = self.name + '_(.*?).zip'
                        match = re.compile(rx,re.DOTALL).findall(fpage)
                        pass#print  "match 2=", match
                try:        
                        latest = self.findmax(match)
                except:        
                        latest = max(match) 
                latest = latest.replace("%7E", "~")                       
                pass#print  "latest =", latest
                pass#print  "self.version =", self.version
                if latest != self.version:
                    if not self.url1.endswith(".zip"):  #datadirectory zip false
                        self.session.open(GetaddonsA3, self.line)           
                    else:
                        self.xurl = self.url0 + latest + ".zip"
                        pass#print  "self.xurl =", self.xurl
                        txt = _("New version ") + latest + _(" is available. Update Now ?")
                        pass#print  "txt =", txt
                        self.session.openWithCallback(self.do_update, MessageBox, txt, type = 0)
                else:
                        self.okClicked2()
                               
    def findmax(self, match = []):
                A = []
                B = []
                C = []
                D = []
                E = []
                for item in match:
                        item = item.replace("%7E", "~")
                        x = item.split(".")
                        pass#print "x =", x
                        A.append(int(x[0]))
                lx = len(x)        
                Amax = max(A) 
                maxitem = str(Amax)
                if lx > 1:
                    for item in match:        
                        x = item.split(".")
                        if int(x[0]) == int(Amax):
                                B.append(int(x[1]))
                        else:
                                continue         
                    Bmax = max(B) 
                    maxitem = str(Amax) + "." + str(Bmax)
                    if lx > 2:
                      for item in match:        
                        x = item.split(".")
                        if (int(x[0]) == int(Amax)) and (int(x[1]) == int(Bmax)):
                                C.append(int(x[2]))
                      Cmax = max(C) 
                      maxitem = str(Amax) + "." + str(Bmax) + "." + str(Cmax)                         
                return maxitem        

    def do_update(self, answer):
                if answer is None:
                       self.okClicked2()
                else:
                       if answer is False:
                               self.okClicked2()
                       else:
                               xurl = self.xurl
                               pass#print  "self.xurl=", self.xurl
                               xdest = "/tmp/plug.zip"
	                       downloadPage(xurl, xdest).addCallback(self.install).addErrback(self.showError)

    def install(self, fplug):
                fdest = THISPLUG + "/plugins"
                addon = THISPLUG + "/plugins/" + self.name
                cmd1 = "rm -rf '" + addon + "'" 
                cmd2 = " unzip -o -q '/tmp/plug.zip' -d '" + fdest + "'"
                cmd3 = " cp -f '" + THISPLUG + "/xpath.py' " + addon 
                cmd = cmd1 + " && " + cmd2 + " && " + cmd3
                pass#print "cmd =", cmd
                title = _("Installing ...")
                self.session.open(Console,_(title),[cmd])
#                self.session.openWithCallback(self.defaultpy,Console,_(title),[cmd])
                self.close()

##################################

    def okClicked(self):
                if self.keylock:
                   return    
    
                pass#print "In StartPlugin_mainmenu okClicked"
                idx = self["menu"].getSelectionIndex()
                if DEBUG == 1:
                       pass#print "idx =", idx
                if idx == 0:
                       self.close()
                elif "Get more" in self.names[idx]:       
                       self.addon()
                else:       
                       self.name = self.names[idx]
                       pass#print "In StartPlugin_mainmenu okClicked B self.name =", self.name
########################################
                       if self.name.endswith("E2"):
                               self.runE2plug(self.name) 
                       else:        
                               self.checkUpd()

    def runE2plug(self, name):
           from Plugins.Extensions.KodiDirect.Execlist import Execlist
           Execlist(self.session, name)

    def okClicked2(self):
############################################                           
                       global SELECT
                       SELECT=[]
                       SELECT.append(self.name)
                       SELECT.append("1")
                       SELECT[1] = self.name
                       pass#print "In StartPlugin_mainmenu SELECT[0] =", SELECT[1]
		       self.id = self.name
		       f = open("/tmp/kodiplug.txt", "w")
		       tplug = self.id + "\n"
		       f.write(tplug)
		       f.close()
		       self.defaultpy()
		       #self.changepy()
		       self.checkImports()
		       
    def defaultpy(self):
        global THISADDON
        THISADDON = THISPLUG + "/plugins/" + self.id
        dpath = THISADDON + "/default.py"
        if not os.path.exists(dpath):
               fmod = self.findmod()
               cmd = "mv " + THISADDON + "/" + fmod + " " + THISADDON + "/default.py"
               pass#print "cmd =", cmd
               os.system(cmd)

        tfile = THISPLUG + "/added.txt"
        f = open(tfile, 'r')
        addtxt = f.read()
        f.close()

        fpath1 = THISPLUG + "/plugins/" + self.id 
        fpath2 = fpath1 + "/fixed2"
        if fileExists(fpath2):
            addtxt2 = "\nf = file('/tmp/e.log', 'a')\nsys.stdout = f\n"
            fpath = fpath1 + "/default.py"
            f = open(fpath, 'r')
            deftxt = f.read()
            f.close()
            if addtxt2 in deftxt:
               f1 = open('/tmp/default.txt', 'w')
               icount =0
               deftxt3 = deftxt.replace(addtxt2, "\n")
               f1.write(deftxt3)
               
               f.close()
               f1.close()
               cmd = "rm " + fpath + " && cp /tmp/default.txt " + fpath  
               os.system(cmd)
            else:
               pass  
               
        else:                   
            fpath = fpath1 + "/default.py"
            f = open(fpath, 'r')
            deftxt = f.read()
            pass#print "In defaultpy deftxt =", deftxt
            x = ord(deftxt[0])
            x1 = ord(deftxt[1])
            x2 = ord(deftxt[2])
            x3 = ord(deftxt[3])
            xm = max([x,x1,x2,x3]) 
            pass#print "In defaultpy nonasci xm =",  xm
            if xm > 127:
                   n1 = deftxt.find("#", 0)
                   if n1 == -1:
                          n1 = 1000
                   n2 = deftxt.find("import", 0)
                   if n2 == -1:
                          n2 = 1000
                   n3 = deftxt.find("from", 0)
                   if n3 == -1:
                          n3 = 1000
                   nmin = min(n1, n2, n3)
                   pass#print "nmin =", nmin
                   deftxt = deftxt[nmin:]

            pass#print "In defaultpy deftxt B=", deftxt
            data = []
            data = deftxt.splitlines()
            f.close()            
            if addtxt not in deftxt:
               cmdrm = "rm " + fpath1 + "/xpath.py"
               os.system(cmdrm)
               f1 = open('/tmp/default.txt', 'w')
               icount =0
#               f = open(fpath, 'r')
               for line in data:
                   line = line.decode("ISO-8859-1")
                   line = line + "\n"
                   if not (line.startswith("#")):
                       if icount==0:
                          f1.write(addtxt)
                          icount = 1
                       else:
                          pass   
                   f1.write(line)
               f.close()
               f1.close()
               cmd = "rm " + fpath + " && cp /tmp/default.txt " + fpath  
               os.system(cmd)
            cmd1 = "touch " + fpath2
            os.system(cmd1)


    def findmod(self):
                xfile = THISADDON + "/addon.xml"
                pass#print "In plugin-py findmod xfile =", xfile
                f = open(xfile, "r")
                ftext = f.read()
                n1 = ftext.find("<extension", 0)
                n2 = ftext.find("library", n1)
                n3 = ftext.find('"', n2)
                n4 = ftext.find('"', (n3+1))
                fmod = ftext[(n3+1):n4]
                pass#print "Newmod =", fmod
                return fmod


######
    def dataAvail(self,rstr):
            
            if rstr:
               self.data1=self.data1+rstr
               if self.progressCallBack is not None:
                  self.progress=self.progress+"..."
                  self.progressCallBack(self.progress)
            #if self.progress_callback is not None:
               #self.progress_callback('Please wait..")
                                              

####
    def progressCallBack(self,progress):
        if progress is not None:
           if progress.startswith("Error"):
              self["info"].setText(progress)
              self.keylock=False
              return
           elif progress.startswith("Finished"):
              self["info"].setText(progress)
              self.stopSpinner()
              self.selection_changed()
              self.keylock=False
              return              
           else:   
              
              self["info"].setText(progress)
    def stream(self):

                self.picfold = config.plugins.kodiplug.cachefold.value+"/xbmc/pic"
                self.tmpfold = config.plugins.kodiplug.cachefold.value+"/xbmc/tmp"
                cmd = "rm " + self.tmpfold + "/*"
                system(cmd)
                system("rm /tmp/data.txt")
                system("rm /tmp/data.txt")
                system("rm /tmp/vidinfo.txt")
                system("rm /tmp/type.txt")
                if DEBUG == 1:
                       pass#print "DEBUG =", DEBUG
                if DEBUG == 1:
                       pass#print "StartPlugin_mainmenu self.arg =", self.arg
                cmd = "python " + self.arg
                cmd = cmd.replace("&", "\\&")
#                afile = file("/tmp/test.txt","w")       
#                afile.write("going in default.py")
#                afile.write(cmd)
                if DEBUG == 1:
                       pass#print "going in default-py Now =", datetime.datetime.now()
#                system(cmd)
#######################################
                fdef ='default'# NEWDEFPY[:-3]
                arg1 = THISPLUG + "/plugins/" + self.name + "/default.py"
                arg2 = "1"
                arg3 = ""
                arg4=config.plugins.kodiplug.cachefold.value
                sys.argv = [arg1,arg2, arg3,arg4]
                d = THISPLUG + "/plugins/" + self.name
                global THISADDON
                THISADDON = d
                self.plugin_id=self.name
                
                
                sys.argv = [arg1,arg2, arg3,arg4]
                d = THISADDON
                
#                dellog()       
                ###############################
                xpath_file=THISPLUG+"/plugins/"+self.name+"/xpath.py"
                fixed2_file=THISPLUG+"/plugins/"+self.name+"/fixed2"
                default_file=THISPLUG+"/plugins/"+self.name+"/default.py"
#                if not os.path.exists(xpath_file): 
                os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)                                       
#                if not os.path.exists(fixed2_file):
#                      os.system("cp -f "+THISPLUG+"/lib/xpath.py "+xpath_file)
#                      os.system("touch " + fixed2_file)   
                cmd='python '+default_file+' 1 '+"'"+arg3+"'" 
                pass#print cmd 
#######################
                            
                self.container = eConsoleAppContainer()
#		self.container.appClosed.append(self.action)
                try:
		       self.container.appClosed.append(self.action)
                except:       
                       self.container.appClosed.connect(self.action) 			        
#		self.container.dataAvail.append(self.dataAvail)
                try:
		       self.container.dataAvail.append(self.dataAvail)
                except:       
                       self.container.dataAvail.connect(self.dataAvail) 	               
  	        self.keylock=True               
     
               
                           #self.debug=False
                self.cancel=False           
                self.startSpinner()          
                self["info"].setText(self.progress)
                self.data1=''
			
#                if os.path.exists("/tmp/KodiDirect_log"):
#                    os.remove("/tmp/KodiDirect_log")
                    
                if os.path.exists("/tmp/data.txt"):
                   os.remove("/tmp/data.txt")                
                timen = time.time() 
                global NTIME 
                NTIME = timen
                timenow = timen - NTIME
                print"In StartPlugin_mainmenu timenow", timenow
                pass#print "In StartPlugin_mainmenu cmd =", cmd
                self.dtext = " "
                self.lastcmd = cmd
                self.p = os.popen(cmd)
                self.timecount = 0
                self.updateTimer.start(self.timeint)

              
    def updateStatus(self):
         ncount = config.plugins.kodiplug.wait.value
#         nct = int(ncount)/4
         self.timecount = self.timecount + 1
         pass#print "In StartPlugin_mainmenu updateStatus self.timecount =", self.timecount
         self.dtext = self.p.read()
         pass#print "In StartPlugin_mainmenu updateStatus self.dtext =", self.dtext
         if "data B" in self.dtext:
                self.updateTimer.stop()
                self.action(" ")
         pass#print "In StartPlugin_mainmenu self.timecount =", self.timecount 
         if self.timecount > self.nct:     
              self.updateTimer.stop()
              self.action(" ")
    
    def action(self,retval):
    
                            
            self.keylock=False
            self.names2 = []
            self.urls2 = []
            self.pics2 = []
            self.names2.append("Exit")
            self.urls2.append(" ")
            self.pics2.append(" ")
            self.names2.append("Setup")
            self.urls2.append(" ")
            self.pics2.append(" ")
            self.names2.append("Favorites")
            self.urls2.append(" ")
            self.pics2.append(" ")            
            
            
            self.tmppics2 = []
            self.lines = []
            self.vidinfo = []
            afile = open("/tmp/test.txt","w")       
            afile.write("\nin action=")
            datain = " "
            parameters = []
            self.stopSpinner()
            self.data = []
            pass#print "StartPlugin_mainmenu self.dtext =", self.dtext
            data = self.dtext.splitlines()
            for line in data:
                   pass#print "StartPlugin_mainmenu line =", line
                   if not "data B" in line: continue
                   else: 
                         i1 = line.find("&", 0)
                         line1 = line[i1:]
                         self.data.append(line1)
            pass#print "StartPlugin_mainmenu self.data =", self.data
            

            if len(self.data) == 0:
#                 self.lastcmd = self.lastcmd + " > /tmp/e1.log 2>&1 &"
                 f1=open('/tmp/e.log',"w+")
                 f1.write(self.dtext)
                 self.error=(_("Error! Submit log /tmp/e.log. For more info use button 'Tips' in first screen"))
                 self["info"].setText(self.error)
                 return
            """
            else:
                 self.selection_changed() 
                 if not path.exists("/tmp/vidinfo.txt"):
                       pass
                 else:
                       myfile = file(r"/tmp/vidinfo.txt")       
                       icount = 0
                       vinfo = myfile.read()
                       myfile.close()
                       self.vidinfo = vinfo.split("ITEM")
                 
                 myfile = open(r"/tmp/data.txt")       
                 icount = 0
                 for line in myfile.readlines():
                        datain = line[:-1]
                        self.data.append(icount)
                        self.data[icount] = datain
                        icount = icount+1
                 myfile.close()
            """
            inum = len(self.data)
            pass#print "StartPlugin_mainmenu inum =", inum
            n1 = 0
            if n1 == 0:
                 i = 0
                 while i < inum:
                        name = " "
                        url = " "
                        line = self.data[i]
                        pass#print "StartPlugin_mainmenu line =", line
                        params = parameters_string_to_dict(line)
                        self.lines.append(line)
                        try:
                               name = params.get("name")
                               name = name.replace("AxNxD", "&")
                               name = name.replace("ExQ", "=")
                        except:
                               pass
                        try:
                              url = params.get("url")
                              url = url.replace("AxNxD", "&")
                              url = url.replace("ExQ", "=")
                        except:
                              pass
                        try:
                              pic = params.get("thumbnailImage")
                              if (pic == "DefaultFolder.png"):
                                     pic = THISPLUG + "/skin/images/default.png"
                        except:
                              pic = THISPLUG + "/skin/images/default.png"
                        self.name = name
                        self.names2.append(name)
                        self.urls2.append(url)
                        self.pics2.append(pic)
                        i = i+1
                 if (len(self.names2) == 2) and (self.urls2[1] is None) and (THISPLUG not in self.names2[1]):
                        if ("rtmp" in self.names2[1]):
                            if "live" in name:
                                name = self.name
                                desc = " "
                                url = self.names2[1]
#                                self.session.open(Showrtmp2, name, url, desc)
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                           
                            else:
                                name = self.name
                                desc = " "
                                url = self.names[1]
#                                self.session.open(Showrtmp, name, url, desc)
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()  

                        else:        
                                name = self.name                                
                                desc = " "
                                url = self.names2[1]
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                 elif (len(self.names2) == 2) and (self.urls2[1] is not None) and (THISPLUG not in self.urls2[1]):
                                name = self.name                                
                                desc = " "
                                url = self.urls2[1]
                                self.progressCallBack("Finished")
                                self.session.open(Playvid, name, url, desc)
                                self.close()
                 else:        
                        if DEBUG == 1:
                                pass#print "StartPlugin_mainmenu self.names2 =", self.names2
                                pass#print "StartPlugin_mainmenu self.urls2 =", self.urls2
                                pass#print "StartPlugin_mainmenu self.pics2 =", self.pics2
                        self.tmppics2 = getpics(self.names2, self.pics2, self.tmpfold, self.picfold)
                        if self.cancel==True:
                           return
                        
                        self.session.open(XbmcPluginScreen, self.id, self.names2, self.urls2, self.tmppics2,1)




class Getadds(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("Please select install method"))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("Install methods")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                methods = []
                methods.append(_("Install from zip"))
                methods.append(_("Install from KodiDirect list"))
                methods.append(_("Install from Kodi official repositories"))
                methods.append(_("Install from other repositories"))
		showlist(methods, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          elif sel == 0:
                self.session.open(Getadds1)     
          elif sel == 1:
                self.session.open(Getaddons)           
          elif sel == 2:
                self.session.open(Getadds3)                  
          else:             
                self.session.open(Getadds4)
                

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Getadds1(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("Please put zip files in folders /tmp, /media/hdd or /media/usb."))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("File locations")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                picthumb = THISPLUG + "/skin/images/default.png"
                self["pixmap"].instance.setPixmapFromFile(picthumb)
                methods = []
                self.urls = []
                methods.append("/tmp")
                self.urls.append("/tmp")
                methods.append("/media/hdd")
                self.urls.append("/media/hdd")
                methods.append("/media/usb")
                self.urls.append("/media/usb")
		showlist(methods, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
          url = self.urls[sel]
	  if sel is None :
                self.close()
          else:             
                self.session.open(Getadds7, url)      

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Getadds7(Screen):

    def __init__(self, session, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("Please select"))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("User install")
		self["title"] = Button(title)	
                pass#print "In Getadds7 url =", url	
                self.url = url
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                self.names = []
                path = self.url
                pass#print "In Getadds7 path =", path	
                for root, dirs, files in os.walk(path):
	           for name in files:
		      if name.endswith(".zip"):
                             self.names.append(name)
                      else:
                             continue
                pass#print "In Getadds7 self.names =", self.names            
                showlist(self.names, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
          self.name = self.names[sel]
	  if sel is None :
                self.close()
          else:             
                xurl = self.url + "/" + self.name
                pass#print  "xurl=", xurl
               
                if self.name.startswith("repo"):
                       fdest = THISPLUG + "/repos"
                elif self.name.startswith("plugin."):
                       fdest = THISPLUG + "/plugins"
                adn = fdest + "/" + self.name 
                if os.path.exists(adn):
                       os.remove(adn)
                cmd = "unzip -o -q '" + xurl + "' -d '" + fdest + "'"
                pass#print "cmd =", cmd
                title = _("Installing ...")
                self.session.open(Console,_(title),[cmd])
                self.close()

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)


class Getadds3(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("WARNING ! Many repository addons may not work. This may be because they are not updated. This is not a KodiDirect error."))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("Kodi official repos")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                methods = []
                self.urls = []
                methods.append("Jarvis")
                self.urls.append("http://mirrors.kodi.tv/addons/jarvis/") 
                methods.append("Gotham")
                self.urls.append("http://mirrors.kodi.tv/addons/gotham/")
                methods.append("Helix")
                self.urls.append("http://mirrors.kodi.tv/addons/helix/")
                methods.append("Frodo")
                self.urls.append("http://mirrors.kodi.tv/addons/frodo/")
		showlist(methods, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
          url = self.urls[sel]
	  if sel is None :
                self.close()
          else:             
                self.session.open(Getadds5, url)      

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Getadds4(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("WARNING ! Many repository addons may not work. This may be because they are not updated. This is not a KodiDirect error."))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = _("Please select repo")
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                pic1 = THISPLUG + "/skin/images/Download.png"  
                self["pixmap"].instance.setPixmapFromFile(pic1)
                self.names = []
                self.urls = []
                path = THISPLUG + "/repos"
                pass#print "In Getadds4 path", path
                for name in os.listdir(path):
                       if "repository." not in name:
                              continue
                       else:
                              url = path + "/" + name + "/"
                       self.names.append(name)
                       self.urls.append(url)
                pass#print "In Getadds4 self.urls =", self.urls
                showlist(self.names, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          else:      
                name = self.names[sel]
                url = self.urls[sel]
                
                tfile = url + "addon.xml"
                pass#print "In Getadds4 tfile =", tfile
                f = open(tfile, "r")
                for line in f.readlines(): 
                      pass#print "In Repo line =", line
                      if "<info" in line:
                             n1 = line.find(">", 0)
                             n2 = line.find('<', n1)
                             infourl = line[(n1+1):n2]
                             pass#print "In Repo infourl A=", infourl
                      if "<datadir" in line:
                             n1 = line.find(">", 0)
                             n2 = line.find('<', n1)
                             plugurl = line[(n1+1):n2]
                             pass#print "In Repo plugurl =", plugurl
                             if "false" in line:
                                   zipcode = "false" 
                             else:
                                   zipcode = "true" 
                pass#print "In Repo infourl =", infourl 
                pass#print "In Repo plugurl =", plugurl
                pass#print "In Repo zipcode =", zipcode                  
                self.session.open(Repo2, infourl, plugurl, zipcode)   


    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Repo2(Screen):

    def __init__(self, session, infourl, plugurl, zipcode):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:       
                self.session=session
                self.skinName = "KodiMenusScreenB"
                self["bild"] = startspinner()
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = "Please select"
		self.infourl = infourl
		self.plugurl = plugurl
		self.zipcode = zipcode
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Addons"
		self["title"] = Button(title)		
                self.icount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       pic1 = THISPLUG + "/skin/images/Download.png"  
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.infourl
                       pass#print "In Repo2 xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "In Repo2 html = ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<add.*?id="(.*?)".*?version="(.*?)"'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       pass#print "In Repo2 match =", match
                       for name, url  in match:
                              if "plugin.video" not in name:
                                     continue
                              self.names.append(name)
                              self.urls.append(url)
		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.zipcode == "false":
                sel = self["menu"].getSelectionIndex()
                if sel is None:
                       self.close()
                name = self.names[sel]
                url1 = self.plugurl + name + "/"
                url2 = self.infourl
                line = name + "###" + url1 + "###" + url2 + "###"
                self.session.open(GetaddonsA3, line)

          else:      
                sel = self["menu"].getSelectionIndex()
                if sel is None:
                       self.close()
                name = self.names[sel]
                url = self.urls[sel]
                if self.plugurl.endswith("/"):
                       url = self.plugurl + name + "/" + name + "-" + url + ".zip?raw=true"
                else:
                       url = self.plugurl + "/" + name + "/" + name + "-" + url + ".zip?raw=true"       
                pass#print "In Repo2 url B= ", url 
                self.session.open(Addons3, name, url)

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)



class Repo3(Screen):

    def __init__(self, session, url, plugurl, zipcode):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
                self["bild"] = startspinner()
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = " "
		pass#print "In Repo3 url =", url		
		self.url = plugurl + url
		self.zipcode = zipcode
		pass#print "In Addons2 self.url =", self.url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Addons"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       pic1 = THISPLUG + "/skin/images/Download.png"  
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "Repo3 xurl=", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "Repo3 html = ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="plugin.video(.*?)">(.*?)</a><'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       for url, name in match:
                              name = name.replace("plugin.video.", "")
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                url = self.url + "/plugin.video" + url
                pass#print "Here in Repo3 name, url =", name, url 
                self.session.open(Addons3, name, url)

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)




class Getadds5(Screen):

    def __init__(self, session, url):
		Screen.__init__(self, session)
                self.session=session
                pass#print "Addons url =", url
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = " "
		self.url = url
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Addons"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       pic1 = THISPLUG + "/skin/images/Download.png"  
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "In Addons xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "In Getadds5 html = ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="(.*?)">(.*?)</a>(.*?)<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       pass#print "In Addons match =", match
                       for url, name, rev in match:
                              rev = rev.replace(" ", "")
                              rev = rev.replace("\n", "")
                              n1 = rev.find(":")
                              rev = rev[:(n1-2)]
                              name = name + " (" + rev + ")"  
                              url1 = self.url + url                            
                              if "plugin.video" not in name:
                                     continue
                              name = name.replace("/", "")
                              name = name.replace("()", "")
       
                              self.names.append(name)
                              self.urls.append(url1)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                pass#print "In Getadds5 url = ", url 
                self.session.open(Getadds6, name, url)
                       

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Getadds6(Screen):

    def __init__(self, session, name, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.name = name
		pass#print "In Getadds6 url =", url
		self.url = url
		pass#print "In Getadds6 self.url =", self.url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Addons"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       pic1 = THISPLUG + "/skin/images/Download.png"  
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "xurl 2=", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "html 2= ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="plugin.video(.*?)">(.*?)</a>(.*?)<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       for url, name, rev in match:
                              name = name + " :" + rev 
                              name = name.replace("plugin.video.", "")
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                url = self.url + "plugin.video" + url
                pass#print "Here in Getadds6 name, url =", name, url 
                self.session.open(Addons3, name, url)

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)




class Getaddons(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenB"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_("Please select category"))
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "KodiDirect list"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                if config.plugins.kodiplug.skinres.value == "fullhd":
                       pic1 = THISPLUG + "/skin/images/DownloadL.png"
                else:
                       pic1 = THISPLUG + "/skin/images/Download.png"
                self["pixmap"].instance.setPixmapFromFile(pic1)
                self.data = []
                cats = []
#                tfile = THISPLUG + "/adlist.txt"
#                myfile = open(tfile, 'r')      
                url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                myfile = urlopen(url1)  
                icount = 0
                for line in myfile.readlines(): 
                       if line.startswith("#####"):
                                     cat = line.replace("#####", "")
                                     cat = cat.replace("####", "")
                                     cats.append(cat)
                                     self.data.append(line)
		showlist(cats, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          else:      
                name = self.data[sel]
#                if "Frodo" in name:
#                       url = "http://mirrors.kodi.tv/addons/jarvis/"
#                       global HOST
#                       HOST = url
#                       self.session.open(Addons, url)
#                       self.close()
                if "Adult" in name:
                       self.catname = name
                       self.allow()
                else:       
                       self.session.open(GetaddonsA2, name)
                       self.close()

    def allow(self):	        
                perm = config.ParentalControl.configured.value
                #####pass#print "perm =", perm 
                
                if config.ParentalControl.configured.value:
			#####pass#print "Here Ad 1"
#                        from Screens.InputBox import InputBox, PinInput
			self.session.openWithCallback(self.pinEntered, PinInput, pinList = [config.ParentalControl.setuppin.value], triesEntry = config.ParentalControl.retries.servicepin, title = _("Please enter the parental control pin code"), windowTitle = _("Enter pin code"))

		else:
			#####pass#print "Here Ad 2"
                        self.pinEntered(True)
#		return
       
    def pinEntered(self, result):
		#####pass#print "Here Ad 3 result =", result
                if result:
                        self.session.open(GetaddonsA2, self.catname)
                        self.close()
		else:
			self.session.openWithCallback(self.close, MessageBox, _("The pin code you entered is wrong."), MessageBox.TYPE_ERROR)
         		self.close()
	        
                       
                       
                      

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)


class GetaddonsA2(Screen):

    def __init__(self, session, cat):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:       
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.cat = cat
		self.info = (_(" "))
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Please select to install"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.names = []
                self.urls = []
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                if config.plugins.kodiplug.skinres.value == "fullhd":
                       pic1 = THISPLUG + "/skin/images/DownloadL.png"
                else:
                       pic1 = THISPLUG + "/skin/images/Download.png"
                self["pixmap"].instance.setPixmapFromFile(pic1)
                self.data = []
#                tfile = THISPLUG + "/adlist.txt"
#                f = open(tfile, 'r')      
#                fpage = f.read()

                url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                fpage = urlopen(url1).read()
                n1 = fpage.find(self.cat)
                n2 = fpage.find("#####", (n1+10))
                fpage2 = fpage[n1:n2]
                lines = fpage2.splitlines()
                nms = []
                for line in lines: 
                       if line.startswith("#####"):
                             continue
                       elif "###" not in line:
                             continue 
                       else:
#                             pass#print "In GetaddonsA2 line =", line
                             items = line.split("###")
#                             pass#print "In GetaddonsA2 items =", items
                             nm = items[0]
                             nm = nm.replace("plugin.video.", "")
                             nm = nm.replace("plugin.audio.", "")
                             nm = nm.replace("plugin.image.", "")
                             nm = nm.replace("plugin.picture.", "")
                             nms.append(nm)
                             self.names.append(items[0])
                             self.urls.append(line)
                             
		showlist(nms, self["menu"])

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          else:      
                line = self.urls[sel]
                self.name = self.names[sel]
                self.checkLine(line)
                
    def checkLine(self, line):
           pass#print "In checkLine line =", line
           items = line.split("###")
           pass#print "In checkLine items =", items
           name = items[0]
           url1 = items[1]
           url2 = items[2]
           if url2 == '':
                return
           elif not items[1].endswith(".zip"):  #datadirectory zip false
                self.session.open(GetaddonsA3, line) 
                self.close()
           else:       
                url2 = items[2]
                n2 = url1.find(".zip", 0)
                n3 = url1.rfind("-", 0, n2)
                if n3 < 0:
                       n3 = url1.rfind("_", 0, n2)
                n4 = n3 + 1
                url0 = url1[:n4] 
                pass#print  "url0 =", url0
                
#                fpage = urlopen(url2).read()
                xurl = url2
                xdest = "/tmp/down.txt"
                self.line = line
                self.name = name
                self.url1 = url1
                self.url2 = url2
                self.url0 = url0 
#                fpage = urlopen(url2).read()
                downloadPage(xurl, xdest).addCallback(self.getdown).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def getdown(self, fplug):                
                fpage = open("/tmp/down.txt", "r").read()
#                pass#print "In checkLine fpage =", fpage
                if self.url2.endswith(".xml"):
                        rx = self.name + '.*?version="(.*?)"'
                else:
                        rx = self.name + '-(.*?).zip'
                match = re.compile(rx,re.DOTALL).findall(fpage)
                pass#print  "match =", match
                if len(match) == 0:
                        rx = self.name + '_(.*?).zip'
                        match = re.compile(rx,re.DOTALL).findall(fpage)
                        pass#print  "match 2=", match
                latest = max(match) 
                if latest is not None:
                        xurl = self.url0 + latest + ".zip"
                        pass#print  "xurl =", xurl
                        xdest = "/tmp/plug.zip"
                        downloadPage(xurl, xdest).addCallback(self.install).addErrback(self.showError)
                else:
                        return               

    def okClickedX(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          else:      
                xurl = self.urls[sel]
#                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                xdest = "/tmp/plug.zip"
	        downloadPage(xurl, xdest).addCallback(self.install).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def installOrig(self, fplug):
#                cmd1 = "wget -O '" + dest + "' '" + self.url + "'"
                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                cmd = "unzip -o -q '/tmp/plug.zip' -d " + fdest
                
                pass#print "cmd =", cmd
                title = (_("Installing addon"))
                self.session.open(Console,_(title),[cmd])
                self.close()

    def install(self, fplug):
#                cmd1 = "wget -O '" + dest + "' '" + self.url + "'"
                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                cmd = "unzip -o -q '/tmp/plug.zip' -d " + fdest
                
                pass#print "cmd =", cmd
                title = (_("Installing addon"))
                self.session.openWithCallback(self.checkName,Console,_(title),[cmd])
#                self.close()

    def checkName(self):
                path = THISPLUG + "/plugins"
                for name in os.listdir(path):
                       if "plugin" not in name:
                           if "__init" in name:
                               continue
                           elif "E2" in name:
                               continue
                           else:    
                               newname = "plugin.video." + name
                               cmd = "mv " + path + "/" + name + " " + path + "/" + newname + " &"
                               os.system(cmd) 
                       if "-master" in name:
                               newname = name.replace("-master", "")
                               cmd = "mv " + path + "/" + name + " " + path + "/" + newname + " &"
                               os.system(cmd) 
                self.close()


    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
		
class GetaddonsA3(Screen):

    def __init__(self, session, line):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:       
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self.line = line
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = (_(" "))
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Please select repository host"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onShown.append(self.openTest)

    def openTest(self):
           items = self.line.split("###")
           pass#print "In openTest items =", items
           name = items[0]
           url1 = items[1]
           url2 = items[2]
           fdest = THISPLUG + "/plugins/" + name 
           cmd = "mkdir -p " + fdest
           os.system(cmd)
           self.getfolder(name, url1, fdest)

    def getfolder(self, name, url, xdest):
                f = urlopen(url)
                fpage = f.read()
                f.close()
                pass#print "In Repo2 getfolder name, url C=", name, url
                pass#print "In Repo2 getfolder xdest=", xdest
                pass#print "In Repo2 getfolder fpage =", fpage
                regexcat = '<li><a href="(.*?)">.*?</a><'
                match = re.compile(regexcat,re.DOTALL).findall(fpage)
                for url1 in match:
                       if "../" in url1:
                              continue
                              
                       if url1.endswith("/"):
                              url2 = url + url1
                              xdest4 = xdest + "/" + url1
                              pass#print "In Repo2 getfolder name, url D=", name, url
                              pass#print "In Repo2 getfolder xdest4 D=", xdest4
                              if not os.path.exists(xdest4):
                                     cmd = "mkdir " + xdest4
                                     os.system(cmd)
                              
                              self.foldback(name, url2, xdest4)     
                       else:       
                              url2 = url + url1
                              pass#print "In Repo2 getfolder url2 =", url2
                              f2 = urlopen(url2)
                              fpage2 = f2.read()
                              xdest3 = xdest + "/" + url1 
                              f3 = open(xdest3, "w")
                              f3.write(fpage2) 
                              f2.close()
                              f3.close() 
                              self.close()  
                return
                
    def foldback(self, name, url, xdest):            
                self.getfolder(name, url, xdest)
                
                

    def okClicked(self):
          sel = self["menu"].getSelectionIndex()
	  if sel is None :
                self.close()
          else:      
                name = self.data[sel]
#                if "Frodo" in name:
#                       url = "http://mirrors.kodi.tv/addons/jarvis/"
#                       global HOST
#                       HOST = url
#                       self.session.open(Addons, url)
#                       self.close()
                if "Adult" in name:
                       self.catname = name
                       self.allow()
                else:       
                       self.session.open(GetaddonsA2, name)
                       self.close()

    def allow(self):	        
                perm = config.ParentalControl.configured.value
                #####pass#print "perm =", perm 
                
                if config.ParentalControl.configured.value:
			#####pass#print "Here Ad 1"
#                        from Screens.InputBox import InputBox, PinInput
			self.session.openWithCallback(self.pinEntered, PinInput, pinList = [config.ParentalControl.setuppin.value], triesEntry = config.ParentalControl.retries.servicepin, title = _("Please enter the parental control pin code"), windowTitle = _("Enter pin code"))

		else:
			#####pass#print "Here Ad 2"
                        self.pinEntered(True)
#		return
       
    def pinEntered(self, result):
		#####pass#print "Here Ad 3 result =", result
                if result:
                        self.session.open(GetaddonsA2, self.catname)
		else:
			self.session.openWithCallback(self.close, MessageBox, _("The pin code you entered is wrong."), MessageBox.TYPE_ERROR)
         		self.close()

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

		
		
				
		
class Addons(Screen):

    def __init__(self, session, url):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:       
                self.session=session
                pass#print "Addons url =", url
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.url = url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Plugins"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                              pic1 = THISPLUG + "/skin/images/DownloadL.png"
                       else:
                              pic1 = THISPLUG + "/skin/images/Download.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "In Addons xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
#                       if DEBUG == 1:
            	              #pass#print "In Addons html = ", html 

                       url1 ="http://www.xtrend-alliance.com/XbmcAddon/Addons/adlist.txt"
                       fpage = urlopen(url1).read()
                       n1 = fpage.find("Frodo")
                       n2 = fpage.find("#####", (n1+10))
                       fpage2 = fpage[n1:n2]


                       self.html = html
                       self.names = []
                       self.urls = []
                       pass#print "In Addons HOST = ", HOST 
                       regexcat = '<a href="plugin.video(.*?)">(.*?)/<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       pass#print "In Addons match =", match
                       for url, name in match:
                              if name not in fpage2:
                                     continue
                              if "plugin.video" not in name:
                                     continue
                                     
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
#	  if self.errcount == 1:
#                self.close()
#          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                pass#print "In Addons url = ", url 
                self.session.open(Addons2, name, url)
                self.close()
                       
    def allow(self):	        
                perm = config.ParentalControl.configured.value
                #####pass#print "perm =", perm 
                
                if config.ParentalControl.configured.value:
			#####pass#print "Here Ad 1"
#                        from Screens.InputBox import InputBox, PinInput
			self.session.openWithCallback(self.pinEntered, PinInput, pinList = [config.ParentalControl.setuppin.value], triesEntry = config.ParentalControl.retries.servicepin, title = _("Please enter the parental control pin code"), windowTitle = _("Enter pin code"))

		else:
			#####pass#print "Here Ad 2"
                        self.pinEntered(True)
#		return
       
    def pinEntered(self, result):
		#####pass#print "Here Ad 3 result =", result
                if result:
                        self.session.open(Addons2, self.region, self.html)
		else:
			self.session.openWithCallback(self.close, MessageBox, _("The pin code you entered is wrong."), MessageBox.TYPE_ERROR)
         		self.close()
	        
                       
                       

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
		
		
		
class Addons2(Screen):

    def __init__(self, session, name, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.name = name
		pass#print "In Addons2 url =", url
		self.url = HOST + "plugin.video" + url
		pass#print "In Addons2 self.url =", self.url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Plugins"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                               pic1 = THISPLUG + "/skin/images/DownloadL.png"
                       else:
                               pic1 = THISPLUG + "/skin/images/Download.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "xurl 2=", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "html 2= ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="plugin.video(.*?)">(.*?)</a>(.*?)<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       for url, name, rev in match:
                              name = name + " :" + rev 
                              name = name.replace("plugin.video.", "")
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                url = self.url + "plugin.video" + url
                pass#print "Here in Addons2 name, url =", name, url 
                self.session.open(Addons3, name, url)
                self.close()

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Addons3(Screen):

    def __init__(self, session, name, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = " "
		self["bild"] = startspinner()
		self.name = name
		self.url = url
		pass#print "In Addons3 self.name =", self.name 
		pass#print "In Addons3 self.url =", self.url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Plugins"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onShown.append(self.openTest)
                
    def okClicked(self): 
                pass

    def openTest(self):
                sel = self["menu"].getSelectionIndex()
                name = self.name.split(" : ")
                self.plug = name[0]
#                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                xdest = "/tmp/" + self.plug
                xurl = self.url
	        downloadPage(xurl, xdest).addCallback(self.install).addErrback(self.showError)

    def showError(self, error):
                pass#print "ERROR :", error

    def install(self, fplug):
#                cmd1 = "wget -O '" + dest + "' '" + self.url + "'"
                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                cmd = "unzip -o -q '/tmp/" + self.plug + "' -d " + fdest
                
                pass#print "cmd =", cmd
                title = _("Installing addons %s" %(self.plug))
                self.session.open(Console,_(title),[cmd])
                self["info"].setText(_("Done."))
                self.close()
                
    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
		


class DelAdd(Screen):

    def __init__(self, session):
		Screen.__init__(self, session)
                self.skinName = "KodiMenusScreen"
                self.session=session
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = " "
                self["info"].setText(self.info)
                self["bild"] = startspinner()
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Select to delete"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.addlist = []
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       pic1 = THISPLUG + "/skin/images/Delete.png"  
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       adds = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins"
                       for name in os.listdir(adds):
                              if "plugin.video.select" in name:
                                    continue
                              elif "script.module.extras" in name:
                                    continue
                              elif "script.module.main" in name:
                                    continue            
                              elif "script.module" in name:                              
                                    continue            
                              elif "__init" in name:                              
                                    continue    
                              self.addlist.append(name)                      

		       showlist(self.addlist, self["menu"])

    def okClicked(self):
                sel = self["menu"].getSelectionIndex()
                plug = self.addlist[sel]
                cmd = "rm -rf '/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/plugins/" + plug + "'"
                title = _("Removing %s" %(plug))
                self.session.open(Console,_(title),[cmd])
                self.close()
                
    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		self["text"].number(number)

####################################
class Scripts(Screen):

    def __init__(self, session, url):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:       
                self.session=session
                pass#print "Addons url =", url
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.url = url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Script Modules"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                               pic1 = THISPLUG + "/skin/images/DownloadL.png"
                       else:
                               pic1 = THISPLUG + "/skin/images/Download.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass #pass#print "In Addons html = ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="script.(.*?)">(.*?)<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       for url, name in match:
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                url = "http://mirrors.kodi.tv/addons/jarvis/script." + url
                self.session.open(Scripts2, name, url)
                       
    def allow(self):	        
                perm = config.ParentalControl.configured.value
                #####pass#print "perm =", perm 
                
                if config.ParentalControl.configured.value:
			#####pass#print "Here Ad 1"
#                        from Screens.InputBox import InputBox, PinInput
			self.session.openWithCallback(self.pinEntered, PinInput, pinList = [config.ParentalControl.setuppin.value], triesEntry = config.ParentalControl.retries.servicepin, title = _("Please enter the parental control pin code"), windowTitle = _("Enter pin code"))

		else:
			#####pass#print "Here Ad 2"
                        self.pinEntered(True)
#		return
       
    def pinEntered(self, result):
		#####pass#print "Here Ad 3 result =", result
                if result:
                        self.session.open(Addons2, self.region, self.html)
		else:
			self.session.openWithCallback(self.close, MessageBox, _("The pin code you entered is wrong."), MessageBox.TYPE_ERROR)
         		self.close()
	        
                       
                       

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
		
class Scripts2(Screen):

    def __init__(self, session, name, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.name = name
		self.url = url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Script Modules"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                              pic1 = THISPLUG + "/skin/images/DownloadL.png"
                       else:
                              pic1 = THISPLUG + "/skin/images/Download.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       pass#print "In Scripts2 xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)
#**************#
    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
            	              pass#print "Scripts2 html = ", html 
                       self.html = html
                       self.names = []
                       self.urls = []
                       regexcat = '<a href="script(.*?)">(.*?)</a>(.*?)<'
                       match = re.compile(regexcat,re.DOTALL).findall(html)
                       for url, name, rev in match:
                              name = name + " :" + rev 
                              name = name.replace("script.", "")
                              self.names.append(name)
                              self.urls.append(url)

		       showlist(self.names, self["menu"])
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "In Scripts2 Download error =", error
		n1 = self.url.find("script.", 0)
		n2 = self.url.find("/", n1)
		sh = self.url[n1:n2]
		pass#print "In Scripts2 self.icount, sh =", self.icount, sh
		if self.icount == 0:
                    if ("script.module.xbmctr" in sh) or ("script.xbmctr" in sh):
                       self.url = "http://xbmc-tr-team-turkish-addons.googlecode.com/svn/trunk/" + sh + "/"
                       self.openTest()
                       self.icount = 1  
		
		
		
		

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
                sel = self["menu"].getSelectionIndex()
                name = self.names[sel]
                url = self.urls[sel]
                url = self.url + "script" + url
                pass#print "Here in Scripts2 name, url =", name, url 
                self.session.open(Scripts3, name, url)

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
            
class Scripts3(Screen):

    def __init__(self, session, name, url):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = " "
		self["bild"] = startspinner()
		self.name = name
		self.url = url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Script Modules"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onShown.append(self.openTest)
                
    def okClicked(self): 
                pass

    def openTest(self):
                sel = self["menu"].getSelectionIndex()
                name = self.name.split(" : ")
                plug = name[0]
                fdest = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect/scripts"
                dest = "/tmp/" + plug
                cmd1 = "wget -O '" + dest + "' '" + self.url + "'"
                cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                cmd = cmd1 + " && " + cmd2
                pass#print "cmd =", cmd
                title = _("Installing addons %s" %(plug))
                self.session.open(Console,_(title),[cmd])
                self.close()
                
    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)
		
		


####################################
class Software(Screen):

    def __init__(self, session, url):
		Screen.__init__(self, session)
#		if config.plugins.polar.menutype.value == "icons1":
#                       self.skinName = "Downloads"
#                else:
                self.session=session       
                self.skinName = "KodiMenusScreen"
#        	self["list"] = MenuList([])
                self["menu"] = RSList([])
		self["info"] = Label()
		self["bild"] = startspinner()
		self.info = " "
		self.url = url
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.close,
			"red": self.close,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("Cancel"))
		self["key_green"] = Button(_("Select"))
		title = "Software"
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                       if config.plugins.kodiplug.skinres.value == "fullhd":
                              pic1 = THISPLUG + "/skin/images/DownloadL.png"
                       else:
                              pic1 = THISPLUG + "/skin/images/Download.png"
                       self["pixmap"].instance.setPixmapFromFile(pic1)
                       xurl = self.url
                       #pass#print "xurl =", xurl
                       getPage(xurl).addCallback(self.gotPage).addErrback(self.getfeedError)

    def gotPage(self, html):
#	        try:
                       if DEBUG == 1:
        	              pass#print "html = ", html 
                       self.data = []
                       icount = 0
                       self.data = html.splitlines()
                       if DEBUG == 1:
                              pass#print "self.data here 1=", self.data
 
		       showlist(self.data, self["menu"])
		       
                       
#                except Exception, error:
#			#pass#print "[plugins]: Could not download HTTP Page\n" + str(error)

    def getfeedError(self, error=""):
		error = str(error)
		pass#print "Download error =", error

    def okClicked(self):
	  if self.errcount == 1:
                self.close()
          else:      
             sel = self["menu"].getSelectionIndex()
             if sel is None:
                   self.close()
             plug = self.data[sel]
             if plug.endswith("_"):
                        plug = plug[:-1]
                        try:
                              cmd = "opkg install " + plug
                        except:
                              cmd = "dpkg --install " + plug

                        pass#print "no zip or ipk cmd =", cmd
                        title = _("Installing software %s" %(plug))
                        self.session.open(Console,_(title),[cmd])
                        self.close()
             else:
                if "update" in plug:
                        f=open("/etc/kodiupd", 'w')
                        txt = plug + "\n"
                        f.write(txt)
                dest = "/tmp/" + plug
                cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Software/" + plug + "'"
##                cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Software2/" + plug + "'"

                if ".ipk" in plug:
                        cmd2 = "opkg install --force-overwrite '/tmp/" + plug + "'"
                elif ".deb" in plug:
                        cmd2 = "dpkg --install '/tmp/" + plug + "'"
                elif ".zip" in plug:        
                        cmd2 = "unzip -o -q '/tmp/" + plug + "' -d /"
                cmd = cmd1 + " && " + cmd2
#                pass#print "cmd =", cmd
                title = _("Installing software %s" %(plug))
                self.session.open(Console,_(title),[cmd])
                self.close()
                
    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

####################################
############## Not used now #############
class StartPlugin(Screen):

        def __init__(self, session):
		Screen.__init__(self, session)
		self.session=session
		self.skinName = "xbmc1"
                title = (_("Addons"))
                self.setTitle(title)
                self["label1"] = StaticText()
                self["label2"] = StaticText()
                self["label3"] = StaticText()
                self["label4"] = StaticText()
               
                self["label1s"] = StaticText()
                self["label2s"] = StaticText()
                self["label3s"] = StaticText()
                self["label4s"] = StaticText()

                self["frame0"] = MovingPixmap()
                self["frame1"] = MovingPixmap()

        	self["list"] = MenuList([])

        	self["pixmap"] = Pixmap()
        	self["pixmap1"] = Pixmap()
		self["info"] = Label()

                self["actions"] = ActionMap(["OkCancelActions", "ColorActions", "DirectionActions", "MovieSelectionActions","EPGSelectActions"],
		{
			"cancel": self.close,
			"ok": self.KeyOk,
			"left": self.key_left,
			"right": self.key_right,
			"red": self.close,
		}, -1)

                self.index = 0
       		self.pos1 = []		

                ict = 0
                i = 1280
                j = 600
                while ict < 320:
                       i1 = i
                       self.pos1.append([i1,j])
                       i = i-4
                       ict = ict+1
                self.pos2 = []		
                ict = 0
                i = 0
                j = 600
                while ict < 320:
                       i1 = i
                       self.pos2.append([i1,j])
                       i = i-4
                       ict = ict+1
                self.index0 = -1
                self.index1 = -1

                self.updateTimer = eTimer()
                try:
                      self.updateTimer_conn = self.updateTimer.timeout.connect(self.updateStatus)
                except AttributeError:
                      self.updateTimer.callback.append(self.updateStatus)
#                self.updateTimer.callback.append(self.updateStatus)
		self.updateTimer.start(0400)
		self.updateStatus()
                self.onShown.append(self.openTest)
                  
        def help(self):
                from Plugins.Extensions.KodiDirect.lib.XBMChelpinfo import XBMChelpinfo
                self.session.open(XBMChelpinfo)
                

        def updateStatus(self):
                   infotxt = "check ...."
                   self.index0 = self.index0+1
                   self.index1 = self.index1+1
                   self.paintFrame()

        def paintFrame(self):
                if self.index1 == 320:
		       self.index1 = 0
                if self.index0 == 320:
		       self.index0 = 0              
		
                ipos10 = self.pos1[self.index0]
		ipos11 = self.pos2[self.index1]
		self["frame0"].moveTo( ipos10[0], ipos10[1], 1)
		self["frame1"].moveTo( ipos11[0], ipos11[1], 1)
		self["frame0"].startMoving()
		self["frame1"].startMoving()
                
        def cancel(self):
                self.close()

        def openTest(self):
                self["label1"].setText(_("Addons"))
                self["label2"].setText(_("Settings"))
                self["label3"].setText(_("Help"))
                self["label4"].setText(_("Exit"))
                self["label1s"].setText(" ")
                self["label2s"].setText(" ")
                self["label3s"].setText(" ")
                self["label4s"].setText(" ")
                if self.index==0:
                        self["label1"].setText(" ")
                        self["label1s"].setText(_("Addons"))
                elif self.index==1:
                        self["label2"].setText(" ")
                        self["label2s"].setText(_("Settings"))
                elif self.index==2:
                        self["label3"].setText(" ")
                        self["label3s"].setText(_("Help"))
                elif self.index==3:
                        self["label4"].setText(" ")
                        self["label4s"].setText(_("Exit"))
               
        def key_left(self):
                self.index -= 1
                if self.index < 0:
                       self.index = 3
                self.openTest()

        def key_right(self):
		self.index += 1
		if self.index > 3:
                       self.index = 0
                self.openTest()

        def KeyOk(self):
                idx = self.index
                if idx == 0:
                       self.session.open(StartPlugin_mainmenu)
                elif idx == 1:
                       self.session.open(XbmcConfigScreen) 
                elif idx == 2:
                       self.help()     
                elif idx == 3:
                       self.close()     
                       


class Splash3(Screen):

        def __init__(self, session, pic):
		Screen.__init__(self, session)
                self.pic = pic
                try:
                       im = Image.open(self.pic)
                except:
                       txt = _("Please install python-imaging")
                       session.openWithCallback(self.do_exit, MessageBox, txt, type = 0)
                       
                imode = im.mode
                if im.mode != "P":
                       im = im.convert("P")
                size_w = im.size[0]
                size_d = im.size[1]
                r = float(size_w)/float(size_d)
                rw = float(size_w)/float(1280)
                rd = float(size_d)/float(720)
                if rw > rd:
                       new_w = 1280
                       new_d = float(size_d)/rw
                if rw < rd:
                       new_d = 720
                       new_w = float(size_w)/rd
                pass#print "In Splash3 size_w, new_w, size_d, new_d =", size_w, new_w, size_d, new_d  
                im = im.resize((int(new_w),int(new_d)), Image.ANTIALIAS)
                
                im.save(self.pic)
                
                new_w = int(new_w)
                new_d = int(new_d)
                self.skin = "<screen position=\"center,center\" size=\"1280,720\" title=\"XBMC Addons\" > \
                <widget name=\"pixmap\" position=\"center,center\" size=\"" + str(new_w) + "," + str(new_d) +"\" zPosition=\"1\" /> \
                </screen>"
                
                title = " "
                self.setTitle(title)
        	self["pixmap"] = Pixmap()
#        	self.pic = pic
                self.session=session
                self["actions"] = ActionMap(["OkCancelActions"],
		{
			"cancel": self.close,
			"ok": self.KeyOk,

		}, -1)

                self.onLayoutFinish.append(self.showbg)
                
        def do_exit(self):
                self.close()        

        def showbg(self):

                          pass#print "Here in Greeting B"
#                   pic1 = THISPLUG + "/skin/images/splash.png"
                          self["pixmap"].instance.setPixmapFromFile(self.pic)
                          pass#print "Here in Greeting C"
                   

        def KeyOk(self):
                self.close()

class ShowPage(Screen):

    def __init__(self, session, ftext):
		Screen.__init__(self, session)
                self.session=session
                self.skinName = "KodiMenusScreenA"
#        	self["list"] = MenuList([])
                self.ftext = ftext
                self["menu"] = RSList([])
		self["info"] = Label()
		self.info = (_(" "))
                self["info"].setText(self.info)
		self.list = []
                self["pixmap"] = Pixmap()
                self["list"] = List(self.list)
                self["list"] = RSList([])
                self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions", "DirectionActions"], 
		{
			"ok": self.okClicked,
			"back": self.cancel,
			"red": self.cancel,
			"green": self.okClicked,
		}, -1)
	        self["key_red"] = Button(_("No"))
		self["key_green"] = Button(_("Yes"))
		title = " "
		self["title"] = Button(title)		
                self.icount = 0
                self.errcount = 0
                pass#print "In showPage 1"
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
                pass#print "In showPage 2"
                if config.plugins.kodiplug.skinres.value == "fullhd":
                              pic1 = THISPLUG + "/skin/images/DownloadL.png"
                else:
                              pic1 = THISPLUG + "/skin/images/Download.png"
                self["pixmap"].instance.setPixmapFromFile(pic1)
                self.data = []
                self.data = self.ftext.splitlines()
                pass#print "In showPage self.data =", self.data
		showlist(self.data, self["menu"])
                       

    def cancel(self):
                       file = open("/etc/kodinodl", "w")
                       file.write(date)
                       file.write("\n") 
	               file.close()
                       self.close()
                       
    def okClicked(self):                   
                       os.system("rm /etc/kodinodl &")
                       self.close()

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		#pass#print "pressed", number
		self["text"].number(number)

class Splash(Screen):
        def __init__(self, session):
		self.skinName = "Splash"
		Screen.__init__(self, session)
                title = " "
                self.setTitle(title)
        	self["pixmap"] = Pixmap()
                self.session=session
                self["actions"] = ActionMap(["OkCancelActions"],
		{
			"cancel": self.close,
			"ok": self.KeyOk,

		}, -1)

                self.icount = 0
                self.updateTimer = eTimer()
	    	self.updateTimer.callback.append(self.updateStatus)
		self.updateTimer.start(0400)
		self.updateStatus()
                self.onLayoutFinish.append(self.showbg)

        def showbg(self):
                   if config.plugins.kodiplug.skinres.value == "fullhd":
                         pic1 = THISPLUG + "/skin/images/greetingsL.png"
                   else:
                         pic1 = THISPLUG + "/skin/images/greetings.png"
                   self["pixmap"].instance.setPixmapFromFile(pic1)
                   
        def updateStatus(self):
                   self.icount = self.icount+1
                   if self.icount > 40:
                           self.updateTimer.stop()
                           if config.plugins.kodiplug.thumb.value == "True":
                              self.session.open(StartPlugin_mainmenu2)
                           else:
                              self.session.open(StartPlugin_mainmenu)
                           self.close()

        def KeyOk(self):
                       self.updateTimer.stop()
                       if config.plugins.kodiplug.thumb.value == "True":
                              self.session.open(StartPlugin_mainmenu2)
                       else:
                              self.session.open(StartPlugin_mainmenu)
                       self.close()
		


_session = ""
def main(session, **kwargs):
        global _session 
        _session = session

        import xpath
        dellog()
        flog = open("/tmp/e.log", "w")
        flog.write("\nKodiDirect session start\n")
        os.system("touch /etc/kodidebug")
        rpath = THISPLUG + "/lib/sources/resolvers"
        if os.path.exists(rpath):
               cmd = "rm -rf " + rpath 
               system(cmd)
        
        if os.path.exists("/etc/xbrestart.sh"):
               cmd = "rm /etc/xbrestart.sh"
               system(cmd)

        spath = THISPLUG + "/scripts/script.module.pysqlite3" 
        if os.path.exists(spath):
               cmd = "rm -rf " + spath 
               system(cmd)
        if config.plugins.kodiplug.thumb.value == "True":
               """
               try:
                      import Image
               except:
                      os.system("opkg install python-imaging") 
               pass#print "Try import Image"
               try:
                      pass#print "Try import Image 2"
                      from PIL import Image
                      Step2(" ")
               """       
               try:
                      import Image
                      Step2(" ")
               except:
                      try:
                             from PIL import Image  
                             Step2(" ")     
                      
                      except:
                             pass#print "Try import failed"
                             session.openWithCallback(Step2, MessageBox, _('Please install python-image or python-imaging\n for your image\nor change config Thumbpic to "No"'), MessageBox.TYPE_ERROR) 
        else:
               Step2(" ")

def Step2(res):               
        if res is None:
               pass
        session = _session       
        try:
               import sqlite3
        except:
               try:
                     system("opkg install python-sqlite3")   
               except:
                     system("apt-get install python-sqlite3")   

        try:
               from sqlite3 import dbapi2
               Step3(" ")
        except:       
               session.openWithCallback(Step3, MessageBox, _('Please install python-sqlite3 for your image'), MessageBox.TYPE_ERROR) 

def Step3(res):               
        if res is None: pass
        session = _session       

    
################################               
        global PICPOS
        PICPOS = []
        ipos = 0
        npos = 0
        while ipos < 300:
              npos = npos - 3
              PICPOS.append(npos)
              ipos = ipos+1
        pass#print "In main PICPOS =", PICPOS             
################################
        path = "/usr/lib/python2.7/"
        for root, dirs, files in os.walk(path):
	       for name in files:
		      if name.startswith("xbmc"):
                             cmd = "rm /usr/lib/python2.7/" + name
                             system(cmd)
################################
        if not os.path.exists("/usr/lib/enigma2/python/hlsclient.py"):
               cmd = "cp " + THISPLUG + "/lib/hlsclient.py /usr/lib/enigma2/python/"
               system(cmd)
        if not os.path.exists("/etc/KodiDirect"):
               system("mkdir -p /etc/KodiDirect")
        if not os.path.exists("/etc/KodiDirect/favorites.xml"):
               cmd = "cp " + THISPLUG + "/lib/defaults/favorites.xml /etc/KodiDirect/"
               system(cmd)
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/vid")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/pic")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/tmp")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/home/")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/database/")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/home/addons/")
        system("mkdir -p "+ config.plugins.kodiplug.cachefold.value+"/xbmc/home/addons/packages")
    
        tskin = "/usr/share/enigma2/" + config.skin.primary_skin.value
        f1 = open(tskin, 'r')
        s=f1.read()
        n1 = s.find('<borderset name="bsListboxEntry"', 0)
        if n1 < 0:
                f1.close()
                pass
        else:
                n2 = s.find("</borderset", n1)
                s1 = s[:n1]
                s2 = s[(n2+12):]
                s = s1 + s2
                f1.close()
                f=open(tskin, 'w')
                f.write(s)
                f.flush()
                f.close()

#########################
        if config.plugins.kodiplug.mainback.value == "default":
                cmd1 = "cp " + THISPLUG + "/skin/images/panel2A.png " + THISPLUG + "/skin/images/panel2.png"
                cmd2 = "cp " + THISPLUG + "/skin/images/panel3A.png " + THISPLUG + "/skin/images/panel3.png"
        else:
                cmd1 = "cp " + THISPLUG + "/skin/images/panel2B.png " + THISPLUG + "/skin/images/panel2.png"
                cmd2 = "cp " + THISPLUG + "/skin/images/panel3B.png " + THISPLUG + "/skin/images/panel3.png"
        system(cmd1)
        system(cmd2)        

        
        if config.plugins.kodiplug.backup.value is True:        
            if not os.path.exists("/etc/kodi-backup"):
               cmd1 = "cp -r " + THISPLUG + "/plugins " + config.plugins.kodiplug.cachefold.value + "/plugins2"
               cmd2 = "rm -rf " + THISPLUG + "/plugins"
               cmd3 = "ln -sf " + config.plugins.kodiplug.cachefold.value + "/plugins2 "+ THISPLUG + "/plugins"
               cmd4 = "cp -r " + THISPLUG + "/scripts " + config.plugins.kodiplug.cachefold.value + "/scripts2"
               cmd5 = "rm -rf " + THISPLUG + "/scripts"
               cmd6 = "ln -sf " + config.plugins.kodiplug.cachefold.value + "/scripts2 "+ THISPLUG + "/scripts"
               cmd = []
               cmd.append(cmd1)
               cmd.append(cmd2)
               cmd.append(cmd3)
               cmd.append(cmd4)
               cmd.append(cmd5)
               cmd.append(cmd6)
#               cmd = cmd1 + " && " + cmd2 + " && " + cmd3
#               pass#print "cmd =", cmd
               title = _("Moving folders plugins and scripts -> cache folder")
               session.open(Console,_(title),cmd)
               system("touch /etc/kodi-backup")
               return 
            else:
               pass

       
        global DEBUG
        if os.path.isfile("/etc/kodidebug"):
               DEBUG = 1
        else:       
               DEBUG = 0
               
        pass#print "In plugin-py DEBUG =", DEBUG       
######################################
        cmd = "wget -O " + THISPLUG + "/Tips.txt http://www.xtrend-alliance.com/XbmcAddon/Tips.txt" 
        os.system(cmd)

        xurl = "http://www.xtrend-alliance.com/XbmcAddon/kodi-news.txt"
        xdest = "/tmp/kodi-news.txt"
	downloadPage(xurl, xdest).addCallback(gotNews).addErrback(showNewsError)

def showNewsError(error):
               menustart()

def gotNews(txt=" "):
                       global date
                       session = _session
                       indic = 0
                       date = ""
                       olddate = ""
                       if not os.path.exists("/tmp/kodi-news.txt"):
                               indic = 0
                       else:
                               myfile = file(r"/tmp/kodi-news.txt")
                               icount = 0
                               for line in myfile.readlines():
                                   if icount == 0:
                                           date = line
                                           break
                                   icount = icount+1
                               myfile.close()
                               myfile = file(r"/tmp/kodi-news.txt") 
                               global newstext   
                               newstext = myfile.read()
                               pass#print "In gotNews newstext =", newstext
                               myfile.close()
                               news = newstext
                               n1 = news.find("update2", 0)
                               if n1 > -1:
                                      upd = news[n1:(n1+14)]
		               else:
		                      upd = "None"
		               global NewUpdate
                               NewUpdate = upd       
		               if fileExists("/etc/kodiupd"): 
		                      myfile = file(r"/etc/kodiupd")
                                      icount = 0
                                      for line in myfile.readlines():
                                             if icount == 0:
                                                    upd1 = line
                                                    break
                                             icount = icount+1
                                      myfile.close()
                               else:   
                                      upd1 = "None"
                                     
                               n2 = upd1.find(".", 0)
                               if n2 > -1:   
                                      upd1 = upd1[:n2]
                               pass#print "upd =", upd
                               pass#print "upd1 =", upd1
                               if upd != "None":
                                   if upd1 != upd:
                                      txt = _("New ") + upd + _(" is available. \nAfter update - gui will restart.\nUpdate Now ?")
                                      session.openWithCallback(do_upd, MessageBox, txt, type = 0)
                                   else:
                                      check_news()
                               else:
                                      check_news()
                               
def do_upd(answer):
        session = _session
        if answer is None:
                check_news()
        else:
            if answer is False:
                check_news()
            else:        
                picfold = config.plugins.kodiplug.cachefold.value+"/xbmc/pic"
                cmd = "rm -rf " + picfold
                os.system(cmd)
                plug = NewUpdate + ".zip"
                if "update" in plug:
                        f=open("/etc/kodiupd", 'w')
                        txt = plug + "\n"
                        f.write(txt)
                dest = "/tmp/" + plug
                cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Software/" + plug + "'"
##                cmd1 = "wget -O '" + dest + "' 'http://www.xtrend-alliance.com/XbmcAddon/Software2/" + plug + "'"

                if ".ipk" in plug:
                        cmd2 = "opkg install --force-overwrite '/tmp/" + plug + "'"
                elif ".deb" in plug:
                        cmd2 = "dpkg --install '/tmp/" + plug + "'"

                elif ".zip" in plug:        
                        cmd2 = "unzip -o -q '/tmp/" + plug + "' -d /"
#                cmd3 = "chmod 755 " + THISPLUG + "/xbrestart.sh"
#                cmd4 = THISPLUG + "/xbrestart.sh &"
                cmd = cmd1 + " && " + cmd2
                title = _("Installing software %s" %(plug))
                session.openWithCallback(done_upd,Console,_(title),[cmd])
                
def done_upd():
                from Restart import Restart
                session = _session                
                Restart(session)
                
                
def check_news():
                       session = _session
                       olddate = " "
                       if not os.path.exists("/etc/kodinodl"):
                              indic = 1
                       else:
                              myfile2 = file(r"/etc/kodinodl")  
                              icount = 0
                              for line in myfile2.readlines():
                                    if icount == 0:
                                           olddate = line
                                           break
                                    icount = icount+1
                              if olddate != date :
                                    indic = 1
                              else:
                                    indic = 0      
                              myfile2.close()
                
                       if indic == 0:
                             menustart()
                       else:             
                             session.openWithCallback(start, ShowPage, newstext)
                
def start():
                       menustart()

def checkvers(name):
#                name = "script.module.urlresolver"
                url2 = "http://mirrors.kodi.tv/addons/jarvis/" + name + "/"
               
                fpage = urlopen(url2).read()
                print "In newvers fpage =", fpage
                rx = name + '-(.*?).zip'
                match = re.compile(rx,re.DOTALL).findall(fpage)
                print  "match =", match
                latest = max(match) 
                print  "latest =", latest
                return latest
        
def menustart():
        global date
        session = _session
        try:
               from SubsSupport import SubsSupport, initSubsSettings
        except:
               cmd = "cp -rf " + THISPLUG + "/scripts/SubsSupport /usr/lib/enigma2/python"
               os.system(cmd)
########################################        
########################################  
        tfile = THISPLUG + "/scripts/script.module.urlresolver/addon.xml"
        if os.path.exists(tfile):
                       f = open(tfile, "r")       
                       txt = f.read()
                       print "In main txt = ", txt
                       n1 = txt.find('<addon', 0)
                       n11 = txt.find('id', n1)
                       n2 = txt.find("version", n11)
                       n3 = txt.find('"', n2)
                       n4 = txt.find('"', (n3+2))
                       version = txt[(n3+1):n4]
                       f.close()
        else:       
                       version = None
        print "In main version = ", version
        newvers = checkvers("script.module.urlresolver")
        if newvers != version:
                       plug = "urlresolver.zip"
                       fdest = THISPLUG + "/scripts"
                       dest = "/tmp/urlresolver.zip"
                       xfile = "http://mirrors.kodi.tv/addons/jarvis/script.module.urlresolver/script.module.urlresolver-" + newvers + ".zip" 
                       cmd1 = "wget -O '" + dest + "' '" + xfile + "'"
                       cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                       
                       cmd = []
                       cmd.append(cmd1)
                       cmd.append(cmd2)
                       
                       print "In main cmd =", cmd
                       title = _("Installing script urlresolver %s" %(plug))
                       session.openWithCallback(upd_done1,Console,_(title),cmd)
        else:       
                       upd_done1()
                       
def upd_done1():
        session = _session

        tfile = THISPLUG + "/scripts/script.module.youtube.dl/addon.xml"
        if os.path.exists(tfile):
                       f = open(tfile, "r")       
                       txt = f.read()
                       print "In main txt = ", txt
                       n1 = txt.find('<addon', 0)
                       n11 = txt.find('id', n1)
                       n2 = txt.find("version", n11)
                       n3 = txt.find('"', n2)
                       n4 = txt.find('"', (n3+2))
                       version = txt[(n3+1):n4]
                       f.close()
        else:       
                       version = None
        print "In main version = ", version
        newvers = checkvers("script.module.youtube.dl")
        if newvers != version:
                       plug = "youtube-dl.zip"
                       fdest = THISPLUG + "/scripts"
                       dest = "/tmp/youtube-dl.zip"
                       xfile = "http://mirrors.kodi.tv/addons/jarvis/script.module.youtube.dl/script.module.youtube.dl-" + newvers + ".zip" 
                       cmd1 = "wget -O '" + dest + "' '" + xfile + "'"
                       cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
                       
                       cmd = []
                       cmd.append(cmd1)
                       cmd.append(cmd2)
                       
                       print "In main cmd =", cmd
                       title = _("Installing script youtube.dl %s" %(plug))
                       session.openWithCallback(upd_done,Console,_(title),cmd)
        else:       
                       upd_done()
                               
        
def kodiUtils(session, **kwargs):
          from Plugins.Extensions.KodiDirect.KodiUtils import KodiUtils
          session.open(KodiUtils)
          


def upd_done():        
        session = _session
        #################
        dest = THISPLUG + "/scripts/script.module.urlresolver/resources/settings.xml"
        xfile = "http://www.xtrend-alliance.com/XbmcAddon/Addons/settings.xml" 
        cmd = "wget -O '" + dest + "' '" + xfile + "'"
        os.system(cmd)
        #################
        dest = THISPLUG + "/scripts/script.module.youtube.dl/lib/YoutubeDLWrapper.py"
        xfile = "http://www.xtrend-alliance.com/XbmcAddon/Addons/YoutubeDLWrapper.py" 
        cmd = "wget -O '" + dest + "' '" + xfile + "'"
        os.system(cmd)
        #################
        plug = "resolvers.zip"
        fdest = THISPLUG + "/scripts/script.module.urlresolver/lib"
        dest = "/tmp/resolvers.zip"
        xfile = "http://www.xtrend-alliance.com/XbmcAddon/Addons/resolvers.zip" 
        cmd1 = "wget -O '" + dest + "' '" + xfile + "'"
        cmd2 = "unzip -o -q '/tmp/" + plug + "' -d " + fdest
        cmd = cmd1 + " && " + cmd2
        os.system(cmd)
        #################
        dest = THISPLUG + "/Execlist.py"
        xfile = "http://www.xtrend-alliance.com/XbmcAddon/Addons/Execlist.py" 
        cmd = "wget -O '" + dest + "' '" + xfile + "'"
        os.system(cmd)
        #################
        if config.plugins.kodiplug.thumb.value == "True":
                session.open(StartPlugin_mainmenu2)
        else:
                if not os.path.exists("/etc/greet"):
                       os.system("touch '/etc/greet'")
                       session.open(Splash)
                else:       
                      session.open(StartPlugin_mainmenu)







        
def mpanel(menuid, **kwargs):
	if menuid == "mainmenu":
		return [("KodiDirect", main, "xbmc_addons", 12)]
	else:
		return []
        
def Plugins(**kwargs):
        ##changed by mfarajmfaraj2608 to list,added code to view downloads from outside the plugin
	loadPluginSkin(kwargs["path"])
        try:
          viewdownloads=config.plugins.kodiplug.viewdownloads.value
          mmenu=config.plugins.kodiplug.mmenu.value
	except:
          viewdownloads='disabled'
          mmenu=False
	list = []
	
#        if mmenu is True: 
        list.append(PluginDescriptor(icon="plugin.png",name="KodiDirect", description="plugins Addons for enigma2", where = PluginDescriptor.WHERE_MENU, fnc=mpanel))
        list.append(PluginDescriptor(icon="plugin.png",name="KodiDirect", description="plugins Addons for enigma2", where = PluginDescriptor.WHERE_PLUGINMENU, fnc=main))
        list.append(PluginDescriptor(icon="plugin.png",name="KodiUtils", description="Extra help items for KodiDirect", where = PluginDescriptor.WHERE_PLUGINMENU, fnc=kodiUtils))
        list.append(PluginDescriptor(icon="plugin.png",name="KodiDirect", description="plugins Addons for enigma2", where = PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=main))
        
        if not viewdownloads=="disabled":
           list.append(PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART,fnc=showjobviews))
        
	
        return list
####code to view current downloads from inside and outside the plugin-mfaraj2608
def showjobviews(reason, **kwargs):    
	if reason == 0:
           try:
		  pjopviews.gotSession(kwargs["session"])
           except:
		  pass
class classJobManagerViews():
	def __init__(self):
		self.dialog = None

	def gotSession(self, session): 
              global _session
              _session = session
              try:
                
		jobmanagerviews_keymap = THISPLUG+"/lib/jobs_keymap.xml"
		self.session=session
                global globalActionMap
		readKeymap(jobmanagerviews_keymap)
		#self.dialog = session.instantiateDialog(ScreenGrabber.ScreenGrabberView)
		#self.dialog.show()
		globalActionMap.actions['JobManagerView'] = self.ShowHide
		#self.ShowHide()

              except:
                 return

        def ShowHide(self):                             
#            from  Plugins.Extensions.KodiDirect.lib.download import viewdownloads
#            viewdownloads(self.session,THISPLUG) 
            from Plugins.Extensions.KodiDirect.lib.XBMCAddonsMediaExplorer import XBMCAddonsMediaExplorer
            _session.open(XBMCAddonsMediaExplorer)          
                		
pjopviews = classJobManagerViews() 


