﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2016
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding execution on hardware, you are permitted to execute this plugin on VU+ hardware
#  which is licensed by satco europe GmbH, if the VTi image is used on that hardware.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.packer import unpack, detect
from twisted.internet import task
from twisted.internet.task import deferLater

agent="Mozilla/5.0 (Windows NT 6.1; rv:40.0) Gecko/20100101 Firefox/40.0"
cookies={}
class livestreamtvMain(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("live-stream.tv")
		self['ContentTitle'] = Label(_("Selection"))

		self.streamList = None
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self._statUpdate = task.LoopingCall(self.updateStat)
		self.keyLocked = False
		self.last_url = None
		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		url = "http://www.live-stream.tv/online/fernsehen/deutsch/ard.html"
		getPage(url, cookies=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.streamList = []
		i = data.find('<ul id="carousel">')
		if i > 0:
			sender = re.findall('<a\s+href="(.*?)".*?<div class="sTA">(.*?)</div>.*?<img class="thumbim" src="(.*?)".+?</strong>.*?<span id="(.*?)-title">(.*?)</span>', data[i:], re.S)
			if sender:
				for url,time,image, station,title in sender:
					if station != "fussball":
						self.streamList.append((decodeHtml(time + ' - ' + title), title, station, url, time, image))
				self.ml.setList(map(self.livestreamtvListEntry, self.streamList))
				self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		self.station = self['liste'].getCurrent()[0][2]
		self.last_url = "http://www.live-stream.tv/online/fernsehen/deutsch/%s.html" % self.station
		getPage(self.last_url, cookies=cookies).addCallback(self.getUpdateInfos).addErrback(self.dataError)

	def updateStat(self):
		ts = str(int(math.floor(time()*1000)))
		url = "http://%s.ucount.in/stats/update/custom/lstv/%s/%s&_=%s&callback=?" % (self._update_infos[2], self._update_infos[0], self._update_infos[1], ts)
		return getPage(url, agent=agent, headers={'Referer':self.last_url})

	def stopStatUpdate(self):
		self.keyLocked = True
		self._statUpdate.stop()
		getPage(self.last_url, cookies=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def play(self, url):
		self._statUpdate.start(20, False)
		title = self['liste'].getCurrent()[0][1]
		self.session.openWithCallback(self.stopStatUpdate, SimplePlayer, [(self.station.upper() + ' - ' + title, url)], showPlaylist=False, ltype='livestreamtv')

	def getUpdateInfos(self, data):
		m = re.search("updateStreamStatistics\s*\('(.*?)','(.*)', '(.*?)'\)", data)
		if m:
			self._update_infos = m.groups()
			return self.updateStat().addCallback(lambda _: self.getStream(data))

	def getStream(self, data):
		m = re.search("type:'flash',\s*src:'(.*?)'.*?file:'(.*?)'", data, re.S)
		if m:
			referer, file = m.groups()
			headers = urllib.quote("{'Referer':'%s','User-Agent':'Mozilla/5.0 (Windows NT 6.1; rv:40.0) Gecko/20100101 Firefox/40.0'}" % referer)
			stream_url = "%s headers=%s" % (file, headers)
			reactor.callLater(1, self.play, stream_url)
