# coding: utf-8
#################################################################################
#
#    SubsPlayer 1.0 for OE 2.2
#    Coded by pcd (c) 2015
#
#    This plugin uses SubsSupport 1.2.0 by mx3L as the main tool,
#    which has been modified for OE 2.2.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#################################################################################
from urllib2 import urlopen
from Components.MenuList import MenuList
from Components.Label import Label

from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Components.ActionMap import NumberActionMap
from Components.Input import Input
from Components.Pixmap import Pixmap
from Components.FileList import FileList
from Screens.ChoiceBox import ChoiceBox
from Plugins.Plugin import PluginDescriptor
from Components.ActionMap import ActionMap
from Screens.InputBox import InputBox, PinInput

from enigma import eServiceReference
from enigma import eServiceCenter
from enigma import getDesktop

from Screens.InfoBar import MoviePlayer
import os
from Components.Button import Button
from Components.ConfigList import ConfigListScreen
from Components.config import config, ConfigSubsection, ConfigInteger, ConfigSelection, ConfigText, ConfigEnableDisable, getConfigListEntry

from SubsSupport.subtitles import E2SubsSeeker, SubsSearch, initSubsSettings, \
    SubsSetupGeneral, SubsSearchSettings, SubsSetupExternal, SubsSetupEmbedded
from SubsSupport.subtitlesdvb import SubsSupportDVB, SubsSetupDVBPlayer
from Screens.InfoBar import MoviePlayer

class SubsSupportSettings(Screen):
    skin = """
        <screen position="center,center" size="300,300">
            <widget name="menuList" position="10,10" size="280,280"/>
        </screen>
        """
    def __init__(self, session, generalSettings, searchSettings, externalSettings, embeddedSettings, dvbSettings):
        Screen.__init__(self, session)
        self.generalSettings = generalSettings
        self.searchSettings = searchSettings
        self.externalSettings = externalSettings
        self.embeddedSettings = embeddedSettings
        self.dvbSettings = dvbSettings
        self["menuList"] = MenuList([
            (("General settings"), "general"),
            (_("External subtitles settings"), "external"),
#            (_("Embedded subtitles settings"), "embedded"),
            (_("Search settings"), "search"),
#            (_("DVB player settings"), "dvb")
        ])
        self["actionmap"] = ActionMap(["OkCancelActions", "DirectionActions"], 
        {
            "up": self["menuList"].up,
            "down": self["menuList"].down,
            "ok": self.confirmSelection,
            "cancel": self.close,
        })
        self.onLayoutFinish.append(self.setWindowTitle)
        
    def setWindowTitle(self):
        self.title = _("SubsSupport settings")
        
    def confirmSelection(self):
        selection  = self["menuList"].getCurrent()[1]
        if selection == "general":
            self.openGeneralSettings()
        elif selection == "external":
            self.openExternalSettings()
        elif selection == "embedded":
            self.openEmbeddedSettings()
        elif selection == "search":
            self.openSearchSettings()
        elif selection == "dvb":
            self.openDVBPlayerSettings()                                   
        
    def openGeneralSettings(self):
        self.session.open(SubsSetupGeneral, self.generalSettings)
        
    def openSearchSettings(self):
        seeker = E2SubsSeeker(self.session, self.searchSettings, True)
        self.session.open(SubsSearchSettings, self.searchSettings, seeker, True)
        
    def openExternalSettings(self):
        self.session.open(SubsSetupExternal, self.externalSettings)
        
    def openEmbeddedSettings(self):
        try:
            from Screens.AudioSelection import QuickSubtitlesConfigMenu
        except ImportError:
            self.session.open(SubsSetupEmbedded, self.embeddedSettings)
        else:
            self.session.open(MessageBox, _("You have OpenPli-based image, please change embedded subtitles settings in Settings / System / Subtitles settings"), MessageBox.TYPE_INFO)
        
    def openDVBPlayerSettings(self):
        self.session.open(SubsSetupDVBPlayer, self.dvbSettings)






class SubsPlayer(Screen):

    skin = """
		<screen position="center,center" size="600,300" title="Media List" >
			<widget name="list" position="10,10" size="580,230" scrollbarMode="showOnDemand" />
		        <ePixmap name="red"    position="0,250"   zPosition="2" size="140,40" pixmap="skin_default/buttons/red.png" transparent="1" alphatest="on" />
	                <ePixmap name="green"  position="140,250" zPosition="2" size="140,40" pixmap="skin_default/buttons/green.png" transparent="1" alphatest="on" />
	                <ePixmap name="yellow" position="280,250" zPosition="2" size="140,40" pixmap="skin_default/buttons/yellow.png" transparent="1" alphatest="on" /> 
	                <ePixmap name="blue"   position="420,250" zPosition="2" size="140,40" pixmap="skin_default/buttons/blue.png" transparent="1" alphatest="on" /> 

	                <widget name="key_red" position="0,250" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <widget name="key_green" position="140,250" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <widget name="key_yellow" position="280,250" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" />
	                <widget name="key_blue" position="420,250" size="140,50" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" />
                </screen>"""


    def __init__(self, session):
		Screen.__init__(self, session)

		self["actions"] = ActionMap(["OkCancelActions", "ColorActions", "DirectionActions"],
		{
			"cancel": self.close,
			"red": self.close,
			"green": self.KeyOk,
			"yellow": self.Conf,
			"blue": self.Download,
			"ok": self.KeyOk
		}, -1)

		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Play"))
		self["key_yellow"] = Button(_("Setup"))
		self["key_blue"] = Button(_("Download\nsubtitles"))

		self["list"] = MenuList([])
		self.vidlist = []
		self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.Getmedia)
                
    def Getmedia(self):
                settings = initSubsSettings()
                self.searchSettings = settings.search

		path = self.searchSettings.downloadPath.value
		print "path =", path
                self.vidlist = []
		for root, dirs, files in os.walk(path):
			for name in files:
                                self.vidlist.append(name)
            
                self["list"].setList(self.vidlist)
                
    def Download(self):            
                sel = self["list"].getSelectionIndex()
                tfile = self.vidlist[sel]
                
                url = self.searchSettings.downloadPath.value + tfile
		file = open("/tmp/subvidurl", "w")
		text = url + "\n"
                file.write(text)
                file.close()
                
                n1 = tfile.rfind(".")
                name = tfile[:n1]
                settings = initSubsSettings().search
                eventList = []
                eventList.append(name)
                self.session.open(SubsSearch, E2SubsSeeker(self.session, settings), settings, searchTitles=eventList, standAlone=True)
		self.close()
		
    def KeyOk(self):
		sel = self["list"].getSelectionIndex()
		tfile = self.vidlist[sel]
		n = tfile.find(".", 0)
		name = tfile[:n]
		settings = initSubsSettings()
                self.searchSettings = settings.search

		url = self.searchSettings.downloadPath.value + tfile
		
                pvid = Play(self.session, name, url)
                pvid.openTest()	
                
    def Conf(self):
                settings = initSubsSettings()
                self.session.open(SubsSupportSettings, settings, settings.search, settings.external, settings.embedded, config.plugins.subsSupport.dvb)

                
    def cancel(self):
                self.session.nav.playService(self.srefOld)
		self.close()
	
    def keyRight(self):
		self["text"].right()
		
		
class Play(Screen):
    skin = """
		<screen position="center,center" size="550,400" title="Streams" >
			<!--widget name="text" position="0,0" size="550,25" font="Regular;20" /-->
			<widget name="list" position="10,0" size="500,350" scrollbarMode="showOnDemand" />
			<!--widget name="pixmap" position="200,0" size="190,250" /-->
			<eLabel position="70,100" zPosition="-1" size="100,69" backgroundColor="#222222" />
			<widget name="info" position="100,230" zPosition="4" size="300,25" font="Regular;18" foregroundColor="#ffffff" transparent="1" halign="center" valign="center" />
		</screen>"""
    def __init__(self, session, name, url):
		Screen.__init__(self, session)
        	self["list"] = MenuList([])
		self["info"] = Label()
		self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.icount = 0
                print "Playvid : name =", name
                print "Playvid : url =", url
                self.name = name
                self.url = url
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
          if self.url != " ": 
                url = self.url
                name = self.name
                self.session.nav.stopService()
                sref = eServiceReference(4097,0,url)
                sref.setName(name)
                print "sref =", sref.toString()
                self.session.open(MoviePlayer, sref)
          else:
                return
           

    def cancel(self):
	        self.session.nav.playService(self.srefOld)
                self.close()

    def okClicked(self):            
                return

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		print "pressed", number
		self["text"].number(number)	


#######################
		
	

 
def main(session, **kwargs):
        session.open(SubsPlayer)

def Plugins(**kwargs):
	return PluginDescriptor(name="SubsPlayer", description="Downloads and shows subtitles", where = PluginDescriptor.WHERE_PLUGINMENU, fnc=main)









