'''
Created on Feb 19, 2015

@author: marko

'''
from enigma import eTimer as Timer
try:
    Timer().callback
except AttributeError:
    # eTimer has changed interface on DMM images
    class  eTimer(object):
        def __init__(self):
            self._timer = Timer()
            
        def __getattr__(self, key):
            if key == "callback" and not hasattr(self._timer,"callback"):
                timeout = self._timer.timeout
                timeout.append = timeout.connect
                return timeout
            else:
                return getattr(self._timer, key)
else:
    eTimer = Timer
    
# this function is not the same accross different images
def LanguageEntryComponent(file, name, index):
    from Tools.Directories import resolveFilename, SCOPE_CURRENT_SKIN
    from Tools.LoadPixmap import LoadPixmap
    png = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, 'countries/' + index + '.png'))
    if png == None:
        png = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, 'countries/' + file + '.png'))
        if png == None:
            png = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, 'countries/missing.png'))
    res = (index, name, png)
    return res