# -*- coding: UTF-8 -*-
from imports import *
from Moduli import *


def ListPartizion():
    Partizion = False
    st = statvfs("/media/hdd")
    free = st.f_bavail * st.f_frsize  
    if free > 1073741824: # Valore in Bytes Superiore a 1gb
        Partizion = True	
    return Partizion	

def Hdd(partition = None):	  
    Size = Used = Avaible = UsedP = Mount = ""
    if partition == None:	  
        partition = config.xhamster.storage.value   
    st = statvfs (partition)
    totSize = st.f_blocks * st.f_frsize;
    freeSize = st.f_bfree * st.f_frsize;
    usedSize = totSize - freeSize;
    availableSize = totSize - usedSize;
    percent = (100*usedSize) / totSize;   
    suffixMb = " Mb";
    suffixGb = " Gb";
    oneGb = 1024*1000*1000
    oneMb = 1024*1000   
    if totSize > oneGb:
      Size = str(totSize / oneGb) + suffixGb;
    else:
      Size = str(totSize / oneMb) + suffixMb;       
    if usedSize > oneGb:
      Used = str(usedSize / oneGb) + suffixGb;
    else:
      Used = str(usedSize / oneMb) + suffixMb;    
    if availableSize > oneGb:          
      Avaible = str(availableSize / oneGb) + suffixGb;
    else:
      Avaible = str(availableSize / oneMb) + suffixMb;    
    UsedP = str(percent) + "%";
    Mount = partition;
    return Size,Used ,Avaible ,UsedP,Mount 
		
def isMountedInRW(path):
    if (os.access (path,os.W_OK)):
      return True
    return False

def Mounted():
    jpartitions = []
    for partition in harddiskmanager.getMountedPartitions():
      if (isMountedInRW(partition.mountpoint)):
        moviePath = os.path.join (partition.mountpoint,"movie");
        try:
          os.mkdir (moviePath)
        except:
          pass
        jpartitions.append((partition.mountpoint,partition.description))
    return jpartitions

def SaveConf():
    a = open(SaveConfName, "w")
    a.write("--- Team Mediastream  ---\n\n")   
    a.write("Storage device = %s\n" % (config.xhamster.storage.value))	
    a.write("BufferingIptv = %s\n" % (config.xhamster.MbBuffering.value))						
    a.write("\n\n--- By m43c0 & mmark --- ")                                     
    a.close()	

def load():
    Storage='/'
    Buffering='3'	
    if os.path.exists(SaveConfName):                   		   
      try:
        xf = open(SaveConfName, "r")
        f = xf.readlines()				
        xf.close()		
      except:
        pass					   
      for line in f:
        try:
          LoadConf = line.strip()
          elements = LoadConf.split('=')				 	
          if LoadConf.find('Storage device') != -1 :
            try:		
              config.xhamster.storage.setValue(str(elements[1][1:]))	
            except:
              pass					
            Storage=str(elements[1][1:])			
          elif LoadConf.find('MainMenu') != -1 :
            try:		
              config.xhamster.mainmenu.setValue(elements[1][1:])		
            except:
              pass						
          elif LoadConf.find('BufferingIptv') != -1 :				
            try:		
              config.xhamster.MbBuffering.setValue(str(elements[1][1:]))	
            except:
              pass							
            Buffering=str(elements[1][1:])			
        except:
          pass  
    return Storage,Buffering
	
	
def MyConfig():	
    config.xhamster = ConfigSubsection()	
    config.xhamster.storage = ConfigSelection(default = "/", choices = Mounted())	
    config.xhamster.MbBuffering = ConfigSelection(default = "3", choices = [("1","1"),("2","2"),("3","3"),("4","4"),("5","5"),("10","10"),("15","15"),("20","20"),("25","25"),("30","30"),("35","35"),("40","40"),("45","45"),("50","50")])				
    config.xhamster.mainmenu = ConfigSelection(default = "Yes", choices = [("Yes", _("Yes")),("No", _("No"))])	 				         
    load()    
	
class MyConfigMain(Screen, ConfigListScreen):

    def __init__(self, session):
        self.session = session
        path = PatchSkin
        with open(path, "r") as f:
          self.skin = f.read()
          f.close()                       
        Screen.__init__(self, session)
        self['title'] = Label("Menu Setup" )      
        self['hdd'] = Label("" )
        self.red = Label("")
        self["Info"] = self.red               
        self.configlist = []					
        self["config"] = ConfigList(self.configlist)	  			
        ConfigListScreen.__init__(self, self.configlist, session = self.session)               
        self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions","EPGSelectActions"], {
             "ok"    : self.keyOK,
             "cancel": self.keyCancel,
             "up"  : self.keyUp,				
             "down"  : self.keyDown,
             "cancel": self.keyCancel,
             #"info" : self.About,				
             "left"  : self.keyLeft,				
             "right" : self.keyRight						
        }, -1)
        MyConfig()	    			
        self.onShown.append(self.MyConfigList)		
		
        self.LoopPannelC = eTimer()
		
        try:				
          self.LoopPannelC.callback.append(self.StorageInfo)    	
        except:			
          self.activityTimer_conn1 = self.LoopPannelC.timeout.connect(self.StorageInfo)			
		
        self.LoopPannelC.stop()        
        self.LoopPannelC.start(5000,True)   
                               
    def keyUp(self):
        self["config"].instance.moveSelection(self["config"].instance.moveUp)
        self.MyConfigList()			

    def keyDown(self):
        self["config"].instance.moveSelection(self["config"].instance.moveDown)
        self.MyConfigList()						
                    
    def keyRight(self):	
        self["config"].handleKey(KEY_RIGHT)
        self.MyConfigList()
                            
    def keyLeft(self):	
        self["config"].handleKey(KEY_LEFT)	
        self.MyConfigList()
                            
    def StorageInfo(self):		
        list = ""
        for x,j in Mounted():				
          Size,Used,Available,UsedPerc,Mount  = Hdd(x)		
          list = str(list)+j.title()+' : '+str(Available)+'\n'			  		  	
        self['hdd'].setText(str(list )) 
                    
    def MyConfigList(self):			
        self.configlist = []	
        self.configlist.append(getConfigListEntry("Dispositivo di memorizzazione", config.xhamster.storage,'storage'))
        if config.xhamster.storage.value != '/' :
          self.configlist.append(getConfigListEntry("MB Buffering Video", config.xhamster.MbBuffering,'BufferingIptv'))				
        self["config"].list = self.configlist		
        self["config"].l.setList(self.configlist)  				
                                                            
    def keyOK(self):
        for x in self["config"].list:
          x[1].save()			
        SaveConf()
        try:			
          self.LoopPannelC.stop()	
        except:
          pass			  
        self.close()		          
          
    def keyCancel(self):	
        try:			
          self.LoopPannelC.stop()	
        except:
          pass			
        self.close()	
