from imports import *

class ClassBarPlay:
      SEEK_STATE_PLAY = (0, 0, 0, ">")
      SEEK_STATE_PAUSE = (1, 0, 0, "||")
      SEEK_STATE_EOF = (1, 0, 0, "END")

      def __init__(self, actionmap = "InfobarSeekActions"):
          self.__event_tracker = ServiceEventTracker(screen=self, eventmap=
            {
              iPlayableService.evSeekableStatusChanged: self.__seekableStatusChanged,
              iPlayableService.evStart: self.__serviceStarted,

              iPlayableService.evEOF: self.__evEOF,
              iPlayableService.evSOF: self.__evSOF,
            })
          self.fast_winding_hint_message_showed = False

          class InfoBarSeekActionMap(HelpableActionMap):
                def __init__(self, screen, *args, **kwargs):
                    HelpableActionMap.__init__(self, screen, *args, **kwargs)
                    self.screen = screen

                def action(self, contexts, action):
                    if action[:5] == "seek:":
                      time = int(action[5:])
                      self.screen.IPtVdoSeekRelative(time * 90000)
                      return 1
                    elif action[:8] == "seekdef:":
                      key = int(action[8:])
                      time = (-config.seek.selfdefined_13.value, False, config.seek.selfdefined_13.value,
                        -config.seek.selfdefined_46.value, False, config.seek.selfdefined_46.value,
                        -config.seek.selfdefined_79.value, False, config.seek.selfdefined_79.value)[key-1]
                      self.screen.IPtVdoSeekRelative(time * 90000)
                      return 1					
                    else:
                      return HelpableActionMap.action(self, contexts, action)

          self["SeekActions"] = InfoBarSeekActionMap(self, actionmap,
              {
                "playpauseService": self.playpauseService,
                "pauseService": (self.pauseService, _("pause")),
                "unPauseService": (self.unPauseService, _("continue")),

                "seekFwd": (self.seekFwd, _("skip forward")),
                "seekFwdManual": (self.seekFwdManual, _("skip forward (enter time)")),
                "seekBack": (self.seekBack, _("skip backward")),
                "seekBackManual": (self.seekBackManual, _("skip backward (enter time)"))
              }, prio=-1)

          self["SeekActions"].setEnabled(False)

          self.seekstate = self.SEEK_STATE_PLAY
          self.lastseekstate = self.SEEK_STATE_PLAY

          self.onPlayStateChanged = [ ]

          self.lockedBecauseOfSkipping = False

          self.__seekableStatusChanged()

      def makeStateForward(self, n):
          return (0, n, 0, ">> %dx" % n)

      def makeStateBackward(self, n):
          return (0, -n, 0, "<< %dx" % n)

      def makeStateSlowMotion(self, n):
          return (0, 0, n, "/%d" % n)

      def isStateForward(self, state):
          return state[1] > 1

      def isStateBackward(self, state):
          return state[1] < 0

      def isStateSlowMotion(self, state):
          return state[1] == 0 and state[2] > 1

      def getHigher(self, n, lst):
          for x in lst:
            if x > n:
              return x
          return False

      def getLower(self, n, lst):
          lst = lst[:]
          lst.reverse()
          for x in lst:
            if x < n:
              return x
          return False

      def showAfterSeek(self):
          if isinstance(self, InfoBarShowHide):
            self.doShow()

      def up(self):
          pass

      def down(self):
          pass

      def getSeek(self):
          service = self.session.nav.getCurrentService()
          if service is None:
            return None
          seek = service.seek()
          if seek is None or not seek.isCurrentlySeekable():
            return None
          return seek

      def isSeekable(self):
          if self.getSeek() is None:
            return False
          return True

      def __seekableStatusChanged(self):
          if not self.isSeekable():
            self["SeekActions"].setEnabled(False)
            self.IPtVsetSeekState(self.SEEK_STATE_PLAY)
          else:
            self["SeekActions"].setEnabled(True)

      def __serviceStarted(self):
          self.fast_winding_hint_message_showed = False
          self.seekstate = self.SEEK_STATE_PLAY
          self.__seekableStatusChanged()

      def IPtVsetSeekState(self, state):
          service = self.session.nav.getCurrentService()
          if service is None:
            return False
          if not self.isSeekable():
            if state not in (self.SEEK_STATE_PLAY, self.SEEK_STATE_PAUSE):
              state = self.SEEK_STATE_PLAY
          pauseable = service.pause()
          if pauseable is None:
            state = self.SEEK_STATE_PLAY
          self.seekstate = state
          if pauseable is not None:
            if self.seekstate[0]:
              pauseable.pause()
            elif self.seekstate[1]:
              pauseable.setFastForward(self.seekstate[1])
            elif self.seekstate[2]:
              pauseable.setSlowMotion(self.seekstate[2])
            else:                      
              pauseable.unpause()
          for c in self.onPlayStateChanged:
            c(self.seekstate)
          self.checkSkipShowHideLock()
          return True

      def playpauseService(self):
          if self.seekstate != self.SEEK_STATE_PLAY:
            self.unPauseService()
          else:
            self.pauseService()

      def pauseService(self):
          if self.seekstate == self.SEEK_STATE_PAUSE:
            if config.seek.on_pause.value == "play":
              self.unPauseService()
            elif config.seek.on_pause.value == "step":
              self.IPtVdoSeekRelative(1)
            elif config.seek.on_pause.value == "last":
              self.IPtVsetSeekState(self.lastseekstate)
              self.lastseekstate = self.SEEK_STATE_PLAY
          else:
            if self.seekstate != self.SEEK_STATE_EOF:
              self.lastseekstate = self.seekstate
            self.IPtVsetSeekState(self.SEEK_STATE_PAUSE);

      def unPauseService(self):
          if self.seekstate == self.SEEK_STATE_PLAY:
            return 0
          self.IPtVsetSeekState(self.SEEK_STATE_PLAY)

      def doSeek(self, pts):
          seekable = self.getSeek()
          if seekable is None:
            return
          seekable.seekTo(pts)

      def IPtVdoSeekRelative(self, pts):
          seekable = self.getSeek()
          if seekable is None:
            return
          prevstate = self.seekstate

          if self.seekstate == self.SEEK_STATE_EOF:
            if prevstate == self.SEEK_STATE_PAUSE:
              self.IPtVsetSeekState(self.SEEK_STATE_PAUSE)
            else:
              self.IPtVsetSeekState(self.SEEK_STATE_PLAY)
          seekable.seekRelative(pts<0 and -1 or 1, abs(pts))
          if abs(pts) > 100 and config.usage.show_infobar_on_skip.value:
            self.showAfterSeek()

      def seekFwd(self):
          seek = self.getSeek()
          if seek and not (seek.isCurrentlySeekable() & 2):
            if not self.fast_winding_hint_message_showed and (seek.isCurrentlySeekable() & 1):
              self.session.open(MessageBox, _("No fast winding possible yet.. but you can use the number buttons to skip forward/backward!"), MessageBox.TYPE_INFO, timeout=10)
              self.fast_winding_hint_message_showed = True
              return
            return 0
          if self.seekstate == self.SEEK_STATE_PLAY:
            self.IPtVsetSeekState(self.makeStateForward(int(config.seek.enter_forward.value)))
          elif self.seekstate == self.SEEK_STATE_PAUSE:
            if len(config.seek.speeds_slowmotion.value):
              self.IPtVsetSeekState(self.makeStateSlowMotion(config.seek.speeds_slowmotion.value[-1]))
            else:
              self.IPtVsetSeekState(self.makeStateForward(int(config.seek.enter_forward.value)))
          elif self.seekstate == self.SEEK_STATE_EOF:
            pass
          elif self.isStateForward(self.seekstate):
            speed = self.seekstate[1]
            if self.seekstate[2]:
              speed /= self.seekstate[2]
            speed = self.getHigher(speed, config.seek.speeds_forward.value) or config.seek.speeds_forward.value[-1]
            self.IPtVsetSeekState(self.makeStateForward(speed))
          elif self.isStateBackward(self.seekstate):
            speed = -self.seekstate[1]
            if self.seekstate[2]:
              speed /= self.seekstate[2]
            speed = self.getLower(speed, config.seek.speeds_backward.value)
            if speed:
              self.IPtVsetSeekState(self.makeStateBackward(speed))
            else:
              self.IPtVsetSeekState(self.SEEK_STATE_PLAY)
          elif self.isStateSlowMotion(self.seekstate):
            speed = self.getLower(self.seekstate[2], config.seek.speeds_slowmotion.value) or config.seek.speeds_slowmotion.value[0]
            self.IPtVsetSeekState(self.makeStateSlowMotion(speed))

      def seekBack(self):
          seek = self.getSeek()
          if seek and not (seek.isCurrentlySeekable() & 2):
            if not self.fast_winding_hint_message_showed and (seek.isCurrentlySeekable() & 1):
              self.session.open(MessageBox, _("No fast winding possible yet.. but you can use the number buttons to skip forward/backward!"), MessageBox.TYPE_INFO, timeout=10)
              self.fast_winding_hint_message_showed = True
              return
            return 0
          seekstate = self.seekstate
          if seekstate == self.SEEK_STATE_PLAY:
            self.IPtVsetSeekState(self.makeStateBackward(int(config.seek.enter_backward.value)))
          elif seekstate == self.SEEK_STATE_EOF:
            self.IPtVsetSeekState(self.makeStateBackward(int(config.seek.enter_backward.value)))
            self.IPtVdoSeekRelative(-6)
          elif seekstate == self.SEEK_STATE_PAUSE:
            self.IPtVdoSeekRelative(-1)
          elif self.isStateForward(seekstate):
            speed = seekstate[1]
            if seekstate[2]:
              speed /= seekstate[2]
            speed = self.getLower(speed, config.seek.speeds_forward.value)
            if speed:
              self.IPtVsetSeekState(self.makeStateForward(speed))
            else:
              self.IPtVsetSeekState(self.SEEK_STATE_PLAY)
          elif self.isStateBackward(seekstate):
            speed = -seekstate[1]
            if seekstate[2]:
              speed /= seekstate[2]
            speed = self.getHigher(speed, config.seek.speeds_backward.value) or config.seek.speeds_backward.value[-1]
            self.IPtVsetSeekState(self.makeStateBackward(speed))
          elif self.isStateSlowMotion(seekstate):
            speed = self.getHigher(seekstate[2], config.seek.speeds_slowmotion.value)
            if speed:
              self.IPtVsetSeekState(self.makeStateSlowMotion(speed))
            else:
              self.IPtVsetSeekState(self.SEEK_STATE_PAUSE)

      def seekFwdManual(self):
          self.session.openWithCallback(self.fwdSeekTo, MinuteInput)

      def fwdSeekTo(self, minutes):
          self.IPtVdoSeekRelative(minutes * 60 * 90000)

      def seekBackManual(self):
          self.session.openWithCallback(self.rwdSeekTo, MinuteInput)

      def rwdSeekTo(self, minutes):
          self.IPtVdoSeekRelative(-minutes * 60 * 90000)

      def checkSkipShowHideLock(self):
          wantlock = self.seekstate != self.SEEK_STATE_PLAY
          if config.usage.show_infobar_on_skip.value:
            if self.lockedBecauseOfSkipping and not wantlock:
              self.unlockShow()
              self.lockedBecauseOfSkipping = False
            if wantlock and not self.lockedBecauseOfSkipping:
              self.lockShow()
              self.lockedBecauseOfSkipping = True

      def calcRemainingTime(self):
          seekable = self.getSeek()
          if seekable is not None:
            len = seekable.getLength()
            try:
              tmp = self.cueGetEndCutPosition()
              if tmp:
                len = [False, tmp]
            except:
              pass
            pos = seekable.getPlayPosition()
            speednom = self.seekstate[1] or 1
            speedden = self.seekstate[2] or 1
            if not len[0] and not pos[0]:
              if len[1] <= pos[1]:
                return 0
              time = (len[1] - pos[1])*speedden/(90*speednom)
              return time
          return False
              
      def __evEOF(self):
          if self.seekstate == self.SEEK_STATE_EOF:
            return
          seekstate = self.seekstate
          if self.seekstate != self.SEEK_STATE_PAUSE:
            self.IPtVsetSeekState(self.SEEK_STATE_EOF)
          if seekstate not in (self.SEEK_STATE_PLAY, self.SEEK_STATE_PAUSE):
            seekable = self.getSeek()
            if seekable is not None:
              seekable.seekTo(-1)
          if seekstate == self.SEEK_STATE_PLAY:
            self.doEofInternal(True)
          else:
            self.doEofInternal(False)

      def doEofInternal(self, playing):
          pass

      def __evSOF(self):
          self.IPtVsetSeekState(self.SEEK_STATE_PLAY)
          self.doSeek(0)
