# -*- coding: UTF-8 -*-
from imports import *
from Setup import *
from Moduli import *

ENIGMA_SERVICE_ID = 0x1001
DEFAULT_VIDEO_PID = 0x44
DEFAULT_AUDIO_PID = 0x45

class InfoBarMedia(Screen,ClassBarPlay):        
    def __init__(self, session,Url,Title,Trama):     
        self.session = session	
        if os.path.exists(PatchInfo):  
          f = open(PatchInfo, "r")
          self.skin = f.read()
          f.close()					  
        Screen.__init__(self, session)
                
        self.Url = Url	                  
        self["service"] = Label(str(Title))	
        self["desc"] = Label("")	

        self["Key_Green"] = Label("")
        self['green'] = Pixmap()	
        self['green'].hide()	
		
        if Trama:
          self["Key_Green"].setText('Trama')
          self['green'].show()
		  
        self.Trama = Trama		
		
        self.isTSVideo = True	
        self.seekBarLocked = False		
        ClassBarPlay.__init__(self)	
        self.OkPause = False				
        self.Loop = eTimer()		
        try:			
          self.Loop.callback.append(self.close)  
        except:		
          self.activityTimer_conn1 = self.Loop.timeout.connect(self.close) 	  	       	   	
        self.Loop.start(10000,True)			
        self["myActionMap"] = ActionMap(["MediaPlayerActions","OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions"],
        {	
        "green" : self.mytrama,		
        "ok"    : self.close,	
        "info"  : self.close,	
        "pause" : self.Pause,
        "yellow": self.Pause,		
        "red"   : self.close	
        }, -1)	

		
    def mytrama(self):
        if self.Trama:	
          self.session.open(MessageBox, (self.Trama), MessageBox.TYPE_INFO)
	
    def Pause(self):	
        if self.OkPause:
          self.OkPause = False
          self.IPtVsetSeekState(self.SEEK_STATE_PLAY)			  
        else:
          self.OkPause = True
          self.IPtVsetSeekState(self.SEEK_STATE_PAUSE)	
                  
    def lockShow(self):
        pass
                        
    def unlockShow(self):
        pass	
		
class PlayerIptv(Screen,InfoBarBase, InfoBarSeek, ClassBarPlay):        
    def __init__(self, session,url,Title,IptvTimer='3',Adulti = False,Trama = False):     
        self.session = session	
        skin = PatchPlay
        if os.path.exists(skin):  
          f = open(skin, "r")
          self.skin = f.read()
          f.close()						
        Screen.__init__(self, session)	
        InfoBarBase.__init__(self)
        InfoBarSeek.__init__(self)	
        ClassBarPlay.__init__(self)			
        self["progress"] = ProgressBar()
        self["progress"].setValue(0)	
        OnclearMem()		
        self.progress = 0	
        self["Key_Red"] = Label(_("Exit"))	
        self["Key_Green"] = Label("")
        self['green'] = Pixmap()	
        self['green'].hide()		
        self['red'] = Pixmap()	
        self['red'].show()	
        self['infobar'] = Pixmap()	
        self['infobar'].show()		
        self.url = url
        self.Title = Title
        self.Trama = Trama		
        self["service"] = Label(self.Title)		
        self.IptvTimer = IptvTimer
        self["Tot"] = Label('| '+self.IptvTimer+' Mb')
        self["Parz"] = Label("0 Mb | ")	
        self["Avviso"] = Label("")		
        self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
        self.lastservice1 = ''
		
        self.LoopService = eTimer()		
        self.Loop = eTimer()
        self.LoopBuffering = eTimer()
        self.LoopBufferingPlay = eTimer()
        self.LoopPlay = eTimer()
        self.LoopProgressBuffering = eTimer()			

        try:				
          self.LoopPlay.callback.append(self.play)  
          self.Loop.callback.append(self.CicleTimer)  		
          self.LoopService.callback.append(self.StopService)  		
          self.LoopBuffering.callback.append(self.BufferingControl)
          self.LoopBufferingPlay.callback.append(self.Player)  			
          self.LoopProgressBuffering.callback.append(self.ProgressBuffering)  	
        except:			
          self.activityTimer_conn1 = self.LoopPlay.timeout.connect(self.play)		
          self.activityTimer_conn2 = self.Loop.timeout.connect(self.CicleTimer)		
          self.activityTimer_conn3 = self.LoopService.timeout.connect(self.StopService)
          self.activityTimer_conn4 = self.LoopBuffering.timeout.connect(self.BufferingControl)
          self.activityTimer_conn5 = self.LoopBufferingPlay.timeout.connect(self.Player)
          self.activityTimer_conn6 = self.LoopProgressBuffering.timeout.connect(self.ProgressBuffering)

        self.Loop.stop()			
        self.LoopService.stop()		
        self.LoopBuffering.stop()			
        self.LoopBufferingPlay.stop()			
        self.LoopPlay.stop()			
        self.LoopProgressBuffering.stop()	
		
        self.Count = 0		
        self.CicleInfo = False		
        self.Http = False	
        self.ForcePlay = False		
        self.PlayLock = True
        self.seekstate = None
        self.OkInfo = False	
        self.Storage,self.Buffering =load()	
        if self.url.find('http') != -1:	    
          if self.Storage == '/':
            self["Tot"] = Label('')
            self["Parz"] = Label("")	
            self["Avviso"] = Label("")	
            self.OffPlayForce = False	
            self.LoopPlay.start(1000,True)			
            self.Count = 99999		
          elif Adulti :
            self["Tot"] = Label('')
            self["Parz"] = Label("")	
            self["Avviso"] = Label("")	
            self.OffPlayForce = False	
            self.LoopPlay.start(1000,True)			
            self.Count = 99999					
          else:			
            self.OffPlayForce = True	
            self.Http = True	
            self.OnBuffering = True		
            self.startDownload()	
        else:		 
          self.OnBuffering = True		
          self.Loop.start(2*1000,True)					
          self.OffPlayForce = True		
        self["myActionMap"] = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions"],
        {	
        "ok": self.info,	
        "info": self.info,			
        "green": self.PlayForce,	
        "cancel": self.precancel,		
        "red": self.precancel	
        }, -1)				
                                
    def BufferingControl(self):
        self.TimeBuff = str(InfoBarSeek.calcRemainingTime(self))
        if self.seekstate == self.SEEK_STATE_PLAY:
          try:	
            if self.PlayLock or container.running():		 
              if int(self.TimeBuff) < 85:
                self.Pause()
                try:
                  self.LoopBuffering.stop()
                except:
                  pass	
              else:		
                self.LoopBuffering.start(100,True) 
            else:			
              return				  
          except:				
            self.LoopBuffering.start(3000,True) 			 
                
    def PlayForce(self):
        self.ForcePlay = True
        self.LoopPlay.start(2000,True)
        
    def ResetTxt(self):
        try:		
          self['green'].hide()
          self['red'].hide()	
          self['infobar'].hide()		
          self["Key_Green"].setText('')
          self["Key_Red"].setText('')  
          self["service"].setText('') 	  
          self["progress"].setValue(0)
          self["Tot"].setText('')
          self["Parz"].setText('')
          self["Avviso"].setText("")			
        except:
          pass  	
                                                
    def ProgressBuffering(self):
        self.progress = self.progress+1
        self["progress"].setValue(self.progress)
        if self.progress < 100:
          self.LoopProgressBuffering.start(100,True)
        elif self.progress == 100:
          self["progress"].setValue(0)
                
    def Player(self):
        self["Avviso"].setText("")
        self["progress"].setValue(0)
        self.PlayLock = True
        self.seekstate = self.SEEK_STATE_PLAY	
        ClassBarPlay.IPtVdoSeekRelative(self,-1)# mod 03-10-2015
        self.IPtVsetSeekState(self.SEEK_STATE_PLAY)	
        self.ResetTxt()
        self.LoopBuffering.start(3000,True) 
        
    def Pause(self):
        if not self.PlayLock and not container.running():
          return
        self.progress = 0
        self.ProgressBuffering()
        self["Avviso"].setText("Attendere.. ... Buffering insufficiente per proseguire.")	
        self['infobar'].show()
        self.seekstate = self.SEEK_STATE_PAUSE
        self.IPtVsetSeekState(self.SEEK_STATE_PAUSE)	
        self.LoopBufferingPlay.start(10*1000,True)
        
    def info(self):
        self.session.open(InfoBarMedia,self.url,self.Title,self.Trama)
                
    def StopService(self):
        try:	
          self.LoopService.stop()	
        except:
          pass  			
        self.CicleInfo = False	
        try:		 
          self.ResetTxt()		
        except:
          pass  	
      
    def precancel(self):
        if self.CicleInfo:
          self.StopService()
        else:	   
          self.session.openWithCallback(self.cancel,MessageBox,_("Vuoi uscire"),MessageBox.TYPE_YESNO, timeout = 20)
        
    def doEofInternal(self, playing):	
        if not playing:	
          if self.Count < 3:
            self["Avviso"].setText("Verde per riavvio - Red per uscire")
            self.OffPlayForce = False 			
            self['green'].show()	
            self['red'].show()
            self['infobar'].show()
            self["Key_Green"].setText('Play')
            self.Count = self.Count +1
          elif self.Count == 99999:	
            pass		
          else:
            self["Avviso"].setText("Spiacente!! Il video non é più funzionante\nPremere rosso per uscire")
            self['infobar'].show()
        else:
          if self.PlayLock or container.running():		 
            self.Pause()	
            return		
          self.seekstate = self.SEEK_STATE_EOF
          self.PlayLock = False		
          self.cancel(True)
                
    def lockShow(self):	
        if self.seekstate != self.SEEK_STATE_PAUSE:
          self.doEofInternal(True)
                
    def unlockShow(self):
        pass

    def startDownload(self):
        self.currentDownload = downloadWithProgress(str(self.url), self.Storage+'/Streaming.mp4')	
        self.currentDownload.addProgress(self.CicleTimer)
        self.currentDownload.start().addCallback(self.stopDownload).addErrback(self.downloadFailed)
                
    def downloadFailed(self):
        self.PlayLock = False	
        try:
          self.currentDownload.stop()
        except:
          pass		
        self["Avviso"].setText("Spiacente!! Errore durante il buffering\nPremere rosso per uscire")
        self['infobar'].show()
        self["Tot"].setText('')
        
    def stopDownload(self):	
        self.PlayLock = False	
        try:
          self.currentDownload.stop()	
        except:
          pass        		
        self["Tot"].setText('')
        
    def CicleTimer(self, receivedBytes=None, totalBytes=False):
        if receivedBytes > 100 and receivedBytes == totalBytes:
          self.PlayLock = False		
        if self.ForcePlay:
          return
        if self.Http:            
          self.url = self.Storage+'/Streaming.mp4'	
        if totalBytes:
          if int(self.IptvTimer) >= float(int(totalBytes)/1024/1024):
            self.IptvTimer = float(int(totalBytes)/1024/1024)
            if int(float(os.path.getsize(self.url)) / float(int(self.IptvTimer) *1024*1024) * 100) < 99:
              self["Tot"].setText('| '+str(self.IptvTimer)+' Mb')
        if not self.OnBuffering:
          return
        try:
          jSize = os.path.getsize(self.url)/1024/1024	
        except:
          jSize = 0	 
        try:
          jSizeStart = os.path.getsize(self.url)
        except:
          jSizeStart = 0			   
        try:
          self.progress = int(float(os.path.getsize(self.url)) / float(int(self.IptvTimer) *1024*1024) * 100)		
        except:
          self.progress = 0		
        self['infobar'].show()		
        self["Parz"].setText(str(jSize)+' Mb | ')
        self["progress"].setValue(self.progress)
        if jSizeStart == 0:
          self["Avviso"].setText("Connection.....\nWait ....."+str(self.Count))	
          if self.Count == 4:		
            self["Avviso"].setText("Connection.....\nWait last check")	
          if self.Count == 5:
            self["progress"].setValue(0)
            self.cancel(True)
            return
          if not self.Http:		
            self.Loop.start(10*1000)
          self.Count = self.Count+1		
        else:
          self.Count = 0
          self["Avviso"].setText("")	  
          self.OffPlayForce	= False
          self['green'].show()	
          self['red'].show()	
          self['infobar'].show()		
          self["Key_Green"].setText('Force Play')				
          if jSize < int(self.IptvTimer) :
            if not self.Http:
              self.Loop.start(500)
          else:
            if self.OnBuffering:						
              try:
                self.Loop.stop()
              except:
                pass	
              self.LoopPlay.start(1000,True)			
            if self.Http:			
              self.OnBuffering = False									
                
    def cancel(self, answer):
        if answer :	
          try:
            self.LoopBuffering.stop()
          except:
            pass			
          self.session.nav.stopService()
          self.session.nav.playService(self.lastservice)	
          container.kill()			
          os.system('rm -fr '+self.Storage+'/Streaming.mp4')
          self.stopDownload()	
          OnclearMem()			
          self.close()     
                
    def play(self):		
        if self.OffPlayForce:
          return	
        self.ResetTxt()		
        try:		
          self.session.nav.stopService()   	
          self.fileRef = eServiceReference(ENIGMA_SERVICE_ID, 0, str(self.url))
          self.fileRef.setData(0,DEFAULT_VIDEO_PID)
          self.fileRef.setData(1,DEFAULT_AUDIO_PID)
          self.session.nav.playService(self.fileRef)	
          self.seekstate = self.SEEK_STATE_PLAY	
          self.PlayLock = True		
          self.LoopBuffering.start(3000,True) 
        except:
          pass  
        try:			  
          self.Loop.stop()
        except:
          pass  		
        self.OffPlayForce = True		
                
