﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2015
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.twagenthelper import twAgentGetPage, TwAgentHelper
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer

glob_agent = 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0'
ck = CookieJar()
initCookies = True
proxyurl = 'http://hdfilme.tv:80/noconnect'
agent = TwAgentHelper(proxy_url=proxyurl, gzip_decoding=True, followRedirect=True, cookieJar=ck, headers={'User-Agent':glob_agent})

class hdfilmeMain(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("HDFilme")
		self['ContentTitle'] = Label(_("Selection"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		#ck.clear()
		self.keyLocked = False
		self.onLayoutFinish.append(self.layoutFinished)
		self.onClose.append(self.hdfilmeExit)

	def layoutFinished(self):
		self.keyLocked = True
		self.streamList.append(("Serien","http://hdfilme.tv/movie-series?&per_page="))
		self.streamList.append(("Kinofilme","http://hdfilme.tv/movie-cinemas?&per_page="))
		self.streamList.append(("Abenteuer","http://hdfilme.tv/movie-movies?cat=72&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Action","http://hdfilme.tv/movie-movies?cat=73&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Animation","http://hdfilme.tv/movie-movies?cat=74&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Drama","http://hdfilme.tv/movie-movies?cat=62&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Fantasy","http://hdfilme.tv/movie-movies?cat=66&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Horror","http://hdfilme.tv/movie-movies?cat=69&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Komödie","http://hdfilme.tv/movie-movies?cat=71&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Krimi","http://hdfilme.tv/movie-movies?cat=78&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Sci-Fi","http://hdfilme.tv/movie-movies?cat=84&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Romance","http://hdfilme.tv/movie-movies?cat=83&country=&order_f=id&order_d=desc&per_page="))
		self.streamList.append(("Thriller","http://hdfilme.tv/movie-movies?cat=88&country=&order_f=id&order_d=desc&per_page="))
		self.ml.setList(map(self._defaultlistcenter, self.streamList))
		self.keyLocked = False
		self.showInfos()

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		genre = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		self.session.open(hdfilmeParsing, genre, url)

	def hdfilmeExit(self):
		global initCookies
		initCookies = True

class hdfilmeParsing(MPScreen):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("HDFilme")
		self['ContentTitle'] = Label("")
		self['Page'] = Label(_("Page:"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.page = 1
		self.lastpage = 1
		self.keyLocked = True
		if initCookies:
			self.onLayoutFinish.append(self.getCookies)
		else:
			self.onLayoutFinish.append(self.loadPage)

	def getCookies(self):
		agent.getWebPage("http://hdfilme.tv/").addCallback(lambda _:self.loadPage()).addErrback(self.dataError)

	def loadPage(self):
		self.streamList = []
		if self.page > 1:
			url = self.url+str((self.page-1)*50)
		else:
			url = self.url
		agent.getWebPage(url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		global initCookies
		if initCookies and 'id="gaIframe"' in data:
			return reactor.callLater(1,self.getCookies)
		initCookies = False

		self.getLastPage(data, '', '</i>\s*Seite.*?/\s*(\d+)')
		movies = re.findall('data-popover="movie-data.*?">\s*<a href="(.*?)">\s*<img.*?src="(.*?)".*?alt="(.*?)"', data, re.I)
		if movies:
			for url,bild,title in movies:
				self.streamList.append((decodeHtml(title),url,bild))
		if len(self.streamList) == 0:
			self.streamList.append((_('No movies found!'), None, None))
		else:
			self.keyLocked = False
		self.ml.setList(map(self._defaultlistleft, self.streamList))
		self.showInfos()

	def showInfos(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		title = self['liste'].getCurrent()[0][0]
		self.coverurl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(self.coverurl)
		self['name'].setText(title)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		self.session.open(hdfilmeStreams, title, url, cover)

class hdfilmeStreams(MPScreen):
	video_formats = (
			{
				'38' : 5, #MP4 Original (HD)
				'37' : 5, #MP4 1080p (HD)
				'22' : 4, #MP4 720p (HD)
				'35' : 2, #FLV 480p
				'18' : 1, #MP4 360p
				'34' : 3, #FLV 360p
			},
			{
				'38' : 5, #MP4 Original (HD)
				'37' : 5, #MP4 1080p (HD)
				'22' : 4, #MP4 720p (HD)
				'35' : 1, #FLV 480p
				'18' : 2, #MP4 360p
				'34' : 3, #FLV 360p
			},
			{
				'38' : 2, #MP4 Original (HD)
				'37' : 1, #MP4 1080p (HD)
				'22' : 1, #MP4 720p (HD)
				'35' : 3, #FLV 480p
				'18' : 4, #MP4 360p
				'34' : 5, #FLV 360p
			}
		)
	new_video_formats = (
			{
				'1080P' : 3, #MP4 1080p
				'720P' : 2, #MP4 720p
				'360P' : 1, #MP4 360p
			},
			{
				'1080P' : 2, #MP4 1080p
				'720P' : 1, #MP4 720p
				'360P' : 3, #MP4 360p
			},
			{
				'1080P' : 1, #MP4 1080p
				'720P' : 2, #MP4 720p
				'360P' : 3, #MP4 360p
			}
		)

	def __init__(self, session, title, url, cover):
		self.movietitle = title
		self.url = url
		self.cover = cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
		}, -1)

		self['title'] = Label("HDFilme")
		self['leftContentTitle'] = Label(_("Stream Selection"))
		self['ContentTitle'] = Label(_("Stream Selection"))
		self['name'] = Label(self.movietitle)
		self['F4'] = Label("Stream")
		self['F4'].hide()

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		agent.getWebPage(self.url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		m = re.search(">Folge:</(.*?)</div>", data, re.S)
		if m:
			streams = re.findall('_episode="(\d+)" _link="" _sub=""\s+href="(.*?)"', m.group(1), re.S)
			if not streams:
				streams = re.findall('_episode="(\d+)" _link="(.*?)" _sub=".*?"\s+(.*?)', m.group(1), re.S)
			for (epi_num, link) in streams:
				self.streamList.append(('Folge '+epi_num, link, epi_num))

		if len(self.streamList) == 0:
			self.streamList.append((_('No supported streams found!'), None, None))
		else:
			self.keyLocked = False
		self.ml.setList(map(self._defaultlisthoster, self.streamList))
		CoverHelper(self['coverArt']).getCover(self.cover)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		link = self['liste'].getCurrent()[0][1]
		self.getStreamUrl(link)

	def makeTitle(self):
		episode = self['liste'].getCurrent()[0][2]
		if episode:
			title = "%s - Folge %s" % (self.movietitle, episode)
		else:
			title = self.movietitle
		return title

	def getStreamUrl(self, link):
		import codecs, base64
		if not link.startswith('http'):
			stream_url = str(codecs.decode(base64.decodestring(link), 'rot_13'))
		else:
			stream_url = link
		if stream_url.startswith('http://hdfilme.tv/'):
			getPage(link).addCallback(self.extractStream, videoPrio=int(config.mediaportal.videoquali_others.value)).addErrback(self.dataError)
		elif '/picasaweb' in stream_url:
			getPage(stream_url).addCallback(self.extractPicasa, stream_url, videoPrio=int(config.mediaportal.videoquali_others.value)).addErrback(self.dataError)
		elif '.youtube.' in stream_url:
			m = re.search('\?v=(.*?)(&|)', stream_url)
			if m:
				id = m.group(1)
				title = self.makeTitle()
				self.session.open(
					YoutubePlayer,
					[(title, id, self.cover)],
					playAll = False,
					showPlaylist=False,
					showCover=True
					)
			else:
				self.stream_not_found()
		else:
			self.play(stream_url)

	def extractStream(self, data, videoPrio=2):
		m = re.search('var newlink = (\[.*?\])', data)
		d = json.loads('{"streams":%s}' % m.group(1)) if m else {}
		links = {}
		for stream in d.get('streams'):
			key = stream.get('label')
			if key:
				if self.new_video_formats[videoPrio].has_key(key):
					links[self.new_video_formats[videoPrio][key]] = stream.get('file')
				else:
					print 'no format prio:',key

		try:
			video_url = links[sorted(links.iterkeys())[0]]
		except (KeyError,IndexError):
			print "Error: no video url found:\n",data
			self.stream_not_found()
		else:
			self.play(str(video_url))

	def extractPicasa(self, data, p_url, videoPrio=2):
		id = p_url.split('#')[-1]
		video_url = None
		m = re.search('"gphoto\$id":"%s".*?"media":\{"content":\[(.*?)\]' % id, data)
		if m:
			links = {}
			streams = re.findall('"url":"(https://redirector.googlevideo.*?)"', m.group(1))
			for url in streams:
				m = re.search('itag=(\d+)', url)
				if m:
					key = m.group(1)
					if self.video_formats[videoPrio].has_key(key):
						links[self.video_formats[videoPrio][key]] = urllib.unquote_plus(url)
					else:
						print 'no stream:',key,url

			try:
				video_url = links[sorted(links.iterkeys())[0]]
			except (KeyError,IndexError):
				print "Error: no video url found"
			else:
				pass
		else:
			print 'no id found'

		if not video_url:
			self.stream_not_found()
		else:
			self.play(video_url)

	def play(self, url):
		title = self.makeTitle()
		self.session.open(SimplePlayer, [(title, url, self.cover)], showPlaylist=False, ltype='hdfilme', cover=True)

	def stream_not_found(self):
		self.session.open(MessageBoxExt, _("Sorry, can't extract a stream url."), MessageBoxExt.TYPE_INFO, timeout=5)
