﻿# -*- coding: utf-8 -*-

from os.path import isfile
import glob
from Plugins.Extensions.MediaPortal.plugin import _
from imports import *
from simpleplayer import SimplePlayer, SimplePlaylistIO
from Components.FileList import FileList
from debuglog import printlog as printl
from configlistext import ConfigListScreenExt
from Plugins.Extensions.MediaPortal.resources.choiceboxext import ChoiceBoxExt

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/SerienFilm/MovieSelection.pyo'):
	from Plugins.Extensions.SerienFilm.MovieSelection import MovieSelection
else:
	from Screens.MovieSelection import MovieSelection
from Plugins.Extensions.MediaPortal.resources.hlsplayer import *

TVG_LOGO_BASE = "http://logo.tvip.ga/"
TVG_INK_LOGO_BASE = "http://logo.iptv.ink/"
TVG_WOW_LOGO_BASE = "http://wownet.ro/logo/"
TVG_CHANNEL_LOGO_PATH = "/usr/share/MediaPortal/channel-icons/"
global colors
colors = {
		'orange': '0xFFA500',
		'orangered': '0xFF4500',
		'lightgrey': '0xD3D3D3',
		'gold': '0xFFD700',
		'goldenrod': '0xDAA520',
		'olivedrab': '0x6B8E23',
		'deeppink': '0xFF1493',
		'red': '0xFF0000',
	}
DEFAULT_COLOR = 'lightgrey'

class simplelistGenreScreen(MPScreen, ThumbsHelper):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config.mediaportal.minitv.value)

		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"5"		: self._keyShowThumb,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"menu": self.keyMenu,
			"red": self.keyCancel,
			"green": self.overwriteM3U,
			"yellow": self.handleGroups,
			"blue": self.deleteEntry
		}, -1)

		if fileExists("/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/plugin.pyo"):
			self.filelist_path = config.plugins.mediainfo.savetopath.value
		else:
			self.filelist_path = "/media/hdd/movie/"

		self.keyLocked = True
		self['title'] = Label("SimpleList")
		self['name'] = Label(_("Selection:"))
		self['F2'] = Label(_("Update PL"))
		self['F2'].hide()
		self['F3'] = Label(_("IPTV Genre"))
		self['F3'].hide()
		self['F4'] = Label(_("Delete PL"))
		self['F4'].hide()

		self.last_pl_number = config.mediaportal.sp_pl_number.value
		self.last_videodir = config.movielist.last_videodir.value
		config.movielist.last_videodir.value = self.filelist_path
		self.last_selection = None
		self.filelist = []
		self.genreliste = None
		self.playlist_num = 1
		self.menu_level = 0
		self.last_menu_idx = 0
		self.ltype = ''
		self.m3u_title = None
		self.lastservice = None
		self.sp_option = ""
		self.tvg_infos = False
		self.group_list = None
		self.group_set = set()
		self.m3u_list = {}
		self.group_stype = 'all'
		self.m3u_file = None
		self.m3u_update_fn = None
		self.logo_base = None
		self.enableThumbs = None

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onClose.append(self._onClose)

		self.onLayoutFinish.append(self.buildMenulist)

	def buildMenulist(self):
		self['F1'].setText(_("Exit"))
		self['ContentTitle'].setText(_('List overview'))
		self.genreliste = []
		self.genreliste.append(('1', _('Video List'), ''))
		path = config.mediaportal.watchlistpath.value + 'mp_global_pl_*'
		list = glob.glob(path)
		for fn in list:
			n = int(re.search('mp_global_pl_(\d+)', fn).group(1))
			self.genreliste.append(('2', 'Global Playlist-%02d' % n, n))

		self.m3u_list.clear()
		path = self.plugin_path + "/userfiles/"
		list = glob.glob(path + '*.m3u')
		for upath in list:
			fn = upath.split('/')[-1]
			self.m3u_list[fn] = upath
			wpath = config.mediaportal.watchlistpath.value + fn
			if not fileExists(wpath) and not fileExists(wpath+'.del'):
				try:
					shutil.copyfile(upath, wpath)
				except:
					pass

		path = config.mediaportal.watchlistpath.value + '*.m3u'
		list = glob.glob(path)
		for fn in list:
			self.genreliste.append(('3', fn.split('/')[-1], fn))

		self.genreliste.sort(key=lambda t : t[0]+t[1].lower())

		self.ml.setList(map(self.simplelistListEntry, self.genreliste))
		self.keyLocked = False
		self['F2'].show()
		self['F4'].show()

	def loadFileList(self):
		self.ltype = 'sl_movies'
		self.session.openWithCallback(self.getSelection, MovieSelection, selectedmovie=self.last_selection)

	def getSelection(self, current):
		from ServiceReference import ServiceReference
		if current:
			if type(current) == tuple:
				current = current[0]
			sref = ServiceReference(current)
			self.last_selection = current
			url = sref.getPath()
			fn = sref.getServiceName()
			self.session.openWithCallback(self.loadFileList, SimplePlayer, [(fn, url)], showPlaylist=False, ltype=self.ltype, googleCoverSupp=config.mediaportal.simplelist_gcoversupp.value, embeddedCoverArt=True)
		else:
			self.keyCancel()

	def globalList(self):
		self.ltype = 'sl_glob_playlist'
		self['ContentTitle'].setText("Global Playlist-%02d" % self.playlist_num)
		self.filelist = SimplePlaylistIO.getPL('mp_global_pl_%02d' % self.playlist_num)
		if self.filelist == []:
			self.keyLocked = True
			self.filelist.append((_("No entrys found!"), "", "dump", None))
		else:
			self.keyLocked = False
		self.ml.setList(map(self._defaultlistleft, self.filelist))
		self['liste'].moveToIndex(0)

	def deleteEntry(self):
		if self.menu_level == 1:
			if not self.filelist:
				self.session.open(MessageBoxExt, _("No playlist found"), MessageBoxExt.TYPE_INFO, timeout=2)
				return
			idx = self['liste'].getSelectedIndex()
			SimplePlaylistIO.delEntry('mp_global_pl_%02d' % self.playlist_num, self.filelist, idx)
			self.ml.setList(map(self._defaultlistleft, self.filelist))
		else:
			sel = self['liste'].getCurrent()[0][0]
			if sel in ('2', '3'):
				self.deletePL()

	def loadM3UList(self, m3ufile):
		self.ltype = 'sl_m3ulist'
		self.m3u_file = m3ufile
		self.m3u_title = m3ufile.split('/')[-1]
		ctitle = self.m3u_title + " (\"{0}/\")".format("/".join(m3ufile.split('/')[0:-1]))
		self['ContentTitle'].setText(ctitle)
		self['F3'].hide()
		self.filelist = []
		self.group_set.clear()
		self.group_list = [
				( _('Show all channels'), 'all')
			]
		self.sp_option = "MP3"
		self.logo_base = ""
		extm3u = extinf = self.tvg_infos = logos = False
		title = path = logo = ""
		tvg_data = None
		do_append = True
		try:
			with open(m3ufile, "rU") as inf:
				for line in inf:
					line = line.strip()
					if not extm3u and '#EXTM3U' in line:
						extm3u = True
						if '$' in line:
							options = line.split(',')[1:]
							for option in options:
								mode, attr = option.split('=')
								if mode == '$MODE':
									self.sp_option = attr
								elif mode == '$LOGOBASE':
									self.logo_base = attr
					elif  extm3u and not extinf and line.startswith('#EXTINF:'):
						m = re.search('\s*[-]*\d+(,|\s)(.+)', line[8:])
						if m:
							extinf = True
							title = m.group(2).split(',')[-1].strip()
							if 'tvg-id=' in m.group(0):
								self.enableThumbs = True
								if 'group-title=' in m.group(0):
									m2 = re.search('tvg-id="(.*?)".*?group-title="(.*?)".*?tvg-logo="(.*?)"', m.group(0))
									if m2:
										tvg_data = ('TVG',) + m2.groups()[:2]
										logo = self.logo_base + m2.groups()[2]
										k = tvg_data[2].lower()
										if k != self.group_stype and 'all' != self.group_stype:
											do_append = False

										if not k in self.group_set:
											self.group_set.add(k)
											self.group_list.append((_("Show \"{0}\" channels").format(tvg_data[2].title()), k))
										self.tvg_infos = True
										m2 = re.search('\[COLOR\s(.*?)\]', title)
										tvg_data += (colors.get(m2.group(1), DEFAULT_COLOR),) if m2 else colors[DEFAULT_COLOR]
										title = re.sub('(\[/*.*?\])', '', title)
								else: # Senderliste
										m2 = re.search('tvg-id="(.*?)".*?tvg-logo="(.*?)"', m.group(0))
										if m2:
											tvg_data = ('TVG-LIST',) + m2.groups()[:1]
											logo = self.logo_base + m2.groups()[1]

											m2 = re.search('\[COLOR\s(.*?)\]', title)
											tvg_data += (colors.get(m2.group(1), DEFAULT_COLOR),) if m2 else colors[DEFAULT_COLOR]
											title = re.sub('(\[/*.*?\])', '', title)
											k = title.lower()
											if k != self.group_stype and 'all' != self.group_stype:
												do_append = False
							elif 'group-title=' in m.group(0): # other tvg pl typ
								m2 = re.search('group-title="(.*?)"', m.group(0))
								if m2:
									k = m2.group(1).lower()
									if k != self.group_stype and 'all' != self.group_stype:
										do_append = False

									if not k in self.group_set:
										self.group_set.add(k)
										self.group_list.append((_("Show \"{0}\" channels").format(m2.group(1).title()), k))
								tvg_data = (colors[DEFAULT_COLOR],)
							else:
								tvg_data = (colors[DEFAULT_COLOR],)
						else:
							title = path = logo = ""
							extinf = False
							tvg_data = None
							do_append = True
							continue

					elif extm3u and extinf and line:
						path = line
						if path.endswith('#m3u#'):
							path = path.replace('#m3u#', '')
							options = ""
							if self.sp_option:
								options += ',$MODE=' + self.sp_option
							if self.logo_base:
								options += ',$LOGOBASE=' + self.logo_base
							return self.getPL(path, m3ufile, options)

					if extinf and path:
						if do_append:
							if logo:
								logos = True
								if not logo[:4] in ('http', 'file'):
									logo_base = TVG_LOGO_BASE if not 'iptv.ink' in path else TVG_INK_LOGO_BASE
									logo = logo_base + logo
							self.filelist.append((title, path, logo, tvg_data))
						title = path = logo = ""
						extinf = False
						tvg_data = None
						do_append = True

		except IOError, e:
			printl(e,self,'E')

		if self.filelist == []:
			self.keyLocked = True
			self.filelist.append((_("No entrys found!"), "", "", (colors[DEFAULT_COLOR],)))
		else:
			self.keyLocked = False

		if not self.tvg_infos:
			self.group_stype = 'all'
		if len(self.group_set) > 0:
			self['F3'].show()

		self.ml.setList(map(self.simpleListTVGListEntry, self.filelist))
		self['liste'].moveToIndex(0)
		if logos:
			self.th_ThumbsQuery(self.filelist, 0, 1, 2, None, None, 1, 1, mode=0)

	def getPL(self, path, m3u_file, options):
		getPage(path, agent='Mozilla/5.0 (X11; Linux x86_64; rv:10.0) Gecko/20100101 Firefox/10.0 (Chrome)').addCallback(self.gotPL, m3u_file, options).addErrback(self.gotPLError)

	def gotPL(self, pl, m3u_file, options):
		pl = re.sub('#EXTM3U\s*.+', '#EXTM3U'+options, pl)
		f = open(m3u_file, 'wb')
		f.write(pl)
		f.close()
		self.loadM3UList(m3u_file)

	def gotPLError(self, result):
		printl(str(result),self,'E')
		self.filelist.append((_("Can't download playlist"), "", "", None))
		self.ml.setList(map(self._defaultlistleft, self.filelist))

	def keyMenu(self):
		self.session.open(SimplelistConfig)

	def keyOK(self):
		if self.keyLocked:
			return
		if self.menu_level == 1:
			if self.ltype == 'sl_glob_playlist':
				idx = self['liste'].getSelectedIndex()
				self.session.open(SimplePlayer, [], playIdx=idx, playList2=self.filelist, plType='global', ltype=self.ltype, playAll=True, googleCoverSupp=config.mediaportal.simplelist_gcoversupp.value, useResume=False)
			elif self.ltype == 'sl_m3ulist':
				idx = self['liste'].getSelectedIndex()
				if 'TVG-LIST' in self.filelist[idx][3]: return
				force_hls_player = config.mediaportal.use_hls_proxy.value or self.filelist[idx][1].startswith('newtopia-stream')
				if force_hls_player and ('.m3u8' in self.filelist[idx][1])>0:
					if not config.mediaportal.use_hls_proxy.value:
						self.session.open(MessageBoxExt, _("If you want to play this stream, you have to activate the HLS-Player in the MP-Setup"), MessageBoxExt.TYPE_INFO)
						return
				if '|' in self.filelist[idx][1]:
					if not config.mediaportal.use_hls_proxy.value:
						self.session.open(MessageBoxExt, _("If you want to play this stream, you have to activate the HLS-Player in the MP-Setup"), MessageBoxExt.TYPE_INFO)
						return

				self.lastservice = self.session.nav.getCurrentlyPlayingServiceReference()
				self.session.openWithCallback(self.restoreLastService, SimplePlayer, self.filelist, playIdx=idx, ltype=self.ltype, playAll=True, googleCoverSupp=config.mediaportal.simplelist_gcoversupp.value, useResume=False, listTitle=self.m3u_title, playerMode=self.sp_option, cover=self.tvg_infos)
		else:
			self['F1'].setText(_("Return"))
			self.last_menu_idx = self['liste'].getSelectedIndex()
			sel = self['liste'].getCurrent()[0][0]
			title = self['liste'].getCurrent()[0][1]
			self['ContentTitle'].setText(title)
			self.menu_level = 1
			self.group_stype = 'all'
			self.enableThumbs = None
			if sel == '1':
				self.loadFileList()
			elif sel == '3':
				self['F2'].hide()
				self['F4'].hide()
				fpath = self['liste'].getCurrent()[0][2]
				self.loadM3UList(fpath)
			else:
				self['F2'].hide()
				self.playlist_num = self['liste'].getCurrent()[0][2]
				self.globalList()

	def _onClose(self):
		config.movielist.last_videodir.value = self.last_videodir

	def _keyShowThumb(self):
		if self.enableThumbs:
			self.keyShowThumb()

	def keyCancel(self):
		if self.menu_level == 0:
			self.close()
		else:
			self['F1'].setText(_("Exit"))
			self.menu_level = 0
			self.keyLocked = False
			self.ltype = ''
			self['F2'].show()
			self['F3'].hide()
			self['F4'].show()
			self['ContentTitle'].setText(_('List overview'))
			self.ml.setList(map(self.simplelistListEntry, self.genreliste))
			self['liste'].moveToIndex(self.last_menu_idx)

	def restoreLastService(self):
		if config.mediaportal.restorelastservice.value == "1":
			if not config.mediaportal.backgroundtv.value:
				self.session.nav.playService(self.lastservice)
			else:
				self.session.nav.stopService()

	def handleGroups(self):
		if not len(self.group_set): return
		sel = 0
		if not self.group_stype: self.group_stype = 'all'
		for me in self.group_list:
			if me[1] == self.group_stype: break
			sel += 1

		self.session.openWithCallback(self.cb_handleGroups, ChoiceBoxExt, title=_("IPTV Genre Selection"), list = self.group_list, selection=sel)

	def cb_handleGroups(self, answer):
		stype = answer and answer[1]
		if stype and self.group_stype != stype:
			self.group_stype = stype
			self.loadM3UList(self.m3u_file)

	def overwriteM3U(self):
		if not self.keyLocked and self.menu_level == 0:
			sel = self['liste'].getCurrent()[0][0]
			title = self['liste'].getCurrent()[0][1].split('/')[-1]
			if sel == '3':
				if title in self.m3u_list:
					list = (
							( _('Yes'), "1"),
							( _('No'), "0")
						)
					self.m3u_update_fn = title
					self.session.openWithCallback(self.cb_overwriteM3U, ChoiceBoxExt, title=_("Overwrite \"{0}\" with the MP playlist?").format(title), list = list)
				else:
					self.session.open(MessageBoxExt, _("No MP playlist \"{0}\" found").format(title), MessageBoxExt.TYPE_INFO, timeout=3)

	def cb_overwriteM3U(self, answer):
		stype = answer and answer[1]
		if stype and stype == "1":
			wpath = config.mediaportal.watchlistpath.value + self.m3u_update_fn
			try:
				shutil.copyfile(self.m3u_list[self.m3u_update_fn], wpath)
				self.session.open(MessageBoxExt, _("Playlist \"{0}\" successfully updated").format(self.m3u_update_fn), MessageBoxExt.TYPE_INFO, timeout=3)
			except:
				self.session.open(MessageBoxExt, _("Can't update \"{0}\" playlist").format(self.m3u_update_fn), MessageBoxExt.TYPE_ERROR)

	def deletePL(self):
		if not self.keyLocked and self.menu_level == 0:
			sel = self['liste'].getCurrent()[0][0]
			title = self['liste'].getCurrent()[0][1].split('/')[-1]
			if sel in ('2', '3'):
				list = (
						( _('Yes'), "1"),
						( _('No'), "0")
					)
				self.m3u_update_fn = title
				self.session.openWithCallback(self.cb_deletePL, ChoiceBoxExt, title=_("OK to delete \"{0}\" playlist?").format(title), list = list)

	def cb_deletePL(self, answer):
		stype = answer and answer[1]
		if stype and stype == "1":
			try:
				path = self['liste'].getCurrent()[0][2]
				if self.m3u_list.has_key(path.split('/')[-1]):
					os.rename(path, path+'.del')
				else:
					os.remove(path)
			except:
				self.session.open(MessageBoxExt, _("Can't delete \"{0}\" playlist").format(self.m3u_update_fn), MessageBoxExt.TYPE_ERROR)
			else:
				self.buildMenulist()

class SimplelistConfig(Screen, ConfigListScreenExt):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/PluginUserDefault.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/PluginUserDefault.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Screen.__init__(self, session)
		self['title'] = Label(_("SimpleList Configuration"))
		self.list = []
		self.list.append(getConfigListEntry(_('Global playlist number'), config.mediaportal.sp_pl_number))
		self.list.append(getConfigListEntry(_('Google coversupport'), config.mediaportal.simplelist_gcoversupp))
		ConfigListScreenExt.__init__(self, self.list)
		self['setupActions'] = ActionMap(['MP_Actions'],
		{
			'ok': 		self.keySave,
			'cancel': 	self.keyCancel
		},-2)