﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2015
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.packer import unpack, detect

agent="Mozilla/5.0 (Windows NT 6.1; rv:40.0) Gecko/20100101 Firefox/40.0"
cookies={}
class livestreamtvMain(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("live-stream.tv")
		self['ContentTitle'] = Label(_("Selection"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False
		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		url = "http://www.live-stream.tv/online/fernsehen/deutsch/ard.html"
		getPage(url, cookies=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		sender = re.findall('<a href="(.*?)".*?<div class="sTA">(.*?)</div>.*?<img class="thumbim" src="(.*?)".+?</strong>.*?<span id="(.*?)-title">(.*?)</span>', data, re.S)
		if sender:
			for url,time,image, station,title in sender:
				if station != "Fussball":
					self.streamList.append((decodeHtml(time + ' - ' + title), title, station, url, time, image))
			self.ml.setList(map(self.livestreamtvListEntry, self.streamList))
			self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		self.station = self['liste'].getCurrent()[0][2]
		url = "http://www.live-stream.tv/online/fernsehen/deutsch/%s.html" % self.station
		getPage(url, cookies=cookies).addCallback(self.getStream).addErrback(self.dataError)


	def getStream(self, data):
		title = self['liste'].getCurrent()[0][1]
		m = re.search('Clappr.Player\(\{.*?source:\s*"(http.*?)"', data, re.S)
		if m:
			stream_url = m.group(1) + "|Referer=http://cdn.clappr.io/latest/d878d8df1d462a3dc4c7b0ea7b4a8065.swf|User-Agent=Mozilla/5.0 (Windows NT 6.1; rv:40.0) Gecko/20100101 Firefox/40.0"
			self.session.open(SimplePlayer, [(self.station.upper() + ' - ' + title, stream_url)], showPlaylist=False, ltype='livestreamtv')

	"""
	def getStream(self, data):
		title = self['liste'].getCurrent()[0][1]
		get_packedjava = re.findall("(eval.function.*?)</script>", data, re.S)
		if get_packedjava:
			sJavascript = get_packedjava[0]
			sUnpacked = unpack(sJavascript)
			if sUnpacked:
				print 'sUnpackecked:',sUnpacked
				m = re.search('netstreambasepath:"(.*?)".*?file:"(.*?)"', sUnpacked)
				if m:
					base, file = m.groups()
					stream_url = base + file
					self.session.open(SimplePlayer, [(self.station.upper() + ' - ' + title, stream_url)], showPlaylist=False, ltype='livestreamtv')
	"""