﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.keyboardext import VirtualKeyBoardExt
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer
from Plugins.Extensions.MediaPortal.resources.twagenthelper import TwAgentHelper
from Components.ProgressBar import ProgressBar

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
elif fileExists('/usr/lib/enigma2/python/Plugins/Extensions/IMDb/plugin.pyo'):
	TMDbPresent = False
	IMDbPresent = True
	from Plugins.Extensions.IMDb.plugin import *
else:
	IMDbPresent = False
	TMDbPresent = False

IS_Version = "STREAMIT v1.32"

IS_siteEncoding = 'utf-8'

BASE_URL = "http://streamit.ws"

"""
	Tastenfunktionen in der Filmliste:
		Bouquet +/-				: Seitenweise blättern in 1 Schritten Up/Down
		'1', '4', '7',
		'3', 6', '9'			: blättern in 2er, 5er, 10er Schritten Down/Up
		Grün/Gelb				: Sortierung [A-Z] bzw. [IMDB]
		INFO					: anzeige der IMDB-Bewertung

	Stream Auswahl:
		Rot/Blau				: Die Beschreibung Seitenweise scrollen

"""

class showstreamitGenre(MPScreen):

	def __init__(self, session, mode):
		self.mode = mode
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0": self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(IS_Version)
		self['ContentTitle'] = Label(_("Menu"))
		self['name'] = Label(_("Genre Selection"))
		self['F1'] = Label(_("Exit"))

		self.param_search = ""
		self.keyLocked = True
		self.genreListe = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		genreListe = []
		if self.mode == "porn":
			Genre = [
				("Porn", BASE_URL + "/c/porn/page/")
				]
		else:
			Genre = [
				("Kino", BASE_URL + "/archiv_kino.php?page="),
				("Neue Filme", BASE_URL + "/archiv_film.php?page="),
				("HD Filme", BASE_URL + "/archiv_filmhd.php?page="),
				("Suche...", BASE_URL + "/suche.php?s=%s"),
				("Abenteuer", BASE_URL + "/archiv_film.php?cat=2&page="),
				("Action", BASE_URL + "/archiv_film.php?cat=1&page="),
				("Animation", BASE_URL + "/archiv_film.php?cat=3&page="),
				("Crime", BASE_URL + "/archiv_film.php?cat=6&page="),
				("Dokumentation", BASE_URL + "/archiv_film.php?cat=7&page="),
				("Drama", BASE_URL + "/archiv_film.php?cat=8&page="),
				("Family", BASE_URL + "/archiv_film.php?cat=9&page="),
				("Fantasy", BASE_URL + "/archiv_film.php?cat=10&page="),
				("History", BASE_URL + "/archiv_film.php?cat=13&page="),
				("Horror", BASE_URL + "/archiv_film.php?cat=14&page="),
				("Komödie", BASE_URL + "/archiv_film.php?cat=5&page="),
				("Mystery", BASE_URL + "/archiv_film.php?cat=17&page="),
				("Romance", BASE_URL + "/archiv_film.php?cat=20&page="),
				("SciFi", BASE_URL + "/archiv_film.php?cat=21&page="),
				("Sport", BASE_URL + "/archiv_film.php?cat=22&page="),
				("Thriller", BASE_URL + "/archiv_film.php?cat=24&page="),
				("War", BASE_URL + "/archiv_film.php?cat=25&page="),
				("Western", BASE_URL + "/archiv_film.php?cat=26&page=")]

		for (Name,Url) in Genre:
			self.genreListe.append((Name,Url))
		self.ml.setList(map(self._defaultlistcenter, self.genreListe))
		self.keyLocked = False

	def cb_Search(self, callback = None, entry = None):
		if callback != None:
			self.param_search = callback.strip()
			words = re.split('[^a-zA-Z0-9äÄöÖüÜß]+', self.param_search)
			s = ""
			j = len(words)
			i = 0
			if not j:
				return

			for word in words:
				i += 1
				if word != '':
					s += urllib.quote(word)
				if i < (j-1):
					s += '+'

			genreName = 'Videosuche: ' + self.param_search
			genreLink = self['liste'].getCurrent()[0][1] % s
			self.session.open(streamitFilmListeScreen, genreLink, genreName)

	def keyOK(self):
		if self.keyLocked:
			return
		genreName = self['liste'].getCurrent()[0][0]
		genreLink = self['liste'].getCurrent()[0][1]
		if 'Suche...' in genreName:
			self.session.openWithCallback(self.cb_Search, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.param_search, is_dialog=True)
		else:
			self.session.open(streamitFilmListeScreen, genreLink, genreName)

class streamitFilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreLink, genreName):
		self.genreLink = genreLink
		self.genreName = genreName

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		widgets_files = ('cover_widgets.xml',)
		self.skin = self.skin.replace('</screen>', '')
		for wf in widgets_files:
			path = "%s/%s/%s" % (self.skin_path, config.mediaportal.skin.value, wf)
			if not fileExists(path):
				path = self.skin_path + mp_globals.skinFallback + "/%s" % wf

			f = open(path, "r")
			for widget in f:
				self.skin += widget
			f.close()
		self.skin += '</screen>'

		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["hdpic"] = Pixmap()
		self['rating10'] = ProgressBar()
		self['rating0'] = Pixmap()
		self["hdpic"].hide()

		self["actions"] = ActionMap(["OkCancelActions", "ShortcutActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions","DirectionActions"], {
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"1" : self.key_1,
			"3" : self.key_3,
			"4" : self.key_4,
			"6" : self.key_6,
			"7" : self.key_7,
			"9" : self.key_9,
			"0": self.closeAll,
			"yellow" : self.keySort,
			"red" :  self.keyTxtPageUp,
			"blue" :  self.keyTxtPageDown,
			"info" :  self.keyTMDbInfo
		}, -1)

		self.sortFuncs = None
		self.sortOrderStrGenre = ""
		self.genreTitle = "Filme in Genre "
		self['title'] = Label(IS_Version)

		self['Page'] = Label(_("Page:"))
		self['F1'] = Label(_("Text-"))
		self['F3'] = Label(_("Sort by..."))
		self['F4'] = Label(_("Text+"))
		self['F3'].hide()

		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.timerStart = False
		self.seekTimerRun = False
		self.eventL = threading.Event()
		self.eventH = threading.Event()
		self.eventP = threading.Event()
		self.filmQ = Queue.Queue(0)
		self.hanQ = Queue.Queue(0)
		self.picQ = Queue.Queue(0)
		self.updateP = 0
		self.keyLocked = True
		self.filmListe = []
		self.page = 0
		self.pages = 0;
		self.neueFilme = re.search('Neue Filme',self.genreName)
		self.sucheFilme = re.search('Videosuche',self.genreName)
		self.pornFilme = re.search('/porn',self.genreLink)
		if 'HD Filme' in self.genreName:
			self.streamTag = 'streamhd'
		else:
			self.streamTag = 'stream'
		self.setGenreStrTitle()

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def setGenreStrTitle(self):
		if self.sortOrderStrGenre:
			sortOrder = ' (%s)' % self.sortOrderStrGenre
		else:
			sortOrder = ''

		self['ContentTitle'].setText("%s%s%s" % (self.genreTitle,self.genreName,sortOrder))

	def loadPage(self):
		if not self.sucheFilme:
			page = max(1,self.page)
			url = "%s%d" % (self.genreLink, page)
		else:
			url = self.genreLink

		if self.page:
			self['page'].setText("%d / %d" % (self.page,self.pages))

		self.filmQ.put(url)
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()
		else:
			self['name'].setText(_('Please wait...'))
			self['handlung'].setText("")
			self['coverArt'].hide()

	def loadPageQueued(self):
		self['name'].setText(_('Please wait...'))
		self['handlung'].setText("")
		self['coverArt'].hide()
		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		self.tw_agent_hlp.getWebPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def dataError(self, error):
		self.eventL.clear()
		printl(error,self,"E")
		self.filmListe.append((_("No movies found!"),"","","", 0, False))
		self.ml.setList(map(self.streamitFilmListEntry,	self.filmListe))

	def loadPageData(self, data):
		self.getPostFuncs(data)
		self.filmListe = []
		if not self.pornFilme:
			l = len(data)
			a = 0
			while a < l:
				mg = re.search('<div id="divA">(.*?)</div>\s+</li>', data[a:], re.S)
				if mg:
					a += mg.end()
					m = re.search('<div class="voting".*?style="width:(\d*).*?<a href="(.*?)".*?title="(.*?)">.*?<img.*?src="(.*?)"', mg.group(1), re.S)
					if m:
						rating,url,name,imageurl = m.groups()
						if 'hd_icon' in mg.group(1):
							hd = True
						else:
							hd = False

						if not rating: rating = "0"
						imdb = "IMDb: %.1f / 10" % (float(rating) / 10)
						self.filmListe.append((decodeHtml(name), BASE_URL+url, BASE_URL+imageurl, imdb, rating, hd))
				else:
					a = l
		else:
			pass

		if self.filmListe:
			if not self.pages:
				m = re.search('class=\'pagination\'.*?page=(\d+)\'>Last</a', data)
				if m:
					self.pages = int(m.group(1))
				else:
					self.pages = 1

				self.page = 1
				self['page'].setText("%d / %d" % (self.page,self.pages))

			self.ml.setList(map(self.streamitFilmListEntry,	self.filmListe))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmListe, 0, 1, 2, None, None, self.page, self.pages)
			self.loadPicQueued()
		else:
			self.filmListe.append((_("No movies found!"),"","","", 0, False))
			self.ml.setList(map(self.streamitFilmListEntry,	self.filmListe))
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()

	def getPostFuncs(self, data):
		self.sortFuncs = []
		m = re.search('id="postFuncs">(.*?)<!-- /#postFuncs -->', data, re.S)
		if m:
			for m2 in re.finditer('href="(.*?)">(.*?)</a', m.group(1)):
				href, name = m2.groups()
				href = re.sub('&page=\d+', '', href) + '&page='
				self.sortFuncs.append((decodeHtml(name), decodeHtml(href)))
		if self.sortFuncs:
			self['F3'].show()
		else:
			self['F3'].hide()

	def loadPicQueued(self):
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
			self.loadPic()

	def loadPic(self):
		if self.picQ.empty():
			self.eventP.clear()
			return

		if self.eventH.is_set() or self.updateP:
			print "Pict. or descr. update in progress"
			print "eventH: ",self.eventH.is_set()
			print "eventP: ",self.eventP.is_set()
			print "updateP: ",self.updateP
			return

		while not self.picQ.empty():
			self.picQ.get_nowait()

		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		streamUrl = self['liste'].getCurrent()[0][1]
		self.getHandlung(streamUrl)
		self.updateP = 1
		CoverHelper(self['coverArt'], self.showCoverExit).getCover(streamPic)
		rate = self['liste'].getCurrent()[0][4]
		hd = self['liste'].getCurrent()[0][5]
		if hd:
			self['hdpic'].show()
		else:
			self['hdpic'].hide()
		rating = int(rate)
		if rating > 100:
			rating = 100
		self['rating10'].setValue(rating)

	def dataErrorP(self, error):
		printl(error,self,"E")
		self.ShowCoverNone()

	def getHandlung(self, url):
		if url == None:
			self['handlung'].setText(_("No information found."))
			return
		self.hanQ.put(url)
		if not self.eventH.is_set():
			self.eventH.set()
			self.getHandlungQeued()

	def getHandlungQeued(self):
		while not self.hanQ.empty():
			url = self.hanQ.get_nowait()
		self.tw_agent_hlp.getWebPage(url).addCallback(self.setHandlung).addErrback(self.dataErrorH)

	def dataErrorH(self, error):
		self.eventH.clear()
		printl(error,self,"E")
		self['handlung'].setText(_("No information found."))

	def setHandlung(self, data):
		m = re.findall('meta property="og:description".*?=\'(.*?)\' />', data)
		if m:
			self['handlung'].setText(decodeHtml(re.sub(r"\s+", " ", m[0])))
		else:
			self['handlung'].setText(_("No information found."))

		if not self.hanQ.empty():
			self.getHandlungQeued()
		else:
			self.eventH.clear()
			self.loadPic()

	def showCoverExit(self):
		self.updateP = 0;
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def keyOK(self):
		if self.keyLocked or self.eventL.is_set():
			return

		streamLink = self['liste'].getCurrent()[0][1]
		streamName = self['liste'].getCurrent()[0][0]
		imageLink = self['liste'].getCurrent()[0][2]
		self.session.open(streamitStreams, streamLink, streamName, imageLink, self.streamTag)

	def keyUpRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].up()

	def keyDownRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].down()

	def key_repeatedUp(self):
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyLeftRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].pageDown()

	def keyPageDown(self):
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageDownFast(1)

	def keyPageUp(self):
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageUpFast(1)

	def keyPageUpFast(self,step):
		if self.keyLocked:
			return
		oldpage = self.page
		if (self.page + step) <= self.pages:
			self.page += step
		else:
			self.page = 1
		if oldpage != self.page:
			self.loadPage()

	def keyPageDownFast(self,step):
		if self.keyLocked:
			return
		oldpage = self.page
		if (self.page - step) >= 1:
			self.page -= step
		else:
			self.page = self.pages
		if oldpage != self.page:
			self.loadPage()

	def key_1(self):
		self.keyPageDownFast(2)

	def key_4(self):
		self.keyPageDownFast(5)

	def key_7(self):
		self.keyPageDownFast(10)

	def key_3(self):
		self.keyPageUpFast(2)

	def key_6(self):
		self.keyPageUpFast(5)

	def key_9(self):
		self.keyPageUpFast(10)

	def keyTMDbInfo(self):
		if not self.keyLocked and TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)
		elif not self.keyLocked and IMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(IMDB, title)

	def keySort(self):
		if not self.keyLocked and self.sortFuncs:
			self.handleSort()

	def handleSort(self):
		from Screens.ChoiceBox import ChoiceBox
		self.session.openWithCallback(self.cb_handleSort, ChoiceBox, title=_("Sort Selection"), list = self.sortFuncs)

	def cb_handleSort(self, answer):
		href = answer and answer[1]
		if href:
			self.genreLink = self.genreLink.split('?')[0] + href
			self.sortOrderStrGenre = answer[0]
			self.setGenreStrTitle()
			self.loadPage()

class streamitStreams(MPScreen):

	def __init__(self, session, filmUrl, filmName, imageLink, streamTag):
		self.filmUrl = filmUrl
		self.filmName = filmName
		self.imageUrl = imageLink
		self.stream_tag = streamTag

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"red" 		: self.keyTxtPageUp,
			"blue" 		: self.keyTxtPageDown,
			"green" 	: self.keyTrailer,
			"ok"    	: self.keyOK,
			"info" 		: self.keyTMDbInfo,
			"0"			: self.closeAll,
			"cancel"	: self.keyCancel
		}, -1)

		self['title'] = Label(IS_Version)
		self['ContentTitle'] = Label(_("Stream Selection"))

		self['name'] = Label(filmName)
		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))

		self.trailerId = None
		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.streamListe = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		streamUrl = self.filmUrl
		self.streamListe.append((_('Please wait...'),"","",""))
		self.ml.setList(map(self.streamitStreamListEntry, self.streamListe))
		self.tw_agent_hlp.getWebPage(streamUrl).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.streamListe = []
		m = re.search('<div id="stream"(.*?</div></div>)</div></div></div>', data, re.S)
		if m:
			buttons = re.findall('id="(.*?)" class="mirrorbuttonsdeutsch">(.*?)</', m.group(1))
			for id,nm in buttons:
				m2 = re.search('class="mirrorsdeutsch"\sid="%s"(.*?)</a></div></div>' % id, m.group(1), re.S)
				if m2:
					m3 = re.search('>Ton: <b>(.*?)</b', m2.group(1))
					if m3:
						ton = ', %s' % m3.group(1)
					else:
						ton = ''
					streams = re.findall('<a href="(.*?)".*?value="(.*?)"', m2.group(1).replace('\n', ''))
					for (isUrl,isStream) in streams:
						if isSupportedHoster(isStream, True):
							streamPart = ''
							isUrl = isUrl.replace('\n','')
							isUrl = isUrl.replace('\r','')
							self.streamListe.append((isStream,isUrl,streamPart,' (%s%s)' % (nm.strip(), ton.strip())))
						else:
							print "No supported hoster:"

		m = re.search('//www.youtube\.com/(embed|v|p)/(.*?)(\?|" |&amp)', data)
		if m:
			self.trailerId = m.group(2)
			self['F2'].setText('Trailer')
		else: self.trailerId = None

		desc = ''
		mdesc = re.search('<b>(Jahr:)</b>.*?">(.*?)</.*?<b>(L&auml;nge:)</b>.*?">(.*?)</', data, re.S)
		if mdesc:
			desc += mdesc.group(1) + mdesc.group(2) + '  ' + mdesc.group(3) + mdesc.group(4) + '\n\n'
		elif desc:
			desc += '\n'

		mdesc = re.search('<div id="cleaner">&nbsp;</div><div id="cleaner">&nbsp;</div>(.*?)<br><br>',data, re.S)
		if mdesc:
			desc += re.sub('<.*?>', '', mdesc.group(1).replace('\n',''), re.S).replace('&nbsp;','').strip()
		else:
			desc += "Keine weiteren Info's !"

		if self.streamListe:
			self.keyLocked = False
		else:
			self.streamListe.append(("No streams found!","","",""))

		self.ml.setList(map(self.streamitStreamListEntry, self.streamListe))
		self['handlung'].setText(decodeHtml(desc))
		CoverHelper(self['coverArt']).getCover(self.imageUrl)

	def dataError(self, error):
		printl(error,self,"E")
		self.streamListe.append(("Data error!","","",""))
		self.ml.setList(map(self.streamitStreamListEntry, self.streamListe))

	def got_link(self, stream_url):
		if stream_url:
			title = self.filmName + self['liste'].getCurrent()[0][2]
			self.session.open(SimplePlayer, [(title, stream_url, self.imageUrl)], cover=True, showPlaylist=False, ltype='streamit')

	def keyTrailer(self):
		if self.trailerId:
			self.session.open(
				YoutubePlayer,
				[(self.filmName+' - Trailer', self.trailerId, self.imageUrl)],
				playAll = False,
				showPlaylist=False,
				showCover=True
				)

	def keyTMDbInfo(self):
		if TMDbPresent:
			self.session.open(TMDbMain, self.filmName)
		elif IMDbPresent:
			self.session.open(IMDB, self.filmName)

	def keyOK(self):
		if self.keyLocked:
			return
		streamLink = self['liste'].getCurrent()[0][1]
		get_stream_link(self.session).check_link(streamLink, self.got_link)