# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.keyboardext import VirtualKeyBoardExt
from Plugins.Extensions.MediaPortal.resources.twagenthelper import TwAgentHelper

config.mediaportal.movie4klang = ConfigText(default="all", fixed_size=False)

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
else:
	TMDbPresent = False

movie4kheader = {'Content-Type':'application/x-www-form-urlencoded'}

def m4kGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def m4kLetterEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER, entry)
		]

def m4kSerienABCEntry(entry):
	flag_name = False

	if entry[2] == "http://img.movie4k.to/img/us_flag_small.png":
		flag_name = "2.png"
	elif entry[2] == "http://img.movie4k.to/img/us_ger_small.png":
		flag_name = "1.png"

	if flag_name:
		png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/%s" % flag_name
		flag = LoadPixmap(png)
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 20, 5, 16, 11, flag),
			(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 900, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]

def m4kSerienABCStaffelnEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

def m4kFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]
def m4kWatchSeriesListEntry(entry):
	if int(entry[4]) != 0:
		new_eps = str(entry[4])
	else:
		new_eps = ""

	png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/%s.png" % entry[2]
	if fileExists(png):
		flag = LoadPixmap(png)
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 15, 3, 20, 20, flag),
			(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 750, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
			(eListboxPythonMultiContent.TYPE_TEXT, 800, 0, 50, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, new_eps)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 750, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
			(eListboxPythonMultiContent.TYPE_TEXT, 800, 0, 50, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, new_eps)
			]

class m4kGenreScreen(MPScreen):

	def __init__(self, session, mode):
		self.showM4kPorn = mode
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"yellow" : self.keyLocale,
			"cancel": self.keyCancel
		}, -1)

		self.locale = config.mediaportal.movie4klang.value
		global movie4kheader
		if self.locale == "de":
			movie4kheader = {'Cookie':'lang=de; onlylanguage=de', 'Content-Type':'application/x-www-form-urlencoded'}
		elif self.locale == "en":
			movie4kheader = {'Cookie':'lang=en; onlylanguage=en', 'Content-Type':'application/x-www-form-urlencoded'}
		elif self.locale == "all":
			movie4kheader = {'Content-Type':'application/x-www-form-urlencoded'}

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Genre:")
		self['F3'] = Label(self.locale)

		self.genreliste = []
		self.searchStr = ''
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		if self.showM4kPorn == "porn":
			self.genreliste.append(("Letzte Updates (XXX)", "http://www.movie4k.to/xxx-updates.html"))
			self.genreliste.append(('Genres', 'http://www.movie4k.to/genres-xxx.html'))
		else:
			self.genreliste.append(("Kinofilme", "http://www.movie4k.to/index.php"))
			self.genreliste.append(("Videofilme", "http://www.movie4k.to/index.php"))
			self.genreliste.append(("Letzte Updates (Filme)", "http://www.movie4k.to/index.php"))
			self.genreliste.append(("Letzte Updates (Serien)", "http://www.movie4k.to/tvshows_featured.php"))
			self.genreliste.append(("Empfohlene Serien", "http://www.movie4k.to/tvshows_featured.php"))
			self.genreliste.append(("Alle Filme A-Z", "FilmeAZ"))
			self.genreliste.append(("Alle Serien A-Z", "SerienAZ"))
			self.genreliste.append(("Suche", "http://www.movie4k.to/movies.php?list=search"))
			self.genreliste.append(("Watchlist", "Watchlist"))
			self.genreliste.append(("Abenteuer", "http://movie4k.to/movies-genre-4-"))
			self.genreliste.append(("Action", "http://movie4k.to/movies-genre-1-"))
			self.genreliste.append(('Biografie', 'http://movie4k.to/movies-genre-6-'))
			self.genreliste.append(('Bollywood', 'http://movie4k.to/movies-genre-27-'))
			self.genreliste.append(('Dokumentation', 'http://movie4k.to/movies-genre-8-'))
			self.genreliste.append(('Drama', 'http://movie4k.to/movies-genre-2-'))
			self.genreliste.append(('Erwachsene', 'http://movie4k.to/movies-genre-58-'))
			self.genreliste.append(('Familie', 'http://movie4k.to/movies-genre-9-'))
			self.genreliste.append(('Fantasy', 'http://movie4k.to/movies-genre-10-'))
			self.genreliste.append(('Geschichte', 'http://movie4k.to/movies-genre-13-'))
			self.genreliste.append(('Horror', 'http://movie4k.to/movies-genre-14-'))
			self.genreliste.append(('Komödie', 'http://movie4k.to/movies-genre-3-'))
			self.genreliste.append(('Kriegsfilme', 'http://movie4k.to/movies-genre-24-'))
			self.genreliste.append(('Krimi', 'http://movie4k.to/movies-genre-7-'))
			self.genreliste.append(('Kurzfilme', 'http://movie4k.to/movies-genre-55-'))
			self.genreliste.append(('Musicals', 'http://movie4k.to/movies-genre-56-'))
			self.genreliste.append(('Musik', 'http://movie4k.to/movies-genre-15-'))
			self.genreliste.append(('Mystery', 'http://movie4k.to/movies-genre-17-'))
			self.genreliste.append(('Reality TV', 'http://movie4k.to/movies-genre-59-'))
			self.genreliste.append(('Romantik', 'http://movie4k.to/movies-genre-20-'))
			self.genreliste.append(('Sci-Fi', 'http://movie4k.to/movies-genre-21-'))
			self.genreliste.append(('Sport', 'http://movie4k.to/movies-genre-22-'))
			self.genreliste.append(('Thriller', 'http://movie4k.to/movies-genre-23-'))
			self.genreliste.append(('Trickfilm', 'http://movie4k.to/movies-genre-5-'))
			self.genreliste.append(('Western', 'http://movie4k.to/movies-genre-25-'))
		self.chooseMenuList.setList(map(m4kGenreListEntry, self.genreliste))

	def keyOK(self):
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamGenreLink = self['liste'].getCurrent()[0][1]

		if streamGenreName == "Watchlist":
			self.session.open(m4kWatchlist)
		elif streamGenreName == "Kinofilme":
			self.session.open(m4kKinoFilmeListeScreen, streamGenreLink, streamGenreName)
		elif streamGenreName == "Videofilme":
			self.session.open(m4kKinoFilmeListeScreen, streamGenreLink, streamGenreName)
		elif streamGenreName == "Letzte Updates (Filme)":
			self.session.open(m4kupdateFilmeListeScreen, streamGenreLink, streamGenreName)
		elif streamGenreName == "Letzte Updates (Serien)":
			self.session.open(m4kSerienUpdateFilmeListeScreen, streamGenreLink, streamGenreName)
		elif streamGenreName == "Empfohlene Serien":
			self.session.open(m4kTopSerienFilmeListeScreen, streamGenreLink, streamGenreName)
		elif streamGenreName == "Alle Serien A-Z":
			self.session.open(m4kSerienABCAuswahl, streamGenreLink)
		elif streamGenreName == "Alle Filme A-Z":
			self.session.open(m4kSerienABCAuswahl, streamGenreLink)
		elif streamGenreLink == 'http://www.movie4k.to/movies.php?list=search':
			self.streamGenreLink = streamGenreLink
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = "", is_dialog=True)
		elif streamGenreName == "Letzte Updates (XXX)":
			self.session.open(m4kXXXUpdateFilmeListeScreen, streamGenreLink, streamGenreName, '')
		elif streamGenreName == "Genres":
			self.session.open(m4kKinoAlleFilmeListeScreen, streamGenreLink, streamGenreName)
		else:
			self.session.open(m4kKinoAlleFilmeListeScreen, streamGenreLink, streamGenreName)

	def keyLocale(self):
		global movie4kheader
		if self.locale == "de":
			movie4kheader = {'Cookie':'lang=en; onlylanguage=en', 'Content-Type':'application/x-www-form-urlencoded'}
			self.locale = "en"
			config.mediaportal.movie4klang.value = "en"
		elif self.locale == "en":
			movie4kheader = {'Content-Type':'application/x-www-form-urlencoded'}
			self.locale = "all"
			config.mediaportal.movie4klang.value = "all"
		elif self.locale == "all":
			self.locale = "de"
			movie4kheader = {'Cookie':'lang=de; onlylanguage=de', 'Content-Type':'application/x-www-form-urlencoded'}
			config.mediaportal.movie4klang.value = "de"
		config.mediaportal.movie4klang.save()
		configfile.save()
		self['F3'].setText(self.locale)

	def searchCallback(self, callbackStr):
		if callbackStr is not None:
			self.searchStr = callbackStr
			url = self.streamGenreLink
			self.searchData = self.searchStr
			self.session.open(m4kSucheAlleFilmeListeScreen, url, self.searchData)

class m4kWatchlist(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"red" : self.keyDel,
			"info": self.update
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Watchlist")
		self['F1'] = Label(_("Delete"))

		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPlaylist)

	def loadPlaylist(self):
		self.streamList = []
		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationLink, stationLang, stationTotaleps) = data[0]
					self.streamList.append((stationName, stationLink, stationLang, stationTotaleps, "0"))
			print "Load Watchlist.."
			self.streamList.sort()
			self.streamMenuList.setList(map(m4kWatchSeriesListEntry, self.streamList))
			readStations.close()
			self.keyLocked = False

	def update(self):
		self.count = len(self.streamList)
		self.counting = 0

		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp"):
			self.write_tmp = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp" , "a")
			self.write_tmp.truncate(0)
		else:
			self.write_tmp = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp" , "a")

		if len(self.streamList) != 0:
			self.keyLocked = True
			self.streamList2 = []
			#print sname, surl, slang, stotaleps
			ds = defer.DeferredSemaphore(tokens=1)
			downloads = [ds.run(self.download,item[1]).addCallback(self.check_data, item[0], item[1], item[2], item[3]).addErrback(self.dataError) for item in self.streamList]
			finished = defer.DeferredList(downloads).addErrback(self.dataError)

	def download(self, item):
		return getPage(item)

	def check_data(self, data, sname, surl, slang, stotaleps):
		#print sname, surl, slang, stotaleps
		count_all_eps = 0
		self.counting += 1
		self['title'].setText("Update %s/%s" % (self.counting,self.count))

		staffeln = re.findall('<FORM name="episodeform(.*?)">(.*?)</FORM>', data, re.S)
		for (staffel, ep_data) in staffeln:
			#(staffel, ep_data) = each
			episodes = re.findall('<OPTION value=".*?".*?>Episode.(.*?)</OPTION>', ep_data, re.S)
			count_all_eps += int(len(episodes))
			last_new_ep = staffel, episodes[-1]


		new_eps =  int(count_all_eps) - int(stotaleps)

		self.write_tmp.write('"%s" "%s" "%s" "%s"\n' % (sname, surl, slang, count_all_eps))

		self.streamList2.append((sname, surl, slang, str(stotaleps), str(new_eps)))
		self.streamList2.sort()
		self.streamMenuList.setList(map(m4kWatchSeriesListEntry, self.streamList2))

		print self.counting, self.count
		if self.counting == self.count:
			print "update done."
			self['title'].setText("Update done.")
			self.write_tmp.close()
			shutil.move(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp", config.mediaportal.watchlistpath.value+"mp_m4k_watchlist")
			self.keyLocked = False

		if last_new_ep:
			(staffel, episode) = last_new_ep
			if int(staffel) < 10:
				staffel3 = "S0"+str(staffel)
			else:
				staffel3 = "S"+str(staffel)

			if int(episode) < 10:
				episode3 = "E0"+str(episode)
			else:
				episode3 = "E"+str(episode)

			SeEp = "%s%s" % (staffel3, episode3)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		print stream_name, url
		self.session.open(m4kEpisodenListeScreen, url, stream_name)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		selectedName = self['liste'].getCurrent()[0][0]

		writeTmp = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp","w")
		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationLink, stationLang, stationTotaleps) = data[0]
					if stationName != selectedName:
						writeTmp.write('"%s" "%s" "%s" "%s"\n' % (stationName, stationLink, stationLang, stationTotaleps))
			readStations.close()
			writeTmp.close()
			shutil.move(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist.tmp", config.mediaportal.watchlistpath.value+"mp_m4k_watchlist")
			self.loadPlaylist()

class m4kSucheAlleFilmeListeScreen(MPScreen):

	def __init__(self, session, searchUrl, searchData):
		self.searchUrl = searchUrl
		self.searchData = searchData
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"red" : self.keyTMDbInfo
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Suche nach: %s" % self.searchData)

		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = self.searchUrl
		sData = self.searchData
		getPage(url,method='POST',postdata=urllib.urlencode({'search':sData}),headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		kino = re.findall('<TR id="coverPreview(.*?)">.*?<a href="(.*?)">(.*?)	 ', data, re.S)
		if kino:
			self.filmliste = []
			for image, teil_url, title in kino:
				url = '%s%s' % ('http://www.movie4k.to/', teil_url)
				print title
				self.filmliste.append((decodeHtml(title), url, image))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		url = self['liste'].getCurrent()[0][1]
		getPage(url, agent=std_headers, headers=movie4kheader).addCallback(self.showInfosData).addErrback(self.dataError)

	def showInfosData(self, data):
		filmdaten = re.findall('<div style="float:left">.*?<img src="(.*?)".*?<div class="moviedescription">(.*?)</div>', data, re.S)
		if filmdaten:
			streamPic, handlung = filmdaten[0]
			CoverHelper(self['coverArt']).getCover(streamPic)
			self['handlung'].setText(decodeHtml(handlung).strip())

	def keyOK(self):
		if self.keyLocked:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kStreamListeScreen, streamLink, streamGenreName, "movie")

	def keyTMDbInfo(self):
		if TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)

class m4kKinoAlleFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber,
			"red" : self.keyTMDbInfo
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Filme Auswahl: %s" % self.streamGenreName)
		self['F2'] = Label(_("Page"))

		self.keyLocked = True
		self.preview = False
		self.filmliste = []
		self.XXX = False
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = ''
		if self.streamGenreLink == 'http://www.movie4k.to/genres-xxx.html':
			url = str(self.streamGenreLink)
			getPage(url, agent=std_headers, headers=movie4kheader).addCallback(self.loadXXXPageData).addErrback(self.dataError)
		elif re.search('http://www.movie4k.to/xxx', self.streamGenreLink):
			url = '%s%s%s' % (self.streamGenreLink, self.page, '.html')
			getPage(url, agent=std_headers, headers={'Cookie':'xxx2=ok', 'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)
		elif re.search('http://www.movie4k.to/movies-updates-', self.streamGenreLink):
			url = '%s%s%s' % (self.streamGenreLink, self.page, '.html')
			getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)
		else:
			url = '%s%s%s' % (self.streamGenreLink, self.page, '.html')
			getPage(url, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadXXXPageData(self, data):
		self.XXX = True
		xxxGenre = re.findall('<TD\sid="tdmovies"\swidth="155">.*?<a\shref="(xxx-genre.*?)">(.*?)</a>', data, re.S)
		if xxxGenre:
			self.filmliste = []
			for teil_url, title in xxxGenre:
				url = '%s%s' % ('http://www.movie4k.to/', teil_url)
				title = title.replace("\t","")
				title = title.strip(" ")
				self.filmliste.append((decodeHtml(title), url))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False

	def loadPageData(self, data):
		self['Page'].setText(_("Page:"))
		self.getLastPage(data, 'id="boxgrey"(.*?)</div>', '.*>(\d+)\s<')
		kino = re.findall('<TR id="coverPreview(.*?)">.*?<a href="(.*?)">(.*?) </a>', data, re.S)
		self.preview = False
		self.thumbfilmliste = []
		if re.search('hover\(function\(e\)', data, re.S):
			self.preview = True
		if kino:
			self.filmliste = []
			for image, teil_url, title in kino:
				url = '%s%s' % ('http://www.movie4k.to/', teil_url)
				print title
				if self.preview == True:
					print "Preview found"
					imagelink = re.findall('coverPreview%s"\).hover\(.*?<img src=\'(.*?)\' alt' % image, data, re.S)
					if imagelink:
						self.thumbfilmliste.append((decodeHtml(title).strip(), url, imagelink[0]))
					else:
						self.thumbfilmliste.append((decodeHtml(title).strip(), url, ''))
				self.filmliste.append((decodeHtml(title).strip(), url, image))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			if self.XXX == False:
				if self.preview == False:
					self.th_ThumbsQuery(self.filmliste,0,1,None,None,'<div style="float:left">.*?<img src="(.*?)"',self.page)
				else:
					self.th_ThumbsQuery(self.thumbfilmliste,0,1,2,None,None,self.page)
				self.showInfos()
			else:
				if self.preview == False:
					self.th_ThumbsQuery(self.filmliste,0,1,None,None,'<div style="float:left">.*?<img src="(.*?)"',self.page)
				else:
					self.th_ThumbsQuery(self.thumbfilmliste,0,1,2,None,None,self.page)

	def showInfos(self):
		url = self['liste'].getCurrent()[0][1]
		getPage(url, agent=std_headers, headers=movie4kheader).addCallback(self.showInfosData).addErrback(self.dataError)

	def showInfosData(self, data):
		filmdaten = re.findall('<div style="float:left">.*?<img src="(.*?)".*?class="moviedescription">(.*?)</div>', data, re.S)
		if filmdaten:
			streamPic = filmdaten[0][0].replace('https','http')
			handlung = filmdaten[0][1]
			CoverHelper(self['coverArt']).getCover(streamPic)
			self['handlung'].setText(decodeHtml(handlung).strip())

	def keyOK(self):
		if self.keyLocked:
			return
		if self.XXX == False:
			streamGenreName = self['liste'].getCurrent()[0][0]
			streamLink = self['liste'].getCurrent()[0][1]
			self.session.open(m4kStreamListeScreen, streamLink, streamGenreName, "movie")
		else:
			streamGenreName= self['liste'].getCurrent()[0][0]
			xxxGenreLink = self['liste'].getCurrent()[0][1]
			self.session.open(m4kXXXUpdateFilmeListeScreen, xxxGenreLink, streamGenreName, 'X')

	def keyTMDbInfo(self):
		if TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)

class m4kupdateFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"red" : self.keyTMDbInfo
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Filme Auswahl: %s" % self.streamGenreName)

		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		last = re.findall('<td valign="top" height="100.*?"><a href="(.*?)"><font color="#000000" size="-1"><strong>(.*?)</strong></font></a></td>', data, re.S)
		if last:
			for url,title in last:
				url = "%s%s" % ("http://www.movie4k.to/", url)
				print title
				self.filmliste.append((decodeHtml(title), url))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamUrl = self['liste'].getCurrent()[0][1]
		getPage(streamUrl, agent=std_headers, headers=movie4kheader).addCallback(self.showHandlung).addErrback(self.dataError)
		#streamPic = self['liste'].getCurrent()[0][2]
		#CoverHelper(self['coverArt']).getCover(streamPic)

	def showHandlung(self, data):
		handlung = re.findall('<div class="moviedescription">(.*?)<', data, re.S)
		if handlung:
			handlung = re.sub(r"\s+", " ", handlung[0])
			self['handlung'].setText(decodeHtml(handlung).strip())
		else:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		if self.keyLocked:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kStreamListeScreen, streamLink, streamName, "movie")

	def keyTMDbInfo(self):
		if TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)

class m4kKinoFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"red" : self.keyTMDbInfo
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Filme Auswahl: %s" % self.streamGenreName)


		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if self.streamGenreName == "Kinofilme":
			kino = re.findall('<div style="float:left">.*?<a href="(.*?)"><img src="(.*?)" border=0 style="width:105px;max-width:105px;max-height:160px;min-height:140px;" alt=".*?kostenlos" title="(.*?).kostenlos"></a>', data, re.S)
		elif self.streamGenreName == "Videofilme":
			kino = re.findall('<div style="float: left;">.*?<a href="(.*?)"><img src="(.*?)" alt=".*?" title="(.*?)" border="0" style="width:105px;max-width:105px;max-height:160px;min-height:140px;"></a>', data, re.S)
		if kino:
			for url,image,title in kino:
				url = "%s%s" % ("http://www.movie4k.to/", url)
				print title
				self.filmliste.append((decodeHtml(title), url, image))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1)
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamUrl = self['liste'].getCurrent()[0][1]
		getPage(streamUrl, agent=std_headers, headers=movie4kheader).addCallback(self.showHandlung).addErrback(self.dataError)
		streamPic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(streamPic)

	def showHandlung(self, data):
		handlung = re.findall('<div class="moviedescription">(.*?)<', data, re.S)
		if handlung:
			handlung = re.sub(r"\s+", " ", handlung[0])
			self['handlung'].setText(decodeHtml(handlung).strip())
		else:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		if self.keyLocked:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kStreamListeScreen, streamLink, streamName, "movie")

	def keyTMDbInfo(self):
		if TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)

class m4kTopSerienFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyAdd
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Serien Auswahl: %s" % self.streamGenreName)
		self['F2'] = Label(_("Add to Watchlist"))


		self.keckse = {}
		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.m4kcookie)

	def m4kcookie(self):
		url = "http://www.movie4k.to/index.php"
		getPage(url, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.getm4kcookie).addErrback(self.dataError)

	def getm4kcookie(self, data):
		self.loadPage()

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		serien = re.findall('<div style="float:left"><a href="(.*?)"><img src="(.*?)" border=0 width=105 height=150 alt=".*?" title="(.*?)"></a>.*?<img src="/img/(.*?).png"', data, re.S)
		if serien:
			for url,image,title,lang in serien:
				url = "%s%s" % ("http://www.movie4k.to/", url)
				print title
				self.filmliste.append((decodeHtml(title), url, image, lang))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1)
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamUrl = self['liste'].getCurrent()[0][1]
		getPage(streamUrl, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.showHandlung).addErrback(self.dataError)
		streamPic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(streamPic)

	def showHandlung(self, data):
		handlung = re.findall('<div class="moviedescription">(.*?)<', data, re.S)
		if handlung:
			handlung = re.sub(r"\s+", " ", handlung[0])
			self['handlung'].setText(decodeHtml(handlung).strip())
		else:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		if self.keyLocked:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		print streamGenreName, streamLink
		self.session.open(m4kEpisodenListeScreen, streamLink, streamGenreName)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		self.mTitle = self['liste'].getCurrent()[0][0]
		self.mUrl = self['liste'].getCurrent()[0][1]
		self.mLang = self['liste'].getCurrent()[0][3]

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","a")
			if self.mLang == "us_ger_small":
				Lang = "de"
			elif self.mLang == "us_flag_small":
				Lang = "en"
			else:
				Lang = ""

			print self.mUrl, self.mTitle, Lang
			writePlaylist.write('"%s" "%s" "%s" "0"\n' % (self.mTitle, self.mUrl, Lang))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the watchlist."), MessageBoxExt.TYPE_INFO, timeout=3)

class m4kSerienUpdateFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyAdd
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Serien Auswahl: %s" % self.streamGenreName)
		self['F2'] = Label(_("Add to Watchlist"))


		self.keyLocked = True
		self.filmliste = []
		self.keckse = {}
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.m4kcookie)

	def m4kcookie(self):
		url = "http://www.movie4k.to/index.php"
		getPage(url, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.getm4kcookie).addErrback(self.dataError)

	def getm4kcookie(self, data):
		self.loadPage()

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		serien = re.findall('<td id="tdmovies"> <img style="vertical-align:top;".*?<a href="(.*?)">.*?<font color="#000000">(.*?)</font></a>', data, re.S)
		if serien:
			for url,title in serien:
				#TODO remove duples
				url = "http://www.movie4k.to/"+url
				self.filmliste.append((decodeHtml(title), url))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, None, None, '<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?id="SIMILARMOVIES"', 1, 1)
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamUrl = self['liste'].getCurrent()[0][1]
		getPage(streamUrl, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.showHandlung).addErrback(self.dataError)

	def showHandlung(self, data):
		image = re.search('<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?class="moviedescription"', data, re.S)
		if image:
			image = image.group(1)
		else:
			image = None
		CoverHelper(self['coverArt']).getCover(image)
		handlung = re.findall('<div class="moviedescription">(.*?)<', data, re.S)
		if handlung:
			handlung = re.sub(r"\s+", " ", handlung[0])
			self['handlung'].setText(decodeHtml(handlung).strip())
		else:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		print streamGenreName, streamLink

		if re.match('.*?,.*?,.*?', streamGenreName):
			cname = re.findall('(.*?),.*?,.*?', streamGenreName, re.S)
			if cname:
				streamGenreName = cname[0]

		self.session.open(m4kEpisodenListeScreen, streamLink, streamGenreName)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		mTitle = self['liste'].getCurrent()[0][0]
		mUrl = self['liste'].getCurrent()[0][1]
		if re.match('.*?,.*?,.*?', mTitle):
			cname = re.findall('(.*?),.*?,.*?', mTitle, re.S)
			if cname:
				mTitle = cname[0]

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
			writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","a")
			print mUrl, mTitle
			writePlaylist.write('"%s" "%s" "%s" "0"\n' % (mTitle, mUrl, "de"))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the watchlist."), MessageBoxExt.TYPE_INFO, timeout=3)

class m4kStreamListeScreen(MPScreen):

	def __init__(self, session, streamGenreLink, streamName, which):
		self.streamGenreLink = streamGenreLink
		self.streamName = streamName
		self.which = which
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label(_("Stream Selection"))


		self.coverUrl = None
		self.base_url = 'http://www.movie4k.to/'
		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.keyLocked = True
		self.filmliste = []
		self.keckse = {}
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_("Please wait..."))
		self.tw_agent_hlp.getWebPage(self.streamGenreLink).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if self.which == "movie":
			streams = []
			dupe = []
			hosters = re.findall('<tr id=.*?tablemoviesindex2.*?>(.*?)</td></tr>', data, re.S)
			if hosters:
				self.filmliste = []
				for hoster_raw in hosters:
					hoster_data = re.findall('href.*?"(.*?)">(.*?)<img.*?&nbsp;(.*?)<', hoster_raw)
					if hoster_data:
						(h_url, h_date, h_name) = hoster_data[0]
						hoster_url = "%s%s" % ("http://www.movie4k.to/", h_url.replace('\\',''))
						if not hoster_url in dupe:
							dupe.append(hoster_url)
							if isSupportedHoster(h_name, True):
								self.filmliste.append((hoster_url, h_date, h_name))
			else:
				hosters = re.findall('<a target="_blank" href="(http://(.*?)\..*?)"><img border=0', data, re.S)
				if hosters:
					(h_url, h_name) = hosters[0]
					print h_url, h_name.capitalize()
					if isSupportedHoster(h_name, True):
						self.filmliste.append((h_url, "", h_name.capitalize()))
		else:
			hoster = re.findall('"tablemoviesindex2.*?<a href.*?"(.*?.html).*?style.*?src.*?"/img/.*?.[gif|png].*?> \&nbsp;(.*?)</a></td></tr>', data, re.S)
			if hoster:
				for url,hostername in hoster:
					url = "%s%s" % ("http://www.movie4k.to/", url)
					if isSupportedHoster(hostername, True):
						self.filmliste.append((url, "", hostername))
		if len(self.filmliste) == 0:
			self.filmliste.append(("", "", "No supported streams found."))
			self.chooseMenuList.setList(map(self.m4kStream2ListEntry, self.filmliste))
			self.showInfosData(data)
		else:
			self.chooseMenuList.setList(map(self.m4kStreamListEntry, self.filmliste))
			self.keyLocked = False
			self.showInfosData(data)
		self['name'].setText(self.streamName)

	def m4kStreamListEntry(self, entry):
		if config.mediaportal.premiumize_use.value:
			premiumFarbe = int(config.mediaportal.premium_color.value, 0)
			if re.search(mp_globals.premium_hosters, entry[2], re.S|re.I):
				return [entry,
					(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1], premiumFarbe),
					(eListboxPythonMultiContent.TYPE_TEXT, 250, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2], premiumFarbe),
					]
			else:
				return [entry,
					(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]),
					(eListboxPythonMultiContent.TYPE_TEXT, 250, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2]),
					]
		else:
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]),
				(eListboxPythonMultiContent.TYPE_TEXT, 250, 0, 200, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2]),
				]

	def m4kStream2ListEntry(self, entry):
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 400, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2])
			]

	def showInfos(self):
		print "link:", self.streamGenreLink
		self.tw_agent_hlp.getWebPage(self.streamGenreLink).addCallback(self.showInfosData).addErrback(self.dataError)

	def showInfosData(self, data):
		image = re.search('<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?class="moviedescription"', data, re.S)
		if image:
			self.coverUrl = image.group(1)
		else:
			self.coverUrl = None
		CoverHelper(self['coverArt']).getCover(self.coverUrl)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamLink = self['liste'].getCurrent()[0][0]
		print self.streamName, streamLink
		self.tw_agent_hlp.getWebPage(streamLink).addCallback(self.get_streamlink, streamLink).addErrback(self.dataError)

	def get_streamlink(self, data, streamLink):
		if re.match('.*?(http://img.movie4k.to/img/parts/teil1_aktiv.png|http://img.movie4k.to/img/parts/teil1_inaktiv.png|http://img.movie4k.to/img/parts/part1_active.png|http://img.movie4k.to/img/parts/part1_inactive.png)', data, re.S):
			print "Open PartListScreen"
			self.session.open(m4kPartListeScreen, streamLink, self.streamName)
		elif isSupportedHoster(streamLink, True):
			get_stream_link(self.session).check_link(streamLink, self.got_link, False)
			return
		else:
			print "Search streamlink..."
			print "1"
			link = re.search('<a\starget="_blank"\shref="(.*?)"><img\sborder=0\ssrc="http://img.movie4k.to/img/click_link.jpg"', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "2"
			link = re.search('<iframe\swidth=".*?"\sheight=".*?"\sframeborder="0"\ssrc="(.*?)"\sscrolling="no"></iframe>', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "3"
			link = re.search('<iframe\ssrc="(.*?)"\sframeborder=0\smarginwidth=0\smarginheight=0\sscrolling=no\swidth=.*?height=.*?></iframe>', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "4"
			link = re.search("<iframe\sstyle=.*?src='(.*?)'\sscrolling='no'></iframe>", data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "5"
			link = re.search('<div\sid="emptydiv"><iframe.*?src=["|\'](.*?)["|\']', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "6"
			link = re.search('<div\sid="emptydiv"><script type="text/javascript"\ssrc=["|\'](.*?)["|\']>', data, re.S|re.I)
			if link:
				print link.group(1).replace('?embed','')
				get_stream_link(self.session).check_link(link.group(1).replace('?embed',''), self.got_link, False)
				return
			print "7"
			link = re.search('<object\sid="vbbplayer".*?src=["|\'](.*?)["|\']', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "8"
			link = re.search('<param\sname="movie"\svalue="(.*?)"', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			link = re.search('<a target="_blank" href="(.*?)"><img border=0 src="/img/click_link.jpg"', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "9"
			link = re.search('<iframe\ssrc="(.*?)"\swidth=".*?"\sheight=".*?"\sframeborder="0"\sscrolling="no"></iframe>', data, re.S|re.I)
			if link:
				print link.group(1)
				get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
				return
			print "10"
			message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)

	def got_link(self, stream_url):
		if stream_url == None:
			message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			if not fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watched"):
				open(config.mediaportal.watchlistpath.value+"mp_m4k_watched","w").close()

			self.update_liste = []
			leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_m4k_watched")
			if not leer == 0:
				self.updates_read = open(config.mediaportal.watchlistpath.value+"mp_m4k_watched" , "r")
				for lines in sorted(self.updates_read.readlines()):
					line = re.findall('"(.*?)"', lines)
					if line:
						print line[0]
						self.update_liste.append("%s" % (line[0]))
				self.updates_read.close()

				updates_read2 = open(config.mediaportal.watchlistpath.value+"mp_m4k_watched" , "a")
				check = ("%s" % self.streamName)
				if not check in self.update_liste:
					print "update add: %s" % (self.streamName)
					updates_read2.write('"%s"\n' % (self.streamName))
					updates_read2.close()
				else:
					print "dupe %s" % (self.streamName)
			else:
				updates_read3 = open(config.mediaportal.watchlistpath.value+"mp_m4k_watched" , "a")
				print "update add: %s" % (self.streamName)
				updates_read3.write('"%s"\n' % (self.streamName))
				updates_read3.close()

			self.session.open(SimplePlayer, [(self.streamName, stream_url, self.coverUrl)], showPlaylist=False, ltype='movie4k', cover=True)

class m4kPartListeScreen(MPScreen):

	def __init__(self, session, streamGenreLink, streamName):
		self.streamGenreLink = streamGenreLink
		self.streamName = streamName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label(_("Parts Selection"))
		self['name'] = Label(self.streamName)

		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(41)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		id = re.findall('[film-|movie-](\d+)\.html', self.streamGenreLink, re.S)
		if id:
			print id
			url1 = "%s%s%s" % ("http://www.movie4k.to/movie.php?id=", id[0], "&part=1")
			url2 = "%s%s%s" % ("http://www.movie4k.to/movie.php?id=", id[0], "&part=2")
			self.filmliste.append(("1", url1))
			self.filmliste.append(("2", url2))
			self.chooseMenuList.setList(map(self.m4kPartsListEntry, self.filmliste))
			self.keyLocked = False
		else:
			print "id fehler.."

	def m4kPartsListEntry(self, entry):
		part = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/teil%s.png" % entry[0]
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 396, 3, 108, 35, LoadPixmap(part))
			]

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamPart = self['liste'].getCurrent()[0][0]
		streamLinkPart = self['liste'].getCurrent()[0][1]
		self.sname = "%s - Teil %s" % (self.streamName, streamPart)
		print self.sname, streamLinkPart
		getPage(streamLinkPart, agent=std_headers, headers=movie4kheader).addCallback(self.get_streamlink).addErrback(self.dataError)

	def get_streamlink(self, data):
		print "Search streamlink..."
		print "1"
		link = re.search('<a\starget="_blank"\shref="(.*?)"><img\sborder=0\ssrc="http://img.movie4k.to/img/click_link.jpg"', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "2"
		link = re.search('<iframe\swidth=".*?"\sheight=".*?"\sframeborder="0"\ssrc="(.*?)"\sscrolling="no"></iframe>', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "3"
		link = re.search('<iframe\ssrc="(.*?)"\sframeborder=0\smarginwidth=0\smarginheight=0\sscrolling=no\swidth=.*?height=.*?></iframe>', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "4"
		link = re.search("<iframe\sstyle=.*?src='(.*?)'\sscrolling='no'></iframe>", data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "5"
		link = re.search('<div\sid="emptydiv"><iframe.*?src=["|\'](.*?)["|\']', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "6"
		link = re.search('<div\sid="emptydiv"><script type="text/javascript"\ssrc=["|\'](.*?)["|\']>', data, re.S|re.I)
		if link:
			print link.group(1).replace('?embed','')
			get_stream_link(self.session).check_link(link.group(1).replace('?embed',''), self.got_link, False)
			return
		print "7"
		link = re.search('<object\sid="vbbplayer".*?src=["|\'](.*?)["|\']', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "8"
		link = re.search('<param\sname="movie"\svalue="(.*?)"', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return
		print "9"
		link = re.search('<iframe\ssrc="(.*?)"\swidth=".*?"\sheight=".*?"\sframeborder="0"\sscrolling="no"></iframe>', data, re.S|re.I)
		if link:
			print link.group(1)
			get_stream_link(self.session).check_link(link.group(1), self.got_link, False)
			return

		message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)

	def got_link(self, stream_url):
		if stream_url == None:
			message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			self.session.open(SimplePlayer, [(self.sname, stream_url)], showPlaylist=False, ltype='movie4k', cover=False)

class m4kEpisodenListeScreen(MPScreen):

	def __init__(self, session, streamGenreLink, streamName):
		self.streamGenreLink = streamGenreLink
		self.streamName = streamName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label(_("Episode Selection"))
		self['name'] = Label(self.streamName)


		self.keyLocked = True
		self.filmliste = []
		self.keckse = {}
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.watched_liste = []
		self.mark_last_watched = []
		if not fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watched"):
			open(config.mediaportal.watchlistpath.value+"mp_m4k_watched","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watched"):
			leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_m4k_watched")
			if not leer == 0:
				self.updates_read = open(config.mediaportal.watchlistpath.value+"mp_m4k_watched" , "r")
				for lines in sorted(self.updates_read.readlines()):
					line = re.findall('"(.*?)"', lines)
					if line:
						self.watched_liste.append("%s" % (line[0]))
				self.updates_read.close()

		folgen = re.findall('<FORM name="episodeform(.*?)">(.*?)</FORM>', data, re.S)
		if folgen:
			for staffel,ep_data in folgen:
				episodes = re.findall('<OPTION value="(.*?)".*?>Episode.(.*?)</OPTION>', ep_data, re.S)
				if episodes:
					for url_to_streams, episode in episodes:
						if int(staffel) < 10:
							staffel3 = "S0"+str(staffel)
						else:
							staffel3 = "S"+str(staffel)

						if int(episode) < 10:
							episode3 = "E0"+str(episode)
						else:
							episode3 = "E"+str(episode)
						staffel_episode = "%s - %s%s" % (self.streamName,staffel3,episode3)
						staffel_episode = staffel_episode.replace('	','')
						url_to_streams = "http://www.movie4k.to/%s" % url_to_streams
						if staffel_episode in self.watched_liste:
							self.filmliste.append((staffel_episode,url_to_streams,True))
							self.mark_last_watched.append(staffel_episode)
						else:
							self.filmliste.append((staffel_episode,url_to_streams,False))
			self.chooseMenuList.setList(map(self.m4kStreamListEntry, self.filmliste))

			# jump to last watched episode
			if len(self.mark_last_watched) != 0:
				counting_watched = 0
				for (name,url,watched) in self.filmliste:
					counting_watched += 1
					if self.mark_last_watched[-1] == name:
						counting_watched = int(counting_watched) - 1
						print "last watched episode: %s" % counting_watched
						break
				self['liste'].moveToIndex(int(counting_watched))
			else:
				if len(self.filmliste) != 0:
					jump_last = len(self.filmliste) -1
				else:
					jump_last = 0
				print "last episode: %s" % jump_last
				self['liste'].moveToIndex(int(jump_last))

			self.keyLocked = False
			self.showInfosData(data)

	def m4kStreamListEntry(self, entry):
		if entry[2]:
			png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.png"
			watched = LoadPixmap(png)
			return [entry,
				(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 39, 3, 100, 22, watched),
				(eListboxPythonMultiContent.TYPE_TEXT, 100, 0, 700, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
				]
		else:
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 100, 0, 700, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
				]

	def showInfos(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.showInfosData).addErrback(self.dataError)

	def showInfosData(self, data):
		image = re.search('<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?class="moviedescription"', data, re.S)
		if image:
			image = image.group(1)
		else:
			image = None
		CoverHelper(self['coverArt']).getCover(image)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamEpisode = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		print streamEpisode, streamLink
		self.session.open(m4kStreamListeScreen, streamLink, streamEpisode, "tv")

class m4kXXXUpdateFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamXXXLink, streamGenreName, genre):
		self.streamXXXLink = streamXXXLink
		self.streamGenreName = streamGenreName
		self.genre = False
		if genre == 'X':
			self.genre = True
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyPageNumber,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("XXX Auswahl")


		self.keyLocked = True
		self.preview = False
		self.filmliste = []
		self.keckse = {}
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.genre == True:
			shortUrl = re.findall('http://www.movie4k.to/xxx-genre-[0-9]*[0-9]*.*?',self.streamXXXLink)
			shortUrlC = str(shortUrl[0])
			url = shortUrlC + '-' + str(self.page) + '.html'
		else:
			url = str(self.streamXXXLink)
		getPage(url, agent=std_headers, headers={'Cookie': 'xxx2=ok', 'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self['Page'].setText(_("Page:"))
		self.getLastPage(data, 'id="boxwhite"(.*?)</div><!--maincontent2', '.*>(\d+)\s<')
		self.filmliste = []
		if self.genre == False:
			serien = re.findall('<TD id="(.*?)" width="380">.*?<a href="(.*?)">(.*?)</a>', data, re.S)
		else:
			serien = re.findall('<TR id="(.*?)">.*?<TD width="550" id="tdmovies">.*?<a href="(.*?)">(.*?)</a>', data, re.S)
		self.preview = False
		self.thumbfilmliste = []
		if re.search('hover\(function\(e\)', data, re.S):
			self.preview = True

		if serien:
			for cover,url,title in serien:
				url = "%s%s" % ("http://www.movie4k.to/", url)
				title = title.replace("\t","")
				title = title.strip(" ")

				if self.preview == True:
					print "Preview found"
					imagelink = re.findall('%s"\).hover\(.*?<img src=\'(.*?)\' alt' % cover, data, re.S)
					if imagelink:
						self.thumbfilmliste.append((decodeHtml(title), url, imagelink[0]))
					else:
						self.thumbfilmliste.append((decodeHtml(title), url, ''))

				self.filmliste.append((decodeHtml(title), url))
			self.chooseMenuList.setList(map(m4kFilmListEntry, self.filmliste))
			self.keyLocked = False
			if self.preview == False:
				self.th_ThumbsQuery(self.filmliste, 0, 1, None, None, '<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?id="SIMILARMOVIES"', self.page)
			else:
				self.th_ThumbsQuery(self.thumbfilmliste,0,1,2,None,None,self.page)
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamUrl = self['liste'].getCurrent()[0][1]
		getPage(streamUrl, agent=std_headers, cookies=self.keckse, headers=movie4kheader).addCallback(self.showHandlung).addErrback(self.dataError)

	def showHandlung(self, data):
		image = re.search('<img\ssrc="(http://img.movie4k.(to|tv)/thumbs/.*?movie4k-film.jpg)".*?class="moviedescription"', data, re.S)
		if image:
			image = image.group(1)
		else:
			image = None
		CoverHelper(self['coverArt']).getCover(image)
		handlung = re.findall('<div class="moviedescription">(.*?)<', data, re.S)
		if handlung:
			handlung = re.sub(r"\s+", " ", handlung[0])
			self['handlung'].setText(decodeHtml(handlung).strip())
		else:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kStreamListeScreen, streamLink, streamName, "movie")

class m4kSerienABCAuswahl(MPScreen):

	def __init__(self, session, m4kGotLink):
		self.m4kGotLink = m4kGotLink
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Movie4k.to")
		if self.m4kGotLink == 'FilmeAZ':
			self['ContentTitle'] = Label("Filme A-Z")
		else:
			self['ContentTitle'] = Label("Serien A-Z")

		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		abc = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","#"]
		for letter in abc:
			self.streamList.append((letter))
		self.streamMenuList.setList(map(m4kLetterEntry, self.streamList))
		self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		auswahl = self['liste'].getCurrent()[0]
		if auswahl == '#':
			auswahl = '1'
		print auswahl
		if self.m4kGotLink == 'SerienAZ':
			streamGenreName = "%s" % auswahl
			streamGenreLink = "http://www.movie4k.to/tvshows-all-%s.html" % auswahl
			self.session.open(m4kSerienABCListe, streamGenreLink, streamGenreName)
		elif self.m4kGotLink == 'FilmeAZ':
			streamGenreName = "%s" % auswahl
			streamGenreLink = 'http://www.movie4k.to/movies-all-%s-' % auswahl
			self.session.open(m4kKinoAlleFilmeListeScreen, streamGenreLink, streamGenreName)

class m4kSerienABCListe(MPScreen):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyAdd
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Serie Auswahl: %s" % self.streamGenreName)
		self['F2'] = Label(_("Add to Watchlist"))

		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		print self.streamGenreLink
		serien = re.findall('<TD id="tdmovies" width="538"><a href="(.*?)">(.*?)<.*?src="/img/(.*?)\.', data, re.S)
		if serien:
			self.streamList = []
			for urlPart, title, landImage in serien:
				url = '%s%s' % ('http://www.movie4k.to/', urlPart)
				self.filmliste.append((decodeHtml(title), url, landImage))
			self.chooseMenuList.setList(map(m4kSerienABCEntry, self.filmliste))
			self.keyLocked = False
			self.showInfos()
		else:
			print "parsen - Keine Daten gefunden"

	def showInfos(self):
		landImageUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(landImageUrl)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kSerienABCListeStaffeln, streamLink, streamGenreName)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		self.mTitle = self['liste'].getCurrent()[0][0]
		self.mUrl = self['liste'].getCurrent()[0][1]
		self.mLang = self['liste'].getCurrent()[0][2]
		self.flag_stored = self.mLang.replace('/img/','').replace('.png','')
		print self.flag_stored

		getPage(self.mUrl, headers=movie4kheader).addCallback(self.get_final).addErrback(self.dataError)

	def get_final(self, data):
		print "final"
		season_link = False
		serien = re.findall('<TD id="tdmovies" width="538"><a href="(.*?)">(.*?)<.*?src="/img/(.*?)\.', data, re.S)
		if serien:
			for each in serien:
				(link, seriesname, flag) = each
				if flag == self.flag_stored:
					season_link = "http://www.movie4k.to/%s" % link
		else:
			message = self.session.open(MessageBoxExt, _("No link found."), MessageBoxExt.TYPE_INFO, timeout=3)

		if season_link:
			print season_link
			getPage(season_link, headers=movie4kheader).addCallback(self.get_final2).addErrback(self.dataError)
		else:
			message = self.session.open(MessageBoxExt, _("No link found."), MessageBoxExt.TYPE_INFO, timeout=3)

	def get_final2(self, data):
		print "final2"
		serien = re.findall('<TD id="tdmovies" width="538"><a href="(.*?)">(.*?)<.*?border=0 src="/img/(.*?)\.', data, re.S)
		if serien:
			for each in serien:
				(link, seriesname, flag) = each
				if flag == self.flag_stored:
					season_link = "http://www.movie4k.to/%s" % link
		else:
			message = self.session.open(MessageBoxExt, _("No link found."), MessageBoxExt.TYPE_INFO, timeout=3)

		if season_link:
			if not fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
				open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","w").close()
			if fileExists(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist"):
				writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_m4k_watchlist","a")
				if self.mLang == "us_ger_small":
					Lang = "de"
				elif self.mLang == "us_flag_small":
					Lang = "en"
				else:
					Lang = ""

				print season_link, seriesname, Lang
				seriesname = re.search("^(.*?)(, |$)", seriesname)
				writePlaylist.write('"%s" "%s" "%s" "0"\n' % (seriesname.group(1), season_link, Lang))
				writePlaylist.close()
				message = self.session.open(MessageBoxExt, _("Selection was added to the watchlist."), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			message = self.session.open(MessageBoxExt, _("No link found."), MessageBoxExt.TYPE_INFO, timeout=3)

class m4kSerienABCListeStaffeln(MPScreen):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label("Staffel Auswahl:")
		self['name'] = Label(self.streamGenreName)
		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.page = 1
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		print self.streamGenreLink
		staffeln = re.findall('<TD id="tdmovies" width="538"><a href="(.*?)".*?Season:(.*?)<', data, re.S)
		if staffeln:
			print "staffeln parsen gefunden"
			self.streamList = []
			for urlPart, season in staffeln:
				url = '%s%s' % ('http://www.movie4k.to/', urlPart)
				formatTitle = 'Season %s' % season
				self.filmliste.append((decodeHtml(formatTitle), url))
			self.chooseMenuList.setList(map(m4kSerienABCStaffelnEntry, self.filmliste))
			self.keyLocked = False
		else:
			print "parsen - Keine Daten gefunden"

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kSerienABCListeStaffelnFilme, streamLink, streamGenreName)

class m4kSerienABCListeStaffelnFilme(MPScreen):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("movie4k.to")
		self['ContentTitle'] = Label(_("Season Selection"))
		self['name'] = Label(self.streamGenreName)
		self.keyLocked = True
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.streamGenreLink, agent=std_headers, headers=movie4kheader).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		print self.streamGenreLink
		staffeln = re.findall('<TD id="tdmovies" width="538"><a href="(.*?)">(.*?), Season:(.*?), Episode:(.*?)<', data, re.S)
		if staffeln:
			print "episode parsen gefunden"
			self.streamList = []
			for urlPart, title, season, episode in staffeln:
				url = '%s%s' % ('http://www.movie4k.to/', urlPart)
				formatTitle = 'Season %s Episode %s' % (season, episode)
				print url
				self.filmliste.append((decodeHtml(formatTitle), url, title))
			self.chooseMenuList.setList(map(m4kSerienABCStaffelnEntry, self.filmliste))
			self.keyLocked = False
		else:
			print "parsen - Keine Daten gefunden"

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamEpisode = self['liste'].getCurrent()[0][2] + self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(m4kStreamListeScreen, streamLink, streamEpisode, "tv")