﻿# -*- coding: utf-8 -*-
#    m3u8 Player for MediaPortal
#    based on ChunkPlayer for Kodi by LivingOn
#
#    Copyright (c) 2015 MediaPortal Team
#    Copyright (c) 2014 LivingOn <LivingOn@xmail.net>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program. If not, see <http://www.gnu.org/licenses/>.

from imports import *
from time import sleep

class m3u8ChunkGrabber(threading.Thread):

	DELAY_AT_START = 2
	DELAY_AT_RUN = 1

	def __init__(self, streamurl, sequencenr, streamqueue, playlisturl, streambasepost, media):
		threading.Thread.__init__(self)
		self._streamurl = streamurl
		self._sequencenr = sequencenr + 1
		self._streamqueue = streamqueue
		self._playlisturl = playlisturl
		self._streambasepost = streambasepost
		self._media = media
		self._stop_running_thread = False
		self.lastID = ""
		self._delay = self.DELAY_AT_START
		if self._media == "laola1":
			self.DELAY_AT_RUN = 0.8

	def run(self):
		for i in xrange(self._sequencenr, sys.maxint):
			if self._playlisturl:
				data = self._get_data(self._playlisturl)
				getURL, getID = re.findall('(index-\d+-(.*?).ts)', data)[0]
				if getID != self.lastID:
					url = "%s%s" % (self._streamurl, getURL)
					self.lastID = getID
				else:
					sleep(1)
					continue
			else:
				url = "%s%d%s" % (self._streamurl, i, self._streambasepost)
			while True:
				data = self._get_data(url)
				if data:
					printl(url,self,"H")
					self._streamqueue.put(data)
					self._delay = self.DELAY_AT_RUN
					break
				else:
					sleep(self._delay)
				if self._stop_running_thread:
					break
			if self._stop_running_thread:
				break

	def stop(self):
		self._stop_running_thread = True

	def _get_data(self, url):
		result = None
		try:
			result = urllib2.urlopen(url).read()
		except:
			pass
		return result

class m3u8StreamServer(threading.Thread):

	def __init__(self, streamurl, sequencenr, port, playlisturl, streambasepost, media):
		threading.Thread.__init__(self)
		self._streamurl = streamurl
		self._sequencenr = sequencenr
		self._port = port
		self._streamqueue = Queue.Queue()
		self._playlisturl = playlisturl
		self._streambasepost = streambasepost
		self._media = media
		self._chunkgrabber_thread = m3u8ChunkGrabber(self._streamurl, self._sequencenr, self._streamqueue, self._playlisturl, self._streambasepost, self._media)

	def run(self):
		self._chunkgrabber_thread.start()
		sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
		server_address = ("127.0.0.1", self._port)
		sock.bind(server_address)
		sock.listen(1)
		active = True
		while active:
			connection = sock.accept()[0]
			client_header = connection.recv(4096)
			connection.send(self._get_header())
			if client_header.startswith("HEAD"):
				connection.close()
				continue
			else:
				is_initial_call = True
				initial_call_counter = 0
				while active:
					if not self._streamqueue.empty():
						is_initial_call = False
						try:
							chunk = self._streamqueue.get()
							connection.send(chunk)
						except:
							self._chunkgrabber_thread.stop()
							break
					else:
						try:
							connection.send("")
						except:
							self._chunkgrabber_thread.stop()
							break
						if is_initial_call:
							initial_call_counter += 1
							if initial_call_counter > 15:
								self._chunkgrabber_thread.stop()
								active = False
						sleep(1)
				break

	def _get_header(self):
		return "\r\n".join(["HTTP/1.1 200 OK", "Accept-Ranges: bytes", "Content-Type: video/mp4", "", "",])

class m3u8Player:

	def __init__(self, session):
		self.session = session

	def play_stream(self, data, name, media="chaturbate", playlisturl=None):
		self.media = media
		self.name = name
		self.playlisturl = playlisturl
		self.streambasepost = ".ts"
		if data:
			if self.media == "chaturbate":
				playlist = re.findall('(http.*?://.*?.stream.highwebmedia.com:1935.*?m3u8)', data)[0]
				if playlist:
					self.streambase = re.findall('(.*)playlist.*', playlist)[0]
					getPage(playlist).addCallback(self.getplaylist).addErrback(self.dataError)
				else:
					self.quitStream()
			elif self.media == "newtopia":
				self.streambase = re.findall('(http://utpdehls01-i.akamaihd.net/hls/live/.*?Segment)', data)[0]
				if self.streambase:
					self.getseq(data)
				else:
					self.quitStream()
			elif self.media == "laola1":
				self.streambase = re.findall('(http://.*?akamaihd.net/.*?segment)', data)[0]
				self.streambasepost = re.findall('http://.*?akamaihd.net/.*?segment\d+(.*?)\n', data)[0]
				if self.streambase:
					self.getseq(data)
				else:
					self.quitStream()
			elif self.media == "twitch":
				self.streambase = re.findall('(http://.*?/)py-index-live', self.playlisturl)[0]
				self.getseq(data)
			else:
				self.quitStream()
		else:
			self.quitStream()

	def getplaylist(self, data):
		chunkurl = re.findall('(chunk.*)', data)[0]
		url = self.streambase + chunkurl
		getPage(url).addCallback(self.getseq).addErrback(self.dataError)

	def getseq(self, data):
		if self.media == "newtopia":
			sequencenr = int(re.findall('/Segment(\d+)', data)[-1])-5
		if self.media == "laola1":
			sequencenr = int(re.findall('/segment(\d+)', data)[-1])-5
		else:
			sequencenr = int(re.findall('EXT-X-MEDIA-SEQUENCE:(\d*)', data)[0])
		if self.media == "chaturbate":
			filename = re.findall('(media_w.*?_)', data)[0]
			streamurl = self.streambase + filename
		else:
			streamurl = self.streambase
		if self.media == "twitch":
			playlisturl = self.playlisturl
		else:
			playlisturl = None
		if streamurl and sequencenr:
			port = 52000 + random.randint(100,500)
			lsst = m3u8StreamServer(streamurl, sequencenr, port, playlisturl, self.streambasepost, self.media)
			lsst.start()
			self.url = "http://127.0.0.1:" + str(port)
			reactor.callLater(2, self.play)

	def dataError(self, error):
		printl(error,self,"E")

	def play(self):
		self.session.openWithCallback(self.quitStream, SimplePlayer, [(self.name, self.url)], showPlaylist=False, ltype='m3u8')

	def quitStream(self):
		self['name'].setText(self.name)
		self.keyLocked = False