﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

class wrestlingnetworkGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("wrestling-network.net")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.genreliste = [('Full Replays',"http://wrestling-network.net/tag/show-replay/page/"),
							('WWE',"http://wrestling-network.net/category/wwe/page/"),
							('RAW',"http://wrestling-network.net/category/wwe/wwe-raw/page/"),
							('SmackDown',"http://wrestling-network.net/category/wwe/wwe-smackdown/page/"),
							('NXT',"http://wrestling-network.net/category/wwe/wwe-nxt/page"),
							('TNA',"http://wrestling-network.net/category/tna/page/"),
							('WWE Network',"http://wrestling-network.net/category/wwe-network/page/"),
							('Total Divas',"http://wrestling-network.net/category/wwe/total-divas/page/")]
		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		wrestlingnetworkName = self['liste'].getCurrent()[0][0]
		wrestlingnetworkUrl = self['liste'].getCurrent()[0][1]
		self.session.open(wrestlingnetworkListeScreen, wrestlingnetworkName, wrestlingnetworkUrl)

class wrestlingnetworkListeScreen(MPScreen):

	def __init__(self, session, genreName, genreLink):
		self.genreLink = genreLink
		self.genreName = genreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self.keyLocked = True
		self['title'] = Label("wrestling-network.net")
		self['ContentTitle'] = Label("Genre: %s" % self.genreName)

		self['Page'] = Label(_("Page:"))
		self.page = 1
		self.lastpage = 1

		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		url = "%s%s" % (self.genreLink ,str(self.page))
		getPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, '', "<span class='pages'>Page.*?of (.*?)</span>")
		shows = re.findall('class="clip-link"\sdata-id=".*?"\stitle="(.*?)"\shref="(.*?)">.*?<img\ssrc="(.*?)" ', data, re.S)
		if shows:
			self.filmliste = []
			for (title,url,image) in shows:
				self.filmliste.append((decodeHtml(title),url,image))
			self.ml.setList(map(self._defaultlistleft, self.filmliste))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Url = self['liste'].getCurrent()[0][1]
		idx = self['liste'].getSelectedIndex()
		self.session.open(wrestlingnetworkPlayer, Name, Url)

class wrestlingnetworkPlayer(MPScreen):

	def __init__(self, session, Name, Url):
		self.Name = Name
		self.Url = Url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)

		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("wrestling-network.net")
		self['ContentTitle'] = Label("Videos: %s" %self.Name)

		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.getVideo)

	def getVideo(self):
		url = self.Url
		getPage(url).addCallback(self.getData).addErrback(self.dataError)

	def getData(self, data):
		url = re.findall('href="(http://wrestling-network.net/dailymotion-embed/.*?)">(.*?)</a>', data, re.S)
		self.filmliste = []
		for (url,title) in url:
			self.filmliste.append((decodeHtml(title),url))
		self.ml.setList(map(self._defaultlistleft, self.filmliste))
		self.ml.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		getPage(url).addCallback(self.getExtraData).addErrback(self.dataError)

	def getExtraData(self, data):
		url = re.findall('<iframe.*?src="(http://www.dailymotion.com/embed/video/.*?)\?', data, re.S)
		if url:
			getPage(url[0]).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		data = data.replace("\\/", "/")
		title = self['liste'].getCurrent()[0][0]
		streamname = self.Name + " - " + title
		stream_url = re.findall('"stream_(h264|h264_hq|h264_hd)_url":"(http://www.dailymotion.com/cdn/.*?)"', data, re.S)
		if stream_url:
			self.session.open(SimplePlayer, [(streamname, stream_url[-1][1])], showPlaylist=False, ltype='wrestling')