﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.songstolink import SongstoLink

class showSongstoGenre(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.baseurl = 'http://songs.to/json/songlist.php?'

		self["title"] = Label("Songs.to Music Player")
		self['ContentTitle'] = Label('Music Tops')
		self['name'] = Label(_("Selection:"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False
		self.playing = False
		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		scGenre = [("Suche ( Interpret )", "&col=artist"),
			("Suche ( Titel )", "&col=title"),
			("Suche ( Album )", "&col=album"),
			("Songs Top 500", "top=all"),
			("Singles Top 100", "charts=music_single_de"),
			("Dance Top 50", "charts=music_dance_de"),
			("Black Top 30", "charts=music_black_de"),
			("Singles US Top 100", "charts=music_single_us"),
			("Singles UK Top 100", "charts=music_single_uk"),
			("Euro Top 100", "charts=music_single_eu"),
			("Party-Schlager Top 100", "charts=music_schlager_de"),
			("Metal-Rock Top 15", "charts=music_album_mrc"),
			("Ballermann Charts", "charts=music_ballermann_de"),
			("Mallorca Mega Charts", "charts=music_mallorca_de"),
			("DJ Hitparade", "charts=music_djhit_de"),
			("Singles Jahr 2013", "charts=music_year2013_de"),
			("Singles Jahr 2012", "charts=music_year2012_de"),
			("Singles Jahr 2011", "charts=music_year2011_de"),
			("Album Top 50", "charts=music_album_de"),
			("Sampler-Charts", "charts=music_sampler_album_de"),
			("Schlager Album Charts", "charts=music_album_schlager_de"),
			("Top Rock Albums", "charts=music_rock_album_us"),
			("DDP Top 100", "charts=music_ddp100_de"),
			("DDP Hot 50", "charts=music_ddphot50_de"),
			("DDP Jahr 2014", "charts=music_ddpyear2014_de"),
			("DDP Jahr 2013", "charts=music_ddpyear2013_de"),
			("DDP Jahr 2012", "charts=music_ddpyear2012_de"),
			("DDP Jahr 2011", "charts=music_ddpyear2011_de"),
			("DDP Jahr 2010", "charts=music_ddpyear2010_de"),
			("DDP Jahr 2009", "charts=music_ddpyear2009_de"),
			("DDP Jahr 2008", "charts=music_ddpyear2008_de"),
			("DDP Jahr 2007", "charts=music_ddpyear2007_de"),
			("DDP Jahr 2006", "charts=music_ddpyear2006_de"),
			("DDP Jahr 2005", "charts=music_ddpyear2005_de"),
			("Heatseekers Songs", "charts=music_heatseekers_us"),
			("Hot Country Songs", "charts=music_country_us"),
			("Hot Rock Songs", "charts=music_rock_us"),
			("Rock Airplay", "charts=music_rockair_us"),
			("80er Hörercharts", "charts=music_80slisteners_de"),
			("House Top 44 Charts", "charts=music_44house_de"),
			("Reggae Albums", "charts=music_reggea_album_us"),
			("New Age Albums", "charts=music_newage_album_us"),
			("Soundtracks", "charts=music_soundtracks_album_us"),
			("Classical Albums", "charts=music_classical_album_us"),
			("Jazz Albums", "charts=music_jazz_album_us"),
			("Blues Albums", "charts=music_blues_album_us"),
			("Folk Albums", "charts=music_folk_album_us"),
			("Hard Rock Albums", "charts=music_hardrock_album_us"),
			("Top Country Albums", "charts=music_country_album_us"),
			("R&B/HipHop Albums", "charts=music_randbhip_album_us"),
			("Rap Albums", "charts=music_rap_album_us"),
			("Top Latin Albums", "charts=music_latin_album_us"),
			("Gospel Albums", "charts=music_gospel_album_us"),
			("Christian Albums", "charts=music_christian_album_us")]

		for (scName, scUrl) in scGenre:
			self.streamList.append((scName, scUrl))
		self.ml.setList(map(self._defaultlistcenter, self.streamList))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		scName = self['liste'].getCurrent()[0][0]
		scUrl = self['liste'].getCurrent()[0][1]
		if scName == "Songs Top 500":
			scUrl = self.baseurl + scUrl
			self.session.open(showSongstoAll, scUrl, scName)
		elif re.match('Suche.*?', scName):
			self.suchtitel = scName
			self.suchmodus = scUrl
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (self.suchtitel+":"), text = "", is_dialog=True)
		else:
			scUrl = self.baseurl + scUrl
			self.session.open(showSongstoTop, scUrl, scName)

	def searchCallback(self, callbackStr):
		if callbackStr is not None:
			self.suchString = callbackStr.replace(' ', '%20')
			scUrl = self.baseurl + "keyword=" + self.suchString + self.suchmodus
			scName = self.suchtitel + ": " + callbackStr
			self.session.open(showSongstoAll, scUrl, scName)

class showSongstoAll(MPScreen):

	def __init__(self, session, link, name):
		self.scLink = link
		self.scGuiName = name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel
		}, -1)

		self["title"] = Label("Songs.to Music Player")
		self['ContentTitle'] = Label(self.scGuiName)
		self['name'] = Label(_("Selection:"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		if self.scGuiName != "Songs Top 500" and not re.match('Suche.*?', self.scGuiName):
			print "data:",self.scLink
			self.scData(self.scLink)
		else:
			getPage(self.scLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.scData).addErrback(self.dataError)

	def scData(self, data):
		data = data.replace('"cover":null','"cover":"",')
		findSongs = re.findall('"hash":"(.*?)","title":"(.*?)","artist":"(.*?)","album":"(.*?)".*?"cover":"(.*?)"', data, re.S)
		if findSongs:
			for (scHash,scTitle,scArtist,scAlbum,scCover) in findSongs:
				self.streamList.append((decodeHtml(scTitle), decodeHtml(scArtist), scAlbum, scCover, scHash))
			self.ml.setList(map(self._playlist, self.streamList))
			self.keyLocked = False

	def _playlist(self, entry):
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont('mediaportal', height - 2 * mp_globals.sizefactor - self.fontoffset))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height - self.fontoffset, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]))
		return res

	def keyOK(self):
		if self.keyLocked:
			print self.keyLocked
			return

		idx = self['liste'].getSelectedIndex()
		self.session.open(SongstoPlayer, self.streamList, 'songstoall', int(idx), self.scGuiName)

class showSongstoTop(MPScreen):

	def __init__(self, session, link, name):
		self.scLink = link
		self.scGuiName = name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel
		}, -1)

		self["title"] = Label("Songs.to Music Player")
		self['ContentTitle'] = Label(self.scGuiName)
		self['name'] = Label(_("Selection:"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		getPage(self.scLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.scDataGet).addErrback(self.dataError)

	def scDataGet(self, data):
		findSongs = re.findall('name1":"(.*?)","name2":"(.*?)"', data, re.S)
		if findSongs:
			for (scArtist, scTitle) in findSongs:
				self.streamList.append((decodeHtml(scTitle), decodeHtml(scArtist)))
			self.ml.setList(map(self._playlist, self.streamList))
			self.keyLocked = False

	def _playlist(self, entry):
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont('mediaportal', height - 2 * mp_globals.sizefactor - self.fontoffset))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height - self.fontoffset, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]))
		return res

	def scDataPost(self, data):
		self.keyLocked = False
		self.session.open(showSongstoAll, data, self.artist + ' - ' + self.album)

	def keyOK(self):
		if self.keyLocked:
			return

		if self.scGuiName == "Album Top 50" or self.scGuiName == "Sampler-Charts" or self.scGuiName == "Schlager Album Charts" or	self.scGuiName == "Top Rock Albums" or self.scGuiName == "Reggae Albums" or self.scGuiName == "New Age Albums" or self.scGuiName == "Soundtracks" or self.scGuiName == "Classical Albums" or self.scGuiName == "Jazz Albums" or self.scGuiName == "Blues Albums" or self.scGuiName == "Folk Albums" or self.scGuiName == "Hard Rock Albums" or self.scGuiName == "Top Country Albums" or self.scGuiName == "R&B/HipHop Albums" or self.scGuiName == "Rap Albums" or self.scGuiName == "Top Latin Albums" or self.scGuiName == "Gospel Albums" or self.scGuiName == "Christian Albums":
			self.keyLocked = True
			self.artist = self['liste'].getCurrent()[0][1]
			self.album = self['liste'].getCurrent()[0][0]
			url = "http://songs.to/json/songlist.php?quickplay=1"
			dataPost = "data=%7B%22data%22%3A%5B%7B%22artist%22%3A%22"+self.artist+"%22%2C%20%22album%22%3A%22"+self.album+"%22%2C%20%22title%22%3A%22%22%7D%5D%7D"
			#print "datapost:",dataPost
			getPage(url, method='POST', postdata=dataPost, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.scDataPost).addErrback(self.dataError)
		else:
			idx = self['liste'].getSelectedIndex()
			self.session.open(SongstoPlayer, self.streamList, 'songstotop', int(idx), self.scGuiName)

class SongstoPlayer(SimplePlayer):

	def __init__(self, session, playList, songsto_type, playIdx=0, listTitle=None):
		print "SongstoPlayer:"
		self.songsto_type = songsto_type

		SimplePlayer.__init__(self, session, playList, playIdx=playIdx, playAll=True, listTitle=listTitle, ltype='songsto', cover=True, autoScrSaver=True, listEntryPar=[20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, ' - ', 1, 0])

	def getVideo(self):
		sc_artist = self.playList[self.playIdx][1]
		sc_title = self.playList[self.playIdx][self.title_inr]
		if self.songsto_type == 'songstotop':
			sc_album = ''
			token = ''
			imgurl = ''
		else:
			sc_album = self.playList[self.playIdx][2]
			token = self.playList[self.playIdx][4]
			imgurl = self.playList[self.playIdx][3]
			imgurl = "http://songs.to/covers/"+imgurl

		SongstoLink(self.session).getLink(self.playStream, self.dataError, sc_title, sc_artist, sc_album, token, imgurl)