﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2015
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.simpleplayer import SimplePlayerMenu, SimplePlaylistIO

import uuid

config.mediaportal.groove_username = ConfigText(default="grooveUserName", fixed_size=False)
config.mediaportal.groove_password = ConfigPassword(default="groovePassword", fixed_size=False)
config.mediaportal.groove_limit = ConfigText(default="500", fixed_size=False)
config.mediaportal.groove_sAWR1 = ConfigText(default="70", fixed_size=False)
config.mediaportal.groove_sAWR2 = ConfigText(default="100", fixed_size=False)
config.mediaportal.groove_sAWM = ConfigText(default="0.9", fixed_size=False)
config.mediaportal.groove_wMR1 = ConfigText(default="-9", fixed_size=False)
config.mediaportal.groove_wMR2 = ConfigText(default="9", fixed_size=False)

try:
	from Plugins.Extensions.mediainfo.plugin import mediaInfo
	MediainfoPresent = True
except:
	MediainfoPresent = False

class Session():
	def __init__(self):
		self.user = str(uuid.uuid4())
		self.session = hashlib.md5(self.user.encode('utf-8')).hexdigest()
		self.secret = hashlib.md5(self.session.encode('utf-8')).hexdigest()
		self.country = {'ID': 221, 'CC1': 0, 'CC2': 0, 'CC3': 0, 'CC4': 0, 'DMA': 0, 'IPR': 0}
		self.clients = {'htmlshark' : {'version' : '20130520','token' : 'nuggetsOfBaller'},'jsqueue' : {'version' : '20130520','token' : 'chickenFingers'}}
		self.user_agent = 'Mozilla/5.0 (Windows NT 6.2; rv:9.0.1) Gecko/20100101 Firefox/9.0.1'
		self.token_timeout = 1200
		self.groove_userid = -1
		self.groove_username = ''
		self.mpUserPlaylist = []

class getGrooveData():
	def __init__(self, session=None):
		if session is None:
			self.session = Session()
			self.session.sessiontime = time()
		else:
			self.session = session
		self.callback_main = ''
		self.tokencallback = None
		self.grooveID = ''
		self.method = ''
		self.grooveparameters = ''

	def getToken(self, tokencallback, callback, grooveID, method, grooveparameters):
		self.callback_main = callback
		self.tokencallback = tokencallback
		self.grooveID = grooveID
		self.method = method
		self.grooveparameters = grooveparameters
		method = 'getCommunicationToken'
		parameters = {'secretKey' : self.session.secret}
		header = {'uuid' :self.session.user,
										'session' : self.session.session,
										'clientRevision' : self.session.clients['htmlshark']['version'],
										'country' : self.session.country,
										'privacy' : 0,
										'client' : 'htmlshark'}
		data = json.dumps({'parameters' : parameters, 'method' : method, 'header' : header})
		url = 'https://grooveshark.com/more.php?%s' % (method)
		getPage(url, agent=self._json_request_header(), method='POST', postdata=data.encode('utf-8'), headers=self._json_request_header()).addCallback(self.getQueueID).addErrback(self.dataError)

	def getQueueID(self,data):
		result = json.loads(data.decode('utf-8'))
		if 'result' in result:
			self.session.token = result['result']
			self.session.sessiontime = time()
			self.queueIDRequest('initiateQueue', None, self.header(None, None, 'initiateQueue', None, 'jsqueue'))

	def queueIDRequest(self, method, parameters, header):
		data = json.dumps({'parameters' : parameters, 'method' : method, 'header' : header})
		url = 'https://grooveshark.com/more.php?%s' % (method)
		getPage(url, agent=self._json_request_header(), method='POST', postdata=data.encode('utf-8'), headers=self._json_request_header()).addCallback(self.getPageData).addErrback(self.dataError)

	def getPageData(self,data):
		result = json.loads(data.decode('utf-8'))
		if 'result' in result:
			self.session.queue = result['result']
			if self.tokencallback == None:
				self.callback_main(self.session.queue)
			else:
				self.tokencallback(self.callback_main, self.grooveID, self.method, self.grooveparameters)

	def datarequest(self, callback, grooveID, method, parameters, ext_header='htmlshark'):
		header = self.header(callback, grooveID, method, parameters, ext_header)
		data = json.dumps({'parameters' : parameters, 'method' : method, 'header' : header})
		url = 'https://grooveshark.com/more.php?%s' % (method)
		if time() - self.session.sessiontime > self.session.token_timeout -10:
			self.getToken(self.datarequest , callback, grooveID, method, parameters)
		d = getPage(url, agent=self._json_request_header(), method='POST', postdata=data.encode('utf-8'), headers=self._json_request_header())
		d.addCallback(self.getFinalData, callback)
		d.addErrback(self.dataError)

	def getFinalData(self,data,callback):
		result = json.loads(data.decode('utf-8'))
		if 'result' in result:
			grooveresult = result['result']
			print "Final Data Found"
			callback(grooveresult)

	def header(self, callback, grooveID, method, parameters, client='htmlshark'):
		return {'token' : self._request_token(callback, grooveID, method, parameters, client),
				'privacy' : 0,
				'uuid' : self.session.user,
				'clientRevision' : self.session.clients[client]['version'],
				'session' : self.session.session,
				'client' : client,
				'country' : self.session.country}

	def _request_token(self, callback, grooveID, method, parameters, client):
		random_value = self._random_hex()
		return random_value + hashlib.sha1((method + ':' + self.session.token + ':' + self.session.clients[client]['token'] + ':' + random_value).encode('utf-8')).hexdigest()

	def _random_hex(self):
		return ''.join([random.choice('0123456789abcdef') for i in range(6)])

	def _json_request_header(self):
		return {'Cookie' : 'PHPSESSID=' + self.session.session, 'Content-Type' : 'application/json',
				'User-Agent' : self.session.user_agent, 'Content-Type' : 'application/json'}

	def dataError(self, error):
		print "LOAD ERROR #####", error

class grooveSetupScreen(Screen, ConfigListScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/GroovesharkSetup.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/GroovesharkSetup.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Screen.__init__(self, session)
		self['title'] = Label("Grooveshark " + _("Setup"))
		self.setTitle("Grooveshark " + _("Setup"))

		self.list = []
		ConfigListScreen.__init__(self, self.list)

		self.list.append(getConfigListEntry(_("Username:"), config.mediaportal.groove_username))
		self.list.append(getConfigListEntry(_("Password:"), config.mediaportal.groove_password))
		self.list.append(getConfigListEntry(_("Search limit:"), config.mediaportal.groove_limit))
		self.list.append(getConfigListEntry("--- Expert Radio Settings ---", config.mediaportal.fake_entry))
		self.list.append(getConfigListEntry("seedArtistWeightRange1 (70):", config.mediaportal.groove_sAWR1))
		self.list.append(getConfigListEntry("seedArtistWeightRange2 (100):", config.mediaportal.groove_sAWR2))
		self.list.append(getConfigListEntry("secArtistWeight (0.9):", config.mediaportal.groove_sAWM))
		self.list.append(getConfigListEntry("weightModifierRange1 (-9):", config.mediaportal.groove_wMR1))
		self.list.append(getConfigListEntry("weightModifierRange2 (9):", config.mediaportal.groove_wMR2))

		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok":		self.saveConfig,
			"cancel":	self.exit
		}, -1)

	def saveConfig(self):
		print "save"
		for x in self["config"].list:
			x[1].save()
		configfile.save()
		self.close()

	def exit(self):
		self.close()

class grooveGenreScreen(MPScreen):

	def __init__(self, session):
		self.groovehelper = getGrooveData()
		self.groovesession = self.groovehelper.session
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"leavePlayer": self.stopPlay,
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"yellow": self.setup
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False
		self.keyLocked = True
		self['title'] = Label("grooveshark.com")
		self['ContentTitle'] = Label("Genre:")
		self['F3'] = Label(_("Setup"))

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.grooveID = 0
		self.groovequeue = ''

		self.onLayoutFinish.append(self.initGroove)
		self.onClose.append(self.stopPlay)

	def initGroove(self):
		getGrooveData(self.groovesession).getToken(None, self.grooveLogin, '1', '', '')

	def grooveLogin(self, groovequeue):
		self.groovequeue = str(groovequeue)
		puser = str(config.mediaportal.groove_username.value)
		ppassword = str(config.mediaportal.groove_password.value)
		if puser != "grooveUserName" and ppassword != "groovePassword":
				self.groovemethod = 'authenticateUser'
				self.grooveparameters = {"username":puser,"password":ppassword}
				getGrooveData(self.groovesession).datarequest(self.grooveLoginCallback, 0, self.groovemethod, self.grooveparameters)
		else:
			self['title'].setText("grooveshark.com - MPUser Username not set ")
			self.loadPage(self.groovequeue)

	def grooveLoginCallback(self, result):
		try:
			if result['userID'] > 0:
				self.groovehelper.session.groove_userid = result['userID']
				self.groovehelper.session.groove_username = result['FName']
			else:
				self.groovehelper.session.groove_userid = -1
		except:
			self.groovehelper.session.groove_userid = -1
		if self.groovehelper.session.groove_userid != -1:
			titletxt = "grooveshark.com - logged in as %s " % str(self.groovehelper.session.groove_username)
			self['title'].setText(titletxt)
			groovemethod = 'userGetPlaylists'
			grooveparameter = {'userID' : self.groovehelper.session.groove_userid}
			grooveparameter['limit'] = int(config.mediaportal.groove_limit.value) if config.mediaportal.groove_limit.value.isdigit() else 500
			getGrooveData(self.groovesession).datarequest(self.grooveMPPlaylistCallback, 0, groovemethod, grooveparameter)
		else:
			self['title'].setText("grooveshark.com - not logged in")
			self.loadPage(self.groovequeue)

	def grooveMPPlaylistCallback(self,result):
		for playlists in result['Playlists']:
			playlistname = playlists['Name']
			playlistid= playlists['PlaylistID']
			self.groovehelper.session.mpUserPlaylist.append((playlistname.encode("UTF-8"), str(playlistid)))
		self.loadPage(self.groovequeue)

	def loadPage(self, groovequeue):
		self.groovequeue = str(groovequeue)
		self.genreliste = [('Local Song Playlist',"none",1),
							('Popular Songs daily',"none",2),
							('Popular Songs monthly',"none",21),
							('Play Radio',"none",3),
							('Search Artists',"none",4),
							('Search Songs',"none",5),
							('Search Playlists',"none",6),
							('Search Albums',"none",7),
							('Search Username',"none",8),
							('MP User Playlists',"none",16),
							('MP User Favorits',"none",17),
							('MP User Collection',"none",18),
							('MP User Subscribed Playlist',"none",19)
							]
		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False
		self['name'].setText("")

	def seekFwd(self):
		self['liste'].pageDown()

	def seekBack(self):
		self['liste'].pageUp()

	def keyOK(self):
		if self.keyLocked:
			return
		grooveGenre = self['liste'].getCurrent()[0][0]
		self.grooveID = self['liste'].getCurrent()[0][2]
		if self.grooveID == 1:
			self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, grooveGenre, self.grooveID, '', self.groovequeue)
		elif self.grooveID == 2 or self.grooveID == 21:
			self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, grooveGenre, self.grooveID, '', self.groovequeue)
		elif self.grooveID == 3:
			self.session.openWithCallback(self.groovePlayCallback, grooveRadioScreen, self.groovesession, grooveGenre, self.grooveID, self.groovequeue)
		elif self.grooveID == 4:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Artists - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 5:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Songstitle - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 6:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Playlists - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 7:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Albums - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 8:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("User - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 9:
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("User - Enter search query")), text = "", is_dialog=True)
		elif self.grooveID == 16 or self.grooveID == 17 or self.grooveID == 18 or self.grooveID == 19:
			puser = self.groovehelper.session.groove_userid
			if puser == -1:
				message = self.session.open(MessageBoxExt, _("Username/Password is not set or wrong - please use Setup (yellowKey) or verify your Password"), MessageBoxExt.TYPE_INFO, timeout=10)
			else:
				if self.grooveID == 16 or self.grooveID == 19:
					self.session.open(grooveSelectScreen, self.groovesession, puser, self.grooveID, puser, self.groovequeue)
				else:
					self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, puser, self.grooveID, 'MP User', self.groovequeue)

	def searchCallback(self, callbackStr):
		if callbackStr is not None:
			print callbackStr
			Name = callbackStr
			if self.grooveID == 5:
				self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, Name, self.grooveID, None, self.groovequeue)
			else:
				self.session.open(grooveSelectScreen, self.groovesession, Name, self.grooveID, Name, self.groovequeue)

	def groovePlayCallback(self, callbackname=0, callbackvalue=None, grooveID=0):
		if grooveID != 0:
			self.session.open(grooveSelectScreen, self.groovesession, callbackvalue, grooveID, callbackname, self.groovequeue)

	def keyCancel(self):
		self.session.nav.stopService()
		self.session.nav.playService(self.lastservice)
		self.playing = False
		self.close()

	def setup(self):
		if mp_globals.isDreamOS:
			self.session.openWithCallback(self.setupCallback, grooveSetupScreen, is_dialog=True)
		else:
			self.session.openWithCallback(self.setupCallback, grooveSetupScreen)

	def setupCallback(self):
		pass

	def stopPlay(self):
		self.session.nav.stopService()
		self.session.nav.playService(self.lastservice)

class grooveSelectScreen(MPScreen):
	def __init__(self, session, groovesession, genreName, grooveID, groovename, groovequeue):
		self.grooveID = grooveID
		self.groovequeue = groovequeue
		self.genreName = genreName
		self.ext_search = groovename
		self.groovesession = groovesession
		self.groovehelper = getGrooveData(self.groovesession)
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultPlaylistScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultPlaylistScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel,
			"blue": self.keyAction
		}, -1)

		self.keyLocked = True
		self["title"] = Label("groove - ")
		self["coverArt"] = Pixmap()
		self["songtitle"] = Label("")
		self["artist"] = Label(_("Please wait..."))
		self["album"] = Label("Select and OK to search for Songs")
		self["playmode"] = Label("")
		self['F4'] = Label(_(_("Action")))
		self.songliste = []
		self.sortorder = 3
		self.playlistName = ''
		self.playlistID = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.getData)

	def getData(self):
		if self.grooveID == 4:
			self.groovemethod = 'getResultsFromSearch'
			self.grooveparameters = {'query' : self.genreName, 'type' : 'Artists', 'guts' : 0, 'ppOverride' : False}
		if self.grooveID == 107:
				self.groovemethod = 'artistGetAllAlbums'
				self.grooveparameters = {'artistID' : self.genreName }
		elif self.grooveID == 6:
			self.groovemethod = 'getResultsFromSearch'
			self.grooveparameters = {'query' : self.genreName, 'type' : 'Playlists', 'guts' : 0, 'ppOverride' : False}
		elif self.grooveID == 7:
			self.groovemethod = 'getResultsFromSearch'
			self.grooveparameters = {'query' : self.genreName, 'type' : 'Albums', 'guts' : 0, 'ppOverride' : False}
		elif self.grooveID == 8:
			self.groovemethod = 'getResultsFromSearch'
			self.grooveparameters = {'query' : self.genreName, 'type' : 'Users', 'guts' : 0, 'ppOverride' : False}
		elif self.grooveID == 16:
			self.groovemethod = 'userGetPlaylists'
			self.grooveparameters = {'userID' : self.genreName}
		elif self.grooveID == 19:
			self.groovemethod = 'getSubscribedPlaylistsBroadcasts'
			self.grooveparameters = {}
		self.grooveparameters['limit'] = int(config.mediaportal.groove_limit.value) if config.mediaportal.groove_limit.value.isdigit() else 500
		getGrooveData(self.groovesession).datarequest(self.loadPage, self.grooveID, self.groovemethod, self.grooveparameters)

	def loadPage(self, grooveresult):
		self.keyLocked = True
		if self.grooveID == 4:
			self["album"].setText("Select and OK to search for Songs or BlueKey")
			self['title'].setText("groove - Artists %s" % self.genreName)
			for artist in grooveresult['result']:
				artistname = artist['Name']
				artistid = artist['ArtistID']
				sortorder = artist['PopularityIndex']
				self.songliste.append((artistname.encode("UTF-8"), str(artistid), None, sortorder))
		elif self.grooveID == 6:
			self['title'].setText("groove - Playlist %s" % self.genreName)
			for playlists in grooveresult['result']:
				playlistname = "%s - %s" % (playlists['Name'], playlists['FName'])
				playlistcover = playlists['Picture']
				playlistid= playlists['PlaylistID']
				sortorder = playlists['Score']
				self.songliste.append((playlistname.encode("UTF-8"), str(playlistid), playlistcover, sortorder))
		elif self.grooveID == 7:
			self['title'].setText("groove - Albums %s" % self.genreName)
			for album in grooveresult['result']:
				albumname = album['AlbumName']
				albumartist = album['ArtistName']
				albumid = album['AlbumID']
				albumcover = album['CoverArtFilename']
				sortorder = album['Popularity']
				albumtext = "%s - %s" % (albumartist, albumname)
				self.songliste.append((albumtext.encode("UTF-8"), str(albumid), albumcover, sortorder))
		elif self.grooveID == 107:
			self.songliste = []
			self["album"].setText("Select and OK to show Songs or BlueKey")
			self['title'].setText("groove - Albums %s" % self.ext_search)
			for album in grooveresult['albums']:
				albumname = album['Name']
				albumartist = self.ext_search
				albumid = album['AlbumID']
				albumcover = album['CoverArtFilename']
				sortorder = album['Popularity']
				albumtext = "%s - %s" % (albumartist, albumname)
				self.songliste.append((albumtext.encode("UTF-8"), str(albumid), albumcover, sortorder))
		elif self.grooveID == 8:
			self["album"].setText("Select and OK to show Songs or BlueKey")
			self['title'].setText("groove - Users %s" % self.genreName)
			for user in grooveresult['result']:
				userid= user['UserID']
				username= user['Name']
				userfullname= user['Username']
				sortorder = user['Score']
				usertext = "Usename: %s - Name: %s" % (username, userfullname)
				self.songliste.append((usertext.encode("UTF-8"), str(userid), None, sortorder))
		elif self.grooveID == 16:
			self.songliste = []
			self["album"].setText("Select and OK to show Songs or BlueKey")
			self['title'].setText("groove - UsersPlaylist: %s" % str(self.groovehelper.session.groove_username))
			for playlists in grooveresult['Playlists']:
				playlistname = playlists['Name']
				if playlists.has_key('Picture'):
					playlistcover = playlists['Picture']
				else:
					playlistcover = None
				playlistid= playlists['PlaylistID']
				sortorder = playlistid
				self.songliste.append((playlistname.encode("UTF-8"), str(playlistid), playlistcover, sortorder))
		elif self.grooveID == 19:
			self.songliste = []
			self["album"].setText("Select and OK to show Songs or BlueKey")
			self['title'].setText("groove - Subscribed Playlist: %s" % str(self.groovehelper.session.groove_username))
			for playlists in grooveresult['playlists']:
				playlistname = "%s - %s" % (playlists['Name'], playlists['FName'])
				if playlists.has_key('Picture'):
					playlistcover = playlists['Picture']
				else:
					playlistcover = None
				playlistid= playlists['PlaylistID']
				sortorder = playlistid
				self.songliste.append((playlistname.encode("UTF-8"), str(playlistid), playlistcover, sortorder))
		if len(self.songliste) == 0:
			print "No Songlist found!"
			self.songliste.append(('No Songlist found!','',''))
		else:
			self.songliste.sort(key=lambda t : t[3], reverse=True)
		self.ml.setList(map(self._defaultlistleft, self.songliste))
		self.keyLocked = False
		self['artist'].setText("")

	def keyAction(self):
		self.grooveAdd = None
		if self.keyLocked:
			return
		else:
			groovesong = self['liste'].getCurrent()[0]
			if mp_globals.isDreamOS:
				self.session.openWithCallback(self.actionCallback, grooveActionScreen, groovesong, self.grooveID , 2, self.groovesession, is_dialog=True)
			else:
				self.session.openWithCallback(self.actionCallback, grooveActionScreen, groovesong, self.grooveID , 2, self.groovesession)

	def actionCallback(self, result):
		if result != 0:
			if result == 7:
				self.grooveID = 107
				self.ext_search = self['liste'].getCurrent()[0][0]
				self.genreName = self['liste'].getCurrent()[0][1]
				self['artist'].setText(_("Please wait..."))
				self.getData()
			elif result == 9:
				self.grooveID = 16
				self.ext_search = self['liste'].getCurrent()[0][0]
				self.genreName = self['liste'].getCurrent()[0][1]
				self['artist'].setText(_("Please wait..."))
				self.getData()
			elif result == 10:
				if self.sortorder == 3:
					self.sortorder = 0
					rather = False
				else:
					self.sortorder = 3
					rather = True
				self.songliste.sort(key=lambda t : t[self.sortorder], reverse=rather)
				self.ml.setList(map(self._defaultlistleft, self.songliste))
			elif result == 22:
				self.session.openWithCallback(self.newPlayListname_cp, VirtualKeyBoardExt, title = (_("new Playlist - type in new name")), text = "", is_dialog=True)
			elif result == 23:
				delName = self['liste'].getCurrent()[0][0]
				delID = self['liste'].getCurrent()[0][1]
				self.playlistName = delName
				self.playlistID = delID
				groovemethod = 'deletePlaylist'
				grooveparameter = {"playlistID" : int(delID) , "name" : str(delName)}
				getGrooveData(self.groovesession).datarequest(self.delPLcallback, 16, groovemethod, grooveparameter)
			elif result == 24:
				delName = self['liste'].getCurrent()[0][0]
				delID = self['liste'].getCurrent()[0][1]
				self.playlistName = delName
				self.playlistID = delID
				groovemethod = 'unfavorite'
				grooveparameter = {"what": "Playlist", "ID": int(delID)}
				getGrooveData(self.groovesession).datarequest(self.delPLcallback, 19, groovemethod, grooveparameter)
			elif result == 25:
				delName = self['liste'].getCurrent()[0][0]
				delID = self['liste'].getCurrent()[0][1]
				self.playlistName = delName
				self.playlistID = delID
				groovemethod = 'favorite'
				grooveparameter = {"what": "Playlist", "ID": int(delID)}
				getGrooveData(self.groovesession).datarequest(self.groovePlayCallback, 19, groovemethod, grooveparameter)

	def newPlayListname_cp(self, callbackStr):
		if callbackStr is not None:
			print callbackStr
			self.playlistName = callbackStr
			groovemethod = 'createPlaylistEx'
			grooveparameter = {"playlistName" : callbackStr,"songIDs" : [], "playlistAbout" : ""}
			getGrooveData(self.groovesession).datarequest(self.newPLCallback, self.grooveID, groovemethod, grooveparameter)

	def newPLCallback(self, result):
		if result >= 1:
			message = self.session.open(MessageBoxExt, _("new remote Playlist is generated"), MessageBoxExt.TYPE_INFO, timeout=2)
			self.groovehelper.session.mpUserPlaylist.append((self.playlistName.encode("UTF-8"), str(result)))
		else:
			message = self.session.open(MessageBoxExt, _("ERROR, no new remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)
		self.songliste = []
		self.getData()

	def delPLcallback(self, result):
		if result.has_key('success'):
			if  result['success'] == True:
				message = self.session.open(MessageBoxExt, _("subscribed remote Playlist removed"), MessageBoxExt.TYPE_INFO, timeout=2)
			else:
				message = self.session.open(MessageBoxExt, _("ERROR, removing subscribed remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)
		elif result == 1:
			message = self.session.open(MessageBoxExt, _("remote Playlist deleted"), MessageBoxExt.TYPE_INFO, timeout=2)
			self.groovehelper.session.mpUserPlaylist.remove((self.playlistName.encode("UTF-8"), str(self.playlistID)))
		else:
			message = self.session.open(MessageBoxExt, _("ERROR, deleting remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)
		self.songliste = []
		self.getData()

	def keyOK(self):
		if self.keyLocked:
			return
		grooveName = self['liste'].getCurrent()[0][0]
		grooveChoice = self['liste'].getCurrent()[0][1]
		self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, grooveChoice, self.grooveID, grooveName, self.groovequeue)

	def groovePlayCallback(self, callbackname=0, callbackvalue=None, grooveID=0):
		if grooveID != 0:
			self.grooveID = grooveID
			self.genreName = callbackvalue
			self.ext_search = callbackname
			self.getData()

	def keyUp(self):
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDown(self):
		if self.keyLocked:
			return
		self['liste'].down()
		if self.grooveID == 3:
			if self['liste'].getSelectedIndex() == len(self.songliste)-1:
				self.loadPage()

	def keyLeft(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRight(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def keyCancel(self):
		self.close()

class grooveRadioScreen(MPScreen):

	def __init__(self, session, groovesession, grooveGenre, grooveID, groovequeue):
		self.grooveGenre = grooveGenre
		self.grooveID = grooveID
		self.groovequeue = groovequeue
		self.groovesession = groovesession
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False
		self.keyLocked = True
		self['title'] = Label("grooveshark.com - Radio")

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		genrehelper = {'80S': 55, '90S' : 9, 'Ambient': 75, 'Bluegrass': 96, 'Blues': 230, 'Classical': 750, 'ClassicRock': 3529, 'Country': 80,
					'Dubstep': 2563, 'Electronica': 67, 'Experimental': 191, 'Folk': 122, 'Funk': 397, 'Hiphop': 29, 'Indie': 136, 'Jazz': 43,
					'Metal': 17, 'Oldies': 102, 'Pop': 56, 'Rap': 3, 'Reggae': 160, 'Rock': 12, 'Trance': 69}
		for genre, radioid in genrehelper.iteritems():
			self.genreliste.append((genre, radioid, 3))
			self.genreliste.sort()
			self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False

	def seekFwd(self):
		self['liste'].pageDown()

	def seekBack(self):
		self['liste'].pageUp()

	def keyOK(self):
		if self.keyLocked:
			return
		grooveRadioGenre = self['liste'].getCurrent()[0][0]
		grooveRadioCall = self['liste'].getCurrent()[0][1]
		self.session.openWithCallback(self.groovePlayCallback, groovePlayScreen, self.groovesession, grooveRadioGenre, self.grooveID, grooveRadioCall, self.groovequeue)

	def groovePlayCallback(self, callbackname=0, callbackvalue=None, grooveID=0):
		if grooveID != 0:
			self.close(callbackname, callbackvalue, grooveID)

class groovePlayScreen(MPScreen, InfoBarBase, InfoBarSeek):

	def __init__(self, session, groovesession, genreName, grooveID, grooveAdd=None, groovequeue=None):
		self.groovesession = groovesession
		self.grooveID = grooveID
		self.genreName = genreName
		self.grooveAdd = grooveAdd
		self.groovequeue = groovequeue
		self.grooveresult = {}
		self.grooveradiocounter = 10
		self.groovehelper = getGrooveData(self.groovesession)
		self.actionresult = 0
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultPlaylistScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		self._no_picPath = "%s/%s/images/no_coverArt_150.png" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultPlaylistScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)
		InfoBarBase.__init__(self)
		InfoBarSeek.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			config.mediaportal.sp_mi_key.value: self.openMediainfo,
			"leavePlayer": self.stopPlay,
			"menu" : self.openMenu,
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel,
			"green": self.keyAdd,
			"yellow": self.keyPlaymode,
			"red": self.keyDel,
			"blue": self.keyAction
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False
		self.keyLocked = True
		self.playmode = 'Next'
		self.playlistName = ''
		self["title"] = Label("groove - ")
		self["coverArt"] = Pixmap()
		self["songtitle"] = Label("")
		self["artist"] = Label(_("Please wait..."))
		self["album"] = Label("RemoteSong-Playlist")
		self["playmode"] = Label("Next")
		self['F2'] = Label(_("add Song"))
		self['F3'] = Label(_("Playmode"))
		self['F4'] = Label(_("Action"))

		self.songliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.ALBUM_COVER_URL = 'http://images.grooveshark.com/static/albums/'
		self.grooveradio = {}
		self.seedArtists = {}

		self.onLayoutFinish.append(self.getData)

	def getData(self):
		if self.grooveID == 1:
			self.groovemethod = ''
			self.grooveparameters = {'type' : ''}
			self.loadPage('')
		else:
			self.keyLocked = True
			if self.grooveID == 3:
				self.groovemethod = 'getArtistsForTagRadio'
				self.grooveparameters = {'tagID' : self.grooveAdd }
				getGrooveData(self.groovesession).datarequest(self.callback_radio, self.grooveID, self.groovemethod, self.grooveparameters, 'jsqueue')
			else:
				if self.grooveID == 2:
					self.groovemethod = 'popularGetSongs'
					self.grooveparameters = {'type' : 'daily'}
				elif self.grooveID == 21:
					self.groovemethod = 'popularGetSongs'
					self.grooveparameters = {'type' : 'monthly'}
				elif self.grooveID == 4:
					self.groovemethod = 'artistGetArtistSongs'
					self.grooveparameters = {'artistID' : self.genreName }
				elif self.grooveID == 5:
					self.groovemethod = 'getResultsFromSearch'
					self.grooveparameters = {'query' : self.genreName, 'type' : 'Songs', 'guts' : 0, 'ppOverride' : False}
				elif self.grooveID == 6 or self.grooveID == 16 or self.grooveID == 19:
					self.groovemethod = 'playlistGetSongs'
					self.grooveparameters = {'playlistID' : self.genreName }
				elif self.grooveID == 7 or self.grooveID == 107:
					self.groovemethod = 'albumGetAllSongs'
					self.grooveparameters = {'albumID' : self.genreName }
				elif self.grooveID == 8:
					self.groovemethod = 'userGetSongsInLibrary'
					self.grooveparameters = {'userID' : self.genreName, 'page' : 0}
				elif self.grooveID == 17:
					self.groovemethod = 'getFavorites'
					self.grooveparameters = {'userID' : self.genreName, "ofWhat" : "Songs"}
				elif self.grooveID == 18:
					self.groovemethod = 'userGetSongsInLibrary'
					self.grooveparameters = {'userID' : self.genreName, 'page' : 0}
				self.grooveparameters['limit'] = int(config.mediaportal.groove_limit.value) if config.mediaportal.groove_limit.value.isdigit() else 500
				getGrooveData(self.groovesession).datarequest(self.loadPage, self.grooveID, self.groovemethod, self.grooveparameters)

	def callback_radio(self,grooveresult):
		self.keyLocked = True
		songIDs = []
		recentArtists = []
		artistIDs = []
		self.grooveradio = grooveresult

		if len(self.seedArtists) == 0:
			self.seedArtists = dict([(artist['ArtistID'], 'p') for artist in grooveresult])
			if not len(self.songliste) == 0:
				for songs in self.songliste[:100]:
					if not songs[3] == '0':
						self.seedArtists.update(dict([(str(songs[3]), 'p')]))
			if len(self.seedArtists) == 0:
				message = self.session.open(MessageBoxExt, _("No ArtistID found in the song list, may be create new local playlist."), MessageBoxExt.TYPE_INFO, timeout=10)
				self.seedArtists = {'402024': 'p'}
		if not len(self.songliste) == 0:
			for songs in reversed(self.songliste):
				songIDs.append(songs[1])
				artistIDs.append(songs[3])
			[recentArtists.append(i) for i in artistIDs if not i in recentArtists]
		self.groovemethod = 'autoplayGetSong'
		sAWR1 = int(config.mediaportal.groove_sAWR1.value) if config.mediaportal.groove_sAWR1.value.isdigit() else 90
		sAWR2 = int(config.mediaportal.groove_sAWR2.value) if config.mediaportal.groove_sAWR2.value.isdigit() else 120
		sAWM = float(config.mediaportal.groove_sAWM.value) if config.mediaportal.groove_sAWM.value.replace('.','',1).isdigit() else 0.9
		wMR1 = int(config.mediaportal.groove_wMR1.value) if config.mediaportal.groove_wMR1.value.replace('-','',1).isdigit() else -9
		wMR2 = int(config.mediaportal.groove_wMR2.value) if config.mediaportal.groove_wMR2.value.replace('-','',1).isdigit() else 9
		self.grooveparameters = {'weightModifierRange' : [wMR1,wMR2],
								'seedArtists' : self.seedArtists,
								'recentArtists' : recentArtists[:5],
								'songQueueID' : self.groovequeue, 'secondaryArtistWeightModifier' : sAWM,
								'country' : self.groovesession.country, 'seedArtistWeightRange' : [sAWR1,sAWR2],
								'songIDsAlreadySeen' : songIDs, 'maxDuration' : 1500,
								'minDuration' : 60, 'frowns' : []}
		if self.grooveAdd:
			self.grooveparameters['tagID'] = self.grooveAdd
		getGrooveData(self.groovesession).datarequest(self.loadPage, self.grooveID, self.groovemethod, self.grooveparameters, 'jsqueue')

	def loadPage(self, grooveresult):
		self.grooveresult = grooveresult
		self.keyLocked = True
		try:
			if self.grooveID == 1:
				self.songliste = []
				self['title'].setText("groove - Local Playlist")
				self['F1'].setText(_("Delete"))
				self['F2'].setText("")
				if not fileExists(config.mediaportal.watchlistpath.value+"mp_groove_playlist"):
					open(config.mediaportal.watchlistpath.value+"mp_groove_playlist","w").close()
				leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_groove_playlist")
				if not leer == 0:
					self.songs_read = open(config.mediaportal.watchlistpath.value+"mp_groove_playlist" , "r")
					for lines in sorted(self.songs_read.readlines()):
						if len(re.findall('"\s"', lines)) == 5:
							line = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)" "(.*?)"', lines)
						else:
							line = re.findall('"(.*?)" "(.*?)" "(.*?)"', lines)
							line = [(line[0][0], line[0][1], line[0][2], "0", "0")]
						if line and line[0][4] == "0":
							(read_song, read_songid, read_cover, read_artist, read_id) = line[0]
							self.songliste.append((decodeHtml(read_song),read_songid, read_cover, read_artist))
			if self.grooveID == 2 or self.grooveID == 21 or self.grooveID == 18:
				self['title'].setText("groove - Popular Songs")
				for songinfo in self.grooveresult['Songs']:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
			elif self.grooveID == 3:
				self['title'].setText("groove - Radio: %s" % str(self.genreName).capitalize())
				songartist = self.grooveresult['ArtistName']
				songartistid = int(self.grooveresult['ArtistID'])
				songname = self.grooveresult['SongName']
				songcover = self.grooveresult['CoverArtUrl']
				songid = int(self.grooveresult['SongID'])
				songtext = "%s - %s" % (songartist, songname)
				self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
				if len(self.songliste) < self.grooveradiocounter:
					self.callback_radio(self.grooveradio)
			elif self.grooveID == 4:
				self['title'].setText("groove - Artistsongs: %s" % self.grooveAdd)
				for songinfo in self.grooveresult:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
					self.songliste.sort(key=lambda t : t[0])
			elif self.grooveID == 5:
				self['title'].setText("groove - Songs: %s" % self.genreName)
				for songinfo in self.grooveresult['result']:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['SongName']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
					self.songliste.sort(key=lambda t : t[0])
			elif self.grooveID == 6 or self.grooveID == 16 or self.grooveID == 19:
				self['title'].setText("groove - Playlist Songs: %s" % self.grooveAdd)
				for songinfo in self.grooveresult['Songs']:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
			elif self.grooveID == 7 or self.grooveID == 107:
				self['title'].setText("groove - AlbumSongs: %s" % self.grooveAdd)
				for songinfo in self.grooveresult:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
			elif self.grooveID == 8:
				self['title'].setText("groove - Collection: %s" % self.grooveAdd)
				for songinfo in self.grooveresult['Songs']:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
			elif self.grooveID == 17:
				self['title'].setText("groove - Favorits: %s" % self.grooveAdd)
				for songinfo in self.grooveresult:
					songartist = songinfo['ArtistName']
					songartistid = int(songinfo['ArtistID'])
					songname = songinfo['Name']
					songcover = "%s%s" % (self.ALBUM_COVER_URL, songinfo['CoverArtFilename'])
					songid = int(songinfo['SongID'])
					songtext = "%s - %s" % (songartist, songname)
					self.songliste.append((songtext.encode("UTF-8"), songid, songcover, songartistid))
			if len(self.songliste) == 0:
				self.songliste.append((_("No songs found!"),'','','0'))
			self.ml.setList(map(self._defaultlistleft, self.songliste))
			self.keyLocked = False
			self['artist'].setText("")
		except AttributeError, e:
			print "####### AttributeError", e

	def openMenu(self):
		self.session.openWithCallback(self.cb_Menu, SimplePlayerMenu, 'extern')

	def cb_Menu(self, data):
		print "cb_Menu:"
		if data != []:
			if data[0] == 2:
				nm = self['liste'].getCurrent()[0][0]
				p = nm.find('-')
				if p > 0:
					scArtist = nm[:p].strip()
					scTitle = nm[p+1:].strip()
				else:
					scArtist = ''
					scTitle = nm
				url = self['liste'].getCurrent()[0][1]
				ltype = 'groove'
				token = ''
				album = ''
				entry = [scTitle, url, scArtist, album, ltype, token, '', '0']
				res = SimplePlaylistIO.addEntry(data[1], entry)
				if res == 1:
					self.session.open(MessageBoxExt, _("Added entry"), MessageBoxExt.TYPE_INFO, timeout=5)
				elif res == 0:
					self.session.open(MessageBoxExt, _("Entry already exists"), MessageBoxExt.TYPE_INFO, timeout=5)
				else:
					self.session.open(MessageBoxExt, _("Error!"), MessageBoxExt.TYPE_INFO, timeout=5)

	def keyAdd(self):
		if self.keyLocked:
			return
		if not self.grooveID == 1:
			grooveName = self['liste'].getCurrent()[0][0]
			grooveID = self['liste'].getCurrent()[0][1]
			grooveCover = self['liste'].getCurrent()[0][2]
			grooveArtistID = self['liste'].getCurrent()[0][3]
			if not fileExists(config.mediaportal.watchlistpath.value+"mp_groove_playlist"):
				open(config.mediaportal.watchlistpath.value+"mp_groove_playlist","w").close()
			if not self.checkPlaylist(grooveName):
				if fileExists(config.mediaportal.watchlistpath.value+"mp_groove_playlist"):
					writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_groove_playlist","a")
					try:
						writePlaylist.write('"%s" "%s" "%s" "%s" "%s"\n' % ("".join([x if ord(x) < 128 else '?' for x in grooveName]), grooveID, grooveCover, grooveArtistID , self.grooveID))
					except UnicodeDecodeError:
						print "UnicodeDecodeError Skipped record"
					writePlaylist.close()
					message = self.session.open(MessageBoxExt, _("added"), MessageBoxExt.TYPE_INFO, timeout=2)
			else:
				message = self.session.open(MessageBoxExt, _("Song already exists."), MessageBoxExt.TYPE_INFO, timeout=2)

	def keyDel(self):
		if self.keyLocked:
			return
		if self.grooveID == 1:
			grooveName = self['liste'].getCurrent()[0][0]
			writeTmp = open(config.mediaportal.watchlistpath.value+"mp_groove_playlist.tmp","w")
			if fileExists(config.mediaportal.watchlistpath.value+"mp_groove_playlist"):
				readPlaylist = open(config.mediaportal.watchlistpath.value+"mp_groove_playlist","r")
				for rawData in readPlaylist.readlines():
					data = re.findall('"(.*?)" "(.*?)" "(.*?)$', rawData, re.S)
					if data:
						(read_name, read_songinfo, read_cover) = data[0]
						if read_name != grooveName:
							writeTmp.write('"%s" "%s" "%s\n' % (read_name, read_songinfo, read_cover))
				readPlaylist.close()
				writeTmp.close()
				shutil.move(config.mediaportal.watchlistpath.value+"mp_groove_playlist.tmp", config.mediaportal.watchlistpath.value+"mp_groove_playlist")
				self.getData()
		else:
			self.keyCancel()

	def checkPlaylist(self, song):
		if not fileExists(config.mediaportal.watchlistpath.value+"mp_groove_playlist"):
			open(config.mediaportal.watchlistpath.value+"mp_groove_playlist","w").close()
			return False
		else:
			leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_groove_playlist")
			if not leer == 0:
				self.dupelist = []
				self.songs_read = open(config.mediaportal.watchlistpath.value+"mp_groove_playlist" , "r")
				for lines in sorted(self.songs_read.readlines()):
					line = re.findall('"(.*?)" "(.*?)" "(.*?)$', lines)
					if line:
						(read_song, read_id, read_cover) = line[0]
						if read_song == song:
							self.dupelist.append((read_song))
				self.songs_read.close()
				if song in self.dupelist:
					return True
				else:
					return False
			else:
				return False

	def keyPlaymode(self):
		if self.playmode == "Next":
			self["playmode"].setText("Random")
			self.playmode = "Random"
		elif self.playmode == "Random":
			self["playmode"].setText("Next")
			self.playmode = "Next"
		self["album"].setText("RemoteSong-Playlist")

	def keyOK(self):
		if self.keyLocked:
			return
		grooveName = self['liste'].getCurrent()[0][0]
		grooveLink = self['liste'].getCurrent()[0][1]
		if re.match('.*?-', grooveName):
			playinfos = grooveName.split(' - ')
			if playinfos:
				if len(playinfos) == 2:
					self["artist"].setText(playinfos[0])
					self["songtitle"].setText(playinfos[1])
			else:
				playinfos = grooveName.split('-')
				if playinfos:
					if len(playinfos) == 2:
						self["artist"].setText(playinfos[0])
						self["songtitle"].setText(playinfos[1])
		else:
			self["artist"].setText(grooveName)
		grooveCover = self['liste'].getCurrent()[0][2]
		if not grooveCover == None:
			if re.match('.*?None$', grooveCover):
				if fileExists(self._no_picPath):
					CoverHelper(self['coverArt']).showCoverFile(str(self._no_picPath))
				else:
					CoverHelper(self['coverArt']).showCoverNone()
			else:
				CoverHelper(self['coverArt']).getCover(str(grooveCover))
		count = self.groovehelper.session.country
		par = {'songID' : grooveLink, 'type':16400, 'prefetch': 'false', 'mobile': 'false', 'country': count}
		getGrooveData(self.groovesession).datarequest(self.callback_OK, self.grooveID, 'getStreamKeyFromSongIDEx', par)

	def keyAction(self):
		if self.keyLocked:
			return
		else:
			groovesong = self['liste'].getCurrent()[0]
			if mp_globals.isDreamOS:
				self.session.openWithCallback(self.actionCallback, grooveActionScreen, groovesong, self.grooveID , 4, self.groovesession, is_dialog=True)
			else:
				self.session.openWithCallback(self.actionCallback, grooveActionScreen, groovesong, self.grooveID , 4, self.groovesession)

	def actionCallback(self, result):
		self.actionresult = result
		if self.actionresult == 3:
			if self.grooveAdd != None:
				self.genreName = "based on %s " % self.grooveAdd
			self.grooveID = 3
			self.seedArtists = {}
			self.grooveradiocounter = len(self.songliste) + 10
			self.callback_radio(self.grooveradio)
		elif self.actionresult == 4:
			self.keyAdd()
		elif self.actionresult == 6:
			self.songliste.pop(self['liste'].getSelectionIndex())
			self.ml.setList(map(self._defaultlistleft, self.songliste))
		elif self.actionresult == 10:
			if self.sortorder == 3:
				self.sortorder = 0
				rather = False
			else:
				self.sortorder = 3
				rather = True
			self.songliste.sort(key=lambda t : t[self.sortorder], reverse=rather)
			self.ml.setList(map(self._defaultlistleft, self.songliste))
		elif self.actionresult == 11:
			self.songliste = dict((x[0], x) for x in self.songliste).values()
			self.songliste.sort(key=lambda t : t[0], reverse=False)
			self.ml.setList(map(self._defaultlistleft, self.songliste))
			pass
		elif self.actionresult == 7:
			nm = self['liste'].getCurrent()[0][0]
			p = nm.find('-')
			if p > 0:
				scArtist = nm[:p].strip()
			else:
				scArtist = nm
			artistID = self['liste'].getCurrent()[0][3]
			self.grooveID = 107
			self.close(scArtist, artistID, self.grooveID)
		elif self.actionresult == 8:
			self.songliste = []
			self.genreName = self['liste'].getCurrent()[0][3]
			self.grooveID = 4
			self['artist'].setText(_("Please wait..."))
			self.getData()
		elif self.actionresult == 20:
			songName = self['liste'].getCurrent()[0][0]
			if len(self.groovehelper.session.mpUserPlaylist) != 0:
				if mp_globals.isDreamOS:
					self.session.openWithCallback(self.addSongtoRemote, grooveActionScreen, songName, self.grooveID , 5, self.groovesession, is_dialog=True)
				else:
					self.session.openWithCallback(self.addSongtoRemote, grooveActionScreen, songName, self.grooveID , 5, self.groovesession)
			else:
				message = self.session.open(MessageBoxExt, _("MPUser have no remote Playlists, please add some remote Playlists first..."), MessageBoxExt.TYPE_INFO, timeout=2)
		elif self.actionresult == 21  or self.actionresult == 211:
			delsongID = self['liste'].getCurrent()[0][1]
			groovemethod = 'overwritePlaylistEx'
			songIDs = []
			for song in self.songliste:
				if delsongID != int(song[1]):
					songIDs.append(int(song[1]))
			grooveparameter = {"playlistID": self.genreName,"songIDs": songIDs}
			getGrooveData(self.groovesession).datarequest(self.delPLSong_callback, 16, groovemethod, grooveparameter)
		elif self.actionresult == 22:
			self.session.openWithCallback(self.newPlayListname_cp, VirtualKeyBoardExt, title = (_("new Playlist - type in new name")), text = "", is_dialog=True)
		elif self.actionresult == 23:
			songName = self['liste'].getCurrent()[0][0]
			if len(self.groovehelper.session.mpUserPlaylist) != 0:
				if mp_globals.isDreamOS:
					self.session.openWithCallback(self.addSongtoRemote, grooveActionScreen, songName, self.grooveID , 5, self.groovesession, is_dialog=True)
				else:
					self.session.openWithCallback(self.addSongtoRemote, grooveActionScreen, songName, self.grooveID , 5, self.groovesession)
			else:
				message = self.session.open(MessageBoxExt, _("MPUser have no remote Playlists, please add some remote Playlists first..."), MessageBoxExt.TYPE_INFO, timeout=2)

	def newPlayListname_cp(self, callbackStr):
		if callbackStr is not None:
			print callbackStr
			self.playlistName = callbackStr
			groovemethod = 'createPlaylistEx'
			grooveparameter = {"playlistName" : callbackStr ,"songIDs" : [], "playlistAbout" : ""}
			getGrooveData(self.groovesession).datarequest(self.newPLCallback, self.grooveID, groovemethod, grooveparameter)

	def newPLCallback(self, result):
		if result >= 1:
			message = self.session.open(MessageBoxExt, _("new remote Playlist is generated"), MessageBoxExt.TYPE_INFO, timeout=2)
			playlistid = result
			self.groovehelper.session.mpUserPlaylist.append((self.playlistName.encode("UTF-8"), str(playlistid)))
		else:
			message = self.session.open(MessageBoxExt, _("ERROR, no new remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)

	def addSongtoRemote(self,result):
		songID = self['liste'].getCurrent()[0][1]
		groovemethod = 'playlistAddSongToExistingEx'
		grooveparameter = {"playlistID":int(result),"songID":songID}
		getGrooveData(self.groovesession).datarequest(self.addPLSong_callback, 16, groovemethod, grooveparameter)

	def delPLSong_callback(self, result):
		if result == 1:
			if self.actionresult == 211:
				message = self.session.open(MessageBoxExt, _("Song is moved to other remote Playlist"), MessageBoxExt.TYPE_INFO, timeout=5)
			else:
				message = self.session.open(MessageBoxExt, _("Song is removed from remote Playlist"), MessageBoxExt.TYPE_INFO, timeout=5)
		else:
			message = self.session.open(MessageBoxExt, _("ERROR,removing Song from remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)
		self.songliste = []
		self.getData()

	def addPLSong_callback(self, result):
		if result == 1:
			if self.actionresult == 23:
				self.actionCallback(211)
			else:
				message = self.session.open(MessageBoxExt, _("Song added to remote Playlist"), MessageBoxExt.TYPE_INFO, timeout=2)
		else:
			message = self.session.open(MessageBoxExt, _("ERROR, add Song to remote Playlist FAILED"), MessageBoxExt.TYPE_INFO, timeout=5)

	def callback_OK(self, result):
		print result
		try:
			stream_url = 'http://%s/stream.php?streamKey=%s' % (result["ip"],result['streamKey'])
			if stream_url:
				print stream_url
				sref = eServiceReference(0x1001, 0, str(stream_url))
				sref.setName(self['liste'].getCurrent()[0][0])
				self.session.nav.playService(sref)
				self.playing = True
		except TypeError, ex:
			text = "%s : %s" % (ex,result)
			message = self.session.open(MessageBoxExt, _("ERROR Playing Song: %s") % text, MessageBoxExt.TYPE_INFO, timeout=5)

	def openMediainfo(self):
		if MediainfoPresent:
			url = self.session.nav.getCurrentlyPlayingServiceReference().getPath()
			if url[:4] == "http":
				self.session.open(mediaInfo, True)

	def doEofInternal(self, playing):
		print "Play Next Song.."
		if self.playmode == "Next":
			len(self.songliste)-1
			self['liste'].down()
		else:
			count = len(self.songliste)-1
			get_random = random.randint(0, int(count))
			self['liste'].moveToIndex(get_random)

		self.keyOK()
		if self.grooveID == 3:
			if self['liste'].getSelectedIndex() == len(self.songliste)-1:
				self.grooveradiocounter = len(self.songliste) + 10
				self.callback_radio(self.grooveradio)

	def keyUp(self):
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDown(self):
		if self.keyLocked:
			return
		self['liste'].down()
		if self.grooveID == 3:
			if self['liste'].getSelectedIndex() == len(self.songliste)-1:
				self.grooveradiocounter = len(self.songliste) + 10
				self.callback_radio(self.grooveradio)

	def keyLeft(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRight(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def lockShow(self):
		pass

	def unlockShow(self):
		pass

	def seekFwd(self):
		self['liste'].pageDown()

	def seekBack(self):
		self['liste'].pageUp()

	def stopPlay(self):
		self.session.nav.stopService()
		self.playing = False

	def keyCancel(self):
		self.close()

class grooveActionScreen(MPScreen):

	def __init__(self, session, song, grooveID, grooveScreen, groovesession):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/ActionScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/ActionScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)
		self['title'] = Label("Grooveshark " + _("Actions"))
		self.setTitle("Grooveshark " + _("Actions"))

		self.song = song
		self.groovehelper = getGrooveData(groovesession)

		self['interspace'] = Label("------------------------------------------------------------------")
		self.list = []
		songtxt="Artist - Song: %s" % self.song[0]
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		if grooveScreen == 2:
			self['name'] = Label(_("Current Playlist selection: %s" % str(self.song[0])))
			if grooveID == 4:
				self.list.append((_("new search for Albums current Artist"), 7))
			elif grooveID == 6:
				self.list.append((_("search user"), 8))
			elif grooveID == 8:
				self.list.append((_("show users playlists"), 9))
			self.list.append((_("change sort sequence ( Name vs Rating )"), 10))
			if self.groovehelper.session.groove_userid != -1:
				if grooveID == 6 or grooveID == 16:
					self.list.append((_("add Playlist to MPUser subscribed Playlists"), 25))
				if grooveID == 16:
					self.list.append((_("add new Playlist in remote MPUser profile"), 22))
					self.list.append((_("delete selected Playlist in remote MPUser profile"), 23))
				if grooveID == 19:
					self.list.append((_("delete selected subscribed Playlist in remote MPUser profile"), 24))
			else:
				self.list.append(("-------------------------------------", 0))
				self.list.append((_("more options if your are logged in..."), 0))
		elif grooveScreen == 4:
			self['name'] = Label(_("Current Song selection: %s" % str(self.song[0])))
			if not (grooveID == 1 or grooveID == 2 or grooveID == 3 or grooveID == 21):
				self.list.append((_("play Radio based on current Playlist"), 3))
			self.list.append((_("new search for Albums current Artist"), 7))
			self.list.append((_("new search for Songs current Artist"), 8))
			if grooveID != 1:
				self.list.append((_("add current Selection to local Playlist"), 4))
				self.list.append((_("remove current Selection from list"), 6))
			self.list.append((_("remove duplicates from current list"), 11))
			if self.groovehelper.session.groove_userid != -1:
				self.list.append((_("add current Selection to remote MPUser Playlist"), 20))
				self.list.append((_("add new Playlist in remote MPUser profile"), 22))
				if grooveID == 6 or grooveID == 16:
					self.list.append((_("move current Selection to other remote MPUser Playlist"), 23))
					self.list.append((_("remove current Selection from current MPUser Playlist"), 21))
			else:
				self.list.append(("-------------------------------------", 0))
				self.list.append((_("more options if your are logged in..."), 0))
		elif grooveScreen == 5:
			self['name'] = Label(_("Add Song selection: %s to Playlist?" % str(self.song)))
			self.list = self.groovehelper.session.mpUserPlaylist

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok":		self.okAction,
			"cancel":	self.exit
		}, -1)

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.ml.setList(map(self._defaultlistcenter, self.list))
		self['liste'].moveToIndex(0)

	def okAction(self):
		selected = self['liste'].getCurrent()[0][1]
		print "OK", selected
		self.close(selected)

	def exit(self):
		self.close(0)