﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

class movie25GenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("movie25.so")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.genreliste = [ ('New Releases',"http://www.movie25.so/movies/new-releases/"),
		                    ('Last Added',"http://www.movie25.so/movies/latest-added/"),
		                    ('Featured Movies',"http://www.movie25.so/movies/featured-movies/"),
		                    ('Latest HQ Movies',"http://www.movie25.so/movies/latest-hd-movies/"),
		                    ('Most Viewed',"http://www.movie25.so/movies/most-viewed/"),
		                    ('Most Voted',"http://www.movie25.so/movies/most-voted/"),
                            ('Action',"http://www.movie25.so/movies/action/"),
                            ('Adventure',"http://www.movie25.so/movies/adventure/"),
                            ('Animation',"http://www.movie25.so/movies/animation/"),
                            ('Biography',"http://www.movie25.so/movies/biography/"),
                            ('Comedy',"http://www.movie25.so/movies/comedy/"),
                            ('Crime',"http://www.movie25.so/movies/crime/"),
                            ('Documentary',"http://www.movie25.so/movies/documentary/"),
                            ('Drama',"http://www.movie25.so/movies/drama/"),
                            ('Family',"http://www.movie25.so/movies/family/"),
                            ('History',"http://www.movie25.so/movies/history/"),
                            ('Horror',"http://www.movie25.so/movies/horror/"),
                            ('Music',"http://www.movie25.so/movies/music/"),
                            ('Musical',"http://www.movie25.so/movies/musical/"),
                            ('Mystery',"http://www.movie25.so/movies/mystery/"),
                            ('Romance',"http://www.movie25.so/movies/romance/"),
                            ('Sci-Fi',"http://www.movie25.so/movies/sci-fi/"),
                            ('Short',"http://www.movie25.so/movies/short/"),
                            ('Sport',"http://www.movie25.so/movies/sport/"),
                            ('Thriller',"http://www.movie25.so/movies/thriller/"),
                            ('War',"http://www.movie25.so/movies/war/"),
                            ('Western',"http://www.movie25.so/movies/western/"),
                            ('Movie Title 0-9',"http://www.movie25.so/movies/0-9/"),
                            ('Movie Title A',"http://www.movie25.so/movies/a/"),
                            ('Movie Title B',"http://www.movie25.so/movies/b/"),
                            ('Movie Title C',"http://www.movie25.so/movies/c/"),
                            ('Movie Title D',"http://www.movie25.so/movies/d/"),
                            ('Movie Title E',"http://www.movie25.so/movies/e/"),
                            ('Movie Title F',"http://www.movie25.so/movies/f/"),
                            ('Movie Title G',"http://www.movie25.so/movies/g/"),
                            ('Movie Title H',"http://www.movie25.so/movies/h/"),
                            ('Movie Title I',"http://www.movie25.so/movies/i/"),
                            ('Movie Title J',"http://www.movie25.so/movies/j/"),
                            ('Movie Title K',"http://www.movie25.so/movies/k/"),
                            ('Movie Title L',"http://www.movie25.so/movies/l/"),
                            ('Movie Title M',"http://www.movie25.so/movies/m/"),
                            ('Movie Title N',"http://www.movie25.so/movies/n/"),
                            ('Movie Title O',"http://www.movie25.so/movies/o/"),
                            ('Movie Title P',"http://www.movie25.so/movies/p/"),
                            ('Movie Title Q',"http://www.movie25.so/movies/q/"),
                            ('Movie Title R',"http://www.movie25.so/movies/r/"),
                            ('Movie Title S',"http://www.movie25.so/movies/s/"),
                            ('Movie Title T',"http://www.movie25.so/movies/t/"),
                            ('Movie Title U',"http://www.movie25.so/movies/u/"),
                            ('Movie Title V',"http://www.movie25.so/movies/v/"),
                            ('Movie Title W',"http://www.movie25.so/movies/w/"),
                            ('Movie Title X',"http://www.movie25.so/movies/x/"),
                            ('Movie Title Y',"http://www.movie25.so/movies/y/"),
                            ('Movie Title Z',"http://www.movie25.so/movies/z/"),]

		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		streamGenreName = self['liste'].getCurrent()[0][0]
		streamGenreLink = self['liste'].getCurrent()[0][1]
		print streamGenreName, streamGenreLink

		self.session.open(movie25FilmeListeScreen, streamGenreLink, streamGenreName)

class movie25FilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("movie25.so")
		self['ContentTitle'] = Label("%s:" % self.streamGenreName)


		self.keyLocked = True
		self.page = 1
		self.lastpage = 999
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['Page'].setText(str(self.page)+ " of")
		url = "%s%s" % (self.streamGenreLink, str(self.page))
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		lastpage = re.findall('<div class="count_text">.*?\d/(.*\d)&nbsp', data, re.S)
		if lastpage:
			self.lastpage = lastpage[0]
			self['page'].setText(lastpage[0])
		else:
			self.lastpage = 999

		data=data.replace('\r','').replace('\n','').replace('\t','').replace('&nbsp;','')
		movies = re.findall('        <li><div class="movie_pic"><a href="(.+?)"  target.+?img src="(.+?)".+?target="_self" title="(.+?)"', data, re.S)
		movies += re.findall('</li>      <li><div class="movie_pic"><a href="(.+?)"  target.+?img src="(.+?)".+?target="_self" title="(.+?)"', data, re.S)
		if movies:
			self.filmliste = []
			for (link,image,title) in movies:
				link = "http://www.movie25.so" + link
				self.filmliste.append((decodeHtml(title),link,image))
			self.ml.setList(map(self._defaultlistleft, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, self.lastpage)
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		self.session.open(movie25StreamListeScreen, streamLink, streamName)

class movie25StreamListeScreen(MPScreen):

	def __init__(self, session, streamGenreLink, streamGenreName):
		self.streamGenreLink = streamGenreLink
		self.streamGenreName = streamGenreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("movie25.so")
		self['ContentTitle'] = Label("Streams for %s:" % self.streamGenreName)


		self.keyLocked = True
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print self.streamGenreLink
		getPage(self.streamGenreLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		streams = re.findall('<li class="link_name">(.*?)</li>.*?<li class="playing_button"><a href="(.*?)" target', data, re.S)
		print " streams =", streams
		if streams:
			self.filmliste = []
			for (name,link) in streams:
				link = "http://www.movie25.so" + link
				name=name.replace('\r','').replace('\n','').replace('\t','').replace('&nbsp;','')
				if isSupportedHoster(name, True):
					self.filmliste.append((decodeHtml(name.strip()),link))
			if len(self.filmliste) == 0:
				self.filmliste.append((_('No supported streams found!'), None))
			self.ml.setList(map(self._defaultlisthoster, self.filmliste))
			self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamLink = self['liste'].getCurrent()[0][1]
		if streamLink == None:
			return
		print "streamName, streamLink B=", streamName, streamLink
		getPage(streamLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getLink).addErrback(self.dataError)

	def getLink(self, data):
		link = re.findall("type=\"button\" onclick=\"location.href='(http://.*?)'", data, re.S)
		print "link =", link
		if link:
			print link[0]
			get_stream_link(self.session).check_link(link[0], self.got_link, False)
		else:
			message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=3)

	def got_link(self, stream_url):
		if stream_url == None:
			message = self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			self.session.open(SimplePlayer, [(self.streamGenreName, stream_url)], showPlaylist=False, ltype='movie25')