﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def dreamscreencastListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]
class dreamscreencast(MPScreen, ThumbsHelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Dreamscreencast.com")
		self['ContentTitle'] = Label("Videos:")


		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		url = "http://dreamscreencast.com/category/episode/feed/"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		videos = re.findall('<item>.*?<title>(.*?)</title>.*?<link>(.*?)</link>.*?<enclosure\surl="(.*?)"\slength.*?<itunes:summary>(.*?)</itunes:summary>', data, re.S)
		if videos:
			for (title,url,stream,handlung) in videos:
				handlung = handlung.replace("(adsbygoogle = window.adsbygoogle || []).push({});","").strip()
				self.streamList.append((decodeHtml(title),url,handlung,stream))
			self.streamMenuList.setList(map(dreamscreencastListEntry, self.streamList))
			self.keyLocked = False
			self.th_ThumbsQuery(self.streamList, 0, 1, None, None, 'class="post-thumb">.*?src="(.*?)"', 1, 1, mode=1)
			self.showInfos()

	def showInfos(self):
		self.name = self['liste'].getCurrent()[0][0]
		handlung = self['liste'].getCurrent()[0][2]
		url = self['liste'].getCurrent()[0][1]
		self['handlung'].setText(decodeHtml(handlung))
		self['name'].setText(self.name)
		if url:
			getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getImage).addErrback(self.dataError)

	def getImage(self, data):
		image = re.findall('class="post-thumb">.*?src="(.*?)"', data, re.S)
		streamPic = image[0]
		CoverHelper(self['coverArt']).getCover(streamPic)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream = self['liste'].getCurrent()[0][3]
		if stream:
			self.session.open(SimplePlayer, [(self.name, stream)], showPlaylist=False, ltype='dreamscreencast')