﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def sunpornoGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def sunpornoFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class sunpornoGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("SunPorno.com")
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		url = "http://www.sunporno.com/channels"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = re.findall('class="category">.*?img\sclass="thumb"\ssrc="(.*?)".*?class="title"><span>(.*?)</span>.*?class="count"><span>(.*?)</span>.*?href=".*?channels/(.*?)/', data, re.S)
		if Cats:
			for (Image, Title, Count, Id) in Cats:
				Url = "http://www.sunporno.com/?area=movieAjaxListViewer&nicheId=%s&dateAddedType=5&lengthType=0-50&orderBy=id&pageId=" % Id
				self.genreliste.append((Title, Url, Image, Count))
			self.genreliste.sort()
			self.genreliste.insert(0, ("High Definition", "http://www.sunporno.com/?area=movieAjaxListViewer&dateAddedType=5&lengthType=0-50&orderBy=hd&pageId=", None, 1799))
			self.genreliste.insert(0, ("Longest", "http://www.sunporno.com/?area=movieAjaxListViewer&dateAddedType=5&lengthType=0-50&orderBy=longest&pageId=", None, 1799))
			self.genreliste.insert(0, ("Most Favorited", "http://www.sunporno.com/?area=movieAjaxListViewer&dateAddedType=5&lengthType=0-50&orderBy=favorited&pageId=", None, 1799))
			self.genreliste.insert(0, ("Top Rated", "http://www.sunporno.com/?area=movieAjaxListViewer&dateAddedType=5&lengthType=0-50&orderBy=rating&pageId=", None, 1799))
			self.genreliste.insert(0, ("Newest", "http://www.sunporno.com/?area=movieAjaxListViewer&dateAddedType=5&lengthType=0-50&orderBy=id&pageId=", None, 1799))
			self.genreliste.insert(0, ("--- Search ---", "callSuchen", None, 1799))
			self.chooseMenuList.setList(map(sunpornoGenreListEntry, self.genreliste))
			self.chooseMenuList.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()
		self['name'].setText('')

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()

		else:
			Link = self['liste'].getCurrent()[0][1]
			Count = self['liste'].getCurrent()[0][3]
			self.session.open(sunpornoFilmScreen, Link, Name, Count)

	def SuchenCallback(self, callback = None, entry = None):
		if callback is not None and len(callback):
			self.suchString = callback.replace(' ', '+')
			Name = "--- Search ---"
			Link = '%s' % (self.suchString)
			Count = self['liste'].getCurrent()[0][3]
			self.session.open(sunpornoFilmScreen, Link, Name, Count)

class sunpornoFilmScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name, Count):
		self.Link = Link
		self.Name = Name
		self.Count = Count
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("SunPorno.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self.filmliste = []
		if re.match(".*?Search", self.Name):
			url = "http://www.sunporno.com/?area=movieAjaxListViewer&q=%s&dateAddedType=5&lengthType=0-50&orderBy=relevance&pageId=%s" % (self.Link, str(self.page))
		else:
			url = "%s%s" % (self.Link, str(self.page))
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.lastpage = int(round((float(self.Count) / 36) + 0.5))
		self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		Movies = re.findall('id":(.*?),"thumb":"(.*?)",.*?duration":"(.*?)",', data, re.S)
		if Movies:
			for (Id, Image, Runtime) in Movies:
				Title = "Video %s" % Id
				Url = "http://www.sunporno.com/videos/%s/" % Id
				self.filmliste.append((decodeHtml(Title), Url, Image, Runtime))
		if len(self.filmliste) == 0:
			self.filmliste.append((_('No videos found!'), '', None, ''))
		self.chooseMenuList.setList(map(sunpornoFilmListEntry, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, self.lastpage, mode=1)
		self.showInfos()

	def showInfos(self):
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['handlung'].setText("Runtime: %s" % (runtime))
		CoverHelper(self['coverArt']).getCover(pic)
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self, data):
		parse = re.findall('itemprop="name">(.*?)</span>', data, re.S|re.I)
		if parse:
			title = decodeHtml(parse[0])
		else:
			title = self['liste'].getCurrent()[0][0]
		self['name'].setText(title)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		self.keyLocked = True
		getPage(Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		parse = re.findall('itemprop="name">(.*?)</span>', data, re.S|re.I)
		title = decodeHtml(parse[0])
		if parse:
			title = decodeHtml(parse[0])
		else:
			title = self['liste'].getCurrent()[0][0]
		video = re.findall('source\ssrc="(.*?)"', data, re.S)
		if video:
			self.keyLocked = False
			self.session.open(SimplePlayer, [(title, video[0])], showPlaylist=False, ltype='sunporno')