﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def kikaListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 720, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
		(eListboxPythonMultiContent.TYPE_TEXT, 740, 0, 120, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1])
		]

class kikaGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("KIKA+")
		self['ContentTitle'] = Label("Sendungen von A-Z")

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		url = "http://www.kikaplus.net/clients/kika/kikaplus"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		kiVideos = re.findall('<a href="(\?programm=.*?)" title="(.*?)" class="overlay_link" >(.*?)</a><br />', data, re.S)
		if kiVideos:
			self.genreliste = []
			for (url,count_videos,title) in kiVideos:
				url = "http://kikaplus.net/clients/kika/kikaplus/index.php%s" % url.replace('&amp;','&')
				self.genreliste.append((title,count_videos,url))
			self.chooseMenuList.setList(map(kikaListEntry, self.genreliste))
			self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		kikaurl = self['liste'].getCurrent()[0][2]
		self.session.open(kikaFilmListeScreen, kikaurl)

class kikaFilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreLink):
		self.genreLink = genreLink
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.keyLocked = True
		self['title'] = Label("KIKA+")
		self['ContentTitle'] = Label("Folgen:")


		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		getPage(self.genreLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		kiVideos = re.findall('href="(\?id=.*?programm=.*?)".*?<img alt="" src="..(.*?)".*?</label><br />(.*?)<br /><br />Sendedatum: (.*?)<br />', data, re.S)
		if kiVideos:
			self.filmliste = []
			for (url,image,title,datum) in kiVideos:
				url = "http://kikaplus.net/clients/kika/kikaplus/index.php%s" % url.replace('&amp;','&')
				image = "http://kikaplus.net/clients/kika%s" % image
				self.filmliste.append((title,datum,url,image))
			self.chooseMenuList.setList(map(kikaListEntry, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 2, 3, None, None, 1, 1, mode=1)
			self.showInfos()

	def showInfos(self):
		kikaurl = self['liste'].getCurrent()[0][2]
		getPage(kikaurl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self,data):
		kiVideos = re.findall('"Startbild":"(.*?)".*?serverTime=.*?<br /><br />(.*?)<span', data, re.S)
		if kiVideos:
			for (streamPic,handlung) in kiVideos:
				handlung = decodeHtml(handlung)
				streamPic = streamPic.replace(" ","%20")
			self['handlung'].setText(handlung)
			CoverHelper(self['coverArt']).getCover(streamPic)
		self['name'].setText(self['liste'].getCurrent()[0][0])

	def keyOK(self):
		if self.keyLocked:
			return
		self.streamName = self['liste'].getCurrent()[0][0]
		kikaurl = self['liste'].getCurrent()[0][2]
		getPage(kikaurl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		stream = re.findall('so.addVariable\("fullscreenPfad", "(rtmp://.*?)"', data, re.S)
		if stream:
			print stream
			self.session.open(SimplePlayer, [(self.streamName, stream[0])], showPlaylist=False, ltype='kika')