﻿# -*- coding: utf-8 -*-

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer
from Plugins.Extensions.MediaPortal.resources.menuhelper import MenuHelper

DOKUH_Version = "DOKUh.de v1.01"

DOKUH_siteEncoding = 'utf-8'

"""
Sondertastenbelegung:

Genre Auswahl:
	KeyCancel	: Menu Up / Exit
	KeyOK		: Menu Down / Select

Doku Auswahl:
	Bouquet +/-,		: Seitenweise blättern in 1er Schritten Up/Down
	Rot/Blau			: Die Beschreibung Seitenweise scrollen
	'1', '4', '7',
	'3', 6', '9'		: blättern in 2er, 5er, 10er Schritten Down/Up

Stream Auswahl:
	Rot/Blau			: Die Beschreibung Seitenweise scrollen

"""
def DOKUHmenuListentry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class showDOKUHGenre(MenuHelper):

	def __init__(self, session):

		mainGenre = [
			("NEUESTE DOKUS", ""),
			("BELIEBTESTE DOKUS", ""),
			("MEISTGESEHENE DOKUS", "")
			]

		MenuHelper.__init__(self, session, 2, [mainGenre, [None,None,None], [None,None,None]], "http://dokuh.de", "/doku-online-stream/kategorien", DOKUHmenuListentry)

		self['title'] = Label(DOKUH_Version)
		self['ContentTitle'] = Label("Genres")

		self.onLayoutFinish.append(self.mh_initMenu)

	def mh_parseData(self, data):
		print 'parseData:'
		entrys=re.findall('<li id="menu-item.*?<a href="http://dokuh.de/doku-online-stream/kategorien(.*?)/">(.*?)</a>', data)
		return entrys

	def mh_callGenreListScreen(self):
		genreurl = self.mh_baseUrl+self.mh_genreBase+self.mh_genreUrl[0]+self.mh_genreUrl[1]+self.mh_genreUrl[2]
		print genreurl
		self.session.open(DOKUHFilmListeScreen, genreurl, self.mh_genreTitle)

def DOKUHFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]
class DOKUHFilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreLink, genreName):
		self.genreLink = genreLink
		self.genreName = genreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/dokuListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/dokuListScreen.xml"
		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions","DirectionActions"], {
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"1" : self.key_1,
			"3" : self.key_3,
			"4" : self.key_4,
			"6" : self.key_6,
			"7" : self.key_7,
			"9" : self.key_9,
			"0"	: self.closeAll,
			"blue" :  self.keyTxtPageDown,
			"red" :  self.keyTxtPageUp
		}, -1)

		self.sortOrder = 0
		self.baseUrl = "http://dokuh.de"
		self.genreTitle = ""
		self.sortParIMDB = ""
		self.sortParAZ = "?orderby=title"
		self.sortOrderStrAZ = ""
		self.sortOrderStrIMDB = ""
		self.sortOrderStrGenre = ""
		self['title'] = Label(DOKUH_Version)

		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))
		self['Page'] = Label(_("Page:"))

		self.timerStart = False
		self.seekTimerRun = False
		self.filmQ = Queue.Queue(0)
		self.hanQ = Queue.Queue(0)
		self.picQ = Queue.Queue(0)
		self.updateP = 0
		self.eventL = threading.Event()
		self.eventP = threading.Event()
		self.keyLocked = True
		self.dokusListe = []
		self.keckse = CookieJar()
		self.page = 0
		self.pages = 0;
		self.genreNEUESTE = re.match(".*?NEUESTE DOKUS",self.genreName)
		self.genreBELIEBTESTE = re.match(".*?BELIEBTESTE DOKUS",self.genreName)
		self.genreMEISTGESEHEN = re.match(".*?MEISTGESEHENE DOKUS",self.genreName)
		#self.genreBELIEBTESTE = False
		#self.genreMEISTGESEHEN = False
		self.genreSpecial = self.genreNEUESTE or self.genreBELIEBTESTE or self.genreMEISTGESEHEN

		self.setGenreStrTitle()

		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def setGenreStrTitle(self):
		genreName = "%s%s" % (self.genreTitle,self.genreName)
		#print genreName
		self['ContentTitle'].setText(genreName)

	def loadPage(self):
		print "loadPage:"
		if not self.genreSpecial:
			url = "%s/page/%d/%s" % (self.genreLink, self.page, self.sortParAZ)
		else:
			url = self.baseUrl
		if self.page:
			self['page'].setText("%d / %d" % (self.page,self.pages))
		self.filmQ.put(url)
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()
		print "eventL ",self.eventL.is_set()

	def loadPageQueued(self):
		print "loadPageQueued:"
		self['name'].setText(_('Please wait...'))
		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		#self.eventL.clear()
		print url
		twAgentGetPage(url, cookieJar=self.keckse, agent=None, headers=std_headers).addCallback(self.loadPageData).addErrback(self.dataError)

	def dataError(self, error):
		self.eventL.clear()
		print "dataError:"
		printl(error,self,"E")
		self.dokusListe.append((_("No dokus found!"),"","",""))
		self.chooseMenuList.setList(map(DOKUHFilmListEntry, self.dokusListe))

	def loadPageData(self, data):
		print "loadPageData:"
		if self.genreNEUESTE:
			print "Neueste Dokus suche..."
			m=re.search('class="name">neueste Dokus<(.*?)<!-- end .section-box -->',data,re.S)
		elif self.genreBELIEBTESTE:
			print "Beliebteste Dokus suche..."
			m=re.search('class="name">beliebteste Dokus<(.*?)<!-- end .section-box -->',data,re.S)
		elif self.genreMEISTGESEHEN:
			print "Meistgesehene Dokus suche..."
			m=re.search('class="name">meistgesehene Dokus<(.*?)<!-- end .section-box -->',data,re.S)
		else:
			print "Normal search.."
			m=re.search('<div class="loop-content.*?class="thumb">(.*)<!-- end .loop-content -->',data,re.S)
		if m:
			dokus = re.findall('class="clip-link".*?title="(.*?)" href="(.*?)".*?<img src="(.*?)".*?class="desc">(.*?)</p>', m.group(1), re.S)
		else:
			dokus = None
		if dokus:
			print "Dokus found !"
			if not self.pages:
				m = re.findall('class=\'pages\'>Seite.*?von (.*?)</', data)
				if m:
					self.pages = int(m[0])
				else:
					self.pages = 1
				self.page = 1
				print "Page: %d / %d" % (self.page,self.pages)
				self['page'].setText("%d / %d" % (self.page,self.pages))
			self.dokusListe = []
			for	(name,url,img,desc) in dokus:
				#print	"Url: ", url, "Name: ", name
				self.dokusListe.append((decodeHtml(name), url, img, desc))
			self.chooseMenuList.setList(map(DOKUHFilmListEntry, self.dokusListe))
			self.th_ThumbsQuery(self.dokusListe, 0, 1, 2, None, None, self.page, self.pages, mode=1)
			self.loadPicQueued()
		else:
			print "No dokus found!"
			self.dokusListe.append((_("No dokus found!"),"","",""))
			self.chooseMenuList.setList(map(DOKUHFilmListEntry, self.dokusListe))
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()

	def loadPic(self):
		print "loadPic:"

		if self.picQ.empty():
			self.eventP.clear()
			print "picQ is empty"
			return
		if self.updateP:
			print "Pict. or descr. update in progress"
			print "eventP: ",self.eventP.is_set()
			print "updateP: ",self.updateP
			return
		while not self.picQ.empty():
			self.picQ.get_nowait()

		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		#streamUrl = self.baseUrl+re.sub('amp;','',self['liste'].getCurrent()[0][1])
		desc = self['liste'].getCurrent()[0][3]
		#print "streamName: ",streamName
		#print "streamPic: ",streamPic
		#print "streamUrl: ",streamUrl
		self.getHandlung(desc)
		self.updateP = 1
		CoverHelper(self['coverArt'], self.ShowCoverFileExit).getCover(streamPic)

	def getHandlung(self, desc):
		print "getHandlung:"
		if desc == None:
			print "No Infos found !"
			self['handlung'].setText(_("No information found."))
			return
		self.setHandlung(desc)

	def setHandlung(self, data):
		print "setHandlung:"
		self['handlung'].setText(decodeHtml(data))

	def ShowCoverFileExit(self):
		print "showCoverFileExit:"
		self.updateP = 0;
		self.keyLocked	= False
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def loadPicQueued(self):
		print "loadPicQueued:"
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
			self.loadPic()
		print "eventP: ",self.eventP.is_set()

	def keyOK(self):
		if (self.keyLocked|self.eventL.is_set()):
			return
		streamLink = self['liste'].getCurrent()[0][1]
		streamName = self['liste'].getCurrent()[0][0]
		print "Open DOKUHStreams:"
		print "Name: ",streamName
		print "Link: ",streamLink
		self.session.open(DOKUHStreams, streamLink, streamName)

	def keyUpRepeated(self):
		#print "keyUpRepeated"
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDownRepeated(self):
		#print "keyDownRepeated"
		if self.keyLocked:
			return
		self['liste'].down()

	def key_repeatedUp(self):
		#print "key_repeatedUp"
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyLeftRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def keyPageDown(self):
		#print "keyPageDown()"
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageDownFast(1)

	def keyPageUp(self):
		#print "keyPageUp()"
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageUpFast(1)

	def keyPageUpFast(self,step):
		if self.keyLocked:
			return
		#print "keyPageUpFast: ",step
		oldpage = self.page
		if (self.page + step) <= self.pages:
			self.page += step
		else:
			self.page = 1
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def keyPageDownFast(self,step):
		if self.keyLocked:
			return
		print "keyPageDownFast: ",step
		oldpage = self.page
		if (self.page - step) >= 1:
			self.page -= step
		else:
			self.page = self.pages
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def key_1(self):
		#print "keyPageDownFast(2)"
		self.keyPageDownFast(2)

	def key_4(self):
		#print "keyPageDownFast(5)"
		self.keyPageDownFast(5)

	def key_7(self):
		#print "keyPageDownFast(10)"
		self.keyPageDownFast(10)

	def key_3(self):
		#print "keyPageUpFast(2)"
		self.keyPageUpFast(2)

	def key_6(self):
		#print "keyPageUpFast(5)"
		self.keyPageUpFast(5)

	def key_9(self):
		#print "keyPageUpFast(10)"
		self.keyPageUpFast(10)

def DOKUHStreamListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]+entry[3])
		]
class DOKUHStreams(MPScreen, ConfigListScreen, ThumbsHelper):

	def __init__(self, session, dokuUrl, dokuName):
		self.dokuUrl = dokuUrl
		self.dokuName = dokuName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/dokuListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/dokuListScreen.xml"
		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "EPGSelectActions", "WizardActions", "ColorActions", "NumberActions", "MenuActions", "MoviePlayerActions", "InfobarSeekActions"], {
			"ok"    	: self.keyOK,
			"cancel"	: self.keyCancel,
			"5" : self.keyShowThumb,
			"up" 		: self.keyUp,
			"down" 		: self.keyDown,
			"right" 	: self.keyPageDown,
			"left" 		: self.keyPageUp,
			"yellow"	: self.keyYellow,
			"red" 		: self.keyTxtPageUp,
			"0"			: self.closeAll,
			"blue" 		: self.keyTxtPageDown
		}, -1)

		self['title'] = Label(DOKUH_Version)
		self['ContentTitle'] = Label("Streams für "+dokuName)

		self['name'] = Label(dokuName)
		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))
		self['VideoPrio'] = Label("VidPrio")

		self.videoPrio = int(config.mediaportal.youtubeprio.value)
		self.videoPrioS = ['L','M','H']
		self.setVideoPrio()
		self.streamListe = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print "loadPage:"
		streamUrl = self.dokuUrl
		#print "FilmUrl: %s" % self.dokuUrl
		#print "FilmName: %s" % self.dokuName
		twAgentGetPage(streamUrl).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		print "parseData:"
		streams = re.findall('class="related-item".*?loadVideo\(\'(.*?)\'\).*?<img src="(.*?)".*?"duration">'\
					'(.*?)<.*?"title">\s*?(.*?)\s*?</span>.*?<p>(.*?)</p>', data, re.S)
		self.streamListe = []
		if streams:
			print "Streams found"
			for (videoTag,imgUrl,duration,title,desc) in streams:
				self.streamListe.append((title.lstrip().rstrip(),videoTag,imgUrl," ["+duration+"]",desc))
		else:
			m = re.search('www.youtube.com/embed/(.*?)\?', data)
			if m:
				v = m.group(1)
				self.streamListe.append((self.dokuName,v,None,"",None))
		if len(self.streamListe) > 0:
			self.streamMenuList.setList(map(DOKUHStreamListEntry, self.streamListe))
			self.keyLocked	= False
		else:
			print "No dokus found!"
			self.streamListe.append(("No streams found!","","","",""))
			self.streamMenuList.setList(map(DOKUHStreamListEntry, self.streamListe))
		self.th_ThumbsQuery(self.streamListe,0,1,2,None,None,1,1)
		self.showInfos()

	def getHandlung(self, desc):
		print "getHandlung:"
		if desc == None:
			print "No Infos found !"
			self['handlung'].setText(_("No information found."))
			return
		self.setHandlung(desc)

	def setHandlung(self, data):
		print "setHandlung:"
		self['handlung'].setText(decodeHtml(data))

	def showInfos(self):
		print "showInfos:"
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		desc = self['liste'].getCurrent()[0][4]
		print "streamName: ",streamName
		print "streamPic: ",streamPic
		self.getHandlung(desc)
		CoverHelper(self['coverArt']).getCover(streamPic)

	def dataError(self, error):
		print "dataError:"
		printl(error,self,"E")
		self.streamListe.append((_("Read error!"),"","","",""))
		self.streamMenuList.setList(map(DOKUHStreamListEntry, self.streamListe))

	def setVideoPrio(self):
		self.videoPrio = int(config.mediaportal.youtubeprio.value)
		self['vPrio'].setText(self.videoPrioS[self.videoPrio])

	def keyOK(self):
		print "keyOK:"
		if self.keyLocked:
			return
		dhTitle = self['liste'].getCurrent()[0][0]
		dhVideoId = self['liste'].getCurrent()[0][1]
		self.session.openWithCallback(
			self.setVideoPrio,
			YoutubePlayer,
			[(dhTitle, dhVideoId, None)],
			listTitle = self.dokuName,
			showPlaylist=False
			)

	def keyPageUp(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()
		self.loadPic()

	def keyPageDown(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()
		self.loadPic()

	def keyYellow(self):
		self.setVideoPrio()