﻿# -*- coding: utf-8 -*-

import glob
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.simpleplayer import SimplePlayer, SimplePlaylistIO
from Components.FileList import FileList
if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/SerienFilm/MovieSelection.pyo'):
	from Plugins.Extensions.SerienFilm.MovieSelection import MovieSelection
else:
	from Screens.MovieSelection import MovieSelection

def simplelistListEntry(entry):
	if entry[0] == '1':
		icon_name = "directory.png"
	else:
		icon_name = "playlist.png"

	png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/%s" % icon_name
	icon = LoadPixmap(png)
	return [entry,
		(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 145, 0, 24, 24, icon),
		(eListboxPythonMultiContent.TYPE_TEXT, 175, 0, 700, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1])
		]

def simplelistListEntry2(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class simplelistGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config.mediaportal.minitv.value)

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"menu": self.keyMenu,
			"red": self.keyCancel,
			"blue": self.deleteEntry
		}, -1)

		#hole mediainfo download path
		if fileExists("/usr/lib/enigma2/python/Plugins/Extensions/mediainfo/plugin.pyo"):
			self.filelist_path = config.plugins.mediainfo.savetopath.value
			print "Lade Mediainfo download path."
		else:
			self.filelist_path = "/media/hdd/movie/"
			print "Kein Mediainfo installiert."

		self.keyLocked = True
		self['title'] = Label("SimpleList")
		self['ContentTitle'] = Label("")
		self['name'] = Label(_("Selection:"))
		self['F1'] = Label("")
		self['F2'] = Label("")
		self['F3'] = Label("")
		self['F4'] = Label("Löschen")
		self['F4'].hide()

		self.last_pl_number = config.mediaportal.sp_pl_number.value
		self.last_videodir = config.movielist.last_videodir.value
		config.movielist.last_videodir.value = self.filelist_path
		self.last_selection = None
		self.filelist = []
		self.genreliste = []
		self.playlist_num = 1
		self.menu_level = 0
		self.last_menu_idx = 0
		self.ltype = ''
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onClose.append(self._onClose)
		#self.onFirstExecBegin.append(self.globalList)

		self.onLayoutFinish.append(self.buildMenulist)

	def buildMenulist(self):
		self['F1'].setText(_("Exit"))
		self['ContentTitle'].setText('Listen Übersicht')
		self.genreliste.append(('1', 'Video Liste', ''))
		path = config.mediaportal.watchlistpath.value + 'mp_global_pl_*'
		list = glob.glob(path)
		for fn in list:
			print "playlist:",fn
			n = int(re.search('mp_global_pl_(\d+)', fn).group(1))
			self.genreliste.append(('2', 'Globale Playlist-%02d' % n, n))

		self.genreliste.sort(key=lambda t : t[0]+t[1].lower())
		self.chooseMenuList.setList(map(simplelistListEntry, self.genreliste))
		self.keyLocked = False

	def loadFileList(self):
		self.ltype = 'sl_movies'
		self['F4'].hide()
		self.session.openWithCallback(self.getSelection, MovieSelection, selectedmovie=self.last_selection)

	def getSelection(self, current):
		print "getSelection:",current
		if current:
			self.last_selection = current
			url = current.getPath()
			fn = current.getName()
			#print fn
			#print url
			self.session.openWithCallback(self.loadFileList, SimplePlayer, [(fn, url)], showPlaylist=False, ltype=self.ltype)
		else:
			self.keyCancel()

	def globalList(self):
		self.ltype = 'sl_glob_playlist'
		self['ContentTitle'].setText("Global Playlist-%02d" % self.playlist_num)
		self['F4'].show()
		self.filelist == []
		self.filelist = SimplePlaylistIO.getPL('mp_global_pl_%02d' % self.playlist_num)
		if self.filelist == []:
			self.keyLocked = True
			self['F4'].hide()
			self.filelist.append(("", "Keine Einträge vorhanden.", "dump"))
		else:
			self['F4'].show()
			self.keyLocked = False
		self.chooseMenuList.setList(map(simplelistListEntry2, self.filelist))

	def deleteEntry(self):
		if self.ltype != 'sl_glob_playlist' or not len(self.filelist):
			return
		idx = self['liste'].getSelectedIndex()
		SimplePlaylistIO.delEntry('mp_global_pl_%02d' % self.playlist_num, self.filelist, idx)
		self.chooseMenuList.setList(map(simplelistListEntry2, self.filelist))

	def keyMenu(self):
		self.session.open(SimplelistConfig)

	def keyOK(self):
		if self.keyLocked:
			return
		if self.menu_level == 1:
			if self.ltype != 'sl_glob_playlist':
				return
			idx = self['liste'].getSelectedIndex()
			self.session.open(SimplePlayer, [], playIdx=idx, playList2=self.filelist, plType='global', ltype=self.ltype, playAll=True)
		else:
			self['F1'].setText("Zurück")
			self.menu_level = 1
			self.last_menu_idx = self['liste'].getSelectedIndex()
			sel = self['liste'].getCurrent()[0][0]
			title = self['liste'].getCurrent()[0][1]
			self['ContentTitle'].setText(title)
			if sel == '1':
				print "loadFileList"
				self.loadFileList()
			else:
				print "load globalList"
				self.playlist_num = self['liste'].getCurrent()[0][2]
				self.globalList()

	def _onClose(self):
		config.movielist.last_videodir.value = self.last_videodir

	def keyCancel(self):
		if self.menu_level == 0:
			self.close()
		else:
			self['F1'].setText(_("Exit"))
			self.menu_level = 0
			self.ltype = ''
			self['F4'].hide()
			self['ContentTitle'].setText('Listen Übersicht')
			self.chooseMenuList.setList(map(simplelistListEntry, self.genreliste))
			self['liste'].moveToIndex(self.last_menu_idx)

class SimplelistConfig(ConfigListScreen, Screen):
	skin = '\n\t\t<screen position="center,center" size="500,300" title="MP SimpleList Konfiguration">\n\t\t\t<widget name="config" position="10,10" size="480,290" scrollbarMode="showOnDemand" />\n\t\t</screen>'

	def __init__(self, session):
		Screen.__init__(self, session)
		self.list = []
		self.list.append(getConfigListEntry('Glob. playlist number', config.mediaportal.sp_pl_number))
		ConfigListScreen.__init__(self, self.list)
		self['setupActions'] = ActionMap(['MP_Actions'],
		{
			'ok': 		self.keySave,
			'cancel': 	self.keyCancel
		},-2)