﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def Entry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def Entry1(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class wissensthekGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Welt der Wunder - Wissensthek")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		url = "http://www.wissensthek.de/"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		raw = re.findall('<li>.*?id="menu.*?href="(.*?)".*?>(.*?)<', data, re.S)
		if raw:
			for (Url, Title) in raw:
				self.filmliste.append((decodeHtml(Title), Url))
			self.filmliste.sort()
			self.filmliste.insert(0, ("Live TV", None))
			self.chooseMenuList.setList(map(Entry, self.filmliste))
			self.chooseMenuList.moveToIndex(0)
			self.keyLocked = False

	def LiveStream(self, data):
		try:
			raw = re.search('class="pionteve_title">(.*?)</td>.*?</span>(.*?)</i>.*?<i>(.*?)</i>', data, re.S).groups()
			if raw:
				title = raw[0] + "\n" + raw[1] + " " + raw[2]
			else:
				title = "Live TV"
		except:
			title = "Live TV"
		url = "rtmp://mf.weltderwunder.c.nmdn.net:1935/wdw_pc/wdwpc.sdp"
		playlist = []
		playlist.append((title, url))
		self.session.open(SimplePlayer, playlist, showPlaylist=False, ltype='wissensthek')

	def keyOK(self):
		if self.keyLocked:
			return
		if self['liste'].getCurrent()[0][0] == "Live TV":
			url = "http://www.weltderwunder.tv/index.php?id=133"
			getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.LiveStream).addErrback(self.dataError)
		else:
			Name = self['liste'].getCurrent()[0][0]
			Link = "http://www.wissensthek.de/" + self['liste'].getCurrent()[0][1]
			self.session.open(wissensthekListScreen, Link, Name)

class wissensthekListScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("Welt der Wunder - Wissensthek")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		self.page = 1
		self.lastpage = 1
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self.filmliste = []
		url = self.Link + "?tx_kaltura_pi1[pag]=" + str(self.page)
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		lastpage = re.search('target="_self"\s.*target=\'_self\'>(.*?)</a></li>', data, re.S)
		if self.lastpage:
			self.lastpage = int(lastpage.group(1))
			self['page'].setText("%s / %s" % (str(self.page), str(self.lastpage)))

		raw = re.findall('class="video-box">.*?<img\ssrc="(.*?)".*?time-video">.*?<.*?href=".*?(\[|%5B)clipid(\]|%5D)=(.*?)["|\&].*?class="test">(.*?)</a>.*?<span>.*?</span>.*?<p>(.*?)</p>.*?</div>', data, re.S)
		if raw:
			for (Image, dummy1, dummy2, ClipId, Title, Handlung) in raw:
				self.filmliste.append((decodeHtml(Title), ClipId, Image, Handlung))
			self.chooseMenuList.setList(map(Entry1, self.filmliste))
			self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, self.lastpage, mode=1)
		self.showInfos()

	def showInfos(self):
		name = self['liste'].getCurrent()[0][0]
		coverUrl = self['liste'].getCurrent()[0][2]
		handlung = self['liste'].getCurrent()[0][3]
		self['handlung'].setText(decodeHtml(handlung))
		self['name'].setText(decodeHtml(name))
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		title = self['liste'].getCurrent()[0][0]
		ClipId = self['liste'].getCurrent()[0][1]
		url = "http://medianac.nacamar.de/p/249/sp/24900/raw/entry_id/%s" % ClipId + "/version/0"
		if url:
			playlist = []
			playlist.append((title, url))
			self.session.open(SimplePlayer, playlist, showPlaylist=False, ltype='wissensthek')