﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def wrestlingnetworkGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def wrestlingnetworkListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class wrestlingnetworkGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False

		self.keyLocked = True
		self['title'] = Label("wrestling-network.net")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.genreliste = [('Full Replays',"http://wrestling-network.net/tag/show-replay/page/"),
							('WWE',"http://wrestling-network.net/category/wwe/page/"),
							('RAW',"http://wrestling-network.net/category/wwe/wwe-raw/page/"),
							('SmackDown',"http://wrestling-network.net/category/wwe/wwe-smackdown/page/"),
							('NXT',"http://wrestling-network.net/category/wwe/wwe-nxt/page"),
							('TNA',"http://wrestling-network.net/category/tna/page/"),
							('WWE Network',"http://wrestling-network.net/category/wwe-network/page/"),
							('Total Divas',"http://wrestling-network.net/category/wwe/total-divas/page/")]

		self.chooseMenuList.setList(map(wrestlingnetworkGenreListEntry, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		wrestlingnetworkName = self['liste'].getCurrent()[0][0]
		wrestlingnetworkUrl = self['liste'].getCurrent()[0][1]
		self.session.open(wrestlingnetworkListeScreen, wrestlingnetworkName, wrestlingnetworkUrl)

class wrestlingnetworkListeScreen(MPScreen):

	def __init__(self, session, genreName, genreLink):
		self.genreLink = genreLink
		self.genreName = genreName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self.keyLocked = True
		self['title'] = Label("wrestling-network.net")
		self['ContentTitle'] = Label("Genre: %s" % self.genreName)

		self['Page'] = Label(_("Page:"))
		self.page = 1
		self.lastpage = 1

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		url = "%s%s" % (self.genreLink ,str(self.page))
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, '', "<span class='pages'>Page.*?of (.*?)</span>")
		shows = re.findall('class="clip-link"\sdata-id=".*?"\stitle="(.*?)"\shref="(.*?)">.*?<img\ssrc="(.*?)" ', data, re.S)
		if shows:
			self.filmliste = []
			for (title,url,image) in shows:
				self.filmliste.append((decodeHtml(title),url,image))
			self.chooseMenuList.setList(map(wrestlingnetworkListEntry, self.filmliste))
			self.chooseMenuList.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		wrestlingnetworkName = self['liste'].getCurrent()[0][0]
		wrestlingnetworkUrl = self['liste'].getCurrent()[0][1]
		idx = self['liste'].getSelectedIndex()
		self.session.open(wrestlingnetworkPlayer, self.filmliste, int(idx) , True, None, None)

class wrestlingnetworkPlayer(SimplePlayer):

	def __init__(self, session, playList, playIdx=0, playAll=True, listTitle=None, cover=None):

		SimplePlayer.__init__(self, session, playList, playIdx, playAll, listTitle, 'local', 0, cover)

	def getVideo(self):
		self.wrestlingnetworkName = self.playList[self.playIdx][0]
		wrestlingnetworkUrl = self.playList[self.playIdx][1]
		getPage(wrestlingnetworkUrl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getData).addErrback(self.dataError)

	def getData(self, data):
		url = re.findall('<iframe.*?src="(http://www.dailymotion.com/embed/video/.*?)\?', data, re.S)
		if url:
			getPage(url[0], headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getStream).addErrback(self.dataError)
		else:
			extraurl = re.findall('<iframe.*?src="(/dm-big.php.*?)&amp', data, re.S)
			if extraurl:
				url = "http://wrestling-network.net/%s" % extraurl[0]
				getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getExtraData).addErrback(self.dataError)

	def getExtraData(self, data):
		url = re.findall('<iframe.*?src="(http://www.dailymotion.com/embed/video/.*?)\?', data, re.S)
		if url:
			getPage(url[0], headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		data = data.replace("\\/", "/")
		stream_url = re.findall('"stream_(h264|h264_hq|h264_hd)_url":"(http://www.dailymotion.com/cdn/.*?)"', data, re.S)
		if stream_url:
			stream_url = urllib2.unquote(stream_url[-1][1])
			self.playStream(self.wrestlingnetworkName, stream_url)