# -*- coding: utf-8 -*-
#
servicerelation_version="4.2-r1"
#
#  ServiceRelation E2
#
#  Coded by gutemine (c) 2015
#  90% based on PiPServiceRelation by Dr.Best (c) 2011 
#
#  Support: www.oozoon.de
#
#  This plugin is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this plugin may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.

#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed other than under the conditions noted above.
#
from Plugins.Plugin import PluginDescriptor
from Screens.PictureInPicture import PictureInPicture
from Navigation import Navigation
from Components.ParentalControl import parentalControl
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Screens.ChannelSelection import SimpleChannelSelection
from enigma import eServiceCenter, getBestPlayableServiceReference, eServiceReference, eListboxPythonMultiContent, gFont, RT_HALIGN_LEFT, RT_VALIGN_CENTER
from Components.MenuList import MenuList
from Components.Label import Label
from Components.Sources.StaticText import StaticText
from Components.ActionMap import ActionMap
from ServiceReference import ServiceReference
from Tools.BoundFunction import boundFunction
from Components.ConfigList import ConfigListScreen
from Components.config import getConfigListEntry, config, ConfigDirectory, NoSave
from Components.config import config, configfile, ConfigSubsection, ConfigSelection, ConfigSet, ConfigBoolean, ConfigInteger, ConfigSubList, getConfigListEntry, KEY_LEFT, KEY_RIGHT, KEY_0, ConfigNothing, ConfigPIN
from Components.ConfigList import ConfigList

from os import path as os_path
from pickle import load as pickle_load, dump as pickle_dump
from enigma import eEnv
import os

basePictureInPicture__init__ = None
baseNavigation__init__ = None
CONFIG_FILE = eEnv.resolve('${libdir}/enigma2/python/Plugins/SystemPlugins/ServiceRelation/sr_config')
FOCUS_CONFIG, FOCUS_ASSIGN = range(2) 

yes_no_descriptions = {False: _("no"), True: _("yes")}

config.plugins.servicerelation = ConfigSubsection()
config.plugins.servicerelation.pip = ConfigBoolean(default = True, descriptions=yes_no_descriptions)
config.plugins.servicerelation.recording = ConfigBoolean(default = True, descriptions=yes_no_descriptions)

def getRelationDict():
	if os_path.exists(CONFIG_FILE):
		pkl_file = open(CONFIG_FILE, 'rb')
		if pkl_file:
			volumedict = pickle_load(pkl_file)
			pkl_file.close()
			return volumedict
	return {}

def saveRelationDict(dict):
	pkl_file = open(CONFIG_FILE, 'wb')
	if pkl_file:
		pickle_dump(dict, pkl_file)
		pkl_file.close()

def checkCI(serviceref=None,cinum=0):                                         
	if serviceref is None:
		return -1
	cisocket="/var/run/ca/ci%d.socket" % cinum
	if not os_path.exists(cisocket):
		return -1
	cifile="/etc/enigma2/ci%d.xml" % cinum
	if not os_path.exists(cifile):
		return -1
	else:
		f=open(cifile,"r")
		assignments=f.read()
		f.close()
#		print assignments
		if assignments.find(serviceref) is -1:
			if assignments.find("provider name") is -1:
				return -1
			# servicen not found, but maybe provider ...
			#
			# next 40 lines are just because I am impatient 
			#
			f=open(cifile,"r")
			assignments=f.readline()
			pv=[]
			sp=[]
			lp=[]
			pp=[]
			while assignments:
				assignments=f.readline()
				if assignments.find("provider name") is not -1:
					pv=assignments.split()
					provider=pv[1].lstrip("name=")
					sp=serviceref.split(":")
					sid="%04s" % sp[3]
					sid=sid.replace(" ","0")
					tsid="%04s" % sp[4]
					tsid=tsid.replace(" ","0")
					onid="%04s" % sp[5]
					onid=onid.replace(" ","0")
					lamedb="/etc/enigma2/lamedb"
					if os_path.exists(lamedb):
						ll=open(lamedb,"r")
						line=ll.readline()
						line=ll.readline()
						while not line.startswith("services"):
							line=ll.readline()
						while line:
							line=ll.readline()
							lp=line.split(":")
							if len(lp) > 3:
								lp_sid=lp[0].upper()
								lp_tsid=lp[2].upper()
								lp_onid=lp[3].upper()
								if sid==lp_sid and tsid==lp_tsid and onid==lp_onid:
									channel=ll.readline().rstrip("\n")
									line=ll.readline()
									pp=line.split(",")
									servprovider="\"%s\"" % pp[0].lstrip("p:").rstrip("\n")
									if provider==servprovider:	
										print "[SERVICE RELATION] CI slot %d assigned to %s via provider %s" % (cinum+1, serviceref, provider)                    
										ll.close()
										f.close()
										return cinum
						ll.close()
			f.close()
			return -1
		else:
			print "[SERVICE RELATION] CI Slot %d assigned to %s" % (cinum+1, serviceref)                    
			return cinum

def autostart_PictureInPicture(session, **kwargs):
	init_servicerelation()

def setup(session,**kwargs):
	session.open(ServiceRelationSetup)

class ServiceRelationSetup(Screen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="650,550">
			<widget name="config" position="10,10" size="630,80" scrollbarMode="showOnDemand"/>
			<eLabel name="divide1" position="0,85" size="650,2" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" />
			<widget name="name" position="15,100" size="310,50" font="Regular;20" halign="left"/>
			<widget name="relationname" position="340,100" size="320,30" font="Regular;20" halign="left"/>
			<eLabel name="divide2" position="0,135" size="650,2" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" />
			<widget name="entrylist" position="10,150" size="630,340" scrollbarMode="showOnDemand"/>
			<widget name="key_red" position="10,500" zPosition="5" size="150,40" valign="center" halign="center" backgroundColor="red" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget name="key_green" position="170,500" zPosition="5" size="150,40" valign="center" halign="center" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget name="key_yellow" position="330,500" size="150,40" zPosition="5" valign="center" halign="center" backgroundColor="yellow" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget name="key_blue" position="490,500" zPosition="5" size="140,40" valign="center" halign="center" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<ePixmap position="10,500" zPosition="4" size="150,40" pixmap="skin_default/buttons/red.png" transparent="1" alphatest="on" />
			<ePixmap position="170,500" zPosition="4" size="150,40" pixmap="skin_default/buttons/green.png" transparent="1" alphatest="on" />
			<ePixmap position="330,500" zPosition="4" size="150,40" pixmap="skin_default/buttons/yellow.png" transparent="1" alphatest="on" />
			<ePixmap position="490,500" zPosition="4" size="150,40" pixmap="skin_default/buttons/blue.png" transparent="1" alphatest="on" />
		</screen>"""

	def __init__(self, session):
		Screen.__init__(self, session)
                self.list = []                                                     
		self.list.append(getConfigListEntry(_("PIP"), config.plugins.servicerelation.pip))
		self.list.append(getConfigListEntry(_("Recordings"), config.plugins.servicerelation.recording))
                ConfigListScreen.__init__(self, self.list, session = self.session)

		self.focus=FOCUS_CONFIG
		self.onShown.append(self.setWindowTitle) 
                self.onLayoutFinish.append(self.keyChannel)     

		self.menuList = ConfigList(self.list)
		self.menuList.list = self.list
		self.menuList.l.setList(self.list)
		self["config"] = self.menuList

		self.title = _("Service Relation")+" "+_("Configuration")+" "+_("Version")+" "+servicerelation_version
		self["name"] = Label(_("Service"))
		self["relationname"] = Label(_("Related Service"))
		self["key_red"] = Label(_("Delete"))
		self["key_green"] = Label(_("Close"))
		self["key_yellow"] = Label(_("Add"))
		self["key_blue"] = Label(_("Edit"))
		self["entrylist"] = ServiceRelationEntryList([])
		self["actions"] = ActionMap(["WizardActions","MenuActions","ShortcutActions","PiPSetupActions"],
			{
			 "ok"	:	self.keyBlue,
			 "back"	:	self.keyClose,
			 "red"	:	self.keyDelete,
			 "green":	self.keyClose,
			 "yellow":	self.keyYellow,
			 "blue": 	self.keyBlue,
			 "up"	:	self.keyUp,
			 "down"	:	self.keyDown,
			 "right":	self.keyRight,
			 "left":	self.keyLeft,
			 "size+": 	self.keyChannel,
			 "size-": 	self.keyChannel,
			 }, -1)
		self["entrylist"].setConfig(getRelationDict())
		self.updateList()

        def setWindowTitle(self):                                               
                self.setTitle(self.title)     

	def updateList(self):
		self["entrylist"].buildList()

	def keyClose(self):
		for x in self["config"].list:                                   
                	x[1].save()                      
		self.close()

	def keyChannel(self):
		if self.focus==FOCUS_ASSIGN:
			self["key_red"].hide()   
			self["key_yellow"].hide()   
			self["key_blue"].hide()   
			self.focus=FOCUS_CONFIG
             	 	self["config"].instance.setSelectionEnable(True)
              		self["entrylist"].instance.setSelectionEnable(False)
		else:
			self["key_red"].show()   
			self["key_yellow"].show()   
			self["key_blue"].show()   
			self.focus=FOCUS_ASSIGN
	              	self["config"].instance.setSelectionEnable(False)
        	      	self["entrylist"].instance.setSelectionEnable(True)

	def keyUp(self):
                if self.focus == FOCUS_CONFIG:                     
			self["config"].instance.moveSelection(self["config"].instance.moveUp)
                elif self.focus == FOCUS_ASSIGN:                     
			if self["entrylist"].getCurrentIndex() > 0: 
				self["entrylist"].setIndex(self["entrylist"].getCurrentIndex()-1)

	def keyDown(self):
                if self.focus == FOCUS_CONFIG:                     
			if self["config"].getCurrentIndex() < len(self["config"].getList())-1: 
				self["config"].instance.moveSelection(self["config"].instance.moveDown)
                elif self.focus == FOCUS_ASSIGN:                     
			if self["entrylist"].getCurrentIndex() < len(self["entrylist"].getList())-1: 
				self["entrylist"].setIndex(self["entrylist"].getCurrentIndex()+1)

	def keyLeft(self):
                if self.focus == FOCUS_CONFIG:                     
			self["config"].handleKey(KEY_LEFT)
                elif self.focus == FOCUS_ASSIGN:                     
			return

	def keyRight(self):
                if self.focus == FOCUS_CONFIG:                     
			self["config"].handleKey(KEY_RIGHT)
                elif self.focus == FOCUS_ASSIGN:                     
			return

	def keyBlue(self):
                if self.focus == FOCUS_CONFIG:                     
			return
		else:
			try:sel = self["entrylist"].l.getCurrentSelection()[0]
			except: sel = None
			if sel is None:
				return
			self.session.openWithCallback(self.updateList,ServiceRelationEntryConfigScreen,sel, self["entrylist"].configSR)

	def keyYellow(self):
                if self.focus == FOCUS_CONFIG:                     
			return
		else:
			self.session.openWithCallback(self.updateList,ServiceRelationEntryConfigScreen,None, self["entrylist"].configSR)

	def keyDelete(self):
                if self.focus == FOCUS_CONFIG:                     
			return
		else:
			try:sel = self["entrylist"].l.getCurrentSelection()[0]
			except: sel = None
			if sel is None:
				return
			self.session.openWithCallback(self.deleteConfirm, MessageBox, _("Do you really want to delete this entry?"))

	def deleteConfirm(self, result):
		if not result:
			return
		sel = self["entrylist"].l.getCurrentSelection()[0]
		del self["entrylist"].configSR[sel[0]]
		saveRelationDict(self["entrylist"].configSR)
		self.updateList()

class ServiceRelationEntryList(MenuList):
	def __init__(self, list, enableWrapAround = True):
		MenuList.__init__(self, list, enableWrapAround, eListboxPythonMultiContent)
		self.l.setFont(0, gFont("Regular", 20))
		self.l.setFont(1, gFont("Regular", 18))
		self.configSR = None

	def postWidgetCreate(self, instance):
		MenuList.postWidgetCreate(self, instance)
		instance.setItemHeight(20)

	def getCurrentIndex(self):
		return self.instance.getCurrentIndex()

	def getList(self):
		return self.list

	def setIndex(self,index):
		self.moveToIndex(index)
		
	def setConfig(self, configSR):
		self.configSR = configSR
		
	def buildList(self):
		list = []
		for c in self.configSR.items():
			res = [
				c,
				(eListboxPythonMultiContent.TYPE_TEXT, 5, 0, 320, 20, 1, RT_HALIGN_LEFT|RT_VALIGN_CENTER, ServiceReference(eServiceReference(c[0])).getServiceName()),
				(eListboxPythonMultiContent.TYPE_TEXT, 330, 0,320, 20, 1, RT_HALIGN_LEFT|RT_VALIGN_CENTER, ServiceReference(eServiceReference(c[1])).getServiceName()),
			]
			list.append(res)
		self.list = list
		self.l.setList(list)
		self.moveToIndex(0)


class ServiceRelationEntryConfigScreen(ConfigListScreen, Screen):
	skin = """
		<screen name="ServiceRelationEntryConfigScreen" position="center,center" size="650,150">
			<widget name="config" position="10,10" size="630,100" scrollbarMode="showOnDemand" />
			<ePixmap position="10,110" zPosition="4" size="150,40" pixmap="skin_default/buttons/red.png" transparent="1" alphatest="on" />
			<ePixmap position="170,110" zPosition="4" size="150,40" pixmap="skin_default/buttons/green.png" transparent="1" alphatest="on" />
			<ePixmap position="330,110" zPosition="4" size="150,40" pixmap="skin_default/buttons/yellow.png" transparent="1" alphatest="on" />
			<ePixmap position="490,110" zPosition="4" size="150,40" pixmap="skin_default/buttons/blue.png" transparent="1" alphatest="on" />

			<widget source="key_red" render="Label" position="10,110" zPosition="5" size="150,40" valign="center" halign="center" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget source="key_green" render="Label" position="170,110" zPosition="5" size="150,40" valign="center" halign="center" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
		</screen>"""

	def __init__(self, session, entry, configSR):	
		self.session = session
		Screen.__init__(self, session)
		self.title = _("Service Relation")+" "+_("Channel")+" "+_("Setup")
		self["actions"] = ActionMap(["SetupActions", "ColorActions"],
		{
			"green": self.keySave,
			"red": self.keyCancel,
			"cancel": self.keyCancel,
			"ok": self.keySelect,
		}, -2)
		self["key_red"] = StaticText(_("Cancel"))
		self["key_green"] = StaticText(_("OK"))
		self.configSR = configSR
		self.entry = entry
		if entry is None:
			self.currentKey = None
			self.ref1 =  NoSave(ConfigDirectory(default = _("Press OK to select a service")))
			self.ref2 =  NoSave(ConfigDirectory(default = _("Press OK to select a related service")))
		else:
			self.currentKey = entry[0]
			self.ref1 =  NoSave(ConfigDirectory(default = ServiceReference(eServiceReference(entry[0])).getServiceName()))
			self.ref2 =  NoSave(ConfigDirectory(default = ServiceReference(eServiceReference(entry[1])).getServiceName()))
		self.list = [ ]
		self.serviceref1 =  getConfigListEntry(_("Service"), self.ref1)
		self.serviceref2 =  getConfigListEntry(_("Related Service"), self.ref2)
		self.list.append(self.serviceref1)
		self.list.append(self.serviceref2)
		ConfigListScreen.__init__(self, self.list, session)
		
	def keySelect(self):
		cur = self["config"].getCurrent()
		if cur == self.serviceref1:
			index = 1
			descr = _("Channel Selection")
		else:
			index = 2
			if self.entry and self.entry[0]:
				sname = ServiceReference(eServiceReference(self.entry[0])).getServiceName()
			else:
				sname = ""
			descr = _("Related service for %s") % sname
		self.session.openWithCallback(boundFunction(self.channelSelected,index), SimpleChannelSelection, descr)
			
	def channelSelected(self, index, ref = None):
		if ref:
			if self.entry:
				val1 = self.entry[0]
				val2 = self.entry[1]
			else:
				val1 = val2 = None
			if index == 1:
				self.entry = (ref.toString(), val2)
				self.ref1.value = ServiceReference(ref).getServiceName()
			else:
				self.entry = (val1, ref.toString())
				self.ref2.value = ServiceReference(ref).getServiceName()

	def keySave(self):
		if self.entry and self.entry[0] and self.entry[1]:
			if self.currentKey is not None:
				del self.configSR[self.currentKey]
			self.configSR[self.entry[0]] = self.entry[1]
			saveRelationDict(self.configSR)
		self.close()

	def keyCancel(self):
		ConfigListScreen.cancelConfirm(self, True)

def init_servicerelation():
	# PIP
	global basePictureInPicture__init__, basePictureInPicture_playService
	if basePictureInPicture__init__ is None:
		basePictureInPicture__init__ = PictureInPicture.__init__
	PictureInPicture.__init__ = PictureInPicture__init__
	PictureInPicture.playService = playServicePip
	# Normal
	global baseNavigation__init__, baseNavigation_playService
	if baseNavigation__init__ is None:
		baseNavigation__init__ = Navigation.__init__
	Navigation.__init__ = Navigation__init__
	Navigation.playService = playServiceRelation

def PictureInPicture__init__(self, session):
	basePictureInPicture__init__(self, session)
	self.ServiceRelation = getRelationDict()

def playServicePip(self, service):
	current_service = service
	# pip servicerelation depends now on setting and assignment
	if config.plugins.servicerelation.pip.value:
		n_service = self.ServiceRelation.get(service.toString(),None)
		if n_service is not None:
			service = eServiceReference(n_service)
		        channel = ServiceReference(n_service).getServiceName() 
        		if len(channel) > 0:                                  
				print "[SERVICE RELATION] ALTERNATIVE PIP playing %s" % channel
		
	if service and (service.flags & eServiceReference.isGroup):
		ref = getBestPlayableServiceReference(service, eServiceReference())
	else:
		ref = service
	if ref:
		print "pip playing", ref.toString()
		self.pipservice = eServiceCenter.getInstance().play(ref)
		if self.pipservice and not self.pipservice.setTarget(1):
			self.pipservice.start()
			self.currentService = current_service
			return True
		else:
			self.pipservice = None
	return False

def Navigation__init__(self, session):
	baseNavigation__init__(self, session)

def playServiceRelation(self, ref, checkParentalControl = True, forceRestart = False):
	oldref = self.currentlyPlayingServiceReference
	if ref and oldref and ref == oldref and not forceRestart:
		print "ignore request to play already running service(1)"
		return 0
	if ref is None:
		print "ignore request to play nothing"
		return 0

	# non recording servicerelation depends now on setting and assignment
	if config.plugins.servicerelation.recording.value:
		# first stop current service to free CI
		self.stopService()
		# second check if CI is needed at all
		serviceref=ref.toString()
                NUM_CI = 2
	        assigned = 0
	        needs = False
	        serv = ''
	        channel = ''
	        provider = ''
	        recording = ''
                for slot in range(NUM_CI):
            		print '[SERVICE RELATION] checks CI slot %d for %s' % (slot, serviceref)
            		if checkCI(serviceref, slot) is not -1:
                		assigned = assigned + 1
                		if os.path.exists('/var/run/ca/ci%d.service' % slot):
                    			c = open('/var/run/ca/ci%d.service' % slot, 'r')
					serv = c.readline()
                    			channel = c.readline()
                    			provider = c.readline()
                    			recording = c.readline()
                    			c.close()
                    			print '[SERVICE RELATION[ CI slot %d plays currently %s channel %s' % (slot, serv, channel)
                    			if serv.find(serviceref) is -1:
                       				print '[SERVICE RELATION] NEEDS ALTERNATIVE'
                        			needs = True

	        print '[SERVICE RELATION] assigned %d' % assigned
	        if assigned == 1 and needs:
			self.ServiceRelation = getRelationDict()
            		n_ref = self.ServiceRelation.get(ref.toString(), None)
            		if n_ref is not None:
                		ref = eServiceReference(n_ref)
                		channel = ServiceReference(n_ref).getServiceName()
                		if len(channel) > 0:
                    			print '[SERVICE RELATION] ALTERNATIVE playing %s' % channel
        	elif assigned == 2 and needs:
            		playing = []
            		playing = serv.split(':')
            		print playing
            		request = []
            		request = serviceref.split(':')
            		print request
            		if len(playing) > 1 and playing[4] == request[4] and playing[5] == request[5]:
                		self.ServiceRelation = getRelationDict()
                		n_ref = self.ServiceRelation.get(ref.toString(), None)
                		if n_ref is not None:
                    			ref = eServiceReference(n_ref)
                    			channel = ServiceReference(n_ref).getServiceName()
                    			if len(channel) > 0:
                        			print '[SERVICE RELATION] ALTERNATIVE playing %s' % channel
	if ref is None:
		self.stopService()
		return 0
	print "playing", ref.toString()
	if not checkParentalControl or parentalControl.isServicePlayable(ref, boundFunction(self.playService, checkParentalControl = False)):
		if ref.flags & eServiceReference.isGroup:
			if not oldref:
				oldref = eServiceReference()
			playref = getBestPlayableServiceReference(ref, oldref)
			print "playref", playref
			if playref and oldref and playref == oldref and not forceRestart:
				print "ignore request to play already running service(2)"
				return 0
			if not playref or (checkParentalControl and not parentalControl.isServicePlayable(playref, boundFunction(self.playService, checkParentalControl = False))):
				self.stopService()
				return 0
		else:
			playref = ref
		if self.pnav and not self.pnav.playService(playref):
			self.currentlyPlayingServiceReference = playref
			return 0
	else:
		self.stopService()
	return 1

def Plugins(**kwargs):
	list = []
	list.append(PluginDescriptor(name=_("Service Relation"), description=_("Setup")+" "+_("Service Relation"), where = [PluginDescriptor.WHERE_PLUGINMENU], icon = "ServiceRelation.png", fnc=setup))
	list.append(PluginDescriptor(where = PluginDescriptor.WHERE_SESSIONSTART, fnc = autostart_PictureInPicture))
	return list

