﻿# -*- coding: utf-8 -*-
# by betonme @2012

# Imports
from Components.config import config

from Tools.BoundFunction import boundFunction

from urllib import urlencode

from datetime import datetime

import re
import json
from sys import maxint

# Internal
from Plugins.Extensions.SeriesPlugin.IdentifierBase import IdentifierBase
from Plugins.Extensions.SeriesPlugin.Logger import splog


# Constants
SERIESLISTURL     = "http://serienrecorder.lima-city.de/series.php?"
AIRDATESURL = "http://www.wunschliste.de/airdates.pl?"


class SerienServer(IdentifierBase):
	def __init__(self):
		IdentifierBase.__init__(self)

	@classmethod
	def knowsElapsed(cls):
		return True

	@classmethod
	def knowsToday(cls):
		return True

	@classmethod
	def knowsFuture(cls):
		return True

	def getEpisode(self, name, begin, end=None, service=None):
		# On Success: Return a single season, episode, title tuple
		# On Failure: Return a empty list or String or None
		
		self.begin = begin
		self.end = end
		self.service = service
		
		self.knownids = []
		self.returnvalue = None
		
		# Check preconditions
		if not name:
			splog(_("Skip Wunschliste: No show name specified"))
			return _("Skip Wunschliste: No show name specified")
		if not begin:
			splog(_("Skip Wunschliste: No begin timestamp specified"))
			return _("Skip Wunschliste: No begin timestamp specified")
		
		splog("WunschlistePrint getEpisode")
		
		while name:	
			ids = self.getSeries(name)
			
			while ids:
				idserie = ids.pop()
				
				if idserie and len(idserie) == 2:
					id, idname = idserie
					
					# Handle encodings
					self.series = idname
					
					result = self.getNextPage( id )
					if result:
						return result
					
			else:
				name = self.getAlternativeSeries(name)
		
		else:
			return ( self.returnvalue or _("No matching series found") )

	def getSeries(self, name):
		url = SERIESLISTURL + urlencode({ 'q' : name })
		data = self.getPage( url, False )
		
		if data and isinstance(data, basestring):
			#id, calue = data
			#data = json.loads(data).values()
			data = list(reversed( json.loads(data).values() ) )
		
		if data and isinstance(data, list):
			splog("WunschlistePrint ids", data)
			return self.filterKnownIds(data)

	def getNextPage(self, id):
		splog("WunschlistePrint getNextPage")
		
		url = AIRDATESURL + urlencode({ 'serie' : id, 'airdate' : self.begin, 'channel' : self.service })
		data = self.getPage( url, False )
		
		if data and isinstance(data, basestring):
			#xchannel, xday, xdate, xbegin, xend, xepisode, xtitle = data
			data = json.loads(data).values()
		
		if data and isinstance(data, list):
			trs = data
			
			yepisode = None
			
			for tds in trs:
				if tds and len(tds) == 5:
					xchannel, xday, xdate, xbegin, xend, xseason, xepisode, xtitle = tds
					yepisode = (xseason, xepisode, xtitle, self.series)
			
			if yepisode:
				return ( yepisode )
