# -*- coding: utf-8 -*-
#
# AutoPin Plugin by gutemine
#
autopin_version="1.6-r8"
#
from Components.ActionMap import ActionMap, HelpableActionMap, NumberActionMap
from Components.Label import Label, MultiColorLabel
from Components.ConfigList import ConfigListScreen
from Components.ConfigList import ConfigList
from Components.Pixmap import Pixmap
from Tools.LoadPixmap import LoadPixmap
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox 
from Screens.InputBox import InputBox
from Components.Input import Input
from Screens.ChoiceBox import ChoiceBox
from Components.SystemInfo import SystemInfo
from Screens.Console import Console                                                                           
from Components.MenuList import MenuList       
from Screens.Ci import *
from Components.Sources.StaticText import StaticText
from Components.config import config, configfile, ConfigSubsection, ConfigSelection, ConfigSet, ConfigBoolean, ConfigInteger, ConfigSubList, getConfigListEntry, KEY_LEFT, KEY_RIGHT, KEY_0, ConfigNothing, ConfigPIN
from Components.ConfigList import ConfigList
from Components.ServiceEventTracker import ServiceEventTracker
from enigma import ePoint, eConsoleAppContainer, getDesktop, eServiceCenter, eDVBServicePMTHandler, iServiceInformation,  iPlayableService, eServiceReference, eEPGCache, eActionMap
from timer import TimerEntry
from Screens.Standby import Standby, inStandby                 
from Screens.PictureInPicture import PictureInPicture
from Plugins.Plugin import PluginDescriptor

import Screens.Ci
from Plugins.SystemPlugins.CommonInterfaceAssignment.plugin import *
import Plugins.SystemPlugins.CommonInterfaceAssignment.plugin

yes_no_descriptions = {False: _("no"), True: _("yes")}

from xml.etree.cElementTree import parse as ci_parse
from enigma import eTimer, eDVBCI_UI, eDVBCIInterfaces, eEnv, eServiceReference, eServiceCenter

from Tools.BoundFunction import boundFunction
#from Plugins.Extensions.SocketMMI.SocketMMI import SocketMMIMessageHandler
from Plugins.Extensions.SocketMMI.SocketMMI import *
import os
if os.path.exists("/usr/lib/enigma2/python/Plugins/Extensions/SocketMMI/socketmmi.py"):
	from Plugins.Extensions.SocketMMI.socketmmi import eSocket_UI  
else:
	eSocket_UI=None
	import Plugins.Extensions.SocketMMI.socketmmi as socketmmi

spi=[]
spi=_("immediate shutdown").split()                     
config.plugins.autopin = ConfigSubsection()
config.plugins.autopin.confirmhelper = ConfigSelection(default=[], choices = ["2","44","74","103","164","204","304","349","502","503","510","535","536","990","991","993"])
autopin_options = []                                                     
autopin_options.append(( "enable",_("enable")+" "+_("auto")+" "+_("Load") ))                             
autopin_options.append(( "disable",_("disable")+" "+_("auto")+" "+_("Load") ))                       
autopin_options.append(( "start", spi[0]+" "+_("enable") ))                       
autopin_options.append(( "stop", spi[0]+" "+_("disable") ))                       
autopin_options.append(( "restart",_("Restart") ))                       
autopin_options.append(( "reset_ci",_("Reset")+" "+_("CI") ))                             
autopin_options.append(( "reset_assign",_("Reset")+" "+_("CI assignment") ))                             
autopin_options.append(( "info",_("Show Info") ))                      
#autopin_options.append(( "none",_("do nothing") ))                             
autopin_names = []                                                     
autopin_names.append(( "inactive",_("no") ))                             
autopin_names.append(( "active",_("yes") ))                             
#autopin_names.append(( "automatic",_("Automatic").lower() ))                             
config.plugins.autopin.addmodulenametoassignment = ConfigSelection(default="active", choices = autopin_names)
config.plugins.autopin.fixhighbitrate = ConfigBoolean(default = False, descriptions=yes_no_descriptions)
config.plugins.autopin.shutup = ConfigBoolean(default = False, descriptions=yes_no_descriptions)

MAX_NUM_CI = 4

config.plugins.autopin.ci = ConfigSubList()
for slot in range(MAX_NUM_CI):
	config.plugins.autopin.ci.append(ConfigSubsection())
	config.plugins.autopin.ci[slot].command = ConfigSelection(default = "info", choices =autopin_options)

autopin_skin=config.skin.primary_skin.value.replace("/skin.xml","")

ShutUp = config.plugins.autopin.shutup.value
socketHandler = None

autopin_plugindir="/usr/lib/enigma2/python/Plugins/Extensions/AutoPin"

def InitCiConfigPlus():
	config.ci = ConfigSubList()
	for slot in range(MAX_NUM_CI):
		config.ci.append(ConfigSubsection())
		config.ci[slot].pin = ConfigInteger(default = 0, limits=(0,9999))
		config.ci[slot].confirm = ConfigSet(default = [], choices = [2,44,74,103,164,204,304,349,502,503,510,535,536,990,991,993])
		config.ci[slot].resource = ConfigSelection(default="", choices = [("cam_upgrade,host_lac,host_ctrl,app_mmi","4"),("cam_upgrade,host_lac,host_ctrl","3"),("cam_upgrade,host_lac","2"),("cam_upgrade","1"),("","0")])
		config.ci[slot].canDescrambleMultipleServices = ConfigSelection(choices = [("auto", _("Auto")), ("no", _("No")), ("yes", _("Yes"))], default = "auto")
		if SystemInfo["CommonInterfaceSupportsHighBitrates"]:
			config.ci[slot].canHandleHighBitrates = ConfigSelection(choices = [("no", _("No")), ("yes", _("Yes"))], default = "no")
			config.ci[slot].canHandleHighBitrates.slotid = slot
			config.ci[slot].canHandleHighBitrates.addNotifier(setCIBitrate)

def dlgClosedAutoPin(self, slot):                                              
	global ShutUp
	ShutUp=config.plugins.autopin.shutup.value
        if slot in self.dlgs:                                           
               del self.dlgs[slot]                                     

def startMMIAutoPin(self, slot):
	global ShutUp
	# for menus we have to temporary disable ShutUp
	ShutUp=False
	if os.path.exists("/var/lib/dpkg/status"):
		self.dlgs[slot] = self.session.openWithCallback(self.dlgClosed, MMIDialog, slot, 2, self.socket_ui, _("wait for mmi..."))
	else:
		self.dlgs[slot] = self.session.openWithCallback(self.dlgClosed, MMIDialog, slot, 2, socketmmi, _("wait for mmi..."))

def socketStateChangedAutoPin(self, slot):
	global ShutUp
	if os.path.exists("/var/lib/dpkg/status"):
		if slot in self.dlgs:
			self.dlgs[slot].ciStateChanged()
		elif self.socket_ui.availableMMI(slot) == 1:
			if self.session and not ShutUp:
				self.dlgs[slot] = self.session.openWithCallback(self.dlgClosed, MMIDialog, slot, 3, self.socket_ui, _("wait for mmi..."))
	else:
		if slot in self.dlgs:
			self.dlgs[slot].ciStateChanged()
		elif socketmmi.availableMMI(slot) == 1:
			if self.session and not ShutUp:
				self.dlgs[slot] = self.session.openWithCallback(self.dlgClosed, MMIDialog, slot, 3, socketmmi, _("wait for mmi..."))

# rename original on startup in any case
Plugins.Extensions.SocketMMI.SocketMMI.SocketMMIMessageHandler.startMMI = startMMIAutoPin
Plugins.Extensions.SocketMMI.SocketMMI.SocketMMIMessageHandler.dlgClosed = dlgClosedAutoPin
Plugins.Extensions.SocketMMI.SocketMMI.SocketMMIMessageHandler.socketStateChanged = socketStateChangedAutoPin

def showScreenAutoPin(self):
	screen = self.handler.getMMIScreen(self.slotid)

	list = [ ]

	self.timer.stop()
	if len(screen) > 0 and screen[0][0] == "CLOSE":
		timeout = screen[0][1]
		self.mmiclosed = True
		if timeout > 0:
			self.timer.start(timeout*1000, True)
		else:
			self.keyCancel()
	else:
		self.mmiclosed = False
		self.tag = screen[0][0]
		for entry in screen:
			if entry[0] == "PIN":
				self.addEntry(list, entry)
			else:
				if entry[0] == "TITLE":
					self["title"].setText(entry[1])
				elif entry[0] == "SUBTITLE":
					self["subtitle"].setText(entry[1])
				elif entry[0] == "BOTTOM":
					self["bottom"].setText(entry[1])
				elif entry[0] == "TEXT":
					self.addEntry(list, entry)
					# check for auto confirm with classic CI module
					slot=self.slotid
					ci_name=eDVBCI_UI.getInstance().getAppName(slot)
					if len(ci_name) > 0:
						for confirm in config.ci[slot].confirm.value:
							if entry[1].find(" %d " % confirm) is not -1 or entry[1].find(" %d)" % confirm) is not -1 or entry[1].find("(%d)" % confirm) is not -1:
								print "[AUTOPIN] confirmed %d" % confirm
								try:
									self.keyCancel()
								except:
									pass
								return
	self.updateList(list)

def addEntryAutoPin(self, list, entry):
	if entry[0] == "TEXT":		#handle every item (text / pin only?)
		list.append( (entry[1], ConfigNothing(), entry[2]) )
	if entry[0] == "PIN":
		pinlength = entry[1]
		if entry[3] == 1:
			# masked pins:
			x = ConfigPIN(0, len = pinlength, censor = "*")
		else:
			# unmasked pins:
			x = ConfigPIN(0, len = pinlength)
		x.addEndNotifier(self.pinEntered)
		self["subtitle"].setText(entry[2])
		list.append( getConfigListEntry("", x) )
		self["bottom"].setText(_("please press OK when ready"))
		slot=self.slotid	
		if config.ci[slot].pin.value > 0:
			# don't wait for entering 
			self.pinEntered(0)

def okbuttonClickAutoPin(self):
	self.timer.stop()
	if not self.tag:
		return
	if self.tag == "WAIT":
		print "do nothing - wait"
	elif self.tag == "MENU":
		print "answer MENU"
		cur = self["entries"].getCurrent()
		if cur:
			self.handler.answerMenu(self.slotid, cur[2])
		else:
			self.handler.answerMenu(self.slotid, 0)
		self.showWait()
	elif self.tag == "LIST":
		print "answer LIST"
		self.handler.answerMenu(self.slotid, 0)
		self.showWait()
	elif self.tag == "ENQ":
		cur = self["entries"].getCurrent()
		slot=self.slotid	
		if config.ci[slot].pin.value > 0:
			answer=str(config.ci[slot].pin.value)
			length = len(answer)
			while length < 4:
				answer = '0'+answer
				length+=1
		else:
			answer = str(cur[1].value)
			length = len(answer)
			while length < cur[1].getLength():
				answer = '0'+answer
				length+=1
		self.handler.answerEnq(self.slotid, answer)
		self.showWait()

# rename original on startup in any case
Screens.Ci.MMIDialog.addEntry = addEntryAutoPin 
Screens.Ci.MMIDialog.okbuttonClick = okbuttonClickAutoPin 
Screens.Ci.MMIDialog.showScreen = showScreenAutoPin 

def getMMISlotName(real_slot):
		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		NUM_MMI=0
	       	socketHandler = SocketMMIMessageHandler()
		NUM_MMI=socketHandler.numConnections()
		
		module_name = None
		if real_slot < NUM_CI:
			for slot in range(NUM_CI):
				state = eDVBCI_UI.getInstance().getState(slot)
				if state == -1:
					for mmi in range(NUM_MMI):
						mmi_name= socketHandler.getName(mmi)
						mmi_slot=99
						if not mmi_name.startswith("MMI Socket"):
							splitted=[]
							splitted=mmi_name.split()
							if len(splitted) > 1:
								if splitted[0].startswith("CI"):
									mmi_slot=int(splitted[1].strip(":"))-1
							if real_slot == mmi_slot:
								module_name=mmi_name
#								print "[CI] FOUND CI Slot %d as MMI Name %s" % (real_slot,module_name)
		return module_name

def getMMISlotNumber(real_slot):
		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		NUM_MMI=0
	       	socketHandler = SocketMMIMessageHandler()
		NUM_MMI=socketHandler.numConnections()
		
		module_number = None
		if real_slot < NUM_CI:
			for slot in range(NUM_CI):
				state = eDVBCI_UI.getInstance().getState(slot)
				if state == -1:
					for mmi in range(NUM_MMI):
						mmi_name= socketHandler.getName(mmi)
						if not mmi_name.startswith("MMI Socket"):
							mmi_slot=99
							splitted=[]
							splitted=mmi_name.split()
							if len(splitted) > 1:
								if splitted[0].startswith("CI"):
									mmi_slot=int(splitted[1].strip(":"))-1
							if real_slot == mmi_slot:
								module_number=mmi
#								print "[CI] FOUND CI Slot %d as MMI number %s" % (real_slot,module_number)
		return module_number


def saveXMLPlus(self):
	try:
		fp = file(self.filename, 'w')
		fp.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n")
		fp.write("<ci>\n")
		fp.write("\t<slot>\n")
		fp.write("\t\t<id>%s</id>\n" % self.ci_slot)
		for item in self.selectedcaid:
			if len(self.selectedcaid):
				fp.write("\t\t<caid id=\"%s\" />\n" % item[0])
		for item in self.servicelist:
			if len(self.servicelist):
				if item[2]==1:
					fp.write("\t\t<provider name=\"%s\" dvbnamespace=\"%s\" />\n" % (item[0], item[3]))
				else:
					fp.write("\t\t<service name=\"%s\" ref=\"%s\" />\n"  % (item[0].replace("&","&amp;"), item[3]))
		fp.write("\t</slot>\n")
		fp.write("</ci>\n")
		fp.flush()
		fsync(fp.fileno())
		fp.close()
		if config.plugins.autopin.addmodulenametoassignment.value != "inactive":
			# save second time also with Module name ...
			ci_name=getMMISlotName(self.ci_slot)
			if ci_name is None:
				ci_name=eDVBCI_UI.getInstance().getAppName(self.ci_slot)
			ci_name=ci_name.replace("CI %s: " % (self.ci_slot+1),"")
			ci_name=ci_name.replace(" ","_")
			filenamewithmodule=self.filename.replace("ci%d" % self.ci_slot,"ci%d_%s" % (self.ci_slot,ci_name))
#			print filenamewithmodule
			fp = file(filenamewithmodule, 'w')
			fp.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n")
			fp.write("<ci>\n")
			fp.write("\t<slot>\n")
			fp.write("\t\t<id>%s</id>\n" % self.ci_slot)
			for item in self.selectedcaid:
				if len(self.selectedcaid):
					fp.write("\t\t<caid id=\"%s\" />\n" % item[0])
			for item in self.servicelist:
				if len(self.servicelist):
					if item[2]==1:
						fp.write("\t\t<provider name=\"%s\" dvbnamespace=\"%s\" />\n" % (item[0], item[3]))
					else:
						fp.write("\t\t<service name=\"%s\" ref=\"%s\" />\n"  % (item[0].replace("&","&amp;"), item[3]))
			fp.write("\t</slot>\n")
			fp.write("</ci>\n")
			fp.flush()
			fsync(fp.fileno())
			fp.close()
	except:
		print "[CI_Config_CI%d] xml not written" %self.ci_slot
		os.unlink(self.filename)


class CIselectMainMenuPlus(Screen):
	skin = """
		<screen name="CIselectMainMenu" position="center,center" size="500,250" title="CI assignment" >
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" size="140,40" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="140,0" size="140,40" alphatest="on" />
			<widget source="key_red" render="Label" position="0,0" zPosition="1" size="140,40" font="Regular;20" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />
			<widget source="key_green" render="Label" position="140,0" zPosition="1" size="140,40" font="Regular;20" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />
			<widget name="CiList" position="5,50" size="490,200" scrollbarMode="showOnDemand" />
		</screen>"""

	def __init__(self, session, args = 0):

		Screen.__init__(self, session)

		self["key_red"] = StaticText(_("Close"))
		self["key_green"] = StaticText(_("Edit"))

		self["actions"] = ActionMap(["ColorActions","SetupActions"],
			{
				"green": self.greenPressed,
				"red": self.close,
				"ok": self.greenPressed,
				"cancel": self.close
			}, -1)

		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		
		self.dlg = None
		self.state = { }
		self.list = [ ]

		if NUM_CI > 0:
			for slot in range(NUM_CI):
				ci_name=None
				state = eDVBCI_UI.getInstance().getState(slot)
				if state == 0:
					appname = _("Slot %d") %(slot+1) + " - " + _("no module found")
				elif state == 1:	
					appname = _("Slot %d") %(slot+1) + " - " + _("init modules")
				elif state == 2:
					ci_name=eDVBCI_UI.getInstance().getAppName(slot)
					if config.plugins.autopin.addmodulenametoassignment.value != "inactive":
						# synchronize with file with Module name ...
						filename=ci_name.replace(" ","_")
						filenamewithmodule="/etc/enigma2/ci%d_%s.xml" % (slot,filename)
						print filenamewithmodule
						if os.path.exists(filenamewithmodule):
							new=open(filenamewithmodule,"r")
							assignment=new.read()
							new.close()
							old=open("/etc/enigma2/ci%d.xml" % slot, "w")
							old.write(assignment)
							old.close()
					appname = _("Slot %d") %(slot+1) + " - " + ci_name
				if state != -1:
					self.list.append( (appname, ConfigNothing(), 0, slot) )
				else:
					ci_name=getMMISlotName(slot)
					if ci_name is not None and len(ci_name) > 4:
						if config.plugins.autopin.addmodulenametoassignment.value != "inactive":
							# synchronize with file with Module name ...
							filename=ci_name.replace("CI %s: " % (slot+1),"")
							filename=filename.replace(" ","_")
							filenamewithmodule="/etc/enigma2/ci%d_%s.xml" % (slot,filename)
							print filenamewithmodule
							if os.path.exists(filenamewithmodule):
								new=open(filenamewithmodule,"r")
								assignment=new.read()
								new.close()
								old=open("/etc/enigma2/ci%d.xml" % slot, "w")
								old.write(assignment)
								old.close()
						appname = _("Slot %d") %(slot+1) + " - " + ci_name
						self.list.append( (appname, ConfigNothing(), 0, slot) )
		if not self.list:
			self.list.append( (_("no CI slots found") , ConfigNothing(), 1, -1) )

		menuList = ConfigList(self.list)
		menuList.list = self.list
		menuList.l.setList(self.list)
		self["CiList"] = menuList
		self.onShown.append(self.setWindowTitle)

	def setWindowTitle(self):
		self.setTitle(_("CI assignment")+" + "+_("Auto Pin V%s") % autopin_version )

	def greenPressed(self):
		cur = self["CiList"].getCurrent()
		if cur and len(cur) > 2:
			name = cur[0]
			sp=[]
			sp=name.split()
			advanced=True
			if len(sp) > 3:
				if sp[3]=="CI":
					advanced=False
			action = cur[2]
			slot = cur[3]
			if action == 1:
				print "[CI_Wizzard] there is no CI Slot in your receiver"
			else:
				print "[CI_Wizzard] selected CI Slot : %d" % slot
				if config.usage.setup_level.index > 1 and advanced: # advanced
					self.session.open(CIconfigMenu, slot)
				else:
					self.session.open(easyCIconfigMenu, slot)

	"""def yellowPressed(self): # unused
		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		print "[CI_Check] FOUND %d CI Slots " % NUM_CI
		if NUM_CI > 0:
			for ci in range(NUM_CI):
				print eDVBCIInterfaces.getInstance().getDescrambleRules(ci)"""

# rename original on startup in any case
Plugins.SystemPlugins.CommonInterfaceAssignment.plugin.CIselectMainMenu = CIselectMainMenuPlus
Plugins.SystemPlugins.CommonInterfaceAssignment.plugin.CIconfigMenu.saveXML = saveXMLPlus

class CiSelectionPlus(Screen):
	skin = """
		<screen name="CiSelection" position="center,135" size="600,460" title="Common Interface">
		<widget name="text" position="10,10" size="580,25" font="Regular;23" />
		<eLabel position="10,50" size="580,1" backgroundColor="white" />
		<widget name="entries" position="10,60" size="580,380" itemHeight="30" scrollbarMode="showOnDemand" />
		</screen>"""
	def __init__(self, session):
		Screen.__init__(self, session)
#		self["actions"] = ActionMap(["OkCancelActions", "CiSelectionActions" ],
	        self["setupActions"] = ActionMap(["SetupActions"],
			{
				"left": self.keyLeft,
				"right": self.keyLeft,
				"ok": self.okbuttonClick,
				"cancel": self.cancel
			},-2)

		self.dlg = None
		self.state = { }
		self.list = [ ]

		for slot in range(MAX_NUM_CI):
			state = eDVBCI_UI.getInstance().getState(slot)
			if state != -1:
				self.appendEntries(slot, state)
				CiHandler.registerCIMessageHandler(slot, self.ciStateChanged)
			else:
				if getMMISlotName(slot) is not None:
					state=3
					self.appendEntries(slot, state)
					CiHandler.registerCIMessageHandler(slot, self.ciStateChanged)

		menuList = ConfigList(self.list)
		menuList.list = self.list
		menuList.l.setList(self.list)
		self["entries"] = menuList
		self["entries"].onSelectionChanged.append(self.selectionChanged)
		self["text"] = Label(_("Slot %d")%(1))
		self.onShown.append(self.setWindowTitle)

	def setWindowTitle(self):
		self.setTitle(_("Common Interface")+" + "+_("Auto Pin V%s") % autopin_version )

	def selectionChanged(self):
		cur_idx = self["entries"].getCurrentIndex()
		self["text"].setText(_("Slot %d")%((cur_idx / 5)+1))

	def keyConfigEntry(self, key):
		try:
			self["entries"].handleKey(key)
			self["entries"].getCurrent()[1].save()
		except:
			pass

	def keyLeft(self):
		self.keyConfigEntry(KEY_LEFT)

	def keyRight(self):
		self.keyConfigEntry(KEY_RIGHT)

	def appendEntries(self, slot, state):
		self.state[slot] = state
		self.list.append( (_("Reset"), ConfigNothing(), 0, slot) )
		self.list.append( (_("Init"), ConfigNothing(), 1, slot) )
		if self.state[slot] == 0:			#no module
			self.list.append( (_("no module found"), ConfigNothing(), 2, slot) )
		elif self.state[slot] == 1:		#module in init
			self.list.append( (_("init module"), ConfigNothing(), 2, slot) )
		elif self.state[slot] == 2:		#module ready
			#get appname
			appname = eDVBCI_UI.getInstance().getAppName(slot)
			self.list.append( (appname, ConfigNothing(), 2, slot) )
		elif self.state[slot] == 3:		#virtual module
       			mmi_name=getMMISlotName(slot)                      
			if mmi_name is not None:
#				print "[CI] %d %s" % (slot,mmi_name)
				self.list.append( (mmi_name, ConfigNothing(), 2, slot) )

		self.list.append(getConfigListEntry(_("Multiple service support"), config.ci[slot].canDescrambleMultipleServices))
		if SystemInfo["CommonInterfaceSupportsHighBitrates"]:
			self.list.append(getConfigListEntry(_("High bitrate support"), config.ci[slot].canHandleHighBitrates))

	def updateState(self, slot):
		state = eDVBCI_UI.getInstance().getState(slot)
		self.state[slot] = state

		slotidx=0
		while len(self.list[slotidx]) < 3 or self.list[slotidx][3] != slot:
			slotidx += 1

		slotidx += 1 # do not change Reset
		slotidx += 1 # do not change Init

		if state == 0:			#no module
			self.list[slotidx] = (_("no module found"), ConfigNothing(), 2, slot)
		elif state == 1:		#module in init
			self.list[slotidx] = (_("init module"), ConfigNothing(), 2, slot)
		elif state == 2: 		#module ready
			#get appname
			appname = eDVBCI_UI.getInstance().getAppName(slot)
			self.list[slotidx] = (appname, ConfigNothing(), 2, slot)
		elif state == 3:		#virtual module
       			mmi_name= socketHandler.getName(mmi)                       
			if mmi_name is not None:
				self.list[slotidx] = (mmi_name, ConfigNothing(), 2, slot)
		lst = self["entries"]
		lst.list = self.list
		lst.l.setList(self.list)

	def ciStateChanged(self, slot):
		if self.dlg:
			self.dlg.ciStateChanged()
		else:
			state = eDVBCI_UI.getInstance().getState(slot)
			if self.state[slot] != state:
				#print "something happens"
				self.state[slot] = state
				self.updateState(slot)

	def dlgClosed(self, slot):
		global ShutUp
		ShutUp=config.plugins.autopin.shutup.value
		self.dlg = None

	def okbuttonClick(self):
		global ShutUp
		cur = self["entries"].getCurrent()
		if cur and len(cur) > 2:
			action = cur[2]
			slot = cur[3]
			state=self.state[slot]
			print "[CI] ACTION slot %d action %d state %d" % (slot,action,state)
		        self.realinstance = eDVBCI_UI.getInstance()
			if action == 0:		#reset
				if state < 3:
			                self.realinstance.setReset(slot) 
				else:
					if eSocket_UI is not None and getMMISlotNumber(slot) is not None:
						mmi_number=getMMISlotNumber(slot)
				                self.realinstance = eSocket_UI.getInstance()
				                self.realinstance.setReset(mmi_number) 
			elif action == 1:	#init
				if state < 3:
			                self.realinstance.setInit(slot) 
				else:
					if eSocket_UI is not None and getMMISlotNumber(slot) is not None:
						mmi_number=getMMISlotNumber(slot)
				                self.realinstance = eSocket_UI.getInstance()
				                self.realinstance.setInit(mmi_number) 
			elif state == 2: 	#dialog
				# for menus we have to temporary disable it
				ShutUp=False
				self.dlg = self.session.openWithCallback(self.dlgClosed, MMIDialog, slot, action)

			elif state == 3: 	#mmi dialog
				if getMMISlotNumber(slot) is not None:
					if eSocket_UI is not None:
				                self.realinstance = eSocket_UI.getInstance()
					else:
						self.realinstance = socketmmi
					mmi_number=getMMISlotNumber(slot)
					# for menus we have to temporary disable it
					ShutUp=False
					self.dlg = self.session.openWithCallback(self.dlgClosed, MMIDialog, mmi_number, action, self.realinstance)

	def cancel(self):
		for slot in range(MAX_NUM_CI):
			state = eDVBCI_UI.getInstance().getState(slot)
			if state != -1:
				CiHandler.unregisterCIMessageHandler(slot)
		self.close()

# rename original on startup in any case
Screens.Ci.CiSelection = CiSelectionPlus

autopin_title=_("Auto Pin by gutemine")+" V%s " % autopin_version
autopin_help=_("Message")+" "+_("confirmed")+":\n"+_("insert card: 44, 103, 503, 993\nno subscription: 2, 204, 304, 502, 510, 990, 991\nreading card: 74, 536")
autopin_instruction=_("Select command in module line and then\npress OK or Green for execution")

class AutoPin(Screen, ConfigListScreen):
	skin = """
	<screen position="center,center" size="720,540" title="Auto Pin" >
		<widget name="buttonred" position="10,10" size="160,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="buttongreen" position="190,10" size="160,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="buttonyellow" position="370,10" size="160,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="buttonblue" position="550,10" size="160,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="config" position="10,70" size="700,350" scrollbarMode="showOnDemand" />
		<ePixmap pixmap="%s/ci.png" position="12,460" size="78,70" alphatest="on" />

		<widget name="rewind" position="130,430" size="16,16" alphatest="on" />
		<widget name="play" position="210,430" size="16,16" alphatest="on" />
		<widget name="stop" position="290,430" size="16,16" alphatest="on" />
		<widget name="forward" position="370,430" size="16,16" alphatest="on" />
		<widget name="pause" position="450,430" size="16,16" alphatest="on" />

		<widget name="ci0_auth1" position="96,460" size="8,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="ci0_auth2" position="98,462" size="4,26" backgroundColor="green" valign="center" halign="center" zPosition="3"  foregroundColor="green" font="Regular;18"/>
		<widget name="ci1_auth1" position="96,500" size="8,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="ci1_auth2" position="98,502" size="4,26" backgroundColor="green" valign="center" halign="center" zPosition="3"  foregroundColor="green" font="Regular;18"/>

		<eLabel name="ci0_module_back1" position="110,460" size="310,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<eLabel name="ci0_module_back2" position="112,462" size="306,26" backgroundColor="black" valign="center" halign="center" zPosition="3"  foregroundColor="black" font="Regular;18"/>
		<widget name="ci0_module" position="122,471" size="286,8" backgroundColor="white" valign="center" halign="center" zPosition="4"  foregroundColor="white" font="Regular;18"/>

		<eLabel name="ci1_module_back1" position="110,500" size="310,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<eLabel name="ci1_module_back2" position="112,502" size="306,26" backgroundColor="black" valign="center" halign="center" zPosition="3"  foregroundColor="black" font="Regular;18"/>
		<widget name="ci1_module" position="122,511" size="286,8" backgroundColor="white" valign="center" halign="center" zPosition="4"  foregroundColor="white" font="Regular;18"/>

		<eLabel name="ci0_back" position="430,460" size="30,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="ci0" position="432,462" size="26,26" backgroundColors="black,white,red,green,yellow,blue" valign="center" halign="center" zPosition="3"  foregroundColors="white,black,white,white,black,white" font="Regular;16"/>

		<eLabel name="ci1_back" position="430,500" size="30,30" backgroundColor="white" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
		<widget name="ci1" position="432,502" size="26,26" backgroundColors="black,white,red,green,yellow,blue" valign="center" halign="center" zPosition="3"  foregroundColors="white,black,white,white,black,white" font="Regular;16"/>

		<widget name="ci0_text_rect" position="470,460" size="240,30" backgroundColor="yellow" valign="center" halign="center" zPosition="3"  foregroundColor="yellow" font="Regular;16"/>
		<widget name="ci1_text_rect" position="470,500" size="240,30" backgroundColor="yellow" valign="center" halign="center" zPosition="3"  foregroundColor="yellow" font="Regular;16"/>
		<widget name="ci0_text" position="471,461" size="238,28" backgroundColor="black" valign="center" halign="left" zPosition="4"  foregroundColor="yellow" font="Regular;16"/>
		<widget name="ci1_text" position="471,501" size="238,28" backgroundColor="black" valign="center" halign="left" zPosition="4"  foregroundColor="yellow" font="Regular;16"/>
	</screen>""" % (autopin_plugindir)

	def __init__(self, session, args = 0):
		Screen.__init__(self, session)

                self.onShown.append(self.setWindowTitle)
                self.onLayoutFinish.append(self.refreshLayout)
				
		self.list = []                                                  
		ConfigListScreen.__init__(self, self.list, session = self.session)
		self.createSetup()       

		self["buttonred"] = Label(_("Save"))
		self["buttongreen"] = Label(_("OK"))
		self["buttonyellow"] = Label(_("Common Interface"))
		self["buttonblue"] = Label(_("CI assignment"))
      		self["rewind"] = Pixmap() 
      		self["forward"] = Pixmap() 
      		self["stop"] = Pixmap() 
      		self["play"] = Pixmap() 
      		self["pause"] = Pixmap() 
		self["ci0_auth1"] = Label("")
		self["ci0_auth2"] = Label("")
		self["ci1_auth1"] = Label("")
		self["ci1_auth2"] = Label("")
		self["ci0_module"] = Label("")
		self["ci1_module"] = Label("")
		self["ci0"] = MultiColorLabel("1")
		self["ci1"] = MultiColorLabel("2")
		self["ci0_text_rect"] = Label("")
		self["ci1_text_rect"] = Label("")
		self["ci0_text"] = Label("")
		self["ci1_text"] = Label("")
		# hide until checked
		self["ci0_auth1"].hide()
		self["ci0_auth2"].hide()
		self["ci1_auth1"].hide()
		self["ci1_auth2"].hide()

		self["actions"] = ActionMap(["ColorActions","EPGSelectActions","SetupActions","MenuActions", "MediaPlayerActions", "MediaPlayerSeekActions"],
		{
			"green": self.okPressed,
			"red": self.save,
			"yellow": self.interface,
			"blue": self.assign,
			"save": self.save,
			"cancel": self.cancel,
			"info": self.about,
			"menu": self.menu,
			"ok": self.okPressed,
			"exit": self.cancel,
			"pause": self.playPressed,
			"stop": self.stopPressed,
			"seekBack": self.previousPressed,
			"seekFwd": self.nextPressed,
		}, -3)
		for slot in range(MAX_NUM_CI):                                                  
        		config.plugins.autopin.ci[slot].command.value="show"                    
		self.AutoPinRefreshTimer = eTimer()
		if os.path.exists("/var/lib/dpkg/status"):
	 		self.AutoPinRefreshTimer_conn = self.AutoPinRefreshTimer.timeout.connect(self.refreshLayout)
		else:
			self.AutoPinRefreshTimer.callback.append(self.refreshLayout)
		self.AutoPinRefreshTimer.start(200, True)

	def checkDreambin(self):                                                  
		# the typical virtual CI names ...
		self.dreambin="/usr/bin/dreamci"
		self.dreamserv="dreamci"
		self.dreamsh="/usr/bin/enigma2_pre_start_dreamci.sh"
		# now look for alternatives
		for name in os.listdir("/usr/bin"):
			if name.startswith("dream") and name.find("ci") is not -1:
				self.dreambin="/usr/bin/%s" % name
				self.dreamserv=name.lower().replace("_","")
				self.dreamsh="/usr/bin/enigma2_pre_start_%s.sh" % self.dreamserv.replace("dream","")
#		print "[AUTOPIN] dream binary %s" % self.dreambin
#		print "[AUTOPIN] dream service %s" % self.dreamserv
#		print "[AUTOPIN] dream shell %s" % self.dreamsh
		if os.path.exists(self.dreambin):
			return True
		else:
			return False

	def createSetup(self):                                                  
		self.list = []
		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		NUM_MMI=0
		socketHandler = SocketMMIMessageHandler()
		NUM_MMI=socketHandler.numConnections()
		if NUM_CI > 0:
			for slot in range(NUM_CI):
				appname = _("Slot %d") %(slot+1) + " - " + _("no module found")
				state = eDVBCI_UI.getInstance().getState(slot)
				if state == 0:
					appname = _("Slot %d") %(slot+1) + " - " + _("no module found")
				elif state == 1:	
					appname = _("Slot %d") %(slot+1) + " - " + _("init modules")
				elif state == 2:
					appname = _("Slot %d") %(slot+1) + " - " + eDVBCI_UI.getInstance().getAppName(slot)
				if state == -1:
					mmi_name=getMMISlotName(slot)
					if mmi_name is not None:
						appname = _("Slot %d") %(slot+1) + " - " + mmi_name
				if not self.checkDreambin():
					self.list.append((appname, ConfigNothing(), 0))
				else:
					self.list.append(getConfigListEntry(appname, config.plugins.autopin.ci[slot].command,slot))
				self.list.append(getConfigListEntry(_("PIN")+" [0000 = "+ _("none")+"]", config.ci[slot].pin)) 
				if not config.plugins.autopin.shutup.value:
					self.list.append(getConfigListEntry(_("Message"), config.ci[slot].confirm )) 
					config.ci[slot].confirm.addNotifier(self.updateList, initial_call = False,immediate_feedback = False)
				else:
					self.list.append(("", ConfigNothing(), 0))
#				self.list.append(getConfigListEntry(_("Test Type"), config.ci[slot].resource )) 
				self.list.append(("", ConfigNothing(), 0))
			self.list.append(getConfigListEntry(_("Recordings always have priority"), config.recording.asktozap))
#			self.list.append(getConfigListEntry(_("CI assignment")+" + "+_("Name"), config.plugins.autopin.addmodulenametoassignment))
#			self.list.append(getConfigListEntry(_("Fix High Bitrate"), config.plugins.autopin.fixhighbitrate))
			self.list.append(getConfigListEntry(_("Shut Up"), config.plugins.autopin.shutup))
			
		self.menuList = ConfigList(self.list)
		self.menuList.list = self.list
		self.menuList.l.setList(self.list)
		self["config"] = self.menuList

	def updateList(self, configElement):
		defval = []
		if configElement.value and len(config.plugins.autopin.confirmhelper.value) >0:
			val = int(config.plugins.autopin.confirmhelper.value)
			if not val in configElement.value:
				tmp = configElement.value[:]
				tmp.reverse()
				for x in tmp:
					if x < val:
						defval = str(x)
						break
		config.plugins.autopin.confirmhelper.setChoices(map(str, configElement.value), defval)

	def playPressed(self):
		cur_idx = self["config"].getCurrentIndex()
		if cur_idx == 0 or cur_idx == 4:
			print " PLAY ############################"
			self.okPressed("start")

	def stopPressed(self):
		cur_idx = self["config"].getCurrentIndex()
		if cur_idx == 0 or cur_idx == 4:
			print " STOP ############################"
			self.okPressed("stop")

	def previousPressed(self):
		cur_idx = self["config"].getCurrentIndex()
		if cur_idx == 0 or cur_idx == 4:
			print " PREVIOUS ############################"
			self.okPressed("disable")

	def nextPressed(self):
		cur_idx = self["config"].getCurrentIndex()
		if cur_idx == 0 or cur_idx == 4:
			print " NEXT ############################"
			self.okPressed("enable")

	def okPressed(self, action=None):
		binversion=""
		if self.checkDreambin():
			cur = self["config"].getCurrent()
			if cur and len(cur) > 2:
				restart=False
				done=True
				name = cur[0]
				if action is None:
					action = cur[1].value
				slot = cur[2]
				print "[CI] %s slot %d action %s" % (name,slot,action)

				pid=os.getpid()
				print "[AUTOPIN] enigma2 pid %i" % pid
				ci_e2_locked=False
				for of in os.listdir("/proc/%i/fd" % pid):
					if os.path.exists("/proc/%i/fd/%s" % (pid,of)):
						result=os.readlink("/proc/%i/fd/%s" % (pid,of))
						if result.startswith("/dev/ci%d" % slot):
							print "[AUTOPIN] enigma2 has locked /dev/ci%d" % slot
							ci_e2_locked=True

				self.container = eConsoleAppContainer()
				if os.path.exists("/var/lib/dpkg/status"):
					self.container_appClosed_conn = self.container.appClosed.connect(self.runFinished)
				else:
					self.container.appClosed.append(self.runFinished)
				if action == "none":
					return
				elif action == "start":
					text=_("enable")
					if not ci_e2_locked:
						if os.path.exists("/lib/systemd/system"):
							cmd="systemctl start %s%d" % (self.dreamserv,slot)
						else:
							cmd="/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)
						print "[CI] command %s" % cmd
						self.container.execute(cmd)
					else:
						done=False
						restart=True
						text="enigma2"+" "+_("disabled")+" "+_("Slot %d") %(slot+1)+"\n\n"+_("better")+" "+_("enable")+" "+_("auto")+" "+_("Load")+_(" & ")
				elif action == "stop":
					text=_("disable")
					if not ci_e2_locked:
						if os.path.exists("/lib/systemd/system"):
							cmd="systemctl stop %s%d" % (self.dreamserv,slot)
						else:
							cmd="/sbin/start-stop-daemon -K -p /tmp/%s%d.pid" % (self.dreamserv,slot)
						print "[CI] command %s" % cmd
						self.container.execute(cmd)
					else:
						done=False
						restart=True
						text="enigma2"+" "+_("disabled")+" "+_("Slot %d") %(slot+1)+"\n\n"+_("better")+" "+_("enable")+" "+_("auto")+" "+_("Load")+_(" & ")
				elif action == "restart":
					text=_("Restart").lower()
					if not ci_e2_locked:
						if os.path.exists("/lib/systemd/system"):
							cmd="systemctl restart %s%d" % (self.dreamserv,slot)
						else:
							cmd1="/sbin/start-stop-daemon -K -p /tmp/%s%d.pid" % (self.dreamserv,slot)
							cmd2="/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)
							cmd="%s; %s" % (cmd1,cmd2)
						print "[CI] command %s" % cmd
						self.container.execute(cmd)
					else:
						done=False
						restart=True
						text="enigma2"+" "+_("disabled")+" "+_("Slot %d") %(slot+1)+"\n\n"+_("better")+" "+_("enable")+" "+_("auto")+" "+_("Load")+_(" & ")
				elif action == "enable":
					restart=True
					text=_("auto")+" "+_("enable")
					if os.path.exists("/lib/systemd/system"):
						cmd="systemctl enable %s%d" % (self.dreamserv,slot)
						print "[CI] command %s" % cmd
						self.container.execute(cmd)
					else:
						if os.path.exists(self.dreamsh):
							f=open(self.dreamsh,"r")
							cmd=f.read()
							f.close()
							if cmd.find("#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)) is not -1:
								newcmd=cmd.replace("#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot),"/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot))
								f=open(self.dreamsh,"w")
								f.write(newcmd)
								f.close()
						else:
							print "[AUTOPIN] %s not found" % self.dreamsh
				elif action == "disable":
					restart=True
					text=_("auto")+" "+_("disable").lower()
					if os.path.exists("/lib/systemd/system"):
#						cmd="systemctl stop %s%d; systemctl disable %s%d" % (self.dreamserv,slot,self.dreamserv,slot)
						cmd="systemctl disable %s%d" % (self.dreamserv,slot)
						print "[CI] command %s" % cmd
						self.container.execute(cmd)
					else:
#						cmd="/sbin/start-stop-daemon -K -p /tmp/%s%d.pid" % (self.dreamserv,slot)
#						print "[CI] command %s" % cmd
#						self.container.execute(cmd)
						if os.path.exists(self.dreamsh):
							f=open(self.dreamsh,"r")
							cmd=f.read()
							f.close()
							if cmd.find("#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)) is -1:
								newcmd=cmd.replace("/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot),"#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot))
								f=open(self.dreamsh,"w")
								f.write(newcmd)
								f.close()
						else:
							print "[AUTOPIN] %s not found" % self.dreamsh
				elif action == "reset_assign":
					assign="/etc/enigma2/ci%s.xml" % slot
					# remove also file with Module name ...
					module_name=name.replace(_("Slot %d") % (slot+1)+" - ","").replace("CI %s:" % (slot+1),"")
					assign2="/etc/enigma2/ci%s%s.xml" % (slot,module_name.replace(" ","_"))
					if not os.path.exists(assign) and not os.path.exists(assign2):
						done=False
						text=_("not configured")
					else:
						if os.path.exists(assign):
							os.remove(assign)
						if os.path.exists(assign2):
							os.remove(assign2)
						text=_("Reset")+" "+_("CI assignment")
				
				elif action == "reset_ci":
					done=False
					text=_("not configured")
					auth="/etc/enigma2/ci_auth_%s.bin" % slot
					print auth
					if os.path.exists(auth):
						os.remove(auth)
						restart=True
						text=_("Reset")+" "+_("CI")
					module_name=name.replace(_("Slot %d") % (slot+1)+" - ","").replace("CI %s:" % (slot+1),"")
					auth="/etc/enigma2/ci_auth%s.bin" % (module_name.replace(" ","_"))
					print auth
					if os.path.exists(auth):
						os.remove(auth)
						restart=True
						text=_("Reset")+" "+_("CI")
					auth="/etc/enigma2/ci_auth%s_%s.bin" % (module_name.replace(" ","_"),slot)
					print auth
					if os.path.exists(auth):
						os.remove(auth)
						restart=True
						text=_("Reset")+" "+_("CI")
				
				elif action == "info":
					done=False
					kitname=self.dreambin.replace("/usr/bin/","").replace("_","-")
					print kitname
					if os.path.exists(self.dreambin):
						if os.path.exists("/var/lib/dpkg/status"):
							p=open("/var/lib/dpkg/status")
						else:
							p=open("/var/lib/opkg/status")
						while not p.readline().startswith("Package: %s" % kitname):
							pass
						if os.path.exists("/var/lib/dpkg/status"):
							while not p.readline().startswith("Architecture:"):
								pass
						version=p.readline()
						p.close()
						binversion=kitname+" "+version
					print binversion	
					header=_("Show WLAN Status").replace("WLAN","CI")
					enabled=_("enabled")+" "+_("auto")+" "+_("Load")
					running=spi[0]+" "+_("disabled")
					# check for enabled
					if os.path.exists("/lib/systemd/system"):
						if not os.path.lexists("/etc/systemd/system/multi-user.target.wants/%s%d.service" % (self.dreamserv,slot)):
							enabled=_("disabled")+" "+_("auto")+" "+_("Load")
					else:
						if os.path.exists(self.dreamsh):
							f=open(self.dreamsh,"r")
							cmd=f.read()
							f.close()
							if cmd.find("#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)) is not -1:
								enabled=_("disabled")+" "+_("auto")+" "+_("Load")
					# check for running via pidfile
					if os.path.exists("/tmp/%s%d.pid" % (self.dreamserv,slot)):
						running=spi[0]+" "+_("enabled")
					text=header+":\n\n"+enabled+" & "+running
					if ci_e2_locked:
						restart=True
						text=text+"\n\n"+"enigma2"+" "+_("disabled")+" "+_("Slot %d") %(slot+1)+" "+_("better")
				else:
#					done=False
#					text=_("do nothing")
					print "[CI] unsupported command %s" % name
					return
				cimsg= name+"\n\n"+text
				if done:
					cimsg= cimsg+" "+ _("done!")
				cimsg=cimsg+"\n\n"+binversion
        			config.plugins.autopin.ci[slot].command.value="show"                    
				if restart:
					cimsg=cimsg+"\n\n"+_("Please Reboot")
					self.session.open(MessageBox, cimsg,  MessageBox.TYPE_WARNING, timeout=5) 
				else:
					self.session.open(MessageBox, cimsg,  MessageBox.TYPE_INFO, timeout=5) 
		
	def setWindowTitle(self):
		self.setTitle(autopin_title)
		self["rewind"].instance.setPixmapFromFile("/usr/share/enigma2/%s/skin_default/icons/ico_mp_rewind.png" % autopin_skin)
		self["forward"].instance.setPixmapFromFile("/usr/share/enigma2/%s/skin_default/icons/ico_mp_forward.png" % autopin_skin)
		self["stop"].instance.setPixmapFromFile("/usr/share/enigma2/%s/skin_default/icons/ico_mp_stop.png" % autopin_skin)
		self["play"].instance.setPixmapFromFile("/usr/share/enigma2/%s/skin_default/icons/ico_mp_play.png" % autopin_skin)
#		self["pause"].instance.setPixmapFromFile("/usr/share/enigma2/%s/skin_default/icons/ico_mp_pause.png" % autopin_skin)

        def runFinished(self, retval):    
		pass

	def refreshLayout(self):
#		print "[AUTOPIN] updating status"
		# redo the list to reflect modules inserted/ejected ...
		self.list = []
		NUM_CI=eDVBCIInterfaces.getInstance().getNumOfSlots()
		NUM_MMI=0
		socketHandler = SocketMMIMessageHandler()
		NUM_MMI=socketHandler.numConnections()
		if NUM_CI > 0:
			for slot in range(NUM_CI):
				appname = _("Slot %d") %(slot+1) + " - " + _("no module found")
				state = eDVBCI_UI.getInstance().getState(slot)
				if state == 0:
					appname = _("Slot %d") %(slot+1) + " - " + _("no module found")
				elif state == 1:	
					appname = _("Slot %d") %(slot+1) + " - " + _("init modules")
				elif state == 2:
					appname = _("Slot %d") %(slot+1) + " - " + eDVBCI_UI.getInstance().getAppName(slot)
				if state == -1:
					mmi_name=getMMISlotName(slot)
					if mmi_name is not None:
						appname = _("Slot %d") %(slot+1) + " - " + mmi_name
				if not self.checkDreambin():
					self.list.append((appname, ConfigNothing(), 0))
				else:
					self.list.append(getConfigListEntry(appname, config.plugins.autopin.ci[slot].command,slot))
				self.list.append(getConfigListEntry(_("PIN")+" [0000 = "+ _("none")+"]", config.ci[slot].pin))
				if not config.plugins.autopin.shutup.value:
					self.list.append(getConfigListEntry(_("Message"), config.ci[slot].confirm ))
				else:
					self.list.append(("", ConfigNothing(), 0))
#				self.list.append(getConfigListEntry(_("Test Type"), config.ci[slot].resource )) 
				self.list.append(("", ConfigNothing(), 0))
			self.list.append(getConfigListEntry(_("Recordings always have priority"), config.recording.asktozap))
#			self.list.append(getConfigListEntry(_("CI assignment")+" + "+_("Name"), config.plugins.autopin.addmodulenametoassignment))
#			self.list.append(getConfigListEntry(_("Fix High Bitrate"), config.plugins.autopin.fixhighbitrate))
			self.list.append(getConfigListEntry(_("Shut Up"), config.plugins.autopin.shutup))
		# better don't refresh while editing confirm messages ...
		cur_idx = self["config"].getCurrentIndex()
		if cur_idx != 2 and cur_idx != 6:
			self.menuList.l.setList(self.list)
		if cur_idx != 0 and cur_idx != 4:
			self["rewind"].hide()
			self["forward"].hide()
			self["stop"].hide()
			self["play"].hide()
#			self["pause"].hide()
		else:
			self["rewind"].show()
			self["forward"].show()
			self["stop"].show()
			self["play"].show()
#			self["pause"].show()
		if not os.path.exists(self.dreambin):
			self["ci0_text"].hide()
			self["ci1_text"].hide()
			self["ci0_text_rect"].hide()
			self["ci1_text_rect"].hide()
		for slot in range(2):
			state = eDVBCI_UI.getInstance().getState(slot)
			self["ci%s_module" % slot].hide()
			if state > 0:
				self["ci%s_module" % slot].show()
			else:
				name=getMMISlotName(slot)
				if name is not None:
					length=len(name)
					if name.startswith("CI ") and length > 4:
						self["ci%s_module" % slot].show()
						module_name=name.replace("CI %s: " % (slot+1),"")
						self["ci%s_auth1" % slot].hide()
						self["ci%s_auth2" % slot].hide()
						auth="/etc/enigma2/ci_auth_%s.bin" % (slot)
						if os.path.exists(auth):
							self["ci%s_auth1" % slot].show()
							self["ci%s_auth2" % slot].show()
						auth="/etc/enigma2/ci_auth_%s.bin" % (module_name.replace(" ","_"))
						if os.path.exists(auth):
							self["ci%s_auth1" % slot].show()
							self["ci%s_auth2" % slot].show()
						auth="/etc/enigma2/ci_auth_%s_%s.bin" % (module_name.replace(" ","_"),slot)
						if os.path.exists(auth):
							self["ci%s_auth1" % slot].show()
							self["ci%s_auth2" % slot].show()
				
			if os.path.exists(self.dreambin):
				enabled=True
				running=False
				if os.path.exists("/lib/systemd/system"):
					# check for enabled
					if not os.path.lexists("/etc/systemd/system/multi-user.target.wants/%s%d.service" % (self.dreamserv,slot)):
						enabled=False
				else:
					# check for enabled
					if os.path.exists(self.dreamsh):
						f=open(self.dreamsh,"r")
						cmd=f.read()
						f.close()
						print cmd
						if cmd.find("#/sbin/start-stop-daemon -S -b -n %s%d -x %s -- /dev/ci%d" % (self.dreamserv,slot,self.dreambin,slot)) is not -1:
							enabled=False
				# check for running via pidfile
				if os.path.exists("/tmp/%s%d.pid" % (self.dreamserv,slot)):
					running=True
				self["ci%s" % slot].hide()
				if os.path.exists(self.dreambin):
					if enabled:							
						if running:							
#							print "[AUTOPIN] slot %d running and enabled!" % slot
							self["ci%s" % slot].setBackgroundColorNum(3) # green
							self["ci%s" % slot].setForegroundColorNum(3)
						else:
#							print "[AUTOPIN] slot %d NOT running but enabled!" % slot
							self["ci%s" % slot].setBackgroundColorNum(4) # yellow
							self["ci%s" % slot].setForegroundColorNum(4)
					else: # 
						if running:							
#							print "[AUTOPIN] slot %d NOT enabled but running!" % slot
							self["ci%s" % slot].setBackgroundColorNum(5) # blue
							self["ci%s" % slot].setForegroundColorNum(5)
						else:
#							print "[AUTOPIN] slot %d NOT enabled and NOT running!" % slot
							self["ci%s" % slot].setBackgroundColorNum(2) # red
							self["ci%s" % slot].setForegroundColorNum(2)
					servfile="/var/run/ca/ci%d.service" % (slot)
					channelref=""
					channel=""
					channelref=""
					if os.path.exists(servfile):
						channelr=""
						f=open(servfile,"r")
						channelref=f.readline()
						f.close()
					if channelref.startswith("1:0:"):
     						channel = ServiceReference(channelref).getServiceName()
					if len(channel) < 1:
						channel=channelref
#					print "[AUTOPIN] found channel %s from channelref %s" % (channel,channelref)
					self["ci%s_text" % slot].setText("  %s" % channel)
				else:
#					print "[AUTOPIN] no binary"
					self["ci%s" % slot].setBackgroundColorNum(0) # black
					self["ci%s" % slot].setForegroundColorNum(0)
				self["ci%s" % slot].show()
		self.AutoPinRefreshTimer.start(200, True)

	def save(self):
		self.AutoPinRefreshTimer.stop()
		for slot in range(MAX_NUM_CI):                                                  
        		config.plugins.autopin.ci[slot].command.value="show"                    

		global ShutUp
		ShutUp=config.plugins.autopin.shutup.value

		config.ci.save()
		for x in self["config"].list:
			x[1].save()
		# make sure it is in settings file
		configfile.save()
		self.close(True)

	def cancel(self):
		self.AutoPinRefreshTimer.stop()
		for x in self["config"].list:
			x[1].cancel()
		closing=True
		self.close(False)

	def menu(self):
		self.session.openWithCallback(self.menu_confirmed,MessageBox,_("Reset")+" "+_("Authoring mode")+"?", MessageBox.TYPE_YESNO)

	def menu_confirmed(self,answer):
		if answer is True:
			if os.path.exists("/etc/ssl/certs/customer.pem"):
				os.remove("/etc/ssl/certs/customer.pem")
			if os.path.exists("/etc/ssl/certs/device.pem"):
				os.remove("/etc/ssl/certs/device.pem")
			if os.path.exists("/etc/ssl/certs/root.pem"):
				os.remove("/etc/ssl/certs/root.pem")
			self.session.open(MessageBox, _("Authoring mode")+" "+_("was removed successfully") , MessageBox.TYPE_INFO)
		else:
			self.session.open(MessageBox, _("Reset")+" "+_("Authoring mode")+" "+_("unconfirmed") , MessageBox.TYPE_ERROR)

	def about(self):
		self.session.open(MessageBox, "%s\n\n%s\n\n%s" % (autopin_title,autopin_help,autopin_instruction) , MessageBox.TYPE_INFO)

	def interface(self):
		try:
			self.session.open(CiSelectionPlus)
		except:
			self.about()

	def assign(self):
		try:
			self.session.open(CIselectMainMenuPlus)
		except:
			self.about()

def startAutoPin(session, **kwargs):
	session.open(AutoPin)    

autoStartFix = None

def autostart(reason,**kwargs):
	global autoStartFix
	global ShutUp
	if kwargs.has_key("session") and reason == 0:           
		session = kwargs["session"]                       
		print "[AUTOPIN] autostart"
		# adding PIN to settings
		InitCiConfigPlus()
#        	if autoStartFix is None:
#            		autoStartFix = AutoStartFixTimer(session)
		ShutUp=config.plugins.autopin.shutup.value
        
class AutoStartFixTimer:
    def __init__(self, session):
        self.session = session
        self.fixtimer = eTimer()
	if os.path.exists("/var/lib/dpkg/status"):          
        	self.fixtimer_conn = self.fixtimer.timeout.connect(self.onFixTimer)
	else:
        	self.fixtimer.callback.append(self.onFixTimer)
        self.fixtimer.startLongTimer(1)
    
    def onFixTimer(self):
	if config.plugins.autopin.fixhighbitrate.value:
		ciCaids = []
		ciCaids.append(0x98c)
        	service = self.session.nav.getCurrentService()
        	if service is None:
                	self.fixtimer.startLongTimer(1)
                	return None
        	info = service.info()
        	if not info:
                	self.fixtimer.startLongTimer(1)
                	return None
        	serviceCaids = info.getInfoObject(iServiceInformation.sCAIDs)
        	for serviceCaid in serviceCaids:
        		for ciCaid in ciCaids:
                		if ciCaid == serviceCaid:
                			eDVBCI_UI.getInstance().setClockRate(0, eDVBCI_UI.rateHigh)
				else:
					print "[AUTOPIN] reverts high bitrate"
                			eDVBCI_UI.getInstance().setClockRate(0, eDVBCI_UI.rateNormal)
        self.fixtimer.startLongTimer(1)

def sessionstart(reason, **kwargs):                                               
	if reason == 0 and "session" in kwargs:                                                        
		print "[AUTOPIN] sessionstart"

def Plugins(**kwargs):
	return [PluginDescriptor(name=_("Auto Pin")+" & "+_("CI assignment"), description=_("automatic PIN")+" & "+_("CI assignment"), where = PluginDescriptor.WHERE_PLUGINMENU, icon="pin.png", fnc=startAutoPin),
		PluginDescriptor(where = [PluginDescriptor.WHERE_SESSIONSTART, PluginDescriptor.WHERE_AUTOSTART], fnc = autostart), PluginDescriptor(name=_("Auto Pin")+" & "+_("CI assignment"), description=_("automatic PIN")+" & "+_("CI assignment"), where=PluginDescriptor.WHERE_MENU, fnc=mainconf), PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART, fnc=sessionstart, needsRestart=False)]

def mainconf(menuid):
	if menuid != "setup":                                                  
		return [ ]                                                     
	return [(_("Auto Pin")+" & "+_("CI assignment"), startAutoPin, "autopin", None)]  